(ns ike.util.component
  (:require [com.stuartsierra.component :as component]))

(defprotocol IdempotentLifecycle
  "Protocol to ease implementation of idempotent components
  for Stuart Sierra's Component library. The safe-start and
  safe-stop will only be called if started? returns false and
  true, respectively."
  (started? [this])
  (safe-start [this])
  (safe-stop [this]))

(extend-protocol component/Lifecycle
  ike.util.component.IdempotentLifecycle
  (start [this]
    (if (started? this)
      this
      (safe-start this)))
  (stop [this]
    (if (started? this)
      (safe-stop this)
      this)))
