# ike.util

Common utilities for various Clojure libraries.

## ike.util.httpkit

```clojure
[[ike/ike.util.httpkit "0.1.0"]]
```

Primarily, this includes two pieces of functionality:

* `ike.util.http-kit/HttpKitServer` - record implementing Stuart Sierra's `Lifecycle` protocol for use with Component.
* `ike.util.http-kit/websocket-handler` - A handler taking two `core.async` channels: one for input and one for output. This provides some isolation from the HTTP Kit API when communicating with the rest of your application. The handler properly handles closing the HTTP Kit channel and/or the core.async channel, as necessary.

### Example

```clojure
(ns my-app.core
    (:require [ike.util.httpkit :refer [map->HttpKitServer]))

(def my-db ...)

;; handler using the db component
(def my-handler
  [{db :db}]
  ...)

;; handler component should be a standard map, but can use
;; any other components. the HttpKitServer component will
;; take care of creating the necessary middleware.
(def system (component/system-map
              :db my-db
              :handler (component/using
                         {:handler-fn my-handler}
                         [:db])
              :server (component/using
                        (map->HttpKitServer {:options {:port 8080}})
                        [:handler])))
```
