(ns ike.tk.httpkit
  (use ike.tk.ring
       org.httpkit.server)
  (require [puppetlabs.trapperkeeper.services :refer [defservice get-service]]
           [clojure.tools.logging :as log]))

(defservice http-kit-service
  "Service that gets a Ring handler from a HandlerService during init
  and, on start, runs http-kit with that handler and any options specified
  in the :http-kit :options key in the context."
  [HandlerService
   [:ConfigService get-in-config]]
  (init [this context]
    (let [handler-service (get-service this :HandlerService)
          handler (get-handler handler-service)]
      (assoc-in context [:http-kit :handler] handler)))
  (start [this context]
    (log/info "Starting http-kit server.")
    (let [handler (get-in context [:http-kit :handler])
          options (get-in-config [:http-kit])
          stopper (run-server handler options)]
      (assoc-in context [:http-kit :stopper] stopper)))
  (stop [this context]
    (log/info "Stopping http-kit server.")
    (let [stopper (get-in context [:http-kit :stopper])]
      (stopper))
    (assoc-in context [:http-kit :stopper] nil)))
