(ns ike.ramp.file
  (:require [clojure.core.async :as async]
            [clojure.java.io :as io]
            [juxt.dirwatch :as dirwatch])
  (:import [java.io File]))

(defn filter-ext
  [ext]
  (filter (fn [^File file]
            (.endsWith (.getAbsolutePath file) (str "." ext)))))

(defn watch->chan
  [path-str event-ch]
  (let [file (io/file path-str)]
    (dirwatch/watch-dir #(async/put! event-ch %) file)
    event-ch))
