(ns ike.ramp.basic
  (:require [clojure.core.async :as async]
            [clojure.tools.logging :as log]))

(defn chan->console
  "Offramp that takes events and prints them to the console."
  [events-ch]
  (async/reduce #(println "Event: " %) nil events-ch))

(defn chan->log
  "Offramp that takes events and logs them at the INFO level."
  [events-ch]
  (async/reduce #(log/info "Event: " %) nil events-ch))
