(ns ike.highway.routes
  (:require [compojure.core :refer [GET POST defroutes context routes]]
            [compojure.route :refer [not-found]]
            [ring.middleware.params :refer [wrap-params]]
            [clojure.core.async :as async]
            [ike.util.aleph :as aleph]))

(defroutes event-routes
  (context "/events" {bus :ike/bus :as request}
    (GET "/connect" []
         (let [in-ch (async/chan)
               out-ch (async/chan)]
           (async/admix (:bus-mix bus) in-ch)
           (async/tap (:bus-mult bus) out-ch)
           (aleph/websocket->async request in-ch out-ch)))))

(defroutes api-routes
  event-routes
  (not-found "Page not found."))

(def all (wrap-params api-routes))
