(ns ike.gradleui.httpkit
  (use org.httpkit.server)
  (require [puppetlabs.trapperkeeper.services :refer [defservice get-service]]
           [clojure.tools.logging :as log])
  (:gen-class))

(defprotocol HandlerService
  (get-handler [this]))

(defservice http-kit-service
  [HandlerService]
  (init [this context]
    (let [handler-service (get-service this :HandlerService)
          handler (get-handler handler-service)]
      (assoc-in context [:http-kit :handler] handler)))
  (start [this context]
    (log/info "Starting http-kit server.")
    (let [handler (get-in context [:http-kit :handler])
          stopper (run-server handler {:port 8080})]
      (assoc-in context [:http-kit :stopper] stopper)))
  (stop [this context]
    (log/info "Stopping http-kit server.")
    (let [stopper (get-in context [:http-kit :stopper])]
      (stopper))
    (assoc-in context [:http-kit :stopper] nil)))
