(ns ike.gradleui
  (require [ike.gradleui.routes :as routes]
           [ike.gradleui.httpkit :as httpkit]
           [puppetlabs.trapperkeeper.services :refer [defservice]]
           [clojure.tools.logging :as log])
  (:gen-class))

(defservice gradleui-service
  "Default service to run the Gradle UI."
  httpkit/HandlerService
  []
  (get-handler [this]
               routes/app)
  (start [this context]
         (log/info "Starting Gradle UI.")
         context)
  (stop [this context]
        (log/info "Stopping Gradle UI.")
        context))
