# ike.gradleui

Prototype of a continuous integration server for local development use.
Intended as a playground to inform the design of a continuous delivery
platform.

**This currently does not work in any way, shape, or form.**

## Short-Term Goals

- Learning:
  - Develop in Clojure.
  - Use Ring as the web "framework".
  - Build project with Lein.
- Feature support (in priority order, but incomplete):
  - Gradle builds only
  - Start builds from UI.
  - Display build progress and results.
  - Saving projects/jobs for future use.
  - Keyboard shortcuts supported for efficient navigation.
  - Open project in file browser, terminal, or IDE.
  - Display reports created by build.
  - Watch resources to automatically rebuild.
  - Render reports from resources created by build.
  - Chain jobs together.

## Considerations

I am using this project both to learn Clojure and as a prototype for Ike.
Given that, the following are likely:

- Clojure use won't be idiomatic.
- Design will be too OO-influenced.
- Components will not be properly decoupled or abstracted.

## Long-term Goals

- Significant decoupling in order to allow components to be easily replaced
  or added.
- Support multiple build tools: Gradle, Leiningen, maybe SBT.
  - I don't have a use for Maven or Ant, but should be abstracted properly
    to allow someone to implement these.
- Support both use as local CI and traditional server/distributed CI.
