/*
 * Decompiled with CFR 0.152.
 */
package ifesdjeen.stateless4j;

import ifesdjeen.stateless4j.delegates.Action1;
import ifesdjeen.stateless4j.delegates.Action2;
import ifesdjeen.stateless4j.transitions.Transition;
import ifesdjeen.stateless4j.triggers.TriggerBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class StateRepresentation<TState, TTrigger> {
    final TState _state;
    final Map<TTrigger, List<TriggerBehaviour<TState, TTrigger>>> _triggerBehaviours = new HashMap<TTrigger, List<TriggerBehaviour<TState, TTrigger>>>();
    final List<Action2<Transition<TState, TTrigger>, Object[]>> _entryActions = new ArrayList<Action2<Transition<TState, TTrigger>, Object[]>>();
    final List<Action1<Transition<TState, TTrigger>>> _exitActions = new ArrayList<Action1<Transition<TState, TTrigger>>>();
    StateRepresentation<TState, TTrigger> _superstate;
    final List<StateRepresentation<TState, TTrigger>> _substates = new ArrayList<StateRepresentation<TState, TTrigger>>();

    public StateRepresentation(TState state) {
        this._state = state;
    }

    public Boolean CanHandle(TTrigger trigger) {
        try {
            this.TryFindHandler(trigger);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public TriggerBehaviour<TState, TTrigger> TryFindHandler(TTrigger trigger) {
        try {
            return this.TryFindLocalHandler(trigger);
        }
        catch (Exception e) {
            return this.getSuperstate().TryFindHandler(trigger);
        }
    }

    TriggerBehaviour<TState, TTrigger> TryFindLocalHandler(TTrigger trigger) throws Exception {
        if (!this._triggerBehaviours.containsKey(trigger)) {
            throw new Exception();
        }
        List<TriggerBehaviour<TState, TTrigger>> possible = this._triggerBehaviours.get(trigger);
        ArrayList<TriggerBehaviour<TState, TTrigger>> actual = new ArrayList<TriggerBehaviour<TState, TTrigger>>();
        for (TriggerBehaviour<TState, TTrigger> triggerBehaviour : possible) {
            if (!triggerBehaviour.isGuardConditionMet().booleanValue()) continue;
            actual.add(triggerBehaviour);
        }
        if (actual.size() > 1) {
            throw new Exception(String.format("MultipleTransitionsPermitted", trigger, this._state));
        }
        TriggerBehaviour handler = (TriggerBehaviour)actual.get(0);
        if (handler == null) {
            throw new Exception();
        }
        return handler;
    }

    public void AddEntryAction(final TTrigger trigger, final @Nonnull Action2<Transition<TState, TTrigger>, Object[]> action) {
        this._entryActions.add(new Action2<Transition<TState, TTrigger>, Object[]>(){

            @Override
            public void doIt(Transition<TState, TTrigger> t, Object[] args) {
                if (t.getTrigger().equals(trigger)) {
                    action.doIt(t, args);
                }
            }
        });
    }

    public void AddEntryAction(@Nonnull Action2<Transition<TState, TTrigger>, Object[]> action) {
        this._entryActions.add(action);
    }

    public void AddExitAction(@Nonnull Action1<Transition<TState, TTrigger>> action) {
        this._exitActions.add(action);
    }

    public void Enter(@Nonnull Transition<TState, TTrigger> transition, Object ... entryArgs) {
        if (transition.isReentry().booleanValue()) {
            this.ExecuteEntryActions(transition, entryArgs);
        } else if (!this.Includes(transition.getSource()).booleanValue()) {
            if (this._superstate != null) {
                this._superstate.Enter(transition, entryArgs);
            }
            this.ExecuteEntryActions(transition, entryArgs);
        }
    }

    public void Exit(@Nonnull Transition<TState, TTrigger> transition) {
        if (transition.isReentry().booleanValue()) {
            this.ExecuteExitActions(transition);
        } else if (!this.Includes(transition.getDestination()).booleanValue()) {
            this.ExecuteExitActions(transition);
            if (this._superstate != null) {
                this._superstate.Exit(transition);
            }
        }
    }

    void ExecuteEntryActions(@Nonnull Transition<TState, TTrigger> transition, @Nonnull Object[] entryArgs) {
        for (Action2<Transition<TState, TTrigger>, Object[]> action : this._entryActions) {
            action.doIt(transition, entryArgs);
        }
    }

    void ExecuteExitActions(@Nonnull Transition<TState, TTrigger> transition) {
        for (Action1<Transition<TState, TTrigger>> action : this._exitActions) {
            action.doIt(transition);
        }
    }

    public void AddTriggerBehaviour(TriggerBehaviour<TState, TTrigger> triggerBehaviour) {
        List<Object> allowed;
        if (!this._triggerBehaviours.containsKey(triggerBehaviour.getTrigger())) {
            allowed = new ArrayList();
            this._triggerBehaviours.put(triggerBehaviour.getTrigger(), allowed);
        }
        allowed = this._triggerBehaviours.get(triggerBehaviour.getTrigger());
        allowed.add(triggerBehaviour);
    }

    public StateRepresentation<TState, TTrigger> getSuperstate() {
        return this._superstate;
    }

    public void setSuperstate(StateRepresentation<TState, TTrigger> value) {
        this._superstate = value;
    }

    public TState getUnderlyingState() {
        return this._state;
    }

    public void AddSubstate(@Nonnull StateRepresentation<TState, TTrigger> substate) {
        this._substates.add(substate);
    }

    public Boolean Includes(TState state) {
        Boolean isIncluded = false;
        for (StateRepresentation<TState, TTrigger> s : this._substates) {
            if (!s.Includes(state).booleanValue()) continue;
            isIncluded = true;
        }
        return this._state.equals(state) || isIncluded != false;
    }

    public Boolean IsIncludedIn(TState state) {
        return this._state.equals(state) || this._superstate != null && this._superstate.IsIncludedIn(state) != false;
    }

    public List<TTrigger> getPermittedTriggers() {
        HashSet<TTrigger> result = new HashSet<TTrigger>();
        for (TTrigger t : this._triggerBehaviours.keySet()) {
            Boolean isOk = false;
            for (TriggerBehaviour<TState, TTrigger> v : this._triggerBehaviours.get(t)) {
                if (!v.isGuardConditionMet().booleanValue()) continue;
                isOk = true;
            }
            if (!isOk.booleanValue()) continue;
            result.add(t);
        }
        if (this.getSuperstate() != null) {
            result.addAll(this.getSuperstate().getPermittedTriggers());
        }
        return new ArrayList(result);
    }
}

