(ns leiningen.new.ice
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "ice"))

(defn ice
  "Scaffold the needed files for our template."
  ([name]
     (let [data {:name name
                 :sanitized (name-to-path name)}]
       (main/info "Generating fresh 'lein new' ice project.")
       (->files data
                ["project.clj" (render "project.clj" data)]
                [".gitignore" (render "gitignore" data)]
                ["config/prod/config.edn" (render "prod.edn" data)]
                ["config/dev/config.edn" (render "dev.edn" data)]
                ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
                ["src/{{sanitized}}/route.clj" (render "route.clj" data)]
                ["src/{{sanitized}}/config.clj" (render "config.clj" data)]
                ["src/{{sanitized}}/middleware.clj" (render "middleware.clj" data)]
                ["src/{{sanitized}}/document/user/mapper.clj" (render "user/mapper.clj" data)]
                ["src/{{sanitized}}/document/user/validator.clj" (render "user/validator.clj" data)]
                ["src/{{sanitized}}/document/user/resource.clj" (render "user/resource.clj" data)]
                ["src/{{sanitized}}/document/user/admin-resource.clj" (render "user/admin_resource.clj" data)]
                ["src/{{sanitized}}/document/user/route.clj" (render "user/route.clj" data)])))
  ([name model-name]
     (let [data {:name name
                 :sanitized (name-to-path name)
                 :model model-name}]
       (main/info "Generating the needed model file.")
       (->files data
                ["src/{{sanitized}}/document/{{model}}/mapper.clj" (render "mapper.clj" data)]
                ["src/{{sanitized}}/document/{{model}}/validator.clj" (render "validator.clj" data)]
                ["src/{{sanitized}}/document/{{model}}/resource.clj" (render "resource.clj" data)]
                ["src/{{sanitized}}/document/{{model}}/admin-resource.clj" (render "admin_resource.clj" data)]
                ["src/{{sanitized}}/document/{{model}}/route.clj" (render "route.clj" data)]))))
