(ns {{name}}.route
    (:require [compojure.route :as route]
              [ring.middleware.logger :as logger]
              [{{name}}.document.user.route :as ur])
    (:use [compojure.core :only [context
                                 ANY
                                 defroutes
                                 routes]]
          [ring.middleware.defaults :only [wrap-defaults
                                           site-defaults]]
          [clj.faris.qed.resource.normal :only [main-resource]]
          [{{name}}.middleware :only [app-middleware]]))

(defroutes api-routes
  (context "/api" []
           (context "/admin" []
                    (routes ur/admin-user-routes))
           (context "/v1" []
                    (routes ur/user-routes))))

(defroutes -app-routes
  api-routes
  (route/resources "/")
  (ANY "/" [] (main-resource "resources/public/index.html"))
  (route/not-found "Page not exists."))

(def app-routes
  (wrap-defaults (-> -app-routes
                     app-middleware)
                 site-defaults))
