(ns {{name}}.middleware
    (:require [clj.faris.qed.auth.middleware :as am]
              [cemerick.friend :as friend]
              [cemerick.friend [workflows :as workflows]
                               [credentials :as creds]]
              [monger.collection :as mc])
    (:use [clj.faris.qed.util :only [get-db]]
          [{{name}}.core :only [app-state]]))

(defn- friend-map
  [request]
  {:credential-fn (partial creds/bcrypt-credential-fn (:users request))
   :redirect-on-auth? false
   :workflows [(workflows/http-basic :realm "/")
               (workflows/interactive-form)]})

(defn friend-middleware
  [handler]
  (fn [request]
    (let [fm (friend-map request)
          new-handler (friend/authenticate handler fm)]
      (new-handler request))))

(defn login-middleware
  [handler]
  (fn [request]
    (let [{:keys [email password]} (:params request)
          users (when (and (not (nil? email))
                           (not (nil? password)))
                  (mc/find-maps (get-db app-state)
                                {:email email
                                 :password password}))
          new-request (if-not (nil? users)
                        (assoc request :users users)
                        request)]
      (handler new-request))))

(defn app-middleware
  [handler]
  (-> handler
      am/extract-user-info-middleware
      friend-middleware
      am/user-middleware
      login-middleware))
