(ns {{name}}.document.user.route
    (:use [compojure.core :only [defroutes
                                 context
                                 GET
                                 POST
                                 PUT
                                 DELETE]]
          [{{name}}.document.user resource admin-resource]))

(defroutes user-routes
  (context "user" []
           (GET "/" [] get-list-user)
           (GET "/:slug" [slug] (get-one-user-by-slug slug))
           (POST "/" [] post-one-user)
           (PUT "/:slug" [slug] (put-one-user-by-slug slug))
           (DELETE "/:slug" [slug] (delete-one-user-by-slug slug))))

(defroutes admin-user-routes
  (context "user" []
           (GET "/" [] admin-get-list-user)
           (GET "/:slug" [slug] (admin-get-one-user-by-slug slug))
           (POST "/" [] admin-post-one-user)
           (PUT "/:slug" [slug] (admin-put-one-user-by-slug slug))
           (DELETE "/:slug" [slug] (admin-delete-one-user-by-slug slug))))
