(ns {{name}}.document.user.admin-resource
    (:use [clj.faris.qed.resource.admin :only [admin-get-list-resource
                                               admin-get-one-by-slug-resource
                                               admin-put-one-by-slug-resource
                                               admin-delete-one-by-slug-resource
                                               admin-post-one-resource]]
          [clj.faris.qed.util :only [get-db]]
          [liberator.core :only [defresource]]
          [{{name}}.core :only [app-state]]))

(defresource admin-get-list-user
  (get-list-resource (get-db app-state)
                     user->jsonable "user"))

(defresource admin-get-one-user-by-slug
  [slug]
  (get-one-by-slug-resource (get-db app-state)
                            user->jsonable "user"))

(defresource admin-put-one-user-by-slug
  [slug]
  (put-one-by-slug-resource (get-db app-state)
                            user->saveable
                            {{modell}}-validator
                            slug))

(defresource admin-delete-one-user-by-slug
  [slug]
  (delete-one-by-slug-resource (get-db app-state)
                               "user" slug))

(defresource admin-post-one-user-by-slug
  (post-one-resource (get-db app-state)
                     user->jsonable
                     user->saveable
                     user-validator
                     "user"))
