(ns {{name}}.core
    (:use [{{name}}.route :only [app-routes]])
    (:require [clj.faris.qed [db :as db]
                             [server :as server]]
              [{{name}}.config :as app-config]))

(def app-state (atom {}))

(defn start-app!
  [profile-name]
  (let [config (app-config/config-reader profile-name)
        server-config (:server config)
        db-config (:db config)]
    (when-not (and (not (nil? server-config))
                   (not (nil? db-config)))
      (server/start-server! app-state app-routes server-config)
      (db/start-db! app-state db-config))))

(defn stop-app!
  []
  (let [config (app-config/config-reader profile-name)
        db-names (map (fn [db] (:name db)) (:db config))]
    (when-not (empty? db-names)
      (server/stop-server! app-state)
      (for [db-name db-names]
        (db/stop-db! app-state db-name)))))
