(ns {{name}}.document.user.resource
    (:use [clj.faris.qed.resource.normal :only [get-list-resource
                                                get-one-by-slug-resource
                                                put-one-by-slug-resource
                                                delete-one-by-id-resource
                                                post-one-resource]]
          [clj.faris.qed.util :only [get-db]]
          [liberator.core :only [defresource]]
          [{{name}}.core :only [app-state]]))

(defresource get-list-user
  (get-list-resource (get-db app-state)
                     user->jsonable "user"))

(defresource get-one-user-by-slug
  [slug]
  (get-one-by-slug-resource (get-db app-state)
                            user->jsonable "user"))

(defresource put-one-user-by-slug
  [slug]
  (put-one-by-slug-resource (get-db app-state)
                            user->saveable
                            {{modell}}-validator
                            slug))

(defresource delete-one-user-by-slug
  [slug]
  (delete-one-by-slug-resource (get-db app-state) "user" slug))

(defn post-one-user
  (post-one-resource (get-db app-state)
                     user->jsonable
                     user->saveable
                     user-validator
                     "user"))
