(ns ring.middleware.rate-limiter)

(def time-key (atom nil))
(def request-counter (atom {}))

(defn wrap-rate-limiter
  [handler & {:keys [interval max-in-interval key-in-request fail-response]
              :or {key-in-request [:remote-addr]
                   fail-response "Too Many Requests"}}]
  (fn [request]
    (if (and (number? interval) (number? max-in-interval))
      (let [now-key (-> (System/currentTimeMillis) (/ interval) long)]
        (when (not= now-key @time-key)
          (reset! request-counter {})
          (reset! time-key now-key))
        (if (contains? @request-counter key-in-request)
          (swap! request-counter update key-in-request inc)
          (swap! request-counter assoc key-in-request 1))
        (if (> max-in-interval (get @request-counter key-in-request 0))
          (handler request)
          {:status 429 :body fail-response}))
      (handler request))))
