(ns hub.util.facebook-test
  (:use clojure.test
        hub.util.facebook)
  (:require [schema.core :as s]))

;; ## Test Users

(s/defschema TestUser
  "Fields for the test user endpoint."
  {:id s/Str
   :login_url s/Str
   :access_token s/Str})

(s/defschema Paging
  "Not really sure how this is used."
  {:cursors {:before s/Str
             :after s/Str}})

(s/defn test-users :- {:data [TestUser], :paging Paging}
  "Queries the /accounts/test-users endpoint:
  https://developers.facebook.com/docs/graph-api/reference/v2.1/app/accounts/test-users"
  []
  (api-get (str (app-id) "/accounts/test-users")
           {:params {:oauth-token (server-secret)}}))

(defn with-user*
  "Takes a function of one argument and passes in a facebook test
  user."
  [f]
  (f (first (:data (test-users)))))

(defmacro with-user
  "Accepts a binding form (destructuring allowed) and evaluates the
  supplied body with a facebook test user bound to that form."
  [[binding] & forms]
  `(with-user* (fn [~binding] ~@forms)))

(deftest me-test
  (with-user [{id :id token :access_token}]
    (let [fetched (me token)]
      (is (= id (:id fetched))
          "Fetching the user with the me endpoint returns a
                     user with matching ID."))))
