(ns hub.user.transforms
  (require [hub.user.api.schema :as as]
           [hub.user.schema :as us]
           [schema.core :as s]))

(s/defn fulluser-model->fulluser-api :- as/FullUser
  "Converts from model representation of a full user doc to the API
  representation."
  [{:keys [password oauth] :as user} :- us/FullUser]
  (let [base (-> user
                 (select-keys
                  [:username :email :profile :roles :created-at :id :updated-at])
                 (update :roles #(set (or % ["user"]))))
        oauth->name (reduce (fn [acc [provider {:keys [token metadata id]}]]
                              (assoc acc provider {:name (:name metadata)
                                                   :token token
                                                   :id id}))
                            {}
                            oauth)]
    (merge base
           {:password-set? (boolean (not-empty password))
            :type "full-user"
            :oauth oauth->name})))

(s/defn pendinguser-model->pendinguser-api :- as/PendingUser
  "Converts from model representation of a pending user doc to the API
  representation."
  [user :- us/PendingUser]
  (assoc user :type "pending-user"))

(s/defn pendinguser-api->pendinguser-model :- us/PendingUser
  "Converts from model representation of a pending user doc to the API
  representation."
  [user :- as/PendingUser]
  (dissoc user :type))
