(ns hub.queue.schema
  "Schemas for queue messages, by topic."
  (:require [schema.core :as s]))

;; ## User Related
(def UserID s/Str)

(s/defschema UserCreated
  "Topic: 'user-created'. Issued when a new user is created. Mailer
  will send a welcome email."
  (s/named s/Any "hub.user.schema/User"))

(s/defschema UserUpdated
  "Topic: 'user-updated'. Currently no one listens for this."
  (s/named s/Any "hub.user.schema/User"))

(s/defschema UserDeleted
  "Topic: 'user-deleted'. Currently no one listens for this."
  {:user-id UserID
   :deleted-by UserID})

(s/defschema UserMerged
  "Topic: 'user-merged'. Currently no one listens for this."
  {:primary-user UserID
   :absorbed-user UserID})

(s/defschema TriggerPasswordReset
  "Topic: 'trigger-password-reset'. Issued when a user has
  successfully requested a reset code for their password. Mailer will
  send them a reset email."
  {:user-id s/Str
   :name {:first s/Str
          :last s/Str}
   :email s/Str
   :password-reset {:code s/Str
                    :created-at s/Num}})

(s/defschema PasswordResetSuccess
  "Topic: 'password-reset-success'. Currently no one listens for
  this."
  {:user-id s/Str})

;; ## Registration Related

(s/defschema RegistrationCreated
  "Sent when a registration has been created. Mailer listens for this,
  and might issue emails to the registrant, and the race admins."
  ;;TODO:
  s/Any)

(s/defschema RegistrationUpdated
  "Sent when a registration has been updated. Mailer listens for this,
  and might issue emails to the registrant, and the race admins."
  ;;TODO:
  s/Any)
