(ns hub.photo.config
  (:require [environ.core :as e]
            [schema.core :as s]))

(def ^:dynamic *env* {})

(defn env
  ([] (merge e/env *env*))
  ([k] ((env) k))
  ([k default] (get (env) k default)))

(defn default-privacy
  "Default privacy level for photo tagging."
  []
  (env :default-privacy "friends"))

(defn prod? []
  (= (env :ring-env) "prod"))

(defn facebook-config
  "Configuration options for RaceHub's facebook page."
  []
  {
   ;; This is the ID of our RaceHub facebook page.
   :page-id "880042288694305"

   ;; Instructions on how to get a new token that never expires:
   ;; http://stackoverflow.com/questions/12168452/long-lasting-fb-access-token-for-server-to-pull-fb-page-info/21927690#21927690
   :page-admin-token "CAAK3ZC61iOloBABhy3BZCZBUbN6fhZB3A7ZCOAgZAn4WqVEv42Ci4rN2KToxjDsCeKU9jE5v2nMnJpQOuI0Of5qICC6O8xZCnz8fhIGETDCgjWHF2nRsZA3oNZBbLyl83LV5Peo0nmAdHdme1X4umpAODTAqln0QZCyCVZB9aWVT6GkH2XIVZBZApLvoi4mXYUTECwBIZD"})
