(ns hub.photo.config
  (:require [environ.core :as e]
            [schema.core :as s]))

(def ^:dynamic *env* {})

(defn env
  ([] (merge e/env *env*))
  ([k] ((env) k))
  ([k default] (get (env) k default)))

(defn default-privacy
  "Default privacy level for photo tagging."
  []
  (env :default-privacy "friends"))

(defn prod? []
  (= (env :ring-env) "prod"))

(defn facebook-config
  "Configuration options for RaceHub's facebook page."
  []
  {
   ;; This is the ID of our RaceHub facebook page.
   :page-id "880042288694305"

   ;; Instructions on how to get a new token that never expires:
;;1) Go to
;;https://developers.facebook.com/tools/explorer/765257750194063?method=GET&path=880042288694305%3Ffields%3Daccess_token&version=v2.7
   ;; select racehub, get user_access_token, then type in
   ;; "/880042288694305?fields=access_token", Submit. Put the returned
   ;; token into the link below, then click on 'extend token':
   ;; https://developers.facebook.com/tools/debug/accesstoken?q=EAAK3ZC3Rcp48BAAJQrqNJNm3LhrIqONPMz6jcA1oovkZCnGZC637b5yfstqUQZAC3Lkr7P50iPO5YAPAfp3RiZBZAE3N7gotO7p5OsxnZC8c2a3FGwtq3gf6PABrQFcjzWscJ7lR37fGzs1AEFBitwVWgNdpS8EUZB2DtDFLqZAWBngZDZD&version=v2.7
  ;; Previous instructions: ;;http://stackoverflow.com/questions/12168452/long-lasting-fb-access-token-for-server-to-pull-fb-page-info/21927690#21927690
   ;; Should not expire:
   :page-admin-token
"EAAK3ZC3Rcp48BAFGqgwF0Hs2d5YQ0BD52koQyFEt1VIurEKgR8d3yT4X15Jng2wza5xAczDlpOX22hfdXKPorlaSqbmRamFU35AMSszZCHGMsxeEt5hluZB5VxV0RlynHLughZBdzoKzBe3jlTET65zbD2pZACscZD"})
