(ns hub.photo.schema
  "Photos service schema."
  (:require [schema.core :as s]))

;; # Schema

(def ID s/Str)

(s/defschema GeoTag
  {:lat s/Num
   :lng s/Num})

(s/defschema PixelCoords
  {:x-offset s/Int
   :y-offset s/Int})

(s/defschema Privacy
  (s/enum "dont-tag" "private" "friends" "public"))

(def UserID s/Str)

(s/defschema UserTag
  {:user-id UserID
   :privacy-level Privacy})

(def Bib s/Str)

(s/defschema Tag
  {:bib Bib
   (s/optional-key :coords) PixelCoords
   (s/optional-key :user-tag) UserTag})

(s/defschema Dims
  "height and width in pixels."
  {:height s/Int
   :width s/Int})

(def PhotoURL
  (s/named s/Str "Location of the photo."))

(def RaceID s/Str)

(s/defschema Source
  "Photo attribution details."
  {:description s/Str
   (s/optional-key :url) s/Str})

(s/defschema Photo
  "Schema for the photo object."
  {:id ID
   :race-id RaceID
   :photo-url PhotoURL
   :tags [Tag]
   :timestamp s/Int
   (s/optional-key :source) Source
   (s/optional-key :dimensions) Dims
   (s/optional-key :location) GeoTag})


;; Privacy Table

(s/defschema UserTagDoc
  (assoc UserTag :id s/Str))
