(ns hub.photo.setup
  "Setup of photo service - create database, tables, indices."
  (:require [hub.util.rethink :as ur :refer [args]]
            [hub.photo.service :as ps]
            [rethinkdb.query :as r]
            [schema.core :as s]))

(s/defn setup!
  "Basic setup for the photos table in RethinkDB."
  [db-name :- s/Str mode :- (s/enum :test :live)]
  (let [maybe-index (fn [table-name index-name query-fn]
                      (ur/maybe-create-index
                       index-name
                       (r/table (r/db db-name) table-name)
                       query-fn))
        photo-index (partial maybe-index ps/photo-table)
        privacy-index (partial maybe-index ps/privacy-table)]
    ;; Try to create the racehub database.
    (ur/run (ur/try-create db-name))

    ;; Try to create photo table.
    (ur/run (ur/try-table db-name ps/photo-table))

    ;; Same for the privacy table.
    (ur/run (ur/try-table db-name ps/privacy-table))

    (privacy-index "by-user-id"
                   (r/fn [row]
                     (r/get-field row :user-id)))))
