(ns hub.mailer.service.user
  "Emails for user related events (created, updated, merged, etc)."
  (:require [clojure.string :as st]
            [hub.mailer.service :as mail]
            [net.cgrand.enlive-html :as h]
            [schema.core :as s])
  (:import [java.io File]))

;; ## Welcome Emails

(s/defschema WelcomeEmail
  {:first-name (s/maybe s/Str)
   :username s/Str
   :to-email s/Str})

(h/defsnippet welcome-template
  (mail/template "welcome")
  [:body :> h/any-node]
  [first-name username]
  [h/any-node] (mail/replace-vars
                {:first-name first-name
                 :username username
                 ;; TODO: Fix these links!
                 :directory "https://racehubhq.com/races"
                 :profile-link "https://racehubhq.com/profile/races/upcoming"}))

(s/defn send-welcome-email!
  [{:keys [first-name username to-email]
    :or {first-name "there"}} :- WelcomeEmail]
  (mail/send-email {:to-email to-email
                    :subject "Welcome to RaceHub!"
                    :body (welcome-template first-name username)}))

;; ## Reset Password

(s/defschema ResetPassword
  {:first-name (s/maybe s/Str)
   :reset-code s/Str
   :to-email s/Str})

(h/defsnippet reset-password-template
  (mail/template "reset_password")
  [:body :> h/any-node]
  [replacements]
  [h/any-node] (mail/replace-vars replacements))

(s/defn email-pw-reset-code!
  [{:keys [to-email first-name reset-code]} :- ResetPassword]
  (mail/send-email {:to-email to-email
                    :subject "RaceHub Password Reset"
                    :body (reset-password-template
                           {:first-name (or first-name "there")
                            :reset-code reset-code})}))
