(ns hub.mailer.conf
  (:require [environ.core :as e]))

(def ^:dynamic *env* {})

(defn env
  ([] (merge e/env *env*))
  ([k] ((env) k))
  ([k default] (get (env) k default)))

(defn current-server
  []
  (let [prefix (case (env :mode :prod)
                 :dev "local."
                 :staging "staging."
                 :prod "")]
    (format "https://%sracehubhq.com" prefix)))
