(ns hub.mailer.service.invoice
  "Emails for invoice and transfer related events."
  (:require [clojure.string :as st]
            [hub.mailer.service :as mail]
            [net.cgrand.enlive-html :as h]
            [schema.core :as s])
  (:import [java.io File]))

(h/defsnippet invoice-template
  (mail/template "invoice")
  [:body :> h/any-node]
  [{:keys [title balance collected]}]
  [h/any-node] (replace-vars
                {:title title
                 :balance (u/pennies->currency collected)
                 :collected (u/pennies->currency collected)}))

(s/defn send-invoice-email :- ps/Channel
  "Sends an email record of an invoice."
  [invoice :- invoice/Invoice
   title :- regatta/Title
   emails :- [mandrill/Address]]
  (let [collected (invoice/collected-after-cc invoice)
        our-fees (invoice/paddleguru-fees invoice)
        stamp (t/timestamp->mdy (:created-at invoice))]
    (send-email {:to-email emails
                 :attachments [{:type "application/pdf"
                                :name (str "PaddleGuruInvoice" stamp ".pdf")
                                :content (pdf/invoice-attachment invoice)}]
                 :subject (str "PaddleGuru Invoice: " stamp)
                 :body (invoice-template {:title title
                                          :collected collected
                                          :balance (- collected our-fees)})})))
