(defproject {{ns-name}} "0.1.0"
  :description "HU Template for general clojure apps"
  :url "http://org.clojars.padfootprong/{{ns-name}}"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :repositories [["private" {:url "s3p://maven.repo/releases/" :creds :gpg}]]
  :dependencies [[org.clojure/clojure "1.6.0"]
                 [cheshire "5.4.0"]
                 [com.taoensso/timbre "3.3.1"]
                 [clj-time "0.9.0"]
                 [clj-http "1.0.1"]
                 [yesql "0.4.0"]
                 [mysql/mysql-connector-java "5.1.34"]
                 [com.novemberain/langohr "3.0.1"]
                 [volans "0.1.2"]]
  :plugins [[s3-wagon-private "1.1.2"]]
  :target-path "target/%s"
  :profiles {:dev {:dependencies [[midje "1.6.3"]]
                   :plugins [[lein-midje "3.1.3"]]}
             :uberjar {:aot :all}}
  :main ^:skip-aot {{ns-name}}.core)
