(ns {{ns-name}}.db
  (:use [pulsar.constants])
  (:require [clojure.java.jdbc :as jdbc]
            [yesql.core :refer [defquery]]))

; Read only aurora db
(def aurora-ro-db-conn
  {:classname "com.mysql.jdbc.Driver"
   :subprotocol "mysql"
   :subname (str "//" AURORA_RO_DB_HOST ":" AURORA_RO_DB_PORT "/" AURORA_RO_DB_NAME)
   :user AURORA_RO_DB_USER
   :password AURORA_RO_DB_PASSWORD})

; Master DB with write permissions
(def aurora-db-conn
  {:classname "com.mysql.jdbc.Driver"
   :subprotocol "mysql"
   :subname (str "//" AURORA_DB_HOST ":" AURORA_DB_PORT "/" AURORA_DB_NAME)
   :user AURORA_DB_USER
   :password AURORA_DB_PASSWORD})

(defn execute-select-ro
  "Generic function to execute select queries on read-only-db"
  [method & args]
  (apply method aurora-ro-db-conn args))

(defn execute-on-master-db
  "Generic function to execute against master db for write/update/delete queries"
  [method & args]
  (apply method aurora-db-conn args))
