(ns {{ns-name}}.core
  (:require [{{ns-name}}.constants :refer :all]
            [taoensso.timbre :as log :refer (trace debug info warn error report)])
  (:gen-class))

(defn config-logger!
  "Config the log level among (:trace :debug :info :warn :error :fatal :report)"
  [loglevel]
  (println "Configuring logger..." LOG_PATH ", level: " loglevel)
  (log/set-level! loglevel)
  (log/set-config! [:timestamp-pattern] "yyyy-MMM-dd HH:mm:ss")
  (log/set-config! [:timestamp-locale] (java.util.Locale/UK))
  (log/set-config! [:appenders :spit :enabled?] true)
  (log/set-config! [:shared-appender-config :spit-filename] LOG_PATH))

(defn -main
  ""
  [& args]

  (config-logger! LOG_LEVEL)

  (println "Welcome to HU app"))
