(ns leiningen.new.huapp
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "huapp"))

(defn huapp
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
["project.clj" (render "project.clj" data)]
["test/{{sanitized}}/core_test.clj" (render "core_test.clj" data)]
["src/{{sanitized}}/constants.clj" (render "constants.clj" data)]
["src/{{sanitized}}/db.clj" (render "db.clj" data)]
["src/{{sanitized}}/rabbitmq.clj" (render "rabbitmq.clj" data)]
)))