(ns lein-git-version.plugin
  (:use
   clojure.pprint
   [leiningen.git-version :only [get-git-version get-git-rev numcommits-gitrev]]))

(defn middleware
  [project]
  (let [code (str
              ";; Do not edit.  Generated by lein-git-version plugin.\n"
              "(ns " (:name project) ".version)\n"
              "(def version \"" (numcommits-gitrev) "\")\n")
        proj-dir (.toLowerCase (.replace (:name project) \- \_))
        filename (if (:git-version-path project)
                   (str (:git-version-path project) "/version.clj")
                   (str (or (first (:source-paths project)) "src") "/"
                        proj-dir "/version.clj"))]
    (spit filename code)
    (assoc project :version (numcommits-gitrev))))
