// Compiled by ClojureScript 1.9.518 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args26625 = [];
var len__9181__auto___26631 = arguments.length;
var i__9182__auto___26632 = (0);
while(true){
if((i__9182__auto___26632 < len__9181__auto___26631)){
args26625.push((arguments[i__9182__auto___26632]));

var G__26633 = (i__9182__auto___26632 + (1));
i__9182__auto___26632 = G__26633;
continue;
} else {
}
break;
}

var G__26627 = args26625.length;
switch (G__26627) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26625.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async26628 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26628 = (function (f,blockable,meta26629){
this.f = f;
this.blockable = blockable;
this.meta26629 = meta26629;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26628.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26630,meta26629__$1){
var self__ = this;
var _26630__$1 = this;
return (new cljs.core.async.t_cljs$core$async26628(self__.f,self__.blockable,meta26629__$1));
});

cljs.core.async.t_cljs$core$async26628.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26630){
var self__ = this;
var _26630__$1 = this;
return self__.meta26629;
});

cljs.core.async.t_cljs$core$async26628.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26628.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async26628.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async26628.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async26628.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta26629], null);
});

cljs.core.async.t_cljs$core$async26628.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26628.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26628";

cljs.core.async.t_cljs$core$async26628.cljs$lang$ctorPrWriter = (function (this__8617__auto__,writer__8618__auto__,opt__8619__auto__){
return cljs.core._write(writer__8618__auto__,"cljs.core.async/t_cljs$core$async26628");
});

cljs.core.async.__GT_t_cljs$core$async26628 = (function cljs$core$async$__GT_t_cljs$core$async26628(f__$1,blockable__$1,meta26629){
return (new cljs.core.async.t_cljs$core$async26628(f__$1,blockable__$1,meta26629));
});

}

return (new cljs.core.async.t_cljs$core$async26628(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args26637 = [];
var len__9181__auto___26640 = arguments.length;
var i__9182__auto___26641 = (0);
while(true){
if((i__9182__auto___26641 < len__9181__auto___26640)){
args26637.push((arguments[i__9182__auto___26641]));

var G__26642 = (i__9182__auto___26641 + (1));
i__9182__auto___26641 = G__26642;
continue;
} else {
}
break;
}

var G__26639 = args26637.length;
switch (G__26639) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26637.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args26644 = [];
var len__9181__auto___26647 = arguments.length;
var i__9182__auto___26648 = (0);
while(true){
if((i__9182__auto___26648 < len__9181__auto___26647)){
args26644.push((arguments[i__9182__auto___26648]));

var G__26649 = (i__9182__auto___26648 + (1));
i__9182__auto___26648 = G__26649;
continue;
} else {
}
break;
}

var G__26646 = args26644.length;
switch (G__26646) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26644.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args26651 = [];
var len__9181__auto___26654 = arguments.length;
var i__9182__auto___26655 = (0);
while(true){
if((i__9182__auto___26655 < len__9181__auto___26654)){
args26651.push((arguments[i__9182__auto___26655]));

var G__26656 = (i__9182__auto___26655 + (1));
i__9182__auto___26655 = G__26656;
continue;
} else {
}
break;
}

var G__26653 = args26651.length;
switch (G__26653) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26651.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_26658 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_26658) : fn1.call(null,val_26658));
} else {
cljs.core.async.impl.dispatch.run(((function (val_26658,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_26658) : fn1.call(null,val_26658));
});})(val_26658,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args26659 = [];
var len__9181__auto___26662 = arguments.length;
var i__9182__auto___26663 = (0);
while(true){
if((i__9182__auto___26663 < len__9181__auto___26662)){
args26659.push((arguments[i__9182__auto___26663]));

var G__26664 = (i__9182__auto___26663 + (1));
i__9182__auto___26663 = G__26664;
continue;
} else {
}
break;
}

var G__26661 = args26659.length;
switch (G__26661) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26659.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8981__auto___26666 = n;
var x_26667 = (0);
while(true){
if((x_26667 < n__8981__auto___26666)){
(a[x_26667] = (0));

var G__26668 = (x_26667 + (1));
x_26667 = G__26668;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__26669 = (i + (1));
i = G__26669;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async26673 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26673 = (function (flag,meta26674){
this.flag = flag;
this.meta26674 = meta26674;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26673.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_26675,meta26674__$1){
var self__ = this;
var _26675__$1 = this;
return (new cljs.core.async.t_cljs$core$async26673(self__.flag,meta26674__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async26673.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_26675){
var self__ = this;
var _26675__$1 = this;
return self__.meta26674;
});})(flag))
;

cljs.core.async.t_cljs$core$async26673.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26673.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async26673.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async26673.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async26673.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta26674], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async26673.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26673.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26673";

cljs.core.async.t_cljs$core$async26673.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8617__auto__,writer__8618__auto__,opt__8619__auto__){
return cljs.core._write(writer__8618__auto__,"cljs.core.async/t_cljs$core$async26673");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async26673 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async26673(flag__$1,meta26674){
return (new cljs.core.async.t_cljs$core$async26673(flag__$1,meta26674));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async26673(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async26679 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26679 = (function (flag,cb,meta26680){
this.flag = flag;
this.cb = cb;
this.meta26680 = meta26680;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26679.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26681,meta26680__$1){
var self__ = this;
var _26681__$1 = this;
return (new cljs.core.async.t_cljs$core$async26679(self__.flag,self__.cb,meta26680__$1));
});

cljs.core.async.t_cljs$core$async26679.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26681){
var self__ = this;
var _26681__$1 = this;
return self__.meta26680;
});

cljs.core.async.t_cljs$core$async26679.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26679.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async26679.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async26679.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async26679.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta26680], null);
});

cljs.core.async.t_cljs$core$async26679.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26679.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26679";

cljs.core.async.t_cljs$core$async26679.cljs$lang$ctorPrWriter = (function (this__8617__auto__,writer__8618__auto__,opt__8619__auto__){
return cljs.core._write(writer__8618__auto__,"cljs.core.async/t_cljs$core$async26679");
});

cljs.core.async.__GT_t_cljs$core$async26679 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async26679(flag__$1,cb__$1,meta26680){
return (new cljs.core.async.t_cljs$core$async26679(flag__$1,cb__$1,meta26680));
});

}

return (new cljs.core.async.t_cljs$core$async26679(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__26682_SHARP_){
var G__26686 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__26682_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__26686) : fret.call(null,G__26686));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__26683_SHARP_){
var G__26687 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__26683_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__26687) : fret.call(null,G__26687));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__7960__auto__ = wport;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return port;
}
})()], null));
} else {
var G__26688 = (i + (1));
i = G__26688;
continue;
}
} else {
return null;
}
break;
}
})();
var or__7960__auto__ = ret;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5457__auto__ = (function (){var and__7948__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__7948__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__7948__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__9188__auto__ = [];
var len__9181__auto___26694 = arguments.length;
var i__9182__auto___26695 = (0);
while(true){
if((i__9182__auto___26695 < len__9181__auto___26694)){
args__9188__auto__.push((arguments[i__9182__auto___26695]));

var G__26696 = (i__9182__auto___26695 + (1));
i__9182__auto___26695 = G__26696;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__26691){
var map__26692 = p__26691;
var map__26692__$1 = ((((!((map__26692 == null)))?((((map__26692.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26692.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26692):map__26692);
var opts = map__26692__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq26689){
var G__26690 = cljs.core.first(seq26689);
var seq26689__$1 = cljs.core.next(seq26689);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26690,seq26689__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args26697 = [];
var len__9181__auto___26747 = arguments.length;
var i__9182__auto___26748 = (0);
while(true){
if((i__9182__auto___26748 < len__9181__auto___26747)){
args26697.push((arguments[i__9182__auto___26748]));

var G__26749 = (i__9182__auto___26748 + (1));
i__9182__auto___26748 = G__26749;
continue;
} else {
}
break;
}

var G__26699 = args26697.length;
switch (G__26699) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26697.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__26566__auto___26751 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___26751){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___26751){
return (function (state_26723){
var state_val_26724 = (state_26723[(1)]);
if((state_val_26724 === (7))){
var inst_26719 = (state_26723[(2)]);
var state_26723__$1 = state_26723;
var statearr_26725_26752 = state_26723__$1;
(statearr_26725_26752[(2)] = inst_26719);

(statearr_26725_26752[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26724 === (1))){
var state_26723__$1 = state_26723;
var statearr_26726_26753 = state_26723__$1;
(statearr_26726_26753[(2)] = null);

(statearr_26726_26753[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26724 === (4))){
var inst_26702 = (state_26723[(7)]);
var inst_26702__$1 = (state_26723[(2)]);
var inst_26703 = (inst_26702__$1 == null);
var state_26723__$1 = (function (){var statearr_26727 = state_26723;
(statearr_26727[(7)] = inst_26702__$1);

return statearr_26727;
})();
if(cljs.core.truth_(inst_26703)){
var statearr_26728_26754 = state_26723__$1;
(statearr_26728_26754[(1)] = (5));

} else {
var statearr_26729_26755 = state_26723__$1;
(statearr_26729_26755[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26724 === (13))){
var state_26723__$1 = state_26723;
var statearr_26730_26756 = state_26723__$1;
(statearr_26730_26756[(2)] = null);

(statearr_26730_26756[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26724 === (6))){
var inst_26702 = (state_26723[(7)]);
var state_26723__$1 = state_26723;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26723__$1,(11),to,inst_26702);
} else {
if((state_val_26724 === (3))){
var inst_26721 = (state_26723[(2)]);
var state_26723__$1 = state_26723;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26723__$1,inst_26721);
} else {
if((state_val_26724 === (12))){
var state_26723__$1 = state_26723;
var statearr_26731_26757 = state_26723__$1;
(statearr_26731_26757[(2)] = null);

(statearr_26731_26757[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26724 === (2))){
var state_26723__$1 = state_26723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26723__$1,(4),from);
} else {
if((state_val_26724 === (11))){
var inst_26712 = (state_26723[(2)]);
var state_26723__$1 = state_26723;
if(cljs.core.truth_(inst_26712)){
var statearr_26732_26758 = state_26723__$1;
(statearr_26732_26758[(1)] = (12));

} else {
var statearr_26733_26759 = state_26723__$1;
(statearr_26733_26759[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26724 === (9))){
var state_26723__$1 = state_26723;
var statearr_26734_26760 = state_26723__$1;
(statearr_26734_26760[(2)] = null);

(statearr_26734_26760[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26724 === (5))){
var state_26723__$1 = state_26723;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26735_26761 = state_26723__$1;
(statearr_26735_26761[(1)] = (8));

} else {
var statearr_26736_26762 = state_26723__$1;
(statearr_26736_26762[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26724 === (14))){
var inst_26717 = (state_26723[(2)]);
var state_26723__$1 = state_26723;
var statearr_26737_26763 = state_26723__$1;
(statearr_26737_26763[(2)] = inst_26717);

(statearr_26737_26763[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26724 === (10))){
var inst_26709 = (state_26723[(2)]);
var state_26723__$1 = state_26723;
var statearr_26738_26764 = state_26723__$1;
(statearr_26738_26764[(2)] = inst_26709);

(statearr_26738_26764[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26724 === (8))){
var inst_26706 = cljs.core.async.close_BANG_(to);
var state_26723__$1 = state_26723;
var statearr_26739_26765 = state_26723__$1;
(statearr_26739_26765[(2)] = inst_26706);

(statearr_26739_26765[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___26751))
;
return ((function (switch__26440__auto__,c__26566__auto___26751){
return (function() {
var cljs$core$async$state_machine__26441__auto__ = null;
var cljs$core$async$state_machine__26441__auto____0 = (function (){
var statearr_26743 = [null,null,null,null,null,null,null,null];
(statearr_26743[(0)] = cljs$core$async$state_machine__26441__auto__);

(statearr_26743[(1)] = (1));

return statearr_26743;
});
var cljs$core$async$state_machine__26441__auto____1 = (function (state_26723){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_26723);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e26744){if((e26744 instanceof Object)){
var ex__26444__auto__ = e26744;
var statearr_26745_26766 = state_26723;
(statearr_26745_26766[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_26723);

return cljs.core.cst$kw$recur;
} else {
throw e26744;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__26767 = state_26723;
state_26723 = G__26767;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$state_machine__26441__auto__ = function(state_26723){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26441__auto____1.call(this,state_26723);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26441__auto____0;
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26441__auto____1;
return cljs$core$async$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___26751))
})();
var state__26568__auto__ = (function (){var statearr_26746 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_26746[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___26751);

return statearr_26746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___26751))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__26955){
var vec__26956 = p__26955;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26956,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26956,(1),null);
var job = vec__26956;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__26566__auto___27142 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___27142,res,vec__26956,v,p,job,jobs,results){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___27142,res,vec__26956,v,p,job,jobs,results){
return (function (state_26963){
var state_val_26964 = (state_26963[(1)]);
if((state_val_26964 === (1))){
var state_26963__$1 = state_26963;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26963__$1,(2),res,v);
} else {
if((state_val_26964 === (2))){
var inst_26960 = (state_26963[(2)]);
var inst_26961 = cljs.core.async.close_BANG_(res);
var state_26963__$1 = (function (){var statearr_26965 = state_26963;
(statearr_26965[(7)] = inst_26960);

return statearr_26965;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_26963__$1,inst_26961);
} else {
return null;
}
}
});})(c__26566__auto___27142,res,vec__26956,v,p,job,jobs,results))
;
return ((function (switch__26440__auto__,c__26566__auto___27142,res,vec__26956,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0 = (function (){
var statearr_26969 = [null,null,null,null,null,null,null,null];
(statearr_26969[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__);

(statearr_26969[(1)] = (1));

return statearr_26969;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1 = (function (state_26963){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_26963);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e26970){if((e26970 instanceof Object)){
var ex__26444__auto__ = e26970;
var statearr_26971_27143 = state_26963;
(statearr_26971_27143[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_26963);

return cljs.core.cst$kw$recur;
} else {
throw e26970;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__27144 = state_26963;
state_26963 = G__27144;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__ = function(state_26963){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1.call(this,state_26963);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___27142,res,vec__26956,v,p,job,jobs,results))
})();
var state__26568__auto__ = (function (){var statearr_26972 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_26972[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___27142);

return statearr_26972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___27142,res,vec__26956,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__26973){
var vec__26974 = p__26973;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26974,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26974,(1),null);
var job = vec__26974;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__8981__auto___27145 = n;
var __27146 = (0);
while(true){
if((__27146 < n__8981__auto___27145)){
var G__26977_27147 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__26977_27147) {
case "compute":
var c__26566__auto___27149 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__27146,c__26566__auto___27149,G__26977_27147,n__8981__auto___27145,jobs,results,process,async){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (__27146,c__26566__auto___27149,G__26977_27147,n__8981__auto___27145,jobs,results,process,async){
return (function (state_26990){
var state_val_26991 = (state_26990[(1)]);
if((state_val_26991 === (1))){
var state_26990__$1 = state_26990;
var statearr_26992_27150 = state_26990__$1;
(statearr_26992_27150[(2)] = null);

(statearr_26992_27150[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26991 === (2))){
var state_26990__$1 = state_26990;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26990__$1,(4),jobs);
} else {
if((state_val_26991 === (3))){
var inst_26988 = (state_26990[(2)]);
var state_26990__$1 = state_26990;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26990__$1,inst_26988);
} else {
if((state_val_26991 === (4))){
var inst_26980 = (state_26990[(2)]);
var inst_26981 = process(inst_26980);
var state_26990__$1 = state_26990;
if(cljs.core.truth_(inst_26981)){
var statearr_26993_27151 = state_26990__$1;
(statearr_26993_27151[(1)] = (5));

} else {
var statearr_26994_27152 = state_26990__$1;
(statearr_26994_27152[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26991 === (5))){
var state_26990__$1 = state_26990;
var statearr_26995_27153 = state_26990__$1;
(statearr_26995_27153[(2)] = null);

(statearr_26995_27153[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26991 === (6))){
var state_26990__$1 = state_26990;
var statearr_26996_27154 = state_26990__$1;
(statearr_26996_27154[(2)] = null);

(statearr_26996_27154[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26991 === (7))){
var inst_26986 = (state_26990[(2)]);
var state_26990__$1 = state_26990;
var statearr_26997_27155 = state_26990__$1;
(statearr_26997_27155[(2)] = inst_26986);

(statearr_26997_27155[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__27146,c__26566__auto___27149,G__26977_27147,n__8981__auto___27145,jobs,results,process,async))
;
return ((function (__27146,switch__26440__auto__,c__26566__auto___27149,G__26977_27147,n__8981__auto___27145,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0 = (function (){
var statearr_27001 = [null,null,null,null,null,null,null];
(statearr_27001[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__);

(statearr_27001[(1)] = (1));

return statearr_27001;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1 = (function (state_26990){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_26990);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e27002){if((e27002 instanceof Object)){
var ex__26444__auto__ = e27002;
var statearr_27003_27156 = state_26990;
(statearr_27003_27156[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_26990);

return cljs.core.cst$kw$recur;
} else {
throw e27002;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__27157 = state_26990;
state_26990 = G__27157;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__ = function(state_26990){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1.call(this,state_26990);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__;
})()
;})(__27146,switch__26440__auto__,c__26566__auto___27149,G__26977_27147,n__8981__auto___27145,jobs,results,process,async))
})();
var state__26568__auto__ = (function (){var statearr_27004 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_27004[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___27149);

return statearr_27004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(__27146,c__26566__auto___27149,G__26977_27147,n__8981__auto___27145,jobs,results,process,async))
);


break;
case "async":
var c__26566__auto___27158 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__27146,c__26566__auto___27158,G__26977_27147,n__8981__auto___27145,jobs,results,process,async){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (__27146,c__26566__auto___27158,G__26977_27147,n__8981__auto___27145,jobs,results,process,async){
return (function (state_27017){
var state_val_27018 = (state_27017[(1)]);
if((state_val_27018 === (1))){
var state_27017__$1 = state_27017;
var statearr_27019_27159 = state_27017__$1;
(statearr_27019_27159[(2)] = null);

(statearr_27019_27159[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27018 === (2))){
var state_27017__$1 = state_27017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27017__$1,(4),jobs);
} else {
if((state_val_27018 === (3))){
var inst_27015 = (state_27017[(2)]);
var state_27017__$1 = state_27017;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27017__$1,inst_27015);
} else {
if((state_val_27018 === (4))){
var inst_27007 = (state_27017[(2)]);
var inst_27008 = async(inst_27007);
var state_27017__$1 = state_27017;
if(cljs.core.truth_(inst_27008)){
var statearr_27020_27160 = state_27017__$1;
(statearr_27020_27160[(1)] = (5));

} else {
var statearr_27021_27161 = state_27017__$1;
(statearr_27021_27161[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27018 === (5))){
var state_27017__$1 = state_27017;
var statearr_27022_27162 = state_27017__$1;
(statearr_27022_27162[(2)] = null);

(statearr_27022_27162[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27018 === (6))){
var state_27017__$1 = state_27017;
var statearr_27023_27163 = state_27017__$1;
(statearr_27023_27163[(2)] = null);

(statearr_27023_27163[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27018 === (7))){
var inst_27013 = (state_27017[(2)]);
var state_27017__$1 = state_27017;
var statearr_27024_27164 = state_27017__$1;
(statearr_27024_27164[(2)] = inst_27013);

(statearr_27024_27164[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__27146,c__26566__auto___27158,G__26977_27147,n__8981__auto___27145,jobs,results,process,async))
;
return ((function (__27146,switch__26440__auto__,c__26566__auto___27158,G__26977_27147,n__8981__auto___27145,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0 = (function (){
var statearr_27028 = [null,null,null,null,null,null,null];
(statearr_27028[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__);

(statearr_27028[(1)] = (1));

return statearr_27028;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1 = (function (state_27017){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_27017);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e27029){if((e27029 instanceof Object)){
var ex__26444__auto__ = e27029;
var statearr_27030_27165 = state_27017;
(statearr_27030_27165[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27017);

return cljs.core.cst$kw$recur;
} else {
throw e27029;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__27166 = state_27017;
state_27017 = G__27166;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__ = function(state_27017){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1.call(this,state_27017);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__;
})()
;})(__27146,switch__26440__auto__,c__26566__auto___27158,G__26977_27147,n__8981__auto___27145,jobs,results,process,async))
})();
var state__26568__auto__ = (function (){var statearr_27031 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_27031[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___27158);

return statearr_27031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(__27146,c__26566__auto___27158,G__26977_27147,n__8981__auto___27145,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__27167 = (__27146 + (1));
__27146 = G__27167;
continue;
} else {
}
break;
}

var c__26566__auto___27168 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___27168,jobs,results,process,async){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___27168,jobs,results,process,async){
return (function (state_27053){
var state_val_27054 = (state_27053[(1)]);
if((state_val_27054 === (1))){
var state_27053__$1 = state_27053;
var statearr_27055_27169 = state_27053__$1;
(statearr_27055_27169[(2)] = null);

(statearr_27055_27169[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27054 === (2))){
var state_27053__$1 = state_27053;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27053__$1,(4),from);
} else {
if((state_val_27054 === (3))){
var inst_27051 = (state_27053[(2)]);
var state_27053__$1 = state_27053;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27053__$1,inst_27051);
} else {
if((state_val_27054 === (4))){
var inst_27034 = (state_27053[(7)]);
var inst_27034__$1 = (state_27053[(2)]);
var inst_27035 = (inst_27034__$1 == null);
var state_27053__$1 = (function (){var statearr_27056 = state_27053;
(statearr_27056[(7)] = inst_27034__$1);

return statearr_27056;
})();
if(cljs.core.truth_(inst_27035)){
var statearr_27057_27170 = state_27053__$1;
(statearr_27057_27170[(1)] = (5));

} else {
var statearr_27058_27171 = state_27053__$1;
(statearr_27058_27171[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27054 === (5))){
var inst_27037 = cljs.core.async.close_BANG_(jobs);
var state_27053__$1 = state_27053;
var statearr_27059_27172 = state_27053__$1;
(statearr_27059_27172[(2)] = inst_27037);

(statearr_27059_27172[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27054 === (6))){
var inst_27034 = (state_27053[(7)]);
var inst_27039 = (state_27053[(8)]);
var inst_27039__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_27040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27041 = [inst_27034,inst_27039__$1];
var inst_27042 = (new cljs.core.PersistentVector(null,2,(5),inst_27040,inst_27041,null));
var state_27053__$1 = (function (){var statearr_27060 = state_27053;
(statearr_27060[(8)] = inst_27039__$1);

return statearr_27060;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27053__$1,(8),jobs,inst_27042);
} else {
if((state_val_27054 === (7))){
var inst_27049 = (state_27053[(2)]);
var state_27053__$1 = state_27053;
var statearr_27061_27173 = state_27053__$1;
(statearr_27061_27173[(2)] = inst_27049);

(statearr_27061_27173[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27054 === (8))){
var inst_27039 = (state_27053[(8)]);
var inst_27044 = (state_27053[(2)]);
var state_27053__$1 = (function (){var statearr_27062 = state_27053;
(statearr_27062[(9)] = inst_27044);

return statearr_27062;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27053__$1,(9),results,inst_27039);
} else {
if((state_val_27054 === (9))){
var inst_27046 = (state_27053[(2)]);
var state_27053__$1 = (function (){var statearr_27063 = state_27053;
(statearr_27063[(10)] = inst_27046);

return statearr_27063;
})();
var statearr_27064_27174 = state_27053__$1;
(statearr_27064_27174[(2)] = null);

(statearr_27064_27174[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___27168,jobs,results,process,async))
;
return ((function (switch__26440__auto__,c__26566__auto___27168,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0 = (function (){
var statearr_27068 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27068[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__);

(statearr_27068[(1)] = (1));

return statearr_27068;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1 = (function (state_27053){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_27053);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e27069){if((e27069 instanceof Object)){
var ex__26444__auto__ = e27069;
var statearr_27070_27175 = state_27053;
(statearr_27070_27175[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27053);

return cljs.core.cst$kw$recur;
} else {
throw e27069;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__27176 = state_27053;
state_27053 = G__27176;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__ = function(state_27053){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1.call(this,state_27053);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___27168,jobs,results,process,async))
})();
var state__26568__auto__ = (function (){var statearr_27071 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_27071[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___27168);

return statearr_27071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___27168,jobs,results,process,async))
);


var c__26566__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto__,jobs,results,process,async){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto__,jobs,results,process,async){
return (function (state_27109){
var state_val_27110 = (state_27109[(1)]);
if((state_val_27110 === (7))){
var inst_27105 = (state_27109[(2)]);
var state_27109__$1 = state_27109;
var statearr_27111_27177 = state_27109__$1;
(statearr_27111_27177[(2)] = inst_27105);

(statearr_27111_27177[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (20))){
var state_27109__$1 = state_27109;
var statearr_27112_27178 = state_27109__$1;
(statearr_27112_27178[(2)] = null);

(statearr_27112_27178[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (1))){
var state_27109__$1 = state_27109;
var statearr_27113_27179 = state_27109__$1;
(statearr_27113_27179[(2)] = null);

(statearr_27113_27179[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (4))){
var inst_27074 = (state_27109[(7)]);
var inst_27074__$1 = (state_27109[(2)]);
var inst_27075 = (inst_27074__$1 == null);
var state_27109__$1 = (function (){var statearr_27114 = state_27109;
(statearr_27114[(7)] = inst_27074__$1);

return statearr_27114;
})();
if(cljs.core.truth_(inst_27075)){
var statearr_27115_27180 = state_27109__$1;
(statearr_27115_27180[(1)] = (5));

} else {
var statearr_27116_27181 = state_27109__$1;
(statearr_27116_27181[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (15))){
var inst_27087 = (state_27109[(8)]);
var state_27109__$1 = state_27109;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27109__$1,(18),to,inst_27087);
} else {
if((state_val_27110 === (21))){
var inst_27100 = (state_27109[(2)]);
var state_27109__$1 = state_27109;
var statearr_27117_27182 = state_27109__$1;
(statearr_27117_27182[(2)] = inst_27100);

(statearr_27117_27182[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (13))){
var inst_27102 = (state_27109[(2)]);
var state_27109__$1 = (function (){var statearr_27118 = state_27109;
(statearr_27118[(9)] = inst_27102);

return statearr_27118;
})();
var statearr_27119_27183 = state_27109__$1;
(statearr_27119_27183[(2)] = null);

(statearr_27119_27183[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (6))){
var inst_27074 = (state_27109[(7)]);
var state_27109__$1 = state_27109;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27109__$1,(11),inst_27074);
} else {
if((state_val_27110 === (17))){
var inst_27095 = (state_27109[(2)]);
var state_27109__$1 = state_27109;
if(cljs.core.truth_(inst_27095)){
var statearr_27120_27184 = state_27109__$1;
(statearr_27120_27184[(1)] = (19));

} else {
var statearr_27121_27185 = state_27109__$1;
(statearr_27121_27185[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (3))){
var inst_27107 = (state_27109[(2)]);
var state_27109__$1 = state_27109;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27109__$1,inst_27107);
} else {
if((state_val_27110 === (12))){
var inst_27084 = (state_27109[(10)]);
var state_27109__$1 = state_27109;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27109__$1,(14),inst_27084);
} else {
if((state_val_27110 === (2))){
var state_27109__$1 = state_27109;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27109__$1,(4),results);
} else {
if((state_val_27110 === (19))){
var state_27109__$1 = state_27109;
var statearr_27122_27186 = state_27109__$1;
(statearr_27122_27186[(2)] = null);

(statearr_27122_27186[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (11))){
var inst_27084 = (state_27109[(2)]);
var state_27109__$1 = (function (){var statearr_27123 = state_27109;
(statearr_27123[(10)] = inst_27084);

return statearr_27123;
})();
var statearr_27124_27187 = state_27109__$1;
(statearr_27124_27187[(2)] = null);

(statearr_27124_27187[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (9))){
var state_27109__$1 = state_27109;
var statearr_27125_27188 = state_27109__$1;
(statearr_27125_27188[(2)] = null);

(statearr_27125_27188[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (5))){
var state_27109__$1 = state_27109;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27126_27189 = state_27109__$1;
(statearr_27126_27189[(1)] = (8));

} else {
var statearr_27127_27190 = state_27109__$1;
(statearr_27127_27190[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (14))){
var inst_27087 = (state_27109[(8)]);
var inst_27089 = (state_27109[(11)]);
var inst_27087__$1 = (state_27109[(2)]);
var inst_27088 = (inst_27087__$1 == null);
var inst_27089__$1 = cljs.core.not(inst_27088);
var state_27109__$1 = (function (){var statearr_27128 = state_27109;
(statearr_27128[(8)] = inst_27087__$1);

(statearr_27128[(11)] = inst_27089__$1);

return statearr_27128;
})();
if(inst_27089__$1){
var statearr_27129_27191 = state_27109__$1;
(statearr_27129_27191[(1)] = (15));

} else {
var statearr_27130_27192 = state_27109__$1;
(statearr_27130_27192[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (16))){
var inst_27089 = (state_27109[(11)]);
var state_27109__$1 = state_27109;
var statearr_27131_27193 = state_27109__$1;
(statearr_27131_27193[(2)] = inst_27089);

(statearr_27131_27193[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (10))){
var inst_27081 = (state_27109[(2)]);
var state_27109__$1 = state_27109;
var statearr_27132_27194 = state_27109__$1;
(statearr_27132_27194[(2)] = inst_27081);

(statearr_27132_27194[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (18))){
var inst_27092 = (state_27109[(2)]);
var state_27109__$1 = state_27109;
var statearr_27133_27195 = state_27109__$1;
(statearr_27133_27195[(2)] = inst_27092);

(statearr_27133_27195[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27110 === (8))){
var inst_27078 = cljs.core.async.close_BANG_(to);
var state_27109__$1 = state_27109;
var statearr_27134_27196 = state_27109__$1;
(statearr_27134_27196[(2)] = inst_27078);

(statearr_27134_27196[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto__,jobs,results,process,async))
;
return ((function (switch__26440__auto__,c__26566__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0 = (function (){
var statearr_27138 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27138[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__);

(statearr_27138[(1)] = (1));

return statearr_27138;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1 = (function (state_27109){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_27109);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e27139){if((e27139 instanceof Object)){
var ex__26444__auto__ = e27139;
var statearr_27140_27197 = state_27109;
(statearr_27140_27197[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27109);

return cljs.core.cst$kw$recur;
} else {
throw e27139;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__27198 = state_27109;
state_27109 = G__27198;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__ = function(state_27109){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1.call(this,state_27109);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26441__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto__,jobs,results,process,async))
})();
var state__26568__auto__ = (function (){var statearr_27141 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_27141[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto__);

return statearr_27141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto__,jobs,results,process,async))
);

return c__26566__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args27199 = [];
var len__9181__auto___27202 = arguments.length;
var i__9182__auto___27203 = (0);
while(true){
if((i__9182__auto___27203 < len__9181__auto___27202)){
args27199.push((arguments[i__9182__auto___27203]));

var G__27204 = (i__9182__auto___27203 + (1));
i__9182__auto___27203 = G__27204;
continue;
} else {
}
break;
}

var G__27201 = args27199.length;
switch (G__27201) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args27199.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args27206 = [];
var len__9181__auto___27209 = arguments.length;
var i__9182__auto___27210 = (0);
while(true){
if((i__9182__auto___27210 < len__9181__auto___27209)){
args27206.push((arguments[i__9182__auto___27210]));

var G__27211 = (i__9182__auto___27210 + (1));
i__9182__auto___27210 = G__27211;
continue;
} else {
}
break;
}

var G__27208 = args27206.length;
switch (G__27208) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args27206.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args27213 = [];
var len__9181__auto___27266 = arguments.length;
var i__9182__auto___27267 = (0);
while(true){
if((i__9182__auto___27267 < len__9181__auto___27266)){
args27213.push((arguments[i__9182__auto___27267]));

var G__27268 = (i__9182__auto___27267 + (1));
i__9182__auto___27267 = G__27268;
continue;
} else {
}
break;
}

var G__27215 = args27213.length;
switch (G__27215) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args27213.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__26566__auto___27270 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___27270,tc,fc){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___27270,tc,fc){
return (function (state_27241){
var state_val_27242 = (state_27241[(1)]);
if((state_val_27242 === (7))){
var inst_27237 = (state_27241[(2)]);
var state_27241__$1 = state_27241;
var statearr_27243_27271 = state_27241__$1;
(statearr_27243_27271[(2)] = inst_27237);

(statearr_27243_27271[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27242 === (1))){
var state_27241__$1 = state_27241;
var statearr_27244_27272 = state_27241__$1;
(statearr_27244_27272[(2)] = null);

(statearr_27244_27272[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27242 === (4))){
var inst_27218 = (state_27241[(7)]);
var inst_27218__$1 = (state_27241[(2)]);
var inst_27219 = (inst_27218__$1 == null);
var state_27241__$1 = (function (){var statearr_27245 = state_27241;
(statearr_27245[(7)] = inst_27218__$1);

return statearr_27245;
})();
if(cljs.core.truth_(inst_27219)){
var statearr_27246_27273 = state_27241__$1;
(statearr_27246_27273[(1)] = (5));

} else {
var statearr_27247_27274 = state_27241__$1;
(statearr_27247_27274[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27242 === (13))){
var state_27241__$1 = state_27241;
var statearr_27248_27275 = state_27241__$1;
(statearr_27248_27275[(2)] = null);

(statearr_27248_27275[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27242 === (6))){
var inst_27218 = (state_27241[(7)]);
var inst_27224 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_27218) : p.call(null,inst_27218));
var state_27241__$1 = state_27241;
if(cljs.core.truth_(inst_27224)){
var statearr_27249_27276 = state_27241__$1;
(statearr_27249_27276[(1)] = (9));

} else {
var statearr_27250_27277 = state_27241__$1;
(statearr_27250_27277[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27242 === (3))){
var inst_27239 = (state_27241[(2)]);
var state_27241__$1 = state_27241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27241__$1,inst_27239);
} else {
if((state_val_27242 === (12))){
var state_27241__$1 = state_27241;
var statearr_27251_27278 = state_27241__$1;
(statearr_27251_27278[(2)] = null);

(statearr_27251_27278[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27242 === (2))){
var state_27241__$1 = state_27241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27241__$1,(4),ch);
} else {
if((state_val_27242 === (11))){
var inst_27218 = (state_27241[(7)]);
var inst_27228 = (state_27241[(2)]);
var state_27241__$1 = state_27241;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27241__$1,(8),inst_27228,inst_27218);
} else {
if((state_val_27242 === (9))){
var state_27241__$1 = state_27241;
var statearr_27252_27279 = state_27241__$1;
(statearr_27252_27279[(2)] = tc);

(statearr_27252_27279[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27242 === (5))){
var inst_27221 = cljs.core.async.close_BANG_(tc);
var inst_27222 = cljs.core.async.close_BANG_(fc);
var state_27241__$1 = (function (){var statearr_27253 = state_27241;
(statearr_27253[(8)] = inst_27221);

return statearr_27253;
})();
var statearr_27254_27280 = state_27241__$1;
(statearr_27254_27280[(2)] = inst_27222);

(statearr_27254_27280[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27242 === (14))){
var inst_27235 = (state_27241[(2)]);
var state_27241__$1 = state_27241;
var statearr_27255_27281 = state_27241__$1;
(statearr_27255_27281[(2)] = inst_27235);

(statearr_27255_27281[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27242 === (10))){
var state_27241__$1 = state_27241;
var statearr_27256_27282 = state_27241__$1;
(statearr_27256_27282[(2)] = fc);

(statearr_27256_27282[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27242 === (8))){
var inst_27230 = (state_27241[(2)]);
var state_27241__$1 = state_27241;
if(cljs.core.truth_(inst_27230)){
var statearr_27257_27283 = state_27241__$1;
(statearr_27257_27283[(1)] = (12));

} else {
var statearr_27258_27284 = state_27241__$1;
(statearr_27258_27284[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___27270,tc,fc))
;
return ((function (switch__26440__auto__,c__26566__auto___27270,tc,fc){
return (function() {
var cljs$core$async$state_machine__26441__auto__ = null;
var cljs$core$async$state_machine__26441__auto____0 = (function (){
var statearr_27262 = [null,null,null,null,null,null,null,null,null];
(statearr_27262[(0)] = cljs$core$async$state_machine__26441__auto__);

(statearr_27262[(1)] = (1));

return statearr_27262;
});
var cljs$core$async$state_machine__26441__auto____1 = (function (state_27241){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_27241);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e27263){if((e27263 instanceof Object)){
var ex__26444__auto__ = e27263;
var statearr_27264_27285 = state_27241;
(statearr_27264_27285[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27241);

return cljs.core.cst$kw$recur;
} else {
throw e27263;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__27286 = state_27241;
state_27241 = G__27286;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$state_machine__26441__auto__ = function(state_27241){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26441__auto____1.call(this,state_27241);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26441__auto____0;
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26441__auto____1;
return cljs$core$async$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___27270,tc,fc))
})();
var state__26568__auto__ = (function (){var statearr_27265 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_27265[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___27270);

return statearr_27265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___27270,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__26566__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto__){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto__){
return (function (state_27350){
var state_val_27351 = (state_27350[(1)]);
if((state_val_27351 === (7))){
var inst_27346 = (state_27350[(2)]);
var state_27350__$1 = state_27350;
var statearr_27352_27373 = state_27350__$1;
(statearr_27352_27373[(2)] = inst_27346);

(statearr_27352_27373[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27351 === (1))){
var inst_27330 = init;
var state_27350__$1 = (function (){var statearr_27353 = state_27350;
(statearr_27353[(7)] = inst_27330);

return statearr_27353;
})();
var statearr_27354_27374 = state_27350__$1;
(statearr_27354_27374[(2)] = null);

(statearr_27354_27374[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27351 === (4))){
var inst_27333 = (state_27350[(8)]);
var inst_27333__$1 = (state_27350[(2)]);
var inst_27334 = (inst_27333__$1 == null);
var state_27350__$1 = (function (){var statearr_27355 = state_27350;
(statearr_27355[(8)] = inst_27333__$1);

return statearr_27355;
})();
if(cljs.core.truth_(inst_27334)){
var statearr_27356_27375 = state_27350__$1;
(statearr_27356_27375[(1)] = (5));

} else {
var statearr_27357_27376 = state_27350__$1;
(statearr_27357_27376[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27351 === (6))){
var inst_27330 = (state_27350[(7)]);
var inst_27337 = (state_27350[(9)]);
var inst_27333 = (state_27350[(8)]);
var inst_27337__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_27330,inst_27333) : f.call(null,inst_27330,inst_27333));
var inst_27338 = cljs.core.reduced_QMARK_(inst_27337__$1);
var state_27350__$1 = (function (){var statearr_27358 = state_27350;
(statearr_27358[(9)] = inst_27337__$1);

return statearr_27358;
})();
if(inst_27338){
var statearr_27359_27377 = state_27350__$1;
(statearr_27359_27377[(1)] = (8));

} else {
var statearr_27360_27378 = state_27350__$1;
(statearr_27360_27378[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27351 === (3))){
var inst_27348 = (state_27350[(2)]);
var state_27350__$1 = state_27350;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27350__$1,inst_27348);
} else {
if((state_val_27351 === (2))){
var state_27350__$1 = state_27350;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27350__$1,(4),ch);
} else {
if((state_val_27351 === (9))){
var inst_27337 = (state_27350[(9)]);
var inst_27330 = inst_27337;
var state_27350__$1 = (function (){var statearr_27361 = state_27350;
(statearr_27361[(7)] = inst_27330);

return statearr_27361;
})();
var statearr_27362_27379 = state_27350__$1;
(statearr_27362_27379[(2)] = null);

(statearr_27362_27379[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27351 === (5))){
var inst_27330 = (state_27350[(7)]);
var state_27350__$1 = state_27350;
var statearr_27363_27380 = state_27350__$1;
(statearr_27363_27380[(2)] = inst_27330);

(statearr_27363_27380[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27351 === (10))){
var inst_27344 = (state_27350[(2)]);
var state_27350__$1 = state_27350;
var statearr_27364_27381 = state_27350__$1;
(statearr_27364_27381[(2)] = inst_27344);

(statearr_27364_27381[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27351 === (8))){
var inst_27337 = (state_27350[(9)]);
var inst_27340 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_27337) : cljs.core.deref.call(null,inst_27337));
var state_27350__$1 = state_27350;
var statearr_27365_27382 = state_27350__$1;
(statearr_27365_27382[(2)] = inst_27340);

(statearr_27365_27382[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto__))
;
return ((function (switch__26440__auto__,c__26566__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__26441__auto__ = null;
var cljs$core$async$reduce_$_state_machine__26441__auto____0 = (function (){
var statearr_27369 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27369[(0)] = cljs$core$async$reduce_$_state_machine__26441__auto__);

(statearr_27369[(1)] = (1));

return statearr_27369;
});
var cljs$core$async$reduce_$_state_machine__26441__auto____1 = (function (state_27350){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_27350);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e27370){if((e27370 instanceof Object)){
var ex__26444__auto__ = e27370;
var statearr_27371_27383 = state_27350;
(statearr_27371_27383[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27350);

return cljs.core.cst$kw$recur;
} else {
throw e27370;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__27384 = state_27350;
state_27350 = G__27384;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__26441__auto__ = function(state_27350){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__26441__auto____1.call(this,state_27350);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__26441__auto____0;
cljs$core$async$reduce_$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__26441__auto____1;
return cljs$core$async$reduce_$_state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto__))
})();
var state__26568__auto__ = (function (){var statearr_27372 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_27372[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto__);

return statearr_27372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto__))
);

return c__26566__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__26566__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto__,f__$1){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto__,f__$1){
return (function (state_27404){
var state_val_27405 = (state_27404[(1)]);
if((state_val_27405 === (1))){
var inst_27399 = cljs.core.async.reduce(f__$1,init,ch);
var state_27404__$1 = state_27404;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27404__$1,(2),inst_27399);
} else {
if((state_val_27405 === (2))){
var inst_27401 = (state_27404[(2)]);
var inst_27402 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_27401) : f__$1.call(null,inst_27401));
var state_27404__$1 = state_27404;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27404__$1,inst_27402);
} else {
return null;
}
}
});})(c__26566__auto__,f__$1))
;
return ((function (switch__26440__auto__,c__26566__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__26441__auto__ = null;
var cljs$core$async$transduce_$_state_machine__26441__auto____0 = (function (){
var statearr_27409 = [null,null,null,null,null,null,null];
(statearr_27409[(0)] = cljs$core$async$transduce_$_state_machine__26441__auto__);

(statearr_27409[(1)] = (1));

return statearr_27409;
});
var cljs$core$async$transduce_$_state_machine__26441__auto____1 = (function (state_27404){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_27404);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e27410){if((e27410 instanceof Object)){
var ex__26444__auto__ = e27410;
var statearr_27411_27413 = state_27404;
(statearr_27411_27413[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27404);

return cljs.core.cst$kw$recur;
} else {
throw e27410;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__27414 = state_27404;
state_27404 = G__27414;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__26441__auto__ = function(state_27404){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__26441__auto____1.call(this,state_27404);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__26441__auto____0;
cljs$core$async$transduce_$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__26441__auto____1;
return cljs$core$async$transduce_$_state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto__,f__$1))
})();
var state__26568__auto__ = (function (){var statearr_27412 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_27412[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto__);

return statearr_27412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto__,f__$1))
);

return c__26566__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args27415 = [];
var len__9181__auto___27467 = arguments.length;
var i__9182__auto___27468 = (0);
while(true){
if((i__9182__auto___27468 < len__9181__auto___27467)){
args27415.push((arguments[i__9182__auto___27468]));

var G__27469 = (i__9182__auto___27468 + (1));
i__9182__auto___27468 = G__27469;
continue;
} else {
}
break;
}

var G__27417 = args27415.length;
switch (G__27417) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args27415.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__26566__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto__){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto__){
return (function (state_27442){
var state_val_27443 = (state_27442[(1)]);
if((state_val_27443 === (7))){
var inst_27424 = (state_27442[(2)]);
var state_27442__$1 = state_27442;
var statearr_27444_27471 = state_27442__$1;
(statearr_27444_27471[(2)] = inst_27424);

(statearr_27444_27471[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27443 === (1))){
var inst_27418 = cljs.core.seq(coll);
var inst_27419 = inst_27418;
var state_27442__$1 = (function (){var statearr_27445 = state_27442;
(statearr_27445[(7)] = inst_27419);

return statearr_27445;
})();
var statearr_27446_27472 = state_27442__$1;
(statearr_27446_27472[(2)] = null);

(statearr_27446_27472[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27443 === (4))){
var inst_27419 = (state_27442[(7)]);
var inst_27422 = cljs.core.first(inst_27419);
var state_27442__$1 = state_27442;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27442__$1,(7),ch,inst_27422);
} else {
if((state_val_27443 === (13))){
var inst_27436 = (state_27442[(2)]);
var state_27442__$1 = state_27442;
var statearr_27447_27473 = state_27442__$1;
(statearr_27447_27473[(2)] = inst_27436);

(statearr_27447_27473[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27443 === (6))){
var inst_27427 = (state_27442[(2)]);
var state_27442__$1 = state_27442;
if(cljs.core.truth_(inst_27427)){
var statearr_27448_27474 = state_27442__$1;
(statearr_27448_27474[(1)] = (8));

} else {
var statearr_27449_27475 = state_27442__$1;
(statearr_27449_27475[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27443 === (3))){
var inst_27440 = (state_27442[(2)]);
var state_27442__$1 = state_27442;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27442__$1,inst_27440);
} else {
if((state_val_27443 === (12))){
var state_27442__$1 = state_27442;
var statearr_27450_27476 = state_27442__$1;
(statearr_27450_27476[(2)] = null);

(statearr_27450_27476[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27443 === (2))){
var inst_27419 = (state_27442[(7)]);
var state_27442__$1 = state_27442;
if(cljs.core.truth_(inst_27419)){
var statearr_27451_27477 = state_27442__$1;
(statearr_27451_27477[(1)] = (4));

} else {
var statearr_27452_27478 = state_27442__$1;
(statearr_27452_27478[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27443 === (11))){
var inst_27433 = cljs.core.async.close_BANG_(ch);
var state_27442__$1 = state_27442;
var statearr_27453_27479 = state_27442__$1;
(statearr_27453_27479[(2)] = inst_27433);

(statearr_27453_27479[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27443 === (9))){
var state_27442__$1 = state_27442;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27454_27480 = state_27442__$1;
(statearr_27454_27480[(1)] = (11));

} else {
var statearr_27455_27481 = state_27442__$1;
(statearr_27455_27481[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27443 === (5))){
var inst_27419 = (state_27442[(7)]);
var state_27442__$1 = state_27442;
var statearr_27456_27482 = state_27442__$1;
(statearr_27456_27482[(2)] = inst_27419);

(statearr_27456_27482[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27443 === (10))){
var inst_27438 = (state_27442[(2)]);
var state_27442__$1 = state_27442;
var statearr_27457_27483 = state_27442__$1;
(statearr_27457_27483[(2)] = inst_27438);

(statearr_27457_27483[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27443 === (8))){
var inst_27419 = (state_27442[(7)]);
var inst_27429 = cljs.core.next(inst_27419);
var inst_27419__$1 = inst_27429;
var state_27442__$1 = (function (){var statearr_27458 = state_27442;
(statearr_27458[(7)] = inst_27419__$1);

return statearr_27458;
})();
var statearr_27459_27484 = state_27442__$1;
(statearr_27459_27484[(2)] = null);

(statearr_27459_27484[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto__))
;
return ((function (switch__26440__auto__,c__26566__auto__){
return (function() {
var cljs$core$async$state_machine__26441__auto__ = null;
var cljs$core$async$state_machine__26441__auto____0 = (function (){
var statearr_27463 = [null,null,null,null,null,null,null,null];
(statearr_27463[(0)] = cljs$core$async$state_machine__26441__auto__);

(statearr_27463[(1)] = (1));

return statearr_27463;
});
var cljs$core$async$state_machine__26441__auto____1 = (function (state_27442){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_27442);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e27464){if((e27464 instanceof Object)){
var ex__26444__auto__ = e27464;
var statearr_27465_27485 = state_27442;
(statearr_27465_27485[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27442);

return cljs.core.cst$kw$recur;
} else {
throw e27464;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__27486 = state_27442;
state_27442 = G__27486;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$state_machine__26441__auto__ = function(state_27442){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26441__auto____1.call(this,state_27442);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26441__auto____0;
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26441__auto____1;
return cljs$core$async$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto__))
})();
var state__26568__auto__ = (function (){var statearr_27466 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_27466[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto__);

return statearr_27466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto__))
);

return c__26566__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8678__auto__ = (((_ == null))?null:_);
var m__8679__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__8679__auto__.call(null,_));
} else {
var m__8679__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__8679__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__8679__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__8679__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__8679__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8679__auto__.call(null,m,ch));
} else {
var m__8679__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8679__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__8679__auto__.call(null,m));
} else {
var m__8679__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__8679__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__27715 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__27715) : cljs.core.atom.call(null,G__27715));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async27716 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27716 = (function (ch,cs,meta27717){
this.ch = ch;
this.cs = cs;
this.meta27717 = meta27717;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async27716.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_27718,meta27717__$1){
var self__ = this;
var _27718__$1 = this;
return (new cljs.core.async.t_cljs$core$async27716(self__.ch,self__.cs,meta27717__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async27716.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_27718){
var self__ = this;
var _27718__$1 = this;
return self__.meta27717;
});})(cs))
;

cljs.core.async.t_cljs$core$async27716.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27716.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async27716.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27716.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async27716.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async27716.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__27719_27943 = self__.cs;
var G__27720_27944 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__27719_27943,G__27720_27944) : cljs.core.reset_BANG_.call(null,G__27719_27943,G__27720_27944));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async27716.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta27717], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async27716.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27716.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27716";

cljs.core.async.t_cljs$core$async27716.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8617__auto__,writer__8618__auto__,opt__8619__auto__){
return cljs.core._write(writer__8618__auto__,"cljs.core.async/t_cljs$core$async27716");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async27716 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async27716(ch__$1,cs__$1,meta27717){
return (new cljs.core.async.t_cljs$core$async27716(ch__$1,cs__$1,meta27717));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async27716(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__26566__auto___27945 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___27945,cs,m,dchan,dctr,done){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___27945,cs,m,dchan,dctr,done){
return (function (state_27855){
var state_val_27856 = (state_27855[(1)]);
if((state_val_27856 === (7))){
var inst_27851 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
var statearr_27857_27946 = state_27855__$1;
(statearr_27857_27946[(2)] = inst_27851);

(statearr_27857_27946[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (20))){
var inst_27754 = (state_27855[(7)]);
var inst_27766 = cljs.core.first(inst_27754);
var inst_27767 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27766,(0),null);
var inst_27768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27766,(1),null);
var state_27855__$1 = (function (){var statearr_27858 = state_27855;
(statearr_27858[(8)] = inst_27767);

return statearr_27858;
})();
if(cljs.core.truth_(inst_27768)){
var statearr_27859_27947 = state_27855__$1;
(statearr_27859_27947[(1)] = (22));

} else {
var statearr_27860_27948 = state_27855__$1;
(statearr_27860_27948[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (27))){
var inst_27723 = (state_27855[(9)]);
var inst_27803 = (state_27855[(10)]);
var inst_27798 = (state_27855[(11)]);
var inst_27796 = (state_27855[(12)]);
var inst_27803__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_27796,inst_27798);
var inst_27804 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_27803__$1,inst_27723,done);
var state_27855__$1 = (function (){var statearr_27861 = state_27855;
(statearr_27861[(10)] = inst_27803__$1);

return statearr_27861;
})();
if(cljs.core.truth_(inst_27804)){
var statearr_27862_27949 = state_27855__$1;
(statearr_27862_27949[(1)] = (30));

} else {
var statearr_27863_27950 = state_27855__$1;
(statearr_27863_27950[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (1))){
var state_27855__$1 = state_27855;
var statearr_27864_27951 = state_27855__$1;
(statearr_27864_27951[(2)] = null);

(statearr_27864_27951[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (24))){
var inst_27754 = (state_27855[(7)]);
var inst_27773 = (state_27855[(2)]);
var inst_27774 = cljs.core.next(inst_27754);
var inst_27732 = inst_27774;
var inst_27733 = null;
var inst_27734 = (0);
var inst_27735 = (0);
var state_27855__$1 = (function (){var statearr_27865 = state_27855;
(statearr_27865[(13)] = inst_27734);

(statearr_27865[(14)] = inst_27733);

(statearr_27865[(15)] = inst_27735);

(statearr_27865[(16)] = inst_27773);

(statearr_27865[(17)] = inst_27732);

return statearr_27865;
})();
var statearr_27866_27952 = state_27855__$1;
(statearr_27866_27952[(2)] = null);

(statearr_27866_27952[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (39))){
var state_27855__$1 = state_27855;
var statearr_27870_27953 = state_27855__$1;
(statearr_27870_27953[(2)] = null);

(statearr_27870_27953[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (4))){
var inst_27723 = (state_27855[(9)]);
var inst_27723__$1 = (state_27855[(2)]);
var inst_27724 = (inst_27723__$1 == null);
var state_27855__$1 = (function (){var statearr_27871 = state_27855;
(statearr_27871[(9)] = inst_27723__$1);

return statearr_27871;
})();
if(cljs.core.truth_(inst_27724)){
var statearr_27872_27954 = state_27855__$1;
(statearr_27872_27954[(1)] = (5));

} else {
var statearr_27873_27955 = state_27855__$1;
(statearr_27873_27955[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (15))){
var inst_27734 = (state_27855[(13)]);
var inst_27733 = (state_27855[(14)]);
var inst_27735 = (state_27855[(15)]);
var inst_27732 = (state_27855[(17)]);
var inst_27750 = (state_27855[(2)]);
var inst_27751 = (inst_27735 + (1));
var tmp27867 = inst_27734;
var tmp27868 = inst_27733;
var tmp27869 = inst_27732;
var inst_27732__$1 = tmp27869;
var inst_27733__$1 = tmp27868;
var inst_27734__$1 = tmp27867;
var inst_27735__$1 = inst_27751;
var state_27855__$1 = (function (){var statearr_27874 = state_27855;
(statearr_27874[(13)] = inst_27734__$1);

(statearr_27874[(14)] = inst_27733__$1);

(statearr_27874[(18)] = inst_27750);

(statearr_27874[(15)] = inst_27735__$1);

(statearr_27874[(17)] = inst_27732__$1);

return statearr_27874;
})();
var statearr_27875_27956 = state_27855__$1;
(statearr_27875_27956[(2)] = null);

(statearr_27875_27956[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (21))){
var inst_27777 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
var statearr_27879_27957 = state_27855__$1;
(statearr_27879_27957[(2)] = inst_27777);

(statearr_27879_27957[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (31))){
var inst_27803 = (state_27855[(10)]);
var inst_27807 = done(null);
var inst_27808 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_27803);
var state_27855__$1 = (function (){var statearr_27880 = state_27855;
(statearr_27880[(19)] = inst_27807);

return statearr_27880;
})();
var statearr_27881_27958 = state_27855__$1;
(statearr_27881_27958[(2)] = inst_27808);

(statearr_27881_27958[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (32))){
var inst_27797 = (state_27855[(20)]);
var inst_27795 = (state_27855[(21)]);
var inst_27798 = (state_27855[(11)]);
var inst_27796 = (state_27855[(12)]);
var inst_27810 = (state_27855[(2)]);
var inst_27811 = (inst_27798 + (1));
var tmp27876 = inst_27797;
var tmp27877 = inst_27795;
var tmp27878 = inst_27796;
var inst_27795__$1 = tmp27877;
var inst_27796__$1 = tmp27878;
var inst_27797__$1 = tmp27876;
var inst_27798__$1 = inst_27811;
var state_27855__$1 = (function (){var statearr_27882 = state_27855;
(statearr_27882[(22)] = inst_27810);

(statearr_27882[(20)] = inst_27797__$1);

(statearr_27882[(21)] = inst_27795__$1);

(statearr_27882[(11)] = inst_27798__$1);

(statearr_27882[(12)] = inst_27796__$1);

return statearr_27882;
})();
var statearr_27883_27959 = state_27855__$1;
(statearr_27883_27959[(2)] = null);

(statearr_27883_27959[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (40))){
var inst_27823 = (state_27855[(23)]);
var inst_27827 = done(null);
var inst_27828 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_27823);
var state_27855__$1 = (function (){var statearr_27884 = state_27855;
(statearr_27884[(24)] = inst_27827);

return statearr_27884;
})();
var statearr_27885_27960 = state_27855__$1;
(statearr_27885_27960[(2)] = inst_27828);

(statearr_27885_27960[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (33))){
var inst_27814 = (state_27855[(25)]);
var inst_27816 = cljs.core.chunked_seq_QMARK_(inst_27814);
var state_27855__$1 = state_27855;
if(inst_27816){
var statearr_27886_27961 = state_27855__$1;
(statearr_27886_27961[(1)] = (36));

} else {
var statearr_27887_27962 = state_27855__$1;
(statearr_27887_27962[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (13))){
var inst_27744 = (state_27855[(26)]);
var inst_27747 = cljs.core.async.close_BANG_(inst_27744);
var state_27855__$1 = state_27855;
var statearr_27888_27963 = state_27855__$1;
(statearr_27888_27963[(2)] = inst_27747);

(statearr_27888_27963[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (22))){
var inst_27767 = (state_27855[(8)]);
var inst_27770 = cljs.core.async.close_BANG_(inst_27767);
var state_27855__$1 = state_27855;
var statearr_27889_27964 = state_27855__$1;
(statearr_27889_27964[(2)] = inst_27770);

(statearr_27889_27964[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (36))){
var inst_27814 = (state_27855[(25)]);
var inst_27818 = cljs.core.chunk_first(inst_27814);
var inst_27819 = cljs.core.chunk_rest(inst_27814);
var inst_27820 = cljs.core.count(inst_27818);
var inst_27795 = inst_27819;
var inst_27796 = inst_27818;
var inst_27797 = inst_27820;
var inst_27798 = (0);
var state_27855__$1 = (function (){var statearr_27890 = state_27855;
(statearr_27890[(20)] = inst_27797);

(statearr_27890[(21)] = inst_27795);

(statearr_27890[(11)] = inst_27798);

(statearr_27890[(12)] = inst_27796);

return statearr_27890;
})();
var statearr_27891_27965 = state_27855__$1;
(statearr_27891_27965[(2)] = null);

(statearr_27891_27965[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (41))){
var inst_27814 = (state_27855[(25)]);
var inst_27830 = (state_27855[(2)]);
var inst_27831 = cljs.core.next(inst_27814);
var inst_27795 = inst_27831;
var inst_27796 = null;
var inst_27797 = (0);
var inst_27798 = (0);
var state_27855__$1 = (function (){var statearr_27892 = state_27855;
(statearr_27892[(27)] = inst_27830);

(statearr_27892[(20)] = inst_27797);

(statearr_27892[(21)] = inst_27795);

(statearr_27892[(11)] = inst_27798);

(statearr_27892[(12)] = inst_27796);

return statearr_27892;
})();
var statearr_27893_27966 = state_27855__$1;
(statearr_27893_27966[(2)] = null);

(statearr_27893_27966[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (43))){
var state_27855__$1 = state_27855;
var statearr_27894_27967 = state_27855__$1;
(statearr_27894_27967[(2)] = null);

(statearr_27894_27967[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (29))){
var inst_27839 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
var statearr_27895_27968 = state_27855__$1;
(statearr_27895_27968[(2)] = inst_27839);

(statearr_27895_27968[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (44))){
var inst_27848 = (state_27855[(2)]);
var state_27855__$1 = (function (){var statearr_27896 = state_27855;
(statearr_27896[(28)] = inst_27848);

return statearr_27896;
})();
var statearr_27897_27969 = state_27855__$1;
(statearr_27897_27969[(2)] = null);

(statearr_27897_27969[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (6))){
var inst_27787 = (state_27855[(29)]);
var inst_27786 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_27787__$1 = cljs.core.keys(inst_27786);
var inst_27788 = cljs.core.count(inst_27787__$1);
var inst_27789 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_27788) : cljs.core.reset_BANG_.call(null,dctr,inst_27788));
var inst_27794 = cljs.core.seq(inst_27787__$1);
var inst_27795 = inst_27794;
var inst_27796 = null;
var inst_27797 = (0);
var inst_27798 = (0);
var state_27855__$1 = (function (){var statearr_27898 = state_27855;
(statearr_27898[(29)] = inst_27787__$1);

(statearr_27898[(20)] = inst_27797);

(statearr_27898[(21)] = inst_27795);

(statearr_27898[(11)] = inst_27798);

(statearr_27898[(30)] = inst_27789);

(statearr_27898[(12)] = inst_27796);

return statearr_27898;
})();
var statearr_27899_27970 = state_27855__$1;
(statearr_27899_27970[(2)] = null);

(statearr_27899_27970[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (28))){
var inst_27795 = (state_27855[(21)]);
var inst_27814 = (state_27855[(25)]);
var inst_27814__$1 = cljs.core.seq(inst_27795);
var state_27855__$1 = (function (){var statearr_27900 = state_27855;
(statearr_27900[(25)] = inst_27814__$1);

return statearr_27900;
})();
if(inst_27814__$1){
var statearr_27901_27971 = state_27855__$1;
(statearr_27901_27971[(1)] = (33));

} else {
var statearr_27902_27972 = state_27855__$1;
(statearr_27902_27972[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (25))){
var inst_27797 = (state_27855[(20)]);
var inst_27798 = (state_27855[(11)]);
var inst_27800 = (inst_27798 < inst_27797);
var inst_27801 = inst_27800;
var state_27855__$1 = state_27855;
if(cljs.core.truth_(inst_27801)){
var statearr_27903_27973 = state_27855__$1;
(statearr_27903_27973[(1)] = (27));

} else {
var statearr_27904_27974 = state_27855__$1;
(statearr_27904_27974[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (34))){
var state_27855__$1 = state_27855;
var statearr_27905_27975 = state_27855__$1;
(statearr_27905_27975[(2)] = null);

(statearr_27905_27975[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (17))){
var state_27855__$1 = state_27855;
var statearr_27906_27976 = state_27855__$1;
(statearr_27906_27976[(2)] = null);

(statearr_27906_27976[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (3))){
var inst_27853 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27855__$1,inst_27853);
} else {
if((state_val_27856 === (12))){
var inst_27782 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
var statearr_27907_27977 = state_27855__$1;
(statearr_27907_27977[(2)] = inst_27782);

(statearr_27907_27977[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (2))){
var state_27855__$1 = state_27855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27855__$1,(4),ch);
} else {
if((state_val_27856 === (23))){
var state_27855__$1 = state_27855;
var statearr_27908_27978 = state_27855__$1;
(statearr_27908_27978[(2)] = null);

(statearr_27908_27978[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (35))){
var inst_27837 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
var statearr_27909_27979 = state_27855__$1;
(statearr_27909_27979[(2)] = inst_27837);

(statearr_27909_27979[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (19))){
var inst_27754 = (state_27855[(7)]);
var inst_27758 = cljs.core.chunk_first(inst_27754);
var inst_27759 = cljs.core.chunk_rest(inst_27754);
var inst_27760 = cljs.core.count(inst_27758);
var inst_27732 = inst_27759;
var inst_27733 = inst_27758;
var inst_27734 = inst_27760;
var inst_27735 = (0);
var state_27855__$1 = (function (){var statearr_27910 = state_27855;
(statearr_27910[(13)] = inst_27734);

(statearr_27910[(14)] = inst_27733);

(statearr_27910[(15)] = inst_27735);

(statearr_27910[(17)] = inst_27732);

return statearr_27910;
})();
var statearr_27911_27980 = state_27855__$1;
(statearr_27911_27980[(2)] = null);

(statearr_27911_27980[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (11))){
var inst_27754 = (state_27855[(7)]);
var inst_27732 = (state_27855[(17)]);
var inst_27754__$1 = cljs.core.seq(inst_27732);
var state_27855__$1 = (function (){var statearr_27912 = state_27855;
(statearr_27912[(7)] = inst_27754__$1);

return statearr_27912;
})();
if(inst_27754__$1){
var statearr_27913_27981 = state_27855__$1;
(statearr_27913_27981[(1)] = (16));

} else {
var statearr_27914_27982 = state_27855__$1;
(statearr_27914_27982[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (9))){
var inst_27784 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
var statearr_27915_27983 = state_27855__$1;
(statearr_27915_27983[(2)] = inst_27784);

(statearr_27915_27983[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (5))){
var inst_27730 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_27731 = cljs.core.seq(inst_27730);
var inst_27732 = inst_27731;
var inst_27733 = null;
var inst_27734 = (0);
var inst_27735 = (0);
var state_27855__$1 = (function (){var statearr_27916 = state_27855;
(statearr_27916[(13)] = inst_27734);

(statearr_27916[(14)] = inst_27733);

(statearr_27916[(15)] = inst_27735);

(statearr_27916[(17)] = inst_27732);

return statearr_27916;
})();
var statearr_27917_27984 = state_27855__$1;
(statearr_27917_27984[(2)] = null);

(statearr_27917_27984[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (14))){
var state_27855__$1 = state_27855;
var statearr_27918_27985 = state_27855__$1;
(statearr_27918_27985[(2)] = null);

(statearr_27918_27985[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (45))){
var inst_27845 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
var statearr_27919_27986 = state_27855__$1;
(statearr_27919_27986[(2)] = inst_27845);

(statearr_27919_27986[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (26))){
var inst_27787 = (state_27855[(29)]);
var inst_27841 = (state_27855[(2)]);
var inst_27842 = cljs.core.seq(inst_27787);
var state_27855__$1 = (function (){var statearr_27920 = state_27855;
(statearr_27920[(31)] = inst_27841);

return statearr_27920;
})();
if(inst_27842){
var statearr_27921_27987 = state_27855__$1;
(statearr_27921_27987[(1)] = (42));

} else {
var statearr_27922_27988 = state_27855__$1;
(statearr_27922_27988[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (16))){
var inst_27754 = (state_27855[(7)]);
var inst_27756 = cljs.core.chunked_seq_QMARK_(inst_27754);
var state_27855__$1 = state_27855;
if(inst_27756){
var statearr_27923_27989 = state_27855__$1;
(statearr_27923_27989[(1)] = (19));

} else {
var statearr_27924_27990 = state_27855__$1;
(statearr_27924_27990[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (38))){
var inst_27834 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
var statearr_27925_27991 = state_27855__$1;
(statearr_27925_27991[(2)] = inst_27834);

(statearr_27925_27991[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (30))){
var state_27855__$1 = state_27855;
var statearr_27926_27992 = state_27855__$1;
(statearr_27926_27992[(2)] = null);

(statearr_27926_27992[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (10))){
var inst_27733 = (state_27855[(14)]);
var inst_27735 = (state_27855[(15)]);
var inst_27743 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_27733,inst_27735);
var inst_27744 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27743,(0),null);
var inst_27745 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27743,(1),null);
var state_27855__$1 = (function (){var statearr_27927 = state_27855;
(statearr_27927[(26)] = inst_27744);

return statearr_27927;
})();
if(cljs.core.truth_(inst_27745)){
var statearr_27928_27993 = state_27855__$1;
(statearr_27928_27993[(1)] = (13));

} else {
var statearr_27929_27994 = state_27855__$1;
(statearr_27929_27994[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (18))){
var inst_27780 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
var statearr_27930_27995 = state_27855__$1;
(statearr_27930_27995[(2)] = inst_27780);

(statearr_27930_27995[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (42))){
var state_27855__$1 = state_27855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27855__$1,(45),dchan);
} else {
if((state_val_27856 === (37))){
var inst_27723 = (state_27855[(9)]);
var inst_27823 = (state_27855[(23)]);
var inst_27814 = (state_27855[(25)]);
var inst_27823__$1 = cljs.core.first(inst_27814);
var inst_27824 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_27823__$1,inst_27723,done);
var state_27855__$1 = (function (){var statearr_27931 = state_27855;
(statearr_27931[(23)] = inst_27823__$1);

return statearr_27931;
})();
if(cljs.core.truth_(inst_27824)){
var statearr_27932_27996 = state_27855__$1;
(statearr_27932_27996[(1)] = (39));

} else {
var statearr_27933_27997 = state_27855__$1;
(statearr_27933_27997[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27856 === (8))){
var inst_27734 = (state_27855[(13)]);
var inst_27735 = (state_27855[(15)]);
var inst_27737 = (inst_27735 < inst_27734);
var inst_27738 = inst_27737;
var state_27855__$1 = state_27855;
if(cljs.core.truth_(inst_27738)){
var statearr_27934_27998 = state_27855__$1;
(statearr_27934_27998[(1)] = (10));

} else {
var statearr_27935_27999 = state_27855__$1;
(statearr_27935_27999[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___27945,cs,m,dchan,dctr,done))
;
return ((function (switch__26440__auto__,c__26566__auto___27945,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__26441__auto__ = null;
var cljs$core$async$mult_$_state_machine__26441__auto____0 = (function (){
var statearr_27939 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27939[(0)] = cljs$core$async$mult_$_state_machine__26441__auto__);

(statearr_27939[(1)] = (1));

return statearr_27939;
});
var cljs$core$async$mult_$_state_machine__26441__auto____1 = (function (state_27855){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_27855);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e27940){if((e27940 instanceof Object)){
var ex__26444__auto__ = e27940;
var statearr_27941_28000 = state_27855;
(statearr_27941_28000[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27855);

return cljs.core.cst$kw$recur;
} else {
throw e27940;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__28001 = state_27855;
state_27855 = G__28001;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__26441__auto__ = function(state_27855){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__26441__auto____1.call(this,state_27855);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__26441__auto____0;
cljs$core$async$mult_$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__26441__auto____1;
return cljs$core$async$mult_$_state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___27945,cs,m,dchan,dctr,done))
})();
var state__26568__auto__ = (function (){var statearr_27942 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_27942[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___27945);

return statearr_27942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___27945,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args28002 = [];
var len__9181__auto___28005 = arguments.length;
var i__9182__auto___28006 = (0);
while(true){
if((i__9182__auto___28006 < len__9181__auto___28005)){
args28002.push((arguments[i__9182__auto___28006]));

var G__28007 = (i__9182__auto___28006 + (1));
i__9182__auto___28006 = G__28007;
continue;
} else {
}
break;
}

var G__28004 = args28002.length;
switch (G__28004) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args28002.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8679__auto__.call(null,m,ch));
} else {
var m__8679__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8679__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8679__auto__.call(null,m,ch));
} else {
var m__8679__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8679__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__8679__auto__.call(null,m));
} else {
var m__8679__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__8679__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__8679__auto__.call(null,m,state_map));
} else {
var m__8679__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__8679__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__8679__auto__.call(null,m,mode));
} else {
var m__8679__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__8679__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__9188__auto__ = [];
var len__9181__auto___28019 = arguments.length;
var i__9182__auto___28020 = (0);
while(true){
if((i__9182__auto___28020 < len__9181__auto___28019)){
args__9188__auto__.push((arguments[i__9182__auto___28020]));

var G__28021 = (i__9182__auto___28020 + (1));
i__9182__auto___28020 = G__28021;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((3) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9189__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__28013){
var map__28014 = p__28013;
var map__28014__$1 = ((((!((map__28014 == null)))?((((map__28014.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28014.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28014):map__28014);
var opts = map__28014__$1;
var statearr_28016_28022 = state;
(statearr_28016_28022[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__28014,map__28014__$1,opts){
return (function (val){
var statearr_28017_28023 = state;
(statearr_28017_28023[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__28014,map__28014__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_28018_28024 = state;
(statearr_28018_28024[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq28009){
var G__28010 = cljs.core.first(seq28009);
var seq28009__$1 = cljs.core.next(seq28009);
var G__28011 = cljs.core.first(seq28009__$1);
var seq28009__$2 = cljs.core.next(seq28009__$1);
var G__28012 = cljs.core.first(seq28009__$2);
var seq28009__$3 = cljs.core.next(seq28009__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28010,G__28011,G__28012,seq28009__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__28196 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__28196) : cljs.core.atom.call(null,G__28196));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__28197 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__28197) : cljs.core.atom.call(null,G__28197));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async28198 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28198 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta28199){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta28199 = meta28199;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28198.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_28200,meta28199__$1){
var self__ = this;
var _28200__$1 = this;
return (new cljs.core.async.t_cljs$core$async28198(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta28199__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28198.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_28200){
var self__ = this;
var _28200__$1 = this;
return self__.meta28199;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28198.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28198.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28198.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28198.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28198.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28198.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__28201_28367 = self__.cs;
var G__28202_28368 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__28201_28367,G__28202_28368) : cljs.core.reset_BANG_.call(null,G__28201_28367,G__28202_28368));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28198.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28198.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28198.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta28199], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28198.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28198.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28198";

cljs.core.async.t_cljs$core$async28198.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8617__auto__,writer__8618__auto__,opt__8619__auto__){
return cljs.core._write(writer__8618__auto__,"cljs.core.async/t_cljs$core$async28198");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async28198 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async28198(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta28199){
return (new cljs.core.async.t_cljs$core$async28198(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta28199));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async28198(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__26566__auto___28369 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___28369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___28369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_28304){
var state_val_28305 = (state_28304[(1)]);
if((state_val_28305 === (7))){
var inst_28219 = (state_28304[(2)]);
var state_28304__$1 = state_28304;
var statearr_28306_28370 = state_28304__$1;
(statearr_28306_28370[(2)] = inst_28219);

(statearr_28306_28370[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (20))){
var inst_28231 = (state_28304[(7)]);
var state_28304__$1 = state_28304;
var statearr_28307_28371 = state_28304__$1;
(statearr_28307_28371[(2)] = inst_28231);

(statearr_28307_28371[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (27))){
var state_28304__$1 = state_28304;
var statearr_28308_28372 = state_28304__$1;
(statearr_28308_28372[(2)] = null);

(statearr_28308_28372[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (1))){
var inst_28206 = (state_28304[(8)]);
var inst_28206__$1 = calc_state();
var inst_28208 = (inst_28206__$1 == null);
var inst_28209 = cljs.core.not(inst_28208);
var state_28304__$1 = (function (){var statearr_28309 = state_28304;
(statearr_28309[(8)] = inst_28206__$1);

return statearr_28309;
})();
if(inst_28209){
var statearr_28310_28373 = state_28304__$1;
(statearr_28310_28373[(1)] = (2));

} else {
var statearr_28311_28374 = state_28304__$1;
(statearr_28311_28374[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (24))){
var inst_28278 = (state_28304[(9)]);
var inst_28255 = (state_28304[(10)]);
var inst_28264 = (state_28304[(11)]);
var inst_28278__$1 = (inst_28255.cljs$core$IFn$_invoke$arity$1 ? inst_28255.cljs$core$IFn$_invoke$arity$1(inst_28264) : inst_28255.call(null,inst_28264));
var state_28304__$1 = (function (){var statearr_28312 = state_28304;
(statearr_28312[(9)] = inst_28278__$1);

return statearr_28312;
})();
if(cljs.core.truth_(inst_28278__$1)){
var statearr_28313_28375 = state_28304__$1;
(statearr_28313_28375[(1)] = (29));

} else {
var statearr_28314_28376 = state_28304__$1;
(statearr_28314_28376[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (4))){
var inst_28222 = (state_28304[(2)]);
var state_28304__$1 = state_28304;
if(cljs.core.truth_(inst_28222)){
var statearr_28315_28377 = state_28304__$1;
(statearr_28315_28377[(1)] = (8));

} else {
var statearr_28316_28378 = state_28304__$1;
(statearr_28316_28378[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (15))){
var inst_28249 = (state_28304[(2)]);
var state_28304__$1 = state_28304;
if(cljs.core.truth_(inst_28249)){
var statearr_28317_28379 = state_28304__$1;
(statearr_28317_28379[(1)] = (19));

} else {
var statearr_28318_28380 = state_28304__$1;
(statearr_28318_28380[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (21))){
var inst_28254 = (state_28304[(12)]);
var inst_28254__$1 = (state_28304[(2)]);
var inst_28255 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28254__$1,cljs.core.cst$kw$solos);
var inst_28256 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28254__$1,cljs.core.cst$kw$mutes);
var inst_28257 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28254__$1,cljs.core.cst$kw$reads);
var state_28304__$1 = (function (){var statearr_28319 = state_28304;
(statearr_28319[(13)] = inst_28256);

(statearr_28319[(12)] = inst_28254__$1);

(statearr_28319[(10)] = inst_28255);

return statearr_28319;
})();
return cljs.core.async.ioc_alts_BANG_(state_28304__$1,(22),inst_28257);
} else {
if((state_val_28305 === (31))){
var inst_28286 = (state_28304[(2)]);
var state_28304__$1 = state_28304;
if(cljs.core.truth_(inst_28286)){
var statearr_28320_28381 = state_28304__$1;
(statearr_28320_28381[(1)] = (32));

} else {
var statearr_28321_28382 = state_28304__$1;
(statearr_28321_28382[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (32))){
var inst_28263 = (state_28304[(14)]);
var state_28304__$1 = state_28304;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28304__$1,(35),out,inst_28263);
} else {
if((state_val_28305 === (33))){
var inst_28254 = (state_28304[(12)]);
var inst_28231 = inst_28254;
var state_28304__$1 = (function (){var statearr_28322 = state_28304;
(statearr_28322[(7)] = inst_28231);

return statearr_28322;
})();
var statearr_28323_28383 = state_28304__$1;
(statearr_28323_28383[(2)] = null);

(statearr_28323_28383[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (13))){
var inst_28231 = (state_28304[(7)]);
var inst_28238 = inst_28231.cljs$lang$protocol_mask$partition0$;
var inst_28239 = (inst_28238 & (64));
var inst_28240 = inst_28231.cljs$core$ISeq$;
var inst_28241 = (cljs.core.PROTOCOL_SENTINEL === inst_28240);
var inst_28242 = (inst_28239) || (inst_28241);
var state_28304__$1 = state_28304;
if(cljs.core.truth_(inst_28242)){
var statearr_28324_28384 = state_28304__$1;
(statearr_28324_28384[(1)] = (16));

} else {
var statearr_28325_28385 = state_28304__$1;
(statearr_28325_28385[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (22))){
var inst_28263 = (state_28304[(14)]);
var inst_28264 = (state_28304[(11)]);
var inst_28262 = (state_28304[(2)]);
var inst_28263__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28262,(0),null);
var inst_28264__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28262,(1),null);
var inst_28265 = (inst_28263__$1 == null);
var inst_28266 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28264__$1,change);
var inst_28267 = (inst_28265) || (inst_28266);
var state_28304__$1 = (function (){var statearr_28326 = state_28304;
(statearr_28326[(14)] = inst_28263__$1);

(statearr_28326[(11)] = inst_28264__$1);

return statearr_28326;
})();
if(cljs.core.truth_(inst_28267)){
var statearr_28327_28386 = state_28304__$1;
(statearr_28327_28386[(1)] = (23));

} else {
var statearr_28328_28387 = state_28304__$1;
(statearr_28328_28387[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (36))){
var inst_28254 = (state_28304[(12)]);
var inst_28231 = inst_28254;
var state_28304__$1 = (function (){var statearr_28329 = state_28304;
(statearr_28329[(7)] = inst_28231);

return statearr_28329;
})();
var statearr_28330_28388 = state_28304__$1;
(statearr_28330_28388[(2)] = null);

(statearr_28330_28388[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (29))){
var inst_28278 = (state_28304[(9)]);
var state_28304__$1 = state_28304;
var statearr_28331_28389 = state_28304__$1;
(statearr_28331_28389[(2)] = inst_28278);

(statearr_28331_28389[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (6))){
var state_28304__$1 = state_28304;
var statearr_28332_28390 = state_28304__$1;
(statearr_28332_28390[(2)] = false);

(statearr_28332_28390[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (28))){
var inst_28274 = (state_28304[(2)]);
var inst_28275 = calc_state();
var inst_28231 = inst_28275;
var state_28304__$1 = (function (){var statearr_28333 = state_28304;
(statearr_28333[(15)] = inst_28274);

(statearr_28333[(7)] = inst_28231);

return statearr_28333;
})();
var statearr_28334_28391 = state_28304__$1;
(statearr_28334_28391[(2)] = null);

(statearr_28334_28391[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (25))){
var inst_28300 = (state_28304[(2)]);
var state_28304__$1 = state_28304;
var statearr_28335_28392 = state_28304__$1;
(statearr_28335_28392[(2)] = inst_28300);

(statearr_28335_28392[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (34))){
var inst_28298 = (state_28304[(2)]);
var state_28304__$1 = state_28304;
var statearr_28336_28393 = state_28304__$1;
(statearr_28336_28393[(2)] = inst_28298);

(statearr_28336_28393[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (17))){
var state_28304__$1 = state_28304;
var statearr_28337_28394 = state_28304__$1;
(statearr_28337_28394[(2)] = false);

(statearr_28337_28394[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (3))){
var state_28304__$1 = state_28304;
var statearr_28338_28395 = state_28304__$1;
(statearr_28338_28395[(2)] = false);

(statearr_28338_28395[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (12))){
var inst_28302 = (state_28304[(2)]);
var state_28304__$1 = state_28304;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28304__$1,inst_28302);
} else {
if((state_val_28305 === (2))){
var inst_28206 = (state_28304[(8)]);
var inst_28211 = inst_28206.cljs$lang$protocol_mask$partition0$;
var inst_28212 = (inst_28211 & (64));
var inst_28213 = inst_28206.cljs$core$ISeq$;
var inst_28214 = (cljs.core.PROTOCOL_SENTINEL === inst_28213);
var inst_28215 = (inst_28212) || (inst_28214);
var state_28304__$1 = state_28304;
if(cljs.core.truth_(inst_28215)){
var statearr_28339_28396 = state_28304__$1;
(statearr_28339_28396[(1)] = (5));

} else {
var statearr_28340_28397 = state_28304__$1;
(statearr_28340_28397[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (23))){
var inst_28263 = (state_28304[(14)]);
var inst_28269 = (inst_28263 == null);
var state_28304__$1 = state_28304;
if(cljs.core.truth_(inst_28269)){
var statearr_28341_28398 = state_28304__$1;
(statearr_28341_28398[(1)] = (26));

} else {
var statearr_28342_28399 = state_28304__$1;
(statearr_28342_28399[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (35))){
var inst_28289 = (state_28304[(2)]);
var state_28304__$1 = state_28304;
if(cljs.core.truth_(inst_28289)){
var statearr_28343_28400 = state_28304__$1;
(statearr_28343_28400[(1)] = (36));

} else {
var statearr_28344_28401 = state_28304__$1;
(statearr_28344_28401[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (19))){
var inst_28231 = (state_28304[(7)]);
var inst_28251 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28231);
var state_28304__$1 = state_28304;
var statearr_28345_28402 = state_28304__$1;
(statearr_28345_28402[(2)] = inst_28251);

(statearr_28345_28402[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (11))){
var inst_28231 = (state_28304[(7)]);
var inst_28235 = (inst_28231 == null);
var inst_28236 = cljs.core.not(inst_28235);
var state_28304__$1 = state_28304;
if(inst_28236){
var statearr_28346_28403 = state_28304__$1;
(statearr_28346_28403[(1)] = (13));

} else {
var statearr_28347_28404 = state_28304__$1;
(statearr_28347_28404[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (9))){
var inst_28206 = (state_28304[(8)]);
var state_28304__$1 = state_28304;
var statearr_28348_28405 = state_28304__$1;
(statearr_28348_28405[(2)] = inst_28206);

(statearr_28348_28405[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (5))){
var state_28304__$1 = state_28304;
var statearr_28349_28406 = state_28304__$1;
(statearr_28349_28406[(2)] = true);

(statearr_28349_28406[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (14))){
var state_28304__$1 = state_28304;
var statearr_28350_28407 = state_28304__$1;
(statearr_28350_28407[(2)] = false);

(statearr_28350_28407[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (26))){
var inst_28264 = (state_28304[(11)]);
var inst_28271 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_28264);
var state_28304__$1 = state_28304;
var statearr_28351_28408 = state_28304__$1;
(statearr_28351_28408[(2)] = inst_28271);

(statearr_28351_28408[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (16))){
var state_28304__$1 = state_28304;
var statearr_28352_28409 = state_28304__$1;
(statearr_28352_28409[(2)] = true);

(statearr_28352_28409[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (38))){
var inst_28294 = (state_28304[(2)]);
var state_28304__$1 = state_28304;
var statearr_28353_28410 = state_28304__$1;
(statearr_28353_28410[(2)] = inst_28294);

(statearr_28353_28410[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (30))){
var inst_28256 = (state_28304[(13)]);
var inst_28255 = (state_28304[(10)]);
var inst_28264 = (state_28304[(11)]);
var inst_28281 = cljs.core.empty_QMARK_(inst_28255);
var inst_28282 = (inst_28256.cljs$core$IFn$_invoke$arity$1 ? inst_28256.cljs$core$IFn$_invoke$arity$1(inst_28264) : inst_28256.call(null,inst_28264));
var inst_28283 = cljs.core.not(inst_28282);
var inst_28284 = (inst_28281) && (inst_28283);
var state_28304__$1 = state_28304;
var statearr_28354_28411 = state_28304__$1;
(statearr_28354_28411[(2)] = inst_28284);

(statearr_28354_28411[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (10))){
var inst_28206 = (state_28304[(8)]);
var inst_28227 = (state_28304[(2)]);
var inst_28228 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28227,cljs.core.cst$kw$solos);
var inst_28229 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28227,cljs.core.cst$kw$mutes);
var inst_28230 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28227,cljs.core.cst$kw$reads);
var inst_28231 = inst_28206;
var state_28304__$1 = (function (){var statearr_28355 = state_28304;
(statearr_28355[(16)] = inst_28230);

(statearr_28355[(17)] = inst_28229);

(statearr_28355[(18)] = inst_28228);

(statearr_28355[(7)] = inst_28231);

return statearr_28355;
})();
var statearr_28356_28412 = state_28304__$1;
(statearr_28356_28412[(2)] = null);

(statearr_28356_28412[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (18))){
var inst_28246 = (state_28304[(2)]);
var state_28304__$1 = state_28304;
var statearr_28357_28413 = state_28304__$1;
(statearr_28357_28413[(2)] = inst_28246);

(statearr_28357_28413[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (37))){
var state_28304__$1 = state_28304;
var statearr_28358_28414 = state_28304__$1;
(statearr_28358_28414[(2)] = null);

(statearr_28358_28414[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28305 === (8))){
var inst_28206 = (state_28304[(8)]);
var inst_28224 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28206);
var state_28304__$1 = state_28304;
var statearr_28359_28415 = state_28304__$1;
(statearr_28359_28415[(2)] = inst_28224);

(statearr_28359_28415[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___28369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__26440__auto__,c__26566__auto___28369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__26441__auto__ = null;
var cljs$core$async$mix_$_state_machine__26441__auto____0 = (function (){
var statearr_28363 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28363[(0)] = cljs$core$async$mix_$_state_machine__26441__auto__);

(statearr_28363[(1)] = (1));

return statearr_28363;
});
var cljs$core$async$mix_$_state_machine__26441__auto____1 = (function (state_28304){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_28304);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e28364){if((e28364 instanceof Object)){
var ex__26444__auto__ = e28364;
var statearr_28365_28416 = state_28304;
(statearr_28365_28416[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28304);

return cljs.core.cst$kw$recur;
} else {
throw e28364;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__28417 = state_28304;
state_28304 = G__28417;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__26441__auto__ = function(state_28304){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__26441__auto____1.call(this,state_28304);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__26441__auto____0;
cljs$core$async$mix_$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__26441__auto____1;
return cljs$core$async$mix_$_state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___28369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__26568__auto__ = (function (){var statearr_28366 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_28366[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___28369);

return statearr_28366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___28369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8678__auto__ = (((p == null))?null:p);
var m__8679__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$4 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__8679__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__8679__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__8679__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8678__auto__ = (((p == null))?null:p);
var m__8679__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__8679__auto__.call(null,p,v,ch));
} else {
var m__8679__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__8679__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args28418 = [];
var len__9181__auto___28421 = arguments.length;
var i__9182__auto___28422 = (0);
while(true){
if((i__9182__auto___28422 < len__9181__auto___28421)){
args28418.push((arguments[i__9182__auto___28422]));

var G__28423 = (i__9182__auto___28422 + (1));
i__9182__auto___28422 = G__28423;
continue;
} else {
}
break;
}

var G__28420 = args28418.length;
switch (G__28420) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args28418.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8678__auto__ = (((p == null))?null:p);
var m__8679__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__8679__auto__.call(null,p));
} else {
var m__8679__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__8679__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8678__auto__ = (((p == null))?null:p);
var m__8679__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__8679__auto__.call(null,p,v));
} else {
var m__8679__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__8679__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args28426 = [];
var len__9181__auto___28554 = arguments.length;
var i__9182__auto___28555 = (0);
while(true){
if((i__9182__auto___28555 < len__9181__auto___28554)){
args28426.push((arguments[i__9182__auto___28555]));

var G__28556 = (i__9182__auto___28555 + (1));
i__9182__auto___28555 = G__28556;
continue;
} else {
}
break;
}

var G__28428 = args28426.length;
switch (G__28428) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args28426.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__28429 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__28429) : cljs.core.atom.call(null,G__28429));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__7960__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__7960__auto__,mults){
return (function (p1__28425_SHARP_){
if(cljs.core.truth_((p1__28425_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__28425_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__28425_SHARP_.call(null,topic)))){
return p1__28425_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__28425_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__7960__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async28430 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28430 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta28431){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta28431 = meta28431;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28430.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_28432,meta28431__$1){
var self__ = this;
var _28432__$1 = this;
return (new cljs.core.async.t_cljs$core$async28430(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta28431__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28430.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_28432){
var self__ = this;
var _28432__$1 = this;
return self__.meta28431;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28430.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28430.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28430.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28430.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28430.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28430.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__28433 = self__.mults;
var G__28434 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__28433,G__28434) : cljs.core.reset_BANG_.call(null,G__28433,G__28434));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28430.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28430.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta28431], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28430.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28430.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28430";

cljs.core.async.t_cljs$core$async28430.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8617__auto__,writer__8618__auto__,opt__8619__auto__){
return cljs.core._write(writer__8618__auto__,"cljs.core.async/t_cljs$core$async28430");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async28430 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async28430(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta28431){
return (new cljs.core.async.t_cljs$core$async28430(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta28431));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async28430(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__26566__auto___28558 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___28558,mults,ensure_mult,p){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___28558,mults,ensure_mult,p){
return (function (state_28506){
var state_val_28507 = (state_28506[(1)]);
if((state_val_28507 === (7))){
var inst_28502 = (state_28506[(2)]);
var state_28506__$1 = state_28506;
var statearr_28508_28559 = state_28506__$1;
(statearr_28508_28559[(2)] = inst_28502);

(statearr_28508_28559[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (20))){
var state_28506__$1 = state_28506;
var statearr_28509_28560 = state_28506__$1;
(statearr_28509_28560[(2)] = null);

(statearr_28509_28560[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (1))){
var state_28506__$1 = state_28506;
var statearr_28510_28561 = state_28506__$1;
(statearr_28510_28561[(2)] = null);

(statearr_28510_28561[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (24))){
var inst_28485 = (state_28506[(7)]);
var inst_28494 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_28485);
var state_28506__$1 = state_28506;
var statearr_28511_28562 = state_28506__$1;
(statearr_28511_28562[(2)] = inst_28494);

(statearr_28511_28562[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (4))){
var inst_28437 = (state_28506[(8)]);
var inst_28437__$1 = (state_28506[(2)]);
var inst_28438 = (inst_28437__$1 == null);
var state_28506__$1 = (function (){var statearr_28512 = state_28506;
(statearr_28512[(8)] = inst_28437__$1);

return statearr_28512;
})();
if(cljs.core.truth_(inst_28438)){
var statearr_28513_28563 = state_28506__$1;
(statearr_28513_28563[(1)] = (5));

} else {
var statearr_28514_28564 = state_28506__$1;
(statearr_28514_28564[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (15))){
var inst_28479 = (state_28506[(2)]);
var state_28506__$1 = state_28506;
var statearr_28515_28565 = state_28506__$1;
(statearr_28515_28565[(2)] = inst_28479);

(statearr_28515_28565[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (21))){
var inst_28499 = (state_28506[(2)]);
var state_28506__$1 = (function (){var statearr_28516 = state_28506;
(statearr_28516[(9)] = inst_28499);

return statearr_28516;
})();
var statearr_28517_28566 = state_28506__$1;
(statearr_28517_28566[(2)] = null);

(statearr_28517_28566[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (13))){
var inst_28461 = (state_28506[(10)]);
var inst_28463 = cljs.core.chunked_seq_QMARK_(inst_28461);
var state_28506__$1 = state_28506;
if(inst_28463){
var statearr_28518_28567 = state_28506__$1;
(statearr_28518_28567[(1)] = (16));

} else {
var statearr_28519_28568 = state_28506__$1;
(statearr_28519_28568[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (22))){
var inst_28491 = (state_28506[(2)]);
var state_28506__$1 = state_28506;
if(cljs.core.truth_(inst_28491)){
var statearr_28520_28569 = state_28506__$1;
(statearr_28520_28569[(1)] = (23));

} else {
var statearr_28521_28570 = state_28506__$1;
(statearr_28521_28570[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (6))){
var inst_28485 = (state_28506[(7)]);
var inst_28487 = (state_28506[(11)]);
var inst_28437 = (state_28506[(8)]);
var inst_28485__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_28437) : topic_fn.call(null,inst_28437));
var inst_28486 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_28487__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28486,inst_28485__$1);
var state_28506__$1 = (function (){var statearr_28522 = state_28506;
(statearr_28522[(7)] = inst_28485__$1);

(statearr_28522[(11)] = inst_28487__$1);

return statearr_28522;
})();
if(cljs.core.truth_(inst_28487__$1)){
var statearr_28523_28571 = state_28506__$1;
(statearr_28523_28571[(1)] = (19));

} else {
var statearr_28524_28572 = state_28506__$1;
(statearr_28524_28572[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (25))){
var inst_28496 = (state_28506[(2)]);
var state_28506__$1 = state_28506;
var statearr_28525_28573 = state_28506__$1;
(statearr_28525_28573[(2)] = inst_28496);

(statearr_28525_28573[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (17))){
var inst_28461 = (state_28506[(10)]);
var inst_28470 = cljs.core.first(inst_28461);
var inst_28471 = cljs.core.async.muxch_STAR_(inst_28470);
var inst_28472 = cljs.core.async.close_BANG_(inst_28471);
var inst_28473 = cljs.core.next(inst_28461);
var inst_28447 = inst_28473;
var inst_28448 = null;
var inst_28449 = (0);
var inst_28450 = (0);
var state_28506__$1 = (function (){var statearr_28526 = state_28506;
(statearr_28526[(12)] = inst_28450);

(statearr_28526[(13)] = inst_28472);

(statearr_28526[(14)] = inst_28448);

(statearr_28526[(15)] = inst_28447);

(statearr_28526[(16)] = inst_28449);

return statearr_28526;
})();
var statearr_28527_28574 = state_28506__$1;
(statearr_28527_28574[(2)] = null);

(statearr_28527_28574[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (3))){
var inst_28504 = (state_28506[(2)]);
var state_28506__$1 = state_28506;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28506__$1,inst_28504);
} else {
if((state_val_28507 === (12))){
var inst_28481 = (state_28506[(2)]);
var state_28506__$1 = state_28506;
var statearr_28528_28575 = state_28506__$1;
(statearr_28528_28575[(2)] = inst_28481);

(statearr_28528_28575[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (2))){
var state_28506__$1 = state_28506;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28506__$1,(4),ch);
} else {
if((state_val_28507 === (23))){
var state_28506__$1 = state_28506;
var statearr_28529_28576 = state_28506__$1;
(statearr_28529_28576[(2)] = null);

(statearr_28529_28576[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (19))){
var inst_28487 = (state_28506[(11)]);
var inst_28437 = (state_28506[(8)]);
var inst_28489 = cljs.core.async.muxch_STAR_(inst_28487);
var state_28506__$1 = state_28506;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28506__$1,(22),inst_28489,inst_28437);
} else {
if((state_val_28507 === (11))){
var inst_28461 = (state_28506[(10)]);
var inst_28447 = (state_28506[(15)]);
var inst_28461__$1 = cljs.core.seq(inst_28447);
var state_28506__$1 = (function (){var statearr_28530 = state_28506;
(statearr_28530[(10)] = inst_28461__$1);

return statearr_28530;
})();
if(inst_28461__$1){
var statearr_28531_28577 = state_28506__$1;
(statearr_28531_28577[(1)] = (13));

} else {
var statearr_28532_28578 = state_28506__$1;
(statearr_28532_28578[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (9))){
var inst_28483 = (state_28506[(2)]);
var state_28506__$1 = state_28506;
var statearr_28533_28579 = state_28506__$1;
(statearr_28533_28579[(2)] = inst_28483);

(statearr_28533_28579[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (5))){
var inst_28444 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_28445 = cljs.core.vals(inst_28444);
var inst_28446 = cljs.core.seq(inst_28445);
var inst_28447 = inst_28446;
var inst_28448 = null;
var inst_28449 = (0);
var inst_28450 = (0);
var state_28506__$1 = (function (){var statearr_28534 = state_28506;
(statearr_28534[(12)] = inst_28450);

(statearr_28534[(14)] = inst_28448);

(statearr_28534[(15)] = inst_28447);

(statearr_28534[(16)] = inst_28449);

return statearr_28534;
})();
var statearr_28535_28580 = state_28506__$1;
(statearr_28535_28580[(2)] = null);

(statearr_28535_28580[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (14))){
var state_28506__$1 = state_28506;
var statearr_28539_28581 = state_28506__$1;
(statearr_28539_28581[(2)] = null);

(statearr_28539_28581[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (16))){
var inst_28461 = (state_28506[(10)]);
var inst_28465 = cljs.core.chunk_first(inst_28461);
var inst_28466 = cljs.core.chunk_rest(inst_28461);
var inst_28467 = cljs.core.count(inst_28465);
var inst_28447 = inst_28466;
var inst_28448 = inst_28465;
var inst_28449 = inst_28467;
var inst_28450 = (0);
var state_28506__$1 = (function (){var statearr_28540 = state_28506;
(statearr_28540[(12)] = inst_28450);

(statearr_28540[(14)] = inst_28448);

(statearr_28540[(15)] = inst_28447);

(statearr_28540[(16)] = inst_28449);

return statearr_28540;
})();
var statearr_28541_28582 = state_28506__$1;
(statearr_28541_28582[(2)] = null);

(statearr_28541_28582[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (10))){
var inst_28450 = (state_28506[(12)]);
var inst_28448 = (state_28506[(14)]);
var inst_28447 = (state_28506[(15)]);
var inst_28449 = (state_28506[(16)]);
var inst_28455 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_28448,inst_28450);
var inst_28456 = cljs.core.async.muxch_STAR_(inst_28455);
var inst_28457 = cljs.core.async.close_BANG_(inst_28456);
var inst_28458 = (inst_28450 + (1));
var tmp28536 = inst_28448;
var tmp28537 = inst_28447;
var tmp28538 = inst_28449;
var inst_28447__$1 = tmp28537;
var inst_28448__$1 = tmp28536;
var inst_28449__$1 = tmp28538;
var inst_28450__$1 = inst_28458;
var state_28506__$1 = (function (){var statearr_28542 = state_28506;
(statearr_28542[(12)] = inst_28450__$1);

(statearr_28542[(17)] = inst_28457);

(statearr_28542[(14)] = inst_28448__$1);

(statearr_28542[(15)] = inst_28447__$1);

(statearr_28542[(16)] = inst_28449__$1);

return statearr_28542;
})();
var statearr_28543_28583 = state_28506__$1;
(statearr_28543_28583[(2)] = null);

(statearr_28543_28583[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (18))){
var inst_28476 = (state_28506[(2)]);
var state_28506__$1 = state_28506;
var statearr_28544_28584 = state_28506__$1;
(statearr_28544_28584[(2)] = inst_28476);

(statearr_28544_28584[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28507 === (8))){
var inst_28450 = (state_28506[(12)]);
var inst_28449 = (state_28506[(16)]);
var inst_28452 = (inst_28450 < inst_28449);
var inst_28453 = inst_28452;
var state_28506__$1 = state_28506;
if(cljs.core.truth_(inst_28453)){
var statearr_28545_28585 = state_28506__$1;
(statearr_28545_28585[(1)] = (10));

} else {
var statearr_28546_28586 = state_28506__$1;
(statearr_28546_28586[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___28558,mults,ensure_mult,p))
;
return ((function (switch__26440__auto__,c__26566__auto___28558,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__26441__auto__ = null;
var cljs$core$async$state_machine__26441__auto____0 = (function (){
var statearr_28550 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28550[(0)] = cljs$core$async$state_machine__26441__auto__);

(statearr_28550[(1)] = (1));

return statearr_28550;
});
var cljs$core$async$state_machine__26441__auto____1 = (function (state_28506){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_28506);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e28551){if((e28551 instanceof Object)){
var ex__26444__auto__ = e28551;
var statearr_28552_28587 = state_28506;
(statearr_28552_28587[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28506);

return cljs.core.cst$kw$recur;
} else {
throw e28551;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__28588 = state_28506;
state_28506 = G__28588;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$state_machine__26441__auto__ = function(state_28506){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26441__auto____1.call(this,state_28506);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26441__auto____0;
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26441__auto____1;
return cljs$core$async$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___28558,mults,ensure_mult,p))
})();
var state__26568__auto__ = (function (){var statearr_28553 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_28553[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___28558);

return statearr_28553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___28558,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args28589 = [];
var len__9181__auto___28592 = arguments.length;
var i__9182__auto___28593 = (0);
while(true){
if((i__9182__auto___28593 < len__9181__auto___28592)){
args28589.push((arguments[i__9182__auto___28593]));

var G__28594 = (i__9182__auto___28593 + (1));
i__9182__auto___28593 = G__28594;
continue;
} else {
}
break;
}

var G__28591 = args28589.length;
switch (G__28591) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args28589.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args28596 = [];
var len__9181__auto___28599 = arguments.length;
var i__9182__auto___28600 = (0);
while(true){
if((i__9182__auto___28600 < len__9181__auto___28599)){
args28596.push((arguments[i__9182__auto___28600]));

var G__28601 = (i__9182__auto___28600 + (1));
i__9182__auto___28600 = G__28601;
continue;
} else {
}
break;
}

var G__28598 = args28596.length;
switch (G__28598) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args28596.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args28603 = [];
var len__9181__auto___28674 = arguments.length;
var i__9182__auto___28675 = (0);
while(true){
if((i__9182__auto___28675 < len__9181__auto___28674)){
args28603.push((arguments[i__9182__auto___28675]));

var G__28676 = (i__9182__auto___28675 + (1));
i__9182__auto___28675 = G__28676;
continue;
} else {
}
break;
}

var G__28605 = args28603.length;
switch (G__28605) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args28603.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__26566__auto___28678 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___28678,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___28678,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_28644){
var state_val_28645 = (state_28644[(1)]);
if((state_val_28645 === (7))){
var state_28644__$1 = state_28644;
var statearr_28646_28679 = state_28644__$1;
(statearr_28646_28679[(2)] = null);

(statearr_28646_28679[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28645 === (1))){
var state_28644__$1 = state_28644;
var statearr_28647_28680 = state_28644__$1;
(statearr_28647_28680[(2)] = null);

(statearr_28647_28680[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28645 === (4))){
var inst_28608 = (state_28644[(7)]);
var inst_28610 = (inst_28608 < cnt);
var state_28644__$1 = state_28644;
if(cljs.core.truth_(inst_28610)){
var statearr_28648_28681 = state_28644__$1;
(statearr_28648_28681[(1)] = (6));

} else {
var statearr_28649_28682 = state_28644__$1;
(statearr_28649_28682[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28645 === (15))){
var inst_28640 = (state_28644[(2)]);
var state_28644__$1 = state_28644;
var statearr_28650_28683 = state_28644__$1;
(statearr_28650_28683[(2)] = inst_28640);

(statearr_28650_28683[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28645 === (13))){
var inst_28633 = cljs.core.async.close_BANG_(out);
var state_28644__$1 = state_28644;
var statearr_28651_28684 = state_28644__$1;
(statearr_28651_28684[(2)] = inst_28633);

(statearr_28651_28684[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28645 === (6))){
var state_28644__$1 = state_28644;
var statearr_28652_28685 = state_28644__$1;
(statearr_28652_28685[(2)] = null);

(statearr_28652_28685[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28645 === (3))){
var inst_28642 = (state_28644[(2)]);
var state_28644__$1 = state_28644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28644__$1,inst_28642);
} else {
if((state_val_28645 === (12))){
var inst_28630 = (state_28644[(8)]);
var inst_28630__$1 = (state_28644[(2)]);
var inst_28631 = cljs.core.some(cljs.core.nil_QMARK_,inst_28630__$1);
var state_28644__$1 = (function (){var statearr_28653 = state_28644;
(statearr_28653[(8)] = inst_28630__$1);

return statearr_28653;
})();
if(cljs.core.truth_(inst_28631)){
var statearr_28654_28686 = state_28644__$1;
(statearr_28654_28686[(1)] = (13));

} else {
var statearr_28655_28687 = state_28644__$1;
(statearr_28655_28687[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28645 === (2))){
var inst_28607 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_28608 = (0);
var state_28644__$1 = (function (){var statearr_28656 = state_28644;
(statearr_28656[(7)] = inst_28608);

(statearr_28656[(9)] = inst_28607);

return statearr_28656;
})();
var statearr_28657_28688 = state_28644__$1;
(statearr_28657_28688[(2)] = null);

(statearr_28657_28688[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28645 === (11))){
var inst_28608 = (state_28644[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_28644,(10),Object,null,(9));
var inst_28617 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_28608) : chs__$1.call(null,inst_28608));
var inst_28618 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_28608) : done.call(null,inst_28608));
var inst_28619 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_28617,inst_28618);
var state_28644__$1 = state_28644;
var statearr_28658_28689 = state_28644__$1;
(statearr_28658_28689[(2)] = inst_28619);


cljs.core.async.impl.ioc_helpers.process_exception(state_28644__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_28645 === (9))){
var inst_28608 = (state_28644[(7)]);
var inst_28621 = (state_28644[(2)]);
var inst_28622 = (inst_28608 + (1));
var inst_28608__$1 = inst_28622;
var state_28644__$1 = (function (){var statearr_28659 = state_28644;
(statearr_28659[(7)] = inst_28608__$1);

(statearr_28659[(10)] = inst_28621);

return statearr_28659;
})();
var statearr_28660_28690 = state_28644__$1;
(statearr_28660_28690[(2)] = null);

(statearr_28660_28690[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28645 === (5))){
var inst_28628 = (state_28644[(2)]);
var state_28644__$1 = (function (){var statearr_28661 = state_28644;
(statearr_28661[(11)] = inst_28628);

return statearr_28661;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28644__$1,(12),dchan);
} else {
if((state_val_28645 === (14))){
var inst_28630 = (state_28644[(8)]);
var inst_28635 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_28630);
var state_28644__$1 = state_28644;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28644__$1,(16),out,inst_28635);
} else {
if((state_val_28645 === (16))){
var inst_28637 = (state_28644[(2)]);
var state_28644__$1 = (function (){var statearr_28662 = state_28644;
(statearr_28662[(12)] = inst_28637);

return statearr_28662;
})();
var statearr_28663_28691 = state_28644__$1;
(statearr_28663_28691[(2)] = null);

(statearr_28663_28691[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28645 === (10))){
var inst_28612 = (state_28644[(2)]);
var inst_28613 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_28644__$1 = (function (){var statearr_28664 = state_28644;
(statearr_28664[(13)] = inst_28612);

return statearr_28664;
})();
var statearr_28665_28692 = state_28644__$1;
(statearr_28665_28692[(2)] = inst_28613);


cljs.core.async.impl.ioc_helpers.process_exception(state_28644__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_28645 === (8))){
var inst_28626 = (state_28644[(2)]);
var state_28644__$1 = state_28644;
var statearr_28666_28693 = state_28644__$1;
(statearr_28666_28693[(2)] = inst_28626);

(statearr_28666_28693[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___28678,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__26440__auto__,c__26566__auto___28678,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__26441__auto__ = null;
var cljs$core$async$state_machine__26441__auto____0 = (function (){
var statearr_28670 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28670[(0)] = cljs$core$async$state_machine__26441__auto__);

(statearr_28670[(1)] = (1));

return statearr_28670;
});
var cljs$core$async$state_machine__26441__auto____1 = (function (state_28644){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_28644);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e28671){if((e28671 instanceof Object)){
var ex__26444__auto__ = e28671;
var statearr_28672_28694 = state_28644;
(statearr_28672_28694[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28644);

return cljs.core.cst$kw$recur;
} else {
throw e28671;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__28695 = state_28644;
state_28644 = G__28695;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$state_machine__26441__auto__ = function(state_28644){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26441__auto____1.call(this,state_28644);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26441__auto____0;
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26441__auto____1;
return cljs$core$async$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___28678,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__26568__auto__ = (function (){var statearr_28673 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_28673[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___28678);

return statearr_28673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___28678,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args28697 = [];
var len__9181__auto___28755 = arguments.length;
var i__9182__auto___28756 = (0);
while(true){
if((i__9182__auto___28756 < len__9181__auto___28755)){
args28697.push((arguments[i__9182__auto___28756]));

var G__28757 = (i__9182__auto___28756 + (1));
i__9182__auto___28756 = G__28757;
continue;
} else {
}
break;
}

var G__28699 = args28697.length;
switch (G__28699) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args28697.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__26566__auto___28759 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___28759,out){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___28759,out){
return (function (state_28731){
var state_val_28732 = (state_28731[(1)]);
if((state_val_28732 === (7))){
var inst_28711 = (state_28731[(7)]);
var inst_28710 = (state_28731[(8)]);
var inst_28710__$1 = (state_28731[(2)]);
var inst_28711__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28710__$1,(0),null);
var inst_28712 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28710__$1,(1),null);
var inst_28713 = (inst_28711__$1 == null);
var state_28731__$1 = (function (){var statearr_28733 = state_28731;
(statearr_28733[(7)] = inst_28711__$1);

(statearr_28733[(8)] = inst_28710__$1);

(statearr_28733[(9)] = inst_28712);

return statearr_28733;
})();
if(cljs.core.truth_(inst_28713)){
var statearr_28734_28760 = state_28731__$1;
(statearr_28734_28760[(1)] = (8));

} else {
var statearr_28735_28761 = state_28731__$1;
(statearr_28735_28761[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28732 === (1))){
var inst_28700 = cljs.core.vec(chs);
var inst_28701 = inst_28700;
var state_28731__$1 = (function (){var statearr_28736 = state_28731;
(statearr_28736[(10)] = inst_28701);

return statearr_28736;
})();
var statearr_28737_28762 = state_28731__$1;
(statearr_28737_28762[(2)] = null);

(statearr_28737_28762[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28732 === (4))){
var inst_28701 = (state_28731[(10)]);
var state_28731__$1 = state_28731;
return cljs.core.async.ioc_alts_BANG_(state_28731__$1,(7),inst_28701);
} else {
if((state_val_28732 === (6))){
var inst_28727 = (state_28731[(2)]);
var state_28731__$1 = state_28731;
var statearr_28738_28763 = state_28731__$1;
(statearr_28738_28763[(2)] = inst_28727);

(statearr_28738_28763[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28732 === (3))){
var inst_28729 = (state_28731[(2)]);
var state_28731__$1 = state_28731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28731__$1,inst_28729);
} else {
if((state_val_28732 === (2))){
var inst_28701 = (state_28731[(10)]);
var inst_28703 = cljs.core.count(inst_28701);
var inst_28704 = (inst_28703 > (0));
var state_28731__$1 = state_28731;
if(cljs.core.truth_(inst_28704)){
var statearr_28740_28764 = state_28731__$1;
(statearr_28740_28764[(1)] = (4));

} else {
var statearr_28741_28765 = state_28731__$1;
(statearr_28741_28765[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28732 === (11))){
var inst_28701 = (state_28731[(10)]);
var inst_28720 = (state_28731[(2)]);
var tmp28739 = inst_28701;
var inst_28701__$1 = tmp28739;
var state_28731__$1 = (function (){var statearr_28742 = state_28731;
(statearr_28742[(11)] = inst_28720);

(statearr_28742[(10)] = inst_28701__$1);

return statearr_28742;
})();
var statearr_28743_28766 = state_28731__$1;
(statearr_28743_28766[(2)] = null);

(statearr_28743_28766[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28732 === (9))){
var inst_28711 = (state_28731[(7)]);
var state_28731__$1 = state_28731;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28731__$1,(11),out,inst_28711);
} else {
if((state_val_28732 === (5))){
var inst_28725 = cljs.core.async.close_BANG_(out);
var state_28731__$1 = state_28731;
var statearr_28744_28767 = state_28731__$1;
(statearr_28744_28767[(2)] = inst_28725);

(statearr_28744_28767[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28732 === (10))){
var inst_28723 = (state_28731[(2)]);
var state_28731__$1 = state_28731;
var statearr_28745_28768 = state_28731__$1;
(statearr_28745_28768[(2)] = inst_28723);

(statearr_28745_28768[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28732 === (8))){
var inst_28701 = (state_28731[(10)]);
var inst_28711 = (state_28731[(7)]);
var inst_28710 = (state_28731[(8)]);
var inst_28712 = (state_28731[(9)]);
var inst_28715 = (function (){var cs = inst_28701;
var vec__28706 = inst_28710;
var v = inst_28711;
var c = inst_28712;
return ((function (cs,vec__28706,v,c,inst_28701,inst_28711,inst_28710,inst_28712,state_val_28732,c__26566__auto___28759,out){
return (function (p1__28696_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__28696_SHARP_);
});
;})(cs,vec__28706,v,c,inst_28701,inst_28711,inst_28710,inst_28712,state_val_28732,c__26566__auto___28759,out))
})();
var inst_28716 = cljs.core.filterv(inst_28715,inst_28701);
var inst_28701__$1 = inst_28716;
var state_28731__$1 = (function (){var statearr_28746 = state_28731;
(statearr_28746[(10)] = inst_28701__$1);

return statearr_28746;
})();
var statearr_28747_28769 = state_28731__$1;
(statearr_28747_28769[(2)] = null);

(statearr_28747_28769[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___28759,out))
;
return ((function (switch__26440__auto__,c__26566__auto___28759,out){
return (function() {
var cljs$core$async$state_machine__26441__auto__ = null;
var cljs$core$async$state_machine__26441__auto____0 = (function (){
var statearr_28751 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28751[(0)] = cljs$core$async$state_machine__26441__auto__);

(statearr_28751[(1)] = (1));

return statearr_28751;
});
var cljs$core$async$state_machine__26441__auto____1 = (function (state_28731){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_28731);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e28752){if((e28752 instanceof Object)){
var ex__26444__auto__ = e28752;
var statearr_28753_28770 = state_28731;
(statearr_28753_28770[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28731);

return cljs.core.cst$kw$recur;
} else {
throw e28752;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__28771 = state_28731;
state_28731 = G__28771;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$state_machine__26441__auto__ = function(state_28731){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26441__auto____1.call(this,state_28731);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26441__auto____0;
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26441__auto____1;
return cljs$core$async$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___28759,out))
})();
var state__26568__auto__ = (function (){var statearr_28754 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_28754[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___28759);

return statearr_28754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___28759,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args28772 = [];
var len__9181__auto___28821 = arguments.length;
var i__9182__auto___28822 = (0);
while(true){
if((i__9182__auto___28822 < len__9181__auto___28821)){
args28772.push((arguments[i__9182__auto___28822]));

var G__28823 = (i__9182__auto___28822 + (1));
i__9182__auto___28822 = G__28823;
continue;
} else {
}
break;
}

var G__28774 = args28772.length;
switch (G__28774) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args28772.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__26566__auto___28825 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___28825,out){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___28825,out){
return (function (state_28798){
var state_val_28799 = (state_28798[(1)]);
if((state_val_28799 === (7))){
var inst_28780 = (state_28798[(7)]);
var inst_28780__$1 = (state_28798[(2)]);
var inst_28781 = (inst_28780__$1 == null);
var inst_28782 = cljs.core.not(inst_28781);
var state_28798__$1 = (function (){var statearr_28800 = state_28798;
(statearr_28800[(7)] = inst_28780__$1);

return statearr_28800;
})();
if(inst_28782){
var statearr_28801_28826 = state_28798__$1;
(statearr_28801_28826[(1)] = (8));

} else {
var statearr_28802_28827 = state_28798__$1;
(statearr_28802_28827[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28799 === (1))){
var inst_28775 = (0);
var state_28798__$1 = (function (){var statearr_28803 = state_28798;
(statearr_28803[(8)] = inst_28775);

return statearr_28803;
})();
var statearr_28804_28828 = state_28798__$1;
(statearr_28804_28828[(2)] = null);

(statearr_28804_28828[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28799 === (4))){
var state_28798__$1 = state_28798;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28798__$1,(7),ch);
} else {
if((state_val_28799 === (6))){
var inst_28793 = (state_28798[(2)]);
var state_28798__$1 = state_28798;
var statearr_28805_28829 = state_28798__$1;
(statearr_28805_28829[(2)] = inst_28793);

(statearr_28805_28829[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28799 === (3))){
var inst_28795 = (state_28798[(2)]);
var inst_28796 = cljs.core.async.close_BANG_(out);
var state_28798__$1 = (function (){var statearr_28806 = state_28798;
(statearr_28806[(9)] = inst_28795);

return statearr_28806;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28798__$1,inst_28796);
} else {
if((state_val_28799 === (2))){
var inst_28775 = (state_28798[(8)]);
var inst_28777 = (inst_28775 < n);
var state_28798__$1 = state_28798;
if(cljs.core.truth_(inst_28777)){
var statearr_28807_28830 = state_28798__$1;
(statearr_28807_28830[(1)] = (4));

} else {
var statearr_28808_28831 = state_28798__$1;
(statearr_28808_28831[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28799 === (11))){
var inst_28775 = (state_28798[(8)]);
var inst_28785 = (state_28798[(2)]);
var inst_28786 = (inst_28775 + (1));
var inst_28775__$1 = inst_28786;
var state_28798__$1 = (function (){var statearr_28809 = state_28798;
(statearr_28809[(8)] = inst_28775__$1);

(statearr_28809[(10)] = inst_28785);

return statearr_28809;
})();
var statearr_28810_28832 = state_28798__$1;
(statearr_28810_28832[(2)] = null);

(statearr_28810_28832[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28799 === (9))){
var state_28798__$1 = state_28798;
var statearr_28811_28833 = state_28798__$1;
(statearr_28811_28833[(2)] = null);

(statearr_28811_28833[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28799 === (5))){
var state_28798__$1 = state_28798;
var statearr_28812_28834 = state_28798__$1;
(statearr_28812_28834[(2)] = null);

(statearr_28812_28834[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28799 === (10))){
var inst_28790 = (state_28798[(2)]);
var state_28798__$1 = state_28798;
var statearr_28813_28835 = state_28798__$1;
(statearr_28813_28835[(2)] = inst_28790);

(statearr_28813_28835[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28799 === (8))){
var inst_28780 = (state_28798[(7)]);
var state_28798__$1 = state_28798;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28798__$1,(11),out,inst_28780);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___28825,out))
;
return ((function (switch__26440__auto__,c__26566__auto___28825,out){
return (function() {
var cljs$core$async$state_machine__26441__auto__ = null;
var cljs$core$async$state_machine__26441__auto____0 = (function (){
var statearr_28817 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28817[(0)] = cljs$core$async$state_machine__26441__auto__);

(statearr_28817[(1)] = (1));

return statearr_28817;
});
var cljs$core$async$state_machine__26441__auto____1 = (function (state_28798){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_28798);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e28818){if((e28818 instanceof Object)){
var ex__26444__auto__ = e28818;
var statearr_28819_28836 = state_28798;
(statearr_28819_28836[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28798);

return cljs.core.cst$kw$recur;
} else {
throw e28818;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__28837 = state_28798;
state_28798 = G__28837;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$state_machine__26441__auto__ = function(state_28798){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26441__auto____1.call(this,state_28798);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26441__auto____0;
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26441__auto____1;
return cljs$core$async$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___28825,out))
})();
var state__26568__auto__ = (function (){var statearr_28820 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_28820[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___28825);

return statearr_28820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___28825,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async28847 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28847 = (function (f,ch,meta28848){
this.f = f;
this.ch = ch;
this.meta28848 = meta28848;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28847.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28849,meta28848__$1){
var self__ = this;
var _28849__$1 = this;
return (new cljs.core.async.t_cljs$core$async28847(self__.f,self__.ch,meta28848__$1));
});

cljs.core.async.t_cljs$core$async28847.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28849){
var self__ = this;
var _28849__$1 = this;
return self__.meta28848;
});

cljs.core.async.t_cljs$core$async28847.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28847.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async28847.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async28847.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28847.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async28850 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28850 = (function (f,ch,meta28848,_,fn1,meta28851){
this.f = f;
this.ch = ch;
this.meta28848 = meta28848;
this._ = _;
this.fn1 = fn1;
this.meta28851 = meta28851;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28850.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_28852,meta28851__$1){
var self__ = this;
var _28852__$1 = this;
return (new cljs.core.async.t_cljs$core$async28850(self__.f,self__.ch,self__.meta28848,self__._,self__.fn1,meta28851__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async28850.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_28852){
var self__ = this;
var _28852__$1 = this;
return self__.meta28851;
});})(___$1))
;

cljs.core.async.t_cljs$core$async28850.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28850.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async28850.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async28850.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__28838_SHARP_){
var G__28853 = (((p1__28838_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__28838_SHARP_) : self__.f.call(null,p1__28838_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__28853) : f1.call(null,G__28853));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async28850.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta28848,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async28847], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta28851], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async28850.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28850.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28850";

cljs.core.async.t_cljs$core$async28850.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8617__auto__,writer__8618__auto__,opt__8619__auto__){
return cljs.core._write(writer__8618__auto__,"cljs.core.async/t_cljs$core$async28850");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async28850 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async28850(f__$1,ch__$1,meta28848__$1,___$2,fn1__$1,meta28851){
return (new cljs.core.async.t_cljs$core$async28850(f__$1,ch__$1,meta28848__$1,___$2,fn1__$1,meta28851));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async28850(self__.f,self__.ch,self__.meta28848,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__7948__auto__ = ret;
if(cljs.core.truth_(and__7948__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__7948__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__28854 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__28854) : self__.f.call(null,G__28854));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async28847.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28847.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async28847.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta28848], null);
});

cljs.core.async.t_cljs$core$async28847.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28847.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28847";

cljs.core.async.t_cljs$core$async28847.cljs$lang$ctorPrWriter = (function (this__8617__auto__,writer__8618__auto__,opt__8619__auto__){
return cljs.core._write(writer__8618__auto__,"cljs.core.async/t_cljs$core$async28847");
});

cljs.core.async.__GT_t_cljs$core$async28847 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async28847(f__$1,ch__$1,meta28848){
return (new cljs.core.async.t_cljs$core$async28847(f__$1,ch__$1,meta28848));
});

}

return (new cljs.core.async.t_cljs$core$async28847(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async28858 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28858 = (function (f,ch,meta28859){
this.f = f;
this.ch = ch;
this.meta28859 = meta28859;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28858.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28860,meta28859__$1){
var self__ = this;
var _28860__$1 = this;
return (new cljs.core.async.t_cljs$core$async28858(self__.f,self__.ch,meta28859__$1));
});

cljs.core.async.t_cljs$core$async28858.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28860){
var self__ = this;
var _28860__$1 = this;
return self__.meta28859;
});

cljs.core.async.t_cljs$core$async28858.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28858.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async28858.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28858.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async28858.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28858.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async28858.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta28859], null);
});

cljs.core.async.t_cljs$core$async28858.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28858.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28858";

cljs.core.async.t_cljs$core$async28858.cljs$lang$ctorPrWriter = (function (this__8617__auto__,writer__8618__auto__,opt__8619__auto__){
return cljs.core._write(writer__8618__auto__,"cljs.core.async/t_cljs$core$async28858");
});

cljs.core.async.__GT_t_cljs$core$async28858 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async28858(f__$1,ch__$1,meta28859){
return (new cljs.core.async.t_cljs$core$async28858(f__$1,ch__$1,meta28859));
});

}

return (new cljs.core.async.t_cljs$core$async28858(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async28864 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28864 = (function (p,ch,meta28865){
this.p = p;
this.ch = ch;
this.meta28865 = meta28865;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28864.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28866,meta28865__$1){
var self__ = this;
var _28866__$1 = this;
return (new cljs.core.async.t_cljs$core$async28864(self__.p,self__.ch,meta28865__$1));
});

cljs.core.async.t_cljs$core$async28864.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28866){
var self__ = this;
var _28866__$1 = this;
return self__.meta28865;
});

cljs.core.async.t_cljs$core$async28864.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28864.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async28864.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async28864.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28864.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async28864.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28864.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async28864.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta28865], null);
});

cljs.core.async.t_cljs$core$async28864.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28864.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28864";

cljs.core.async.t_cljs$core$async28864.cljs$lang$ctorPrWriter = (function (this__8617__auto__,writer__8618__auto__,opt__8619__auto__){
return cljs.core._write(writer__8618__auto__,"cljs.core.async/t_cljs$core$async28864");
});

cljs.core.async.__GT_t_cljs$core$async28864 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async28864(p__$1,ch__$1,meta28865){
return (new cljs.core.async.t_cljs$core$async28864(p__$1,ch__$1,meta28865));
});

}

return (new cljs.core.async.t_cljs$core$async28864(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args28867 = [];
var len__9181__auto___28911 = arguments.length;
var i__9182__auto___28912 = (0);
while(true){
if((i__9182__auto___28912 < len__9181__auto___28911)){
args28867.push((arguments[i__9182__auto___28912]));

var G__28913 = (i__9182__auto___28912 + (1));
i__9182__auto___28912 = G__28913;
continue;
} else {
}
break;
}

var G__28869 = args28867.length;
switch (G__28869) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args28867.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__26566__auto___28915 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___28915,out){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___28915,out){
return (function (state_28890){
var state_val_28891 = (state_28890[(1)]);
if((state_val_28891 === (7))){
var inst_28886 = (state_28890[(2)]);
var state_28890__$1 = state_28890;
var statearr_28892_28916 = state_28890__$1;
(statearr_28892_28916[(2)] = inst_28886);

(statearr_28892_28916[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28891 === (1))){
var state_28890__$1 = state_28890;
var statearr_28893_28917 = state_28890__$1;
(statearr_28893_28917[(2)] = null);

(statearr_28893_28917[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28891 === (4))){
var inst_28872 = (state_28890[(7)]);
var inst_28872__$1 = (state_28890[(2)]);
var inst_28873 = (inst_28872__$1 == null);
var state_28890__$1 = (function (){var statearr_28894 = state_28890;
(statearr_28894[(7)] = inst_28872__$1);

return statearr_28894;
})();
if(cljs.core.truth_(inst_28873)){
var statearr_28895_28918 = state_28890__$1;
(statearr_28895_28918[(1)] = (5));

} else {
var statearr_28896_28919 = state_28890__$1;
(statearr_28896_28919[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28891 === (6))){
var inst_28872 = (state_28890[(7)]);
var inst_28877 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_28872) : p.call(null,inst_28872));
var state_28890__$1 = state_28890;
if(cljs.core.truth_(inst_28877)){
var statearr_28897_28920 = state_28890__$1;
(statearr_28897_28920[(1)] = (8));

} else {
var statearr_28898_28921 = state_28890__$1;
(statearr_28898_28921[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28891 === (3))){
var inst_28888 = (state_28890[(2)]);
var state_28890__$1 = state_28890;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28890__$1,inst_28888);
} else {
if((state_val_28891 === (2))){
var state_28890__$1 = state_28890;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28890__$1,(4),ch);
} else {
if((state_val_28891 === (11))){
var inst_28880 = (state_28890[(2)]);
var state_28890__$1 = state_28890;
var statearr_28899_28922 = state_28890__$1;
(statearr_28899_28922[(2)] = inst_28880);

(statearr_28899_28922[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28891 === (9))){
var state_28890__$1 = state_28890;
var statearr_28900_28923 = state_28890__$1;
(statearr_28900_28923[(2)] = null);

(statearr_28900_28923[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28891 === (5))){
var inst_28875 = cljs.core.async.close_BANG_(out);
var state_28890__$1 = state_28890;
var statearr_28901_28924 = state_28890__$1;
(statearr_28901_28924[(2)] = inst_28875);

(statearr_28901_28924[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28891 === (10))){
var inst_28883 = (state_28890[(2)]);
var state_28890__$1 = (function (){var statearr_28902 = state_28890;
(statearr_28902[(8)] = inst_28883);

return statearr_28902;
})();
var statearr_28903_28925 = state_28890__$1;
(statearr_28903_28925[(2)] = null);

(statearr_28903_28925[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28891 === (8))){
var inst_28872 = (state_28890[(7)]);
var state_28890__$1 = state_28890;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28890__$1,(11),out,inst_28872);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___28915,out))
;
return ((function (switch__26440__auto__,c__26566__auto___28915,out){
return (function() {
var cljs$core$async$state_machine__26441__auto__ = null;
var cljs$core$async$state_machine__26441__auto____0 = (function (){
var statearr_28907 = [null,null,null,null,null,null,null,null,null];
(statearr_28907[(0)] = cljs$core$async$state_machine__26441__auto__);

(statearr_28907[(1)] = (1));

return statearr_28907;
});
var cljs$core$async$state_machine__26441__auto____1 = (function (state_28890){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_28890);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e28908){if((e28908 instanceof Object)){
var ex__26444__auto__ = e28908;
var statearr_28909_28926 = state_28890;
(statearr_28909_28926[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28890);

return cljs.core.cst$kw$recur;
} else {
throw e28908;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__28927 = state_28890;
state_28890 = G__28927;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$state_machine__26441__auto__ = function(state_28890){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26441__auto____1.call(this,state_28890);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26441__auto____0;
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26441__auto____1;
return cljs$core$async$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___28915,out))
})();
var state__26568__auto__ = (function (){var statearr_28910 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_28910[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___28915);

return statearr_28910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___28915,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args28928 = [];
var len__9181__auto___28931 = arguments.length;
var i__9182__auto___28932 = (0);
while(true){
if((i__9182__auto___28932 < len__9181__auto___28931)){
args28928.push((arguments[i__9182__auto___28932]));

var G__28933 = (i__9182__auto___28932 + (1));
i__9182__auto___28932 = G__28933;
continue;
} else {
}
break;
}

var G__28930 = args28928.length;
switch (G__28930) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args28928.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__26566__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto__){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto__){
return (function (state_29100){
var state_val_29101 = (state_29100[(1)]);
if((state_val_29101 === (7))){
var inst_29096 = (state_29100[(2)]);
var state_29100__$1 = state_29100;
var statearr_29102_29143 = state_29100__$1;
(statearr_29102_29143[(2)] = inst_29096);

(statearr_29102_29143[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (20))){
var inst_29066 = (state_29100[(7)]);
var inst_29077 = (state_29100[(2)]);
var inst_29078 = cljs.core.next(inst_29066);
var inst_29052 = inst_29078;
var inst_29053 = null;
var inst_29054 = (0);
var inst_29055 = (0);
var state_29100__$1 = (function (){var statearr_29103 = state_29100;
(statearr_29103[(8)] = inst_29055);

(statearr_29103[(9)] = inst_29054);

(statearr_29103[(10)] = inst_29052);

(statearr_29103[(11)] = inst_29053);

(statearr_29103[(12)] = inst_29077);

return statearr_29103;
})();
var statearr_29104_29144 = state_29100__$1;
(statearr_29104_29144[(2)] = null);

(statearr_29104_29144[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (1))){
var state_29100__$1 = state_29100;
var statearr_29105_29145 = state_29100__$1;
(statearr_29105_29145[(2)] = null);

(statearr_29105_29145[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (4))){
var inst_29041 = (state_29100[(13)]);
var inst_29041__$1 = (state_29100[(2)]);
var inst_29042 = (inst_29041__$1 == null);
var state_29100__$1 = (function (){var statearr_29106 = state_29100;
(statearr_29106[(13)] = inst_29041__$1);

return statearr_29106;
})();
if(cljs.core.truth_(inst_29042)){
var statearr_29107_29146 = state_29100__$1;
(statearr_29107_29146[(1)] = (5));

} else {
var statearr_29108_29147 = state_29100__$1;
(statearr_29108_29147[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (15))){
var state_29100__$1 = state_29100;
var statearr_29112_29148 = state_29100__$1;
(statearr_29112_29148[(2)] = null);

(statearr_29112_29148[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (21))){
var state_29100__$1 = state_29100;
var statearr_29113_29149 = state_29100__$1;
(statearr_29113_29149[(2)] = null);

(statearr_29113_29149[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (13))){
var inst_29055 = (state_29100[(8)]);
var inst_29054 = (state_29100[(9)]);
var inst_29052 = (state_29100[(10)]);
var inst_29053 = (state_29100[(11)]);
var inst_29062 = (state_29100[(2)]);
var inst_29063 = (inst_29055 + (1));
var tmp29109 = inst_29054;
var tmp29110 = inst_29052;
var tmp29111 = inst_29053;
var inst_29052__$1 = tmp29110;
var inst_29053__$1 = tmp29111;
var inst_29054__$1 = tmp29109;
var inst_29055__$1 = inst_29063;
var state_29100__$1 = (function (){var statearr_29114 = state_29100;
(statearr_29114[(14)] = inst_29062);

(statearr_29114[(8)] = inst_29055__$1);

(statearr_29114[(9)] = inst_29054__$1);

(statearr_29114[(10)] = inst_29052__$1);

(statearr_29114[(11)] = inst_29053__$1);

return statearr_29114;
})();
var statearr_29115_29150 = state_29100__$1;
(statearr_29115_29150[(2)] = null);

(statearr_29115_29150[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (22))){
var state_29100__$1 = state_29100;
var statearr_29116_29151 = state_29100__$1;
(statearr_29116_29151[(2)] = null);

(statearr_29116_29151[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (6))){
var inst_29041 = (state_29100[(13)]);
var inst_29050 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_29041) : f.call(null,inst_29041));
var inst_29051 = cljs.core.seq(inst_29050);
var inst_29052 = inst_29051;
var inst_29053 = null;
var inst_29054 = (0);
var inst_29055 = (0);
var state_29100__$1 = (function (){var statearr_29117 = state_29100;
(statearr_29117[(8)] = inst_29055);

(statearr_29117[(9)] = inst_29054);

(statearr_29117[(10)] = inst_29052);

(statearr_29117[(11)] = inst_29053);

return statearr_29117;
})();
var statearr_29118_29152 = state_29100__$1;
(statearr_29118_29152[(2)] = null);

(statearr_29118_29152[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (17))){
var inst_29066 = (state_29100[(7)]);
var inst_29070 = cljs.core.chunk_first(inst_29066);
var inst_29071 = cljs.core.chunk_rest(inst_29066);
var inst_29072 = cljs.core.count(inst_29070);
var inst_29052 = inst_29071;
var inst_29053 = inst_29070;
var inst_29054 = inst_29072;
var inst_29055 = (0);
var state_29100__$1 = (function (){var statearr_29119 = state_29100;
(statearr_29119[(8)] = inst_29055);

(statearr_29119[(9)] = inst_29054);

(statearr_29119[(10)] = inst_29052);

(statearr_29119[(11)] = inst_29053);

return statearr_29119;
})();
var statearr_29120_29153 = state_29100__$1;
(statearr_29120_29153[(2)] = null);

(statearr_29120_29153[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (3))){
var inst_29098 = (state_29100[(2)]);
var state_29100__$1 = state_29100;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29100__$1,inst_29098);
} else {
if((state_val_29101 === (12))){
var inst_29086 = (state_29100[(2)]);
var state_29100__$1 = state_29100;
var statearr_29121_29154 = state_29100__$1;
(statearr_29121_29154[(2)] = inst_29086);

(statearr_29121_29154[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (2))){
var state_29100__$1 = state_29100;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29100__$1,(4),in$);
} else {
if((state_val_29101 === (23))){
var inst_29094 = (state_29100[(2)]);
var state_29100__$1 = state_29100;
var statearr_29122_29155 = state_29100__$1;
(statearr_29122_29155[(2)] = inst_29094);

(statearr_29122_29155[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (19))){
var inst_29081 = (state_29100[(2)]);
var state_29100__$1 = state_29100;
var statearr_29123_29156 = state_29100__$1;
(statearr_29123_29156[(2)] = inst_29081);

(statearr_29123_29156[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (11))){
var inst_29066 = (state_29100[(7)]);
var inst_29052 = (state_29100[(10)]);
var inst_29066__$1 = cljs.core.seq(inst_29052);
var state_29100__$1 = (function (){var statearr_29124 = state_29100;
(statearr_29124[(7)] = inst_29066__$1);

return statearr_29124;
})();
if(inst_29066__$1){
var statearr_29125_29157 = state_29100__$1;
(statearr_29125_29157[(1)] = (14));

} else {
var statearr_29126_29158 = state_29100__$1;
(statearr_29126_29158[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (9))){
var inst_29088 = (state_29100[(2)]);
var inst_29089 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_29100__$1 = (function (){var statearr_29127 = state_29100;
(statearr_29127[(15)] = inst_29088);

return statearr_29127;
})();
if(cljs.core.truth_(inst_29089)){
var statearr_29128_29159 = state_29100__$1;
(statearr_29128_29159[(1)] = (21));

} else {
var statearr_29129_29160 = state_29100__$1;
(statearr_29129_29160[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (5))){
var inst_29044 = cljs.core.async.close_BANG_(out);
var state_29100__$1 = state_29100;
var statearr_29130_29161 = state_29100__$1;
(statearr_29130_29161[(2)] = inst_29044);

(statearr_29130_29161[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (14))){
var inst_29066 = (state_29100[(7)]);
var inst_29068 = cljs.core.chunked_seq_QMARK_(inst_29066);
var state_29100__$1 = state_29100;
if(inst_29068){
var statearr_29131_29162 = state_29100__$1;
(statearr_29131_29162[(1)] = (17));

} else {
var statearr_29132_29163 = state_29100__$1;
(statearr_29132_29163[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (16))){
var inst_29084 = (state_29100[(2)]);
var state_29100__$1 = state_29100;
var statearr_29133_29164 = state_29100__$1;
(statearr_29133_29164[(2)] = inst_29084);

(statearr_29133_29164[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29101 === (10))){
var inst_29055 = (state_29100[(8)]);
var inst_29053 = (state_29100[(11)]);
var inst_29060 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_29053,inst_29055);
var state_29100__$1 = state_29100;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29100__$1,(13),out,inst_29060);
} else {
if((state_val_29101 === (18))){
var inst_29066 = (state_29100[(7)]);
var inst_29075 = cljs.core.first(inst_29066);
var state_29100__$1 = state_29100;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29100__$1,(20),out,inst_29075);
} else {
if((state_val_29101 === (8))){
var inst_29055 = (state_29100[(8)]);
var inst_29054 = (state_29100[(9)]);
var inst_29057 = (inst_29055 < inst_29054);
var inst_29058 = inst_29057;
var state_29100__$1 = state_29100;
if(cljs.core.truth_(inst_29058)){
var statearr_29134_29165 = state_29100__$1;
(statearr_29134_29165[(1)] = (10));

} else {
var statearr_29135_29166 = state_29100__$1;
(statearr_29135_29166[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto__))
;
return ((function (switch__26440__auto__,c__26566__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__26441__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__26441__auto____0 = (function (){
var statearr_29139 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29139[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__26441__auto__);

(statearr_29139[(1)] = (1));

return statearr_29139;
});
var cljs$core$async$mapcat_STAR__$_state_machine__26441__auto____1 = (function (state_29100){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_29100);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e29140){if((e29140 instanceof Object)){
var ex__26444__auto__ = e29140;
var statearr_29141_29167 = state_29100;
(statearr_29141_29167[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29100);

return cljs.core.cst$kw$recur;
} else {
throw e29140;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__29168 = state_29100;
state_29100 = G__29168;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__26441__auto__ = function(state_29100){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__26441__auto____1.call(this,state_29100);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__26441__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__26441__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto__))
})();
var state__26568__auto__ = (function (){var statearr_29142 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_29142[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto__);

return statearr_29142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto__))
);

return c__26566__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args29169 = [];
var len__9181__auto___29172 = arguments.length;
var i__9182__auto___29173 = (0);
while(true){
if((i__9182__auto___29173 < len__9181__auto___29172)){
args29169.push((arguments[i__9182__auto___29173]));

var G__29174 = (i__9182__auto___29173 + (1));
i__9182__auto___29173 = G__29174;
continue;
} else {
}
break;
}

var G__29171 = args29169.length;
switch (G__29171) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args29169.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args29176 = [];
var len__9181__auto___29179 = arguments.length;
var i__9182__auto___29180 = (0);
while(true){
if((i__9182__auto___29180 < len__9181__auto___29179)){
args29176.push((arguments[i__9182__auto___29180]));

var G__29181 = (i__9182__auto___29180 + (1));
i__9182__auto___29180 = G__29181;
continue;
} else {
}
break;
}

var G__29178 = args29176.length;
switch (G__29178) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args29176.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args29183 = [];
var len__9181__auto___29234 = arguments.length;
var i__9182__auto___29235 = (0);
while(true){
if((i__9182__auto___29235 < len__9181__auto___29234)){
args29183.push((arguments[i__9182__auto___29235]));

var G__29236 = (i__9182__auto___29235 + (1));
i__9182__auto___29235 = G__29236;
continue;
} else {
}
break;
}

var G__29185 = args29183.length;
switch (G__29185) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args29183.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__26566__auto___29238 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___29238,out){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___29238,out){
return (function (state_29209){
var state_val_29210 = (state_29209[(1)]);
if((state_val_29210 === (7))){
var inst_29204 = (state_29209[(2)]);
var state_29209__$1 = state_29209;
var statearr_29211_29239 = state_29209__$1;
(statearr_29211_29239[(2)] = inst_29204);

(statearr_29211_29239[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29210 === (1))){
var inst_29186 = null;
var state_29209__$1 = (function (){var statearr_29212 = state_29209;
(statearr_29212[(7)] = inst_29186);

return statearr_29212;
})();
var statearr_29213_29240 = state_29209__$1;
(statearr_29213_29240[(2)] = null);

(statearr_29213_29240[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29210 === (4))){
var inst_29189 = (state_29209[(8)]);
var inst_29189__$1 = (state_29209[(2)]);
var inst_29190 = (inst_29189__$1 == null);
var inst_29191 = cljs.core.not(inst_29190);
var state_29209__$1 = (function (){var statearr_29214 = state_29209;
(statearr_29214[(8)] = inst_29189__$1);

return statearr_29214;
})();
if(inst_29191){
var statearr_29215_29241 = state_29209__$1;
(statearr_29215_29241[(1)] = (5));

} else {
var statearr_29216_29242 = state_29209__$1;
(statearr_29216_29242[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29210 === (6))){
var state_29209__$1 = state_29209;
var statearr_29217_29243 = state_29209__$1;
(statearr_29217_29243[(2)] = null);

(statearr_29217_29243[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29210 === (3))){
var inst_29206 = (state_29209[(2)]);
var inst_29207 = cljs.core.async.close_BANG_(out);
var state_29209__$1 = (function (){var statearr_29218 = state_29209;
(statearr_29218[(9)] = inst_29206);

return statearr_29218;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29209__$1,inst_29207);
} else {
if((state_val_29210 === (2))){
var state_29209__$1 = state_29209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29209__$1,(4),ch);
} else {
if((state_val_29210 === (11))){
var inst_29189 = (state_29209[(8)]);
var inst_29198 = (state_29209[(2)]);
var inst_29186 = inst_29189;
var state_29209__$1 = (function (){var statearr_29219 = state_29209;
(statearr_29219[(7)] = inst_29186);

(statearr_29219[(10)] = inst_29198);

return statearr_29219;
})();
var statearr_29220_29244 = state_29209__$1;
(statearr_29220_29244[(2)] = null);

(statearr_29220_29244[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29210 === (9))){
var inst_29189 = (state_29209[(8)]);
var state_29209__$1 = state_29209;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29209__$1,(11),out,inst_29189);
} else {
if((state_val_29210 === (5))){
var inst_29186 = (state_29209[(7)]);
var inst_29189 = (state_29209[(8)]);
var inst_29193 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29189,inst_29186);
var state_29209__$1 = state_29209;
if(inst_29193){
var statearr_29222_29245 = state_29209__$1;
(statearr_29222_29245[(1)] = (8));

} else {
var statearr_29223_29246 = state_29209__$1;
(statearr_29223_29246[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29210 === (10))){
var inst_29201 = (state_29209[(2)]);
var state_29209__$1 = state_29209;
var statearr_29224_29247 = state_29209__$1;
(statearr_29224_29247[(2)] = inst_29201);

(statearr_29224_29247[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29210 === (8))){
var inst_29186 = (state_29209[(7)]);
var tmp29221 = inst_29186;
var inst_29186__$1 = tmp29221;
var state_29209__$1 = (function (){var statearr_29225 = state_29209;
(statearr_29225[(7)] = inst_29186__$1);

return statearr_29225;
})();
var statearr_29226_29248 = state_29209__$1;
(statearr_29226_29248[(2)] = null);

(statearr_29226_29248[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___29238,out))
;
return ((function (switch__26440__auto__,c__26566__auto___29238,out){
return (function() {
var cljs$core$async$state_machine__26441__auto__ = null;
var cljs$core$async$state_machine__26441__auto____0 = (function (){
var statearr_29230 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29230[(0)] = cljs$core$async$state_machine__26441__auto__);

(statearr_29230[(1)] = (1));

return statearr_29230;
});
var cljs$core$async$state_machine__26441__auto____1 = (function (state_29209){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_29209);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e29231){if((e29231 instanceof Object)){
var ex__26444__auto__ = e29231;
var statearr_29232_29249 = state_29209;
(statearr_29232_29249[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29209);

return cljs.core.cst$kw$recur;
} else {
throw e29231;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__29250 = state_29209;
state_29209 = G__29250;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$state_machine__26441__auto__ = function(state_29209){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26441__auto____1.call(this,state_29209);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26441__auto____0;
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26441__auto____1;
return cljs$core$async$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___29238,out))
})();
var state__26568__auto__ = (function (){var statearr_29233 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_29233[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___29238);

return statearr_29233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___29238,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args29251 = [];
var len__9181__auto___29321 = arguments.length;
var i__9182__auto___29322 = (0);
while(true){
if((i__9182__auto___29322 < len__9181__auto___29321)){
args29251.push((arguments[i__9182__auto___29322]));

var G__29323 = (i__9182__auto___29322 + (1));
i__9182__auto___29322 = G__29323;
continue;
} else {
}
break;
}

var G__29253 = args29251.length;
switch (G__29253) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args29251.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__26566__auto___29325 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___29325,out){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___29325,out){
return (function (state_29291){
var state_val_29292 = (state_29291[(1)]);
if((state_val_29292 === (7))){
var inst_29287 = (state_29291[(2)]);
var state_29291__$1 = state_29291;
var statearr_29293_29326 = state_29291__$1;
(statearr_29293_29326[(2)] = inst_29287);

(statearr_29293_29326[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29292 === (1))){
var inst_29254 = (new Array(n));
var inst_29255 = inst_29254;
var inst_29256 = (0);
var state_29291__$1 = (function (){var statearr_29294 = state_29291;
(statearr_29294[(7)] = inst_29256);

(statearr_29294[(8)] = inst_29255);

return statearr_29294;
})();
var statearr_29295_29327 = state_29291__$1;
(statearr_29295_29327[(2)] = null);

(statearr_29295_29327[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29292 === (4))){
var inst_29259 = (state_29291[(9)]);
var inst_29259__$1 = (state_29291[(2)]);
var inst_29260 = (inst_29259__$1 == null);
var inst_29261 = cljs.core.not(inst_29260);
var state_29291__$1 = (function (){var statearr_29296 = state_29291;
(statearr_29296[(9)] = inst_29259__$1);

return statearr_29296;
})();
if(inst_29261){
var statearr_29297_29328 = state_29291__$1;
(statearr_29297_29328[(1)] = (5));

} else {
var statearr_29298_29329 = state_29291__$1;
(statearr_29298_29329[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29292 === (15))){
var inst_29281 = (state_29291[(2)]);
var state_29291__$1 = state_29291;
var statearr_29299_29330 = state_29291__$1;
(statearr_29299_29330[(2)] = inst_29281);

(statearr_29299_29330[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29292 === (13))){
var state_29291__$1 = state_29291;
var statearr_29300_29331 = state_29291__$1;
(statearr_29300_29331[(2)] = null);

(statearr_29300_29331[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29292 === (6))){
var inst_29256 = (state_29291[(7)]);
var inst_29277 = (inst_29256 > (0));
var state_29291__$1 = state_29291;
if(cljs.core.truth_(inst_29277)){
var statearr_29301_29332 = state_29291__$1;
(statearr_29301_29332[(1)] = (12));

} else {
var statearr_29302_29333 = state_29291__$1;
(statearr_29302_29333[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29292 === (3))){
var inst_29289 = (state_29291[(2)]);
var state_29291__$1 = state_29291;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29291__$1,inst_29289);
} else {
if((state_val_29292 === (12))){
var inst_29255 = (state_29291[(8)]);
var inst_29279 = cljs.core.vec(inst_29255);
var state_29291__$1 = state_29291;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29291__$1,(15),out,inst_29279);
} else {
if((state_val_29292 === (2))){
var state_29291__$1 = state_29291;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29291__$1,(4),ch);
} else {
if((state_val_29292 === (11))){
var inst_29271 = (state_29291[(2)]);
var inst_29272 = (new Array(n));
var inst_29255 = inst_29272;
var inst_29256 = (0);
var state_29291__$1 = (function (){var statearr_29303 = state_29291;
(statearr_29303[(7)] = inst_29256);

(statearr_29303[(8)] = inst_29255);

(statearr_29303[(10)] = inst_29271);

return statearr_29303;
})();
var statearr_29304_29334 = state_29291__$1;
(statearr_29304_29334[(2)] = null);

(statearr_29304_29334[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29292 === (9))){
var inst_29255 = (state_29291[(8)]);
var inst_29269 = cljs.core.vec(inst_29255);
var state_29291__$1 = state_29291;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29291__$1,(11),out,inst_29269);
} else {
if((state_val_29292 === (5))){
var inst_29264 = (state_29291[(11)]);
var inst_29256 = (state_29291[(7)]);
var inst_29255 = (state_29291[(8)]);
var inst_29259 = (state_29291[(9)]);
var inst_29263 = (inst_29255[inst_29256] = inst_29259);
var inst_29264__$1 = (inst_29256 + (1));
var inst_29265 = (inst_29264__$1 < n);
var state_29291__$1 = (function (){var statearr_29305 = state_29291;
(statearr_29305[(12)] = inst_29263);

(statearr_29305[(11)] = inst_29264__$1);

return statearr_29305;
})();
if(cljs.core.truth_(inst_29265)){
var statearr_29306_29335 = state_29291__$1;
(statearr_29306_29335[(1)] = (8));

} else {
var statearr_29307_29336 = state_29291__$1;
(statearr_29307_29336[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29292 === (14))){
var inst_29284 = (state_29291[(2)]);
var inst_29285 = cljs.core.async.close_BANG_(out);
var state_29291__$1 = (function (){var statearr_29309 = state_29291;
(statearr_29309[(13)] = inst_29284);

return statearr_29309;
})();
var statearr_29310_29337 = state_29291__$1;
(statearr_29310_29337[(2)] = inst_29285);

(statearr_29310_29337[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29292 === (10))){
var inst_29275 = (state_29291[(2)]);
var state_29291__$1 = state_29291;
var statearr_29311_29338 = state_29291__$1;
(statearr_29311_29338[(2)] = inst_29275);

(statearr_29311_29338[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29292 === (8))){
var inst_29264 = (state_29291[(11)]);
var inst_29255 = (state_29291[(8)]);
var tmp29308 = inst_29255;
var inst_29255__$1 = tmp29308;
var inst_29256 = inst_29264;
var state_29291__$1 = (function (){var statearr_29312 = state_29291;
(statearr_29312[(7)] = inst_29256);

(statearr_29312[(8)] = inst_29255__$1);

return statearr_29312;
})();
var statearr_29313_29339 = state_29291__$1;
(statearr_29313_29339[(2)] = null);

(statearr_29313_29339[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___29325,out))
;
return ((function (switch__26440__auto__,c__26566__auto___29325,out){
return (function() {
var cljs$core$async$state_machine__26441__auto__ = null;
var cljs$core$async$state_machine__26441__auto____0 = (function (){
var statearr_29317 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29317[(0)] = cljs$core$async$state_machine__26441__auto__);

(statearr_29317[(1)] = (1));

return statearr_29317;
});
var cljs$core$async$state_machine__26441__auto____1 = (function (state_29291){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_29291);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e29318){if((e29318 instanceof Object)){
var ex__26444__auto__ = e29318;
var statearr_29319_29340 = state_29291;
(statearr_29319_29340[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29291);

return cljs.core.cst$kw$recur;
} else {
throw e29318;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__29341 = state_29291;
state_29291 = G__29341;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$state_machine__26441__auto__ = function(state_29291){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26441__auto____1.call(this,state_29291);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26441__auto____0;
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26441__auto____1;
return cljs$core$async$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___29325,out))
})();
var state__26568__auto__ = (function (){var statearr_29320 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_29320[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___29325);

return statearr_29320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___29325,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args29342 = [];
var len__9181__auto___29416 = arguments.length;
var i__9182__auto___29417 = (0);
while(true){
if((i__9182__auto___29417 < len__9181__auto___29416)){
args29342.push((arguments[i__9182__auto___29417]));

var G__29418 = (i__9182__auto___29417 + (1));
i__9182__auto___29417 = G__29418;
continue;
} else {
}
break;
}

var G__29344 = args29342.length;
switch (G__29344) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args29342.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__26566__auto___29420 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___29420,out){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___29420,out){
return (function (state_29386){
var state_val_29387 = (state_29386[(1)]);
if((state_val_29387 === (7))){
var inst_29382 = (state_29386[(2)]);
var state_29386__$1 = state_29386;
var statearr_29388_29421 = state_29386__$1;
(statearr_29388_29421[(2)] = inst_29382);

(statearr_29388_29421[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29387 === (1))){
var inst_29345 = [];
var inst_29346 = inst_29345;
var inst_29347 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_29386__$1 = (function (){var statearr_29389 = state_29386;
(statearr_29389[(7)] = inst_29346);

(statearr_29389[(8)] = inst_29347);

return statearr_29389;
})();
var statearr_29390_29422 = state_29386__$1;
(statearr_29390_29422[(2)] = null);

(statearr_29390_29422[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29387 === (4))){
var inst_29350 = (state_29386[(9)]);
var inst_29350__$1 = (state_29386[(2)]);
var inst_29351 = (inst_29350__$1 == null);
var inst_29352 = cljs.core.not(inst_29351);
var state_29386__$1 = (function (){var statearr_29391 = state_29386;
(statearr_29391[(9)] = inst_29350__$1);

return statearr_29391;
})();
if(inst_29352){
var statearr_29392_29423 = state_29386__$1;
(statearr_29392_29423[(1)] = (5));

} else {
var statearr_29393_29424 = state_29386__$1;
(statearr_29393_29424[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29387 === (15))){
var inst_29376 = (state_29386[(2)]);
var state_29386__$1 = state_29386;
var statearr_29394_29425 = state_29386__$1;
(statearr_29394_29425[(2)] = inst_29376);

(statearr_29394_29425[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29387 === (13))){
var state_29386__$1 = state_29386;
var statearr_29395_29426 = state_29386__$1;
(statearr_29395_29426[(2)] = null);

(statearr_29395_29426[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29387 === (6))){
var inst_29346 = (state_29386[(7)]);
var inst_29371 = inst_29346.length;
var inst_29372 = (inst_29371 > (0));
var state_29386__$1 = state_29386;
if(cljs.core.truth_(inst_29372)){
var statearr_29396_29427 = state_29386__$1;
(statearr_29396_29427[(1)] = (12));

} else {
var statearr_29397_29428 = state_29386__$1;
(statearr_29397_29428[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29387 === (3))){
var inst_29384 = (state_29386[(2)]);
var state_29386__$1 = state_29386;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29386__$1,inst_29384);
} else {
if((state_val_29387 === (12))){
var inst_29346 = (state_29386[(7)]);
var inst_29374 = cljs.core.vec(inst_29346);
var state_29386__$1 = state_29386;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29386__$1,(15),out,inst_29374);
} else {
if((state_val_29387 === (2))){
var state_29386__$1 = state_29386;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29386__$1,(4),ch);
} else {
if((state_val_29387 === (11))){
var inst_29354 = (state_29386[(10)]);
var inst_29350 = (state_29386[(9)]);
var inst_29364 = (state_29386[(2)]);
var inst_29365 = [];
var inst_29366 = inst_29365.push(inst_29350);
var inst_29346 = inst_29365;
var inst_29347 = inst_29354;
var state_29386__$1 = (function (){var statearr_29398 = state_29386;
(statearr_29398[(7)] = inst_29346);

(statearr_29398[(11)] = inst_29366);

(statearr_29398[(8)] = inst_29347);

(statearr_29398[(12)] = inst_29364);

return statearr_29398;
})();
var statearr_29399_29429 = state_29386__$1;
(statearr_29399_29429[(2)] = null);

(statearr_29399_29429[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29387 === (9))){
var inst_29346 = (state_29386[(7)]);
var inst_29362 = cljs.core.vec(inst_29346);
var state_29386__$1 = state_29386;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29386__$1,(11),out,inst_29362);
} else {
if((state_val_29387 === (5))){
var inst_29354 = (state_29386[(10)]);
var inst_29350 = (state_29386[(9)]);
var inst_29347 = (state_29386[(8)]);
var inst_29354__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_29350) : f.call(null,inst_29350));
var inst_29355 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29354__$1,inst_29347);
var inst_29356 = cljs.core.keyword_identical_QMARK_(inst_29347,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_29357 = (inst_29355) || (inst_29356);
var state_29386__$1 = (function (){var statearr_29400 = state_29386;
(statearr_29400[(10)] = inst_29354__$1);

return statearr_29400;
})();
if(cljs.core.truth_(inst_29357)){
var statearr_29401_29430 = state_29386__$1;
(statearr_29401_29430[(1)] = (8));

} else {
var statearr_29402_29431 = state_29386__$1;
(statearr_29402_29431[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29387 === (14))){
var inst_29379 = (state_29386[(2)]);
var inst_29380 = cljs.core.async.close_BANG_(out);
var state_29386__$1 = (function (){var statearr_29404 = state_29386;
(statearr_29404[(13)] = inst_29379);

return statearr_29404;
})();
var statearr_29405_29432 = state_29386__$1;
(statearr_29405_29432[(2)] = inst_29380);

(statearr_29405_29432[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29387 === (10))){
var inst_29369 = (state_29386[(2)]);
var state_29386__$1 = state_29386;
var statearr_29406_29433 = state_29386__$1;
(statearr_29406_29433[(2)] = inst_29369);

(statearr_29406_29433[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29387 === (8))){
var inst_29354 = (state_29386[(10)]);
var inst_29346 = (state_29386[(7)]);
var inst_29350 = (state_29386[(9)]);
var inst_29359 = inst_29346.push(inst_29350);
var tmp29403 = inst_29346;
var inst_29346__$1 = tmp29403;
var inst_29347 = inst_29354;
var state_29386__$1 = (function (){var statearr_29407 = state_29386;
(statearr_29407[(7)] = inst_29346__$1);

(statearr_29407[(14)] = inst_29359);

(statearr_29407[(8)] = inst_29347);

return statearr_29407;
})();
var statearr_29408_29434 = state_29386__$1;
(statearr_29408_29434[(2)] = null);

(statearr_29408_29434[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___29420,out))
;
return ((function (switch__26440__auto__,c__26566__auto___29420,out){
return (function() {
var cljs$core$async$state_machine__26441__auto__ = null;
var cljs$core$async$state_machine__26441__auto____0 = (function (){
var statearr_29412 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29412[(0)] = cljs$core$async$state_machine__26441__auto__);

(statearr_29412[(1)] = (1));

return statearr_29412;
});
var cljs$core$async$state_machine__26441__auto____1 = (function (state_29386){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_29386);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e29413){if((e29413 instanceof Object)){
var ex__26444__auto__ = e29413;
var statearr_29414_29435 = state_29386;
(statearr_29414_29435[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29386);

return cljs.core.cst$kw$recur;
} else {
throw e29413;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__29436 = state_29386;
state_29386 = G__29436;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
cljs$core$async$state_machine__26441__auto__ = function(state_29386){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26441__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26441__auto____1.call(this,state_29386);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26441__auto____0;
cljs$core$async$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26441__auto____1;
return cljs$core$async$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___29420,out))
})();
var state__26568__auto__ = (function (){var statearr_29415 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_29415[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___29420);

return statearr_29415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___29420,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

