// Compiled by ClojureScript 1.9.518 {:static-fns true, :optimize-constants true}
goog.provide('taoensso.encore');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.reader');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('goog.string.StringBuffer');
goog.require('goog.events');
goog.require('goog.net.XhrIo');
goog.require('goog.net.XhrIoPool');
goog.require('goog.Uri.QueryData');
goog.require('goog.structs');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
/**
 * Used for lib-consumer version assertions
 */
taoensso.encore.encore_version = 1.35;
taoensso.encore.assert_min_encore_version = (function taoensso$encore$assert_min_encore_version(min_version){
if((taoensso.encore.encore_version < min_version)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((taoensso.encore.format.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.format.cljs$core$IFn$_invoke$arity$3("Insufficient com.taoensso/encore version: %s < %s. You may have a Leiningen dependency conflict (see http://goo.gl/qBbLvC for solution).",taoensso.encore.encore_version,min_version) : taoensso.encore.format.call(null,"Insufficient com.taoensso/encore version: %s < %s. You may have a Leiningen dependency conflict (see http://goo.gl/qBbLvC for solution).",taoensso.encore.encore_version,min_version)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$min_DASH_version,min_version,cljs.core.cst$kw$this_DASH_version,taoensso.encore.encore_version], null));
} else {
return null;
}
});
taoensso.encore.read_edn = (function taoensso$encore$read_edn(s){
return cljs.reader.read_string(s);
});
/**
 * Handles optional docstrings & attr maps for a macro def's name.
 *   Stolen from `clojure.tools.macro`.
 */
taoensso.encore.name_with_attrs = (function taoensso$encore$name_with_attrs(name,macro_args){
var vec__26345 = ((typeof cljs.core.first(macro_args) === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(macro_args),cljs.core.next(macro_args)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,macro_args], null));
var docstring = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26345,(0),null);
var macro_args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26345,(1),null);
var vec__26348 = ((cljs.core.map_QMARK_(cljs.core.first(macro_args__$1)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(macro_args__$1),cljs.core.next(macro_args__$1)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.EMPTY,macro_args__$1], null));
var attr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26348,(0),null);
var macro_args__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26348,(1),null);
var attr__$1 = (cljs.core.truth_(docstring)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(attr,cljs.core.cst$kw$doc,docstring):attr);
var attr__$2 = (cljs.core.truth_(cljs.core.meta(name))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.meta(name),attr__$1):attr__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(name,attr__$2),macro_args__$2], null);
});
taoensso.encore.kw_identical_QMARK_ = cljs.core.keyword_identical_QMARK_;
taoensso.encore.stringy_QMARK_ = (function taoensso$encore$stringy_QMARK_(x){
return ((x instanceof cljs.core.Keyword)) || (typeof x === 'string');
});
taoensso.encore.atom_QMARK_ = (function taoensso$encore$atom_QMARK_(x){
return (x instanceof cljs.core.Atom);
});
taoensso.encore.chan_QMARK_ = (function taoensso$encore$chan_QMARK_(x){
return (x instanceof cljs.core.async.impl.channels.ManyToManyChannel);
});
taoensso.encore.re_pattern_QMARK_ = (function taoensso$encore$re_pattern_QMARK_(x){
return (x instanceof RegExp);
});
taoensso.encore.error_QMARK_ = (function taoensso$encore$error_QMARK_(x){
return (x instanceof Error);
});
/**
 * Returns data map iff `x` is an error of any type on platform.
 */
taoensso.encore.error_data = (function taoensso$encore$error_data(x){
var temp__4657__auto__ = (function (){var or__7289__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
if((x instanceof Error)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return null;
}
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var data_map = temp__4657__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(function (){var err = x;
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$err_DASH_type,cljs.core.type(err),cljs.core.cst$kw$err_DASH_msg,err.message,cljs.core.cst$kw$err_DASH_cause,err.cause], null);
})(),data_map], 0));
} else {
return null;
}
});
taoensso.encore.nnil_QMARK_ = (function taoensso$encore$nnil_QMARK_(x){
return !((x == null));
});
taoensso.encore.nblank_QMARK_ = (function taoensso$encore$nblank_QMARK_(x){
return !(clojure.string.blank_QMARK_(x));
});
taoensso.encore.nneg_QMARK_ = (function taoensso$encore$nneg_QMARK_(x){
return !((x < (0)));
});
taoensso.encore.pos_int_QMARK_ = (function taoensso$encore$pos_int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) && ((x > (0)));
});
taoensso.encore.nneg_int_QMARK_ = (function taoensso$encore$nneg_int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) && (!((x < (0))));
});
taoensso.encore.nvec_QMARK_ = (function taoensso$encore$nvec_QMARK_(n,x){
return (cljs.core.vector_QMARK_(x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(x),n));
});
taoensso.encore.udt_QMARK_ = taoensso.encore.nneg_int_QMARK_;
taoensso.encore.vec2_QMARK_ = (function taoensso$encore$vec2_QMARK_(x){
return taoensso.encore.nvec_QMARK_((2),x);
});
taoensso.encore.vec3_QMARK_ = (function taoensso$encore$vec3_QMARK_(x){
return taoensso.encore.nvec_QMARK_((3),x);
});
taoensso.encore.distinct_elements_QMARK_ = (function taoensso$encore$distinct_elements_QMARK_(x){
return (cljs.core.set_QMARK_(x)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(x),cljs.core.count((taoensso.encore.set_STAR_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.set_STAR_.cljs$core$IFn$_invoke$arity$1(x) : taoensso.encore.set_STAR_.call(null,x)))));
});
taoensso.encore.nblank_str_QMARK_ = (function taoensso$encore$nblank_str_QMARK_(x){
return (typeof x === 'string') && (!(clojure.string.blank_QMARK_(x)));
});
taoensso.encore.nneg_num_QMARK_ = (function taoensso$encore$nneg_num_QMARK_(x){
return (typeof x === 'number') && (!((x < (0))));
});
taoensso.encore.pos_num_QMARK_ = (function taoensso$encore$pos_num_QMARK_(x){
return (typeof x === 'number') && ((x > (0)));
});
taoensso.encore.zero_num_QMARK_ = (function taoensso$encore$zero_num_QMARK_(x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),x);
});
taoensso.encore.as__QMARK_nblank = (function taoensso$encore$as__QMARK_nblank(x){
if(typeof x === 'string'){
if(clojure.string.blank_QMARK_(x)){
return null;
} else {
return x;
}
} else {
return null;
}
});
taoensso.encore.as__QMARK_kw = (function taoensso$encore$as__QMARK_kw(x){
if((x instanceof cljs.core.Keyword)){
return x;
} else {
if(typeof x === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(x);
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_name = (function taoensso$encore$as__QMARK_name(x){
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if(typeof x === 'string'){
return x;
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_bool = (function taoensso$encore$as__QMARK_bool(x){
if((x == null)){
return null;
} else {
if((x === true) || (x === false)){
return x;
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,(0))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"false")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"FALSE")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"0"))){
return false;
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,(1))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"true")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"TRUE")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"1"))){
return true;
} else {
return null;
}
}
}
}
});
taoensso.encore.as__QMARK_int = (function taoensso$encore$as__QMARK_int(x){
if((x == null)){
return null;
} else {
if(typeof x === 'number'){
return cljs.core.long$(x);
} else {
if(typeof x === 'string'){
var x__$1 = parseInt(x,(10));
if(cljs.core.truth_(isNaN(x__$1))){
return null;
} else {
return x__$1;
}
} else {
return null;
}
}
}
});
taoensso.encore.as__QMARK_float = (function taoensso$encore$as__QMARK_float(x){
if((x == null)){
return null;
} else {
if(typeof x === 'number'){
return x;
} else {
if(typeof x === 'string'){
var x__$1 = parseFloat(x);
if(cljs.core.truth_(isNan(x__$1))){
return null;
} else {
return x__$1;
}
} else {
return null;
}
}
}
});
taoensso.encore.nnil_EQ_ = (function taoensso$encore$nnil_EQ_(var_args){
var args26353 = [];
var len__8402__auto___26359 = arguments.length;
var i__8403__auto___26360 = (0);
while(true){
if((i__8403__auto___26360 < len__8402__auto___26359)){
args26353.push((arguments[i__8403__auto___26360]));

var G__26361 = (i__8403__auto___26360 + (1));
i__8403__auto___26360 = G__26361;
continue;
} else {
}
break;
}

var G__26358 = args26353.length;
switch (G__26358) {
case 2:
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args26353.slice((2)),(0),null));
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var and__7277__auto__ = taoensso.encore.nnil_QMARK_(x);
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y);
} else {
return and__7277__auto__;
}
});

taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
var and__7277__auto__ = taoensso.encore.nnil_QMARK_(x);
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more);
} else {
return and__7277__auto__;
}
});

taoensso.encore.nnil_EQ_.cljs$lang$applyTo = (function (seq26354){
var G__26355 = cljs.core.first(seq26354);
var seq26354__$1 = cljs.core.next(seq26354);
var G__26356 = cljs.core.first(seq26354__$1);
var seq26354__$2 = cljs.core.next(seq26354__$1);
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__26355,G__26356,seq26354__$2);
});

taoensso.encore.nnil_EQ_.cljs$lang$maxFixedArity = (2);

taoensso.encore.vec_STAR_ = (function taoensso$encore$vec_STAR_(x){
if(cljs.core.vector_QMARK_(x)){
return x;
} else {
return cljs.core.vec(x);
}
});
taoensso.encore.set_STAR_ = (function taoensso$encore$set_STAR_(x){
if(cljs.core.set_QMARK_(x)){
return x;
} else {
return cljs.core.set(x);
}
});
taoensso.encore.ks_EQ_ = (function taoensso$encore$ks_EQ_(ks,m){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_LT__EQ_ = (function taoensso$encore$ks_LT__EQ_(ks,m){
return clojure.set.subset_QMARK_(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_GT__EQ_ = (function taoensso$encore$ks_GT__EQ_(ks,m){
return clojure.set.superset_QMARK_(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_nnil_QMARK_ = (function taoensso$encore$ks_nnil_QMARK_(ks,m){
return cljs.core.every_QMARK_((function (p1__26363_SHARP_){
return taoensso.encore.nnil_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,p1__26363_SHARP_));
}),ks);
});
taoensso.encore.assertion_error = (function taoensso$encore$assertion_error(msg){
return (new Error(msg));
});
/**
 * Implementation detail.
 */
taoensso.encore.hthrow = (function taoensso$encore$hthrow(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26374 = arguments.length;
var i__8403__auto___26375 = (0);
while(true){
if((i__8403__auto___26375 < len__8402__auto___26374)){
args__8409__auto__.push((arguments[i__8403__auto___26375]));

var G__26376 = (i__8403__auto___26375 + (1));
i__8403__auto___26375 = G__26376;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((5) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((5)),(0),null)):null);
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__8410__auto__);
});

taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic = (function (hard_QMARK_,ns_str,_QMARK_line,form,val,p__26370){
var vec__26371 = p__26370;
var _QMARK_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26371,(0),null);
var pattern = "Condition failed in `%s:%s` [pred-form, val]: [%s, %s]";
var line_str = (function (){var or__7289__auto__ = _QMARK_line;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return "?";
}
})();
var form_str = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__7289__auto__ = form;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return "<nil>";
}
})())].join('');
var val_str = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__7289__auto__ = val;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return "<nil>";
}
})())].join('');
var _QMARK_err_str = (function (){var temp__4657__auto__ = _QMARK_err;
if(cljs.core.truth_(temp__4657__auto__)){
var e = temp__4657__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_err)].join('');
} else {
return null;
}
})();
var msg = (function (){var m = (taoensso.encore.format.cljs$core$IFn$_invoke$arity$5 ? taoensso.encore.format.cljs$core$IFn$_invoke$arity$5(pattern,ns_str,line_str,form_str,val_str) : taoensso.encore.format.call(null,pattern,ns_str,line_str,form_str,val_str));
if(cljs.core.not(_QMARK_err_str)){
return m;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(m),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\nPredicate error: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_err_str)].join('');
}
})();
throw ((cljs.core.not(hard_QMARK_))?taoensso.encore.assertion_error(msg):cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$ns,ns_str,cljs.core.cst$kw$_QMARK_line,_QMARK_line,cljs.core.cst$kw$form,form,cljs.core.cst$kw$val,val,cljs.core.cst$kw$_QMARK_err,_QMARK_err], null)));
});

taoensso.encore.hthrow.cljs$lang$maxFixedArity = (5);

taoensso.encore.hthrow.cljs$lang$applyTo = (function (seq26364){
var G__26365 = cljs.core.first(seq26364);
var seq26364__$1 = cljs.core.next(seq26364);
var G__26366 = cljs.core.first(seq26364__$1);
var seq26364__$2 = cljs.core.next(seq26364__$1);
var G__26367 = cljs.core.first(seq26364__$2);
var seq26364__$3 = cljs.core.next(seq26364__$2);
var G__26368 = cljs.core.first(seq26364__$3);
var seq26364__$4 = cljs.core.next(seq26364__$3);
var G__26369 = cljs.core.first(seq26364__$4);
var seq26364__$5 = cljs.core.next(seq26364__$4);
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic(G__26365,G__26366,G__26367,G__26368,G__26369,seq26364__$5);
});

taoensso.encore.non_throwing = (function taoensso$encore$non_throwing(pred){
return (function (x){
var vec__26381 = (function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(x) : pred.call(null,x))], null);
}catch (e26384){if((e26384 instanceof Error)){
var e__25508__auto__ = e26384;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__25508__auto__], null);
} else {
throw e26384;

}
}})();
var _QMARK_r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26381,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26381,(1),null);
return _QMARK_r;
});
});
/**
 * Implementation detail.
 */
taoensso.encore.hpred = (function taoensso$encore$hpred(pred_form){
if(!(cljs.core.vector_QMARK_(pred_form))){
return pred_form;
} else {
var vec__26392 = pred_form;
var seq__26393 = cljs.core.seq(vec__26392);
var first__26394 = cljs.core.first(seq__26393);
var seq__26393__$1 = cljs.core.next(seq__26393);
var type = first__26394;
var first__26394__$1 = cljs.core.first(seq__26393__$1);
var seq__26393__$2 = cljs.core.next(seq__26393__$1);
var p1 = first__26394__$1;
var first__26394__$2 = cljs.core.first(seq__26393__$2);
var seq__26393__$3 = cljs.core.next(seq__26393__$2);
var p2 = first__26394__$2;
var more = seq__26393__$3;
var G__26395 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__26395) {
case "el":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x);
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "not=":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(p1,x);
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "ks-nnil?":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return taoensso.encore.ks_nnil_QMARK_(p1,x);
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "ks<=":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return taoensso.encore.ks_LT__EQ_(p1,x);
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "or":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
var or__7289__auto__ = (cljs.core.truth_(p1)?taoensso.encore.non_throwing((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1) : taoensso.encore.hpred.call(null,p1))).call(null,x):null);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = (cljs.core.truth_(p2)?taoensso.encore.non_throwing((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p2) : taoensso.encore.hpred.call(null,p2))).call(null,x):null);
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
return cljs.core.some(((function (or__7289__auto____$1,or__7289__auto__,G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (p1__26386_SHARP_){
return taoensso.encore.non_throwing((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1__26386_SHARP_) : taoensso.encore.hpred.call(null,p1__26386_SHARP_))).call(null,x);
});})(or__7289__auto____$1,or__7289__auto__,G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))
,more);
}
}
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "not":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
var and__7277__auto__ = ((cljs.core.not(p1))?true:cljs.core.not((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1) : taoensso.encore.hpred.call(null,p1)).call(null,x)));
if(and__7277__auto__){
var and__7277__auto____$1 = ((cljs.core.not(p2))?true:cljs.core.not((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p2) : taoensso.encore.hpred.call(null,p2)).call(null,x)));
if(and__7277__auto____$1){
return cljs.core.every_QMARK_(((function (and__7277__auto____$1,and__7277__auto__,G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (p1__26385_SHARP_){
return cljs.core.not((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1__26385_SHARP_) : taoensso.encore.hpred.call(null,p1__26385_SHARP_)).call(null,x));
});})(and__7277__auto____$1,and__7277__auto__,G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))
,more);
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "ks=":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return taoensso.encore.ks_EQ_(p1,x);
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "and":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
var and__7277__auto__ = ((cljs.core.not(p1))?true:(taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1) : taoensso.encore.hpred.call(null,p1)).call(null,x));
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = ((cljs.core.not(p2))?true:(taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p2) : taoensso.encore.hpred.call(null,p2)).call(null,x));
if(cljs.core.truth_(and__7277__auto____$1)){
return cljs.core.every_QMARK_(((function (and__7277__auto____$1,and__7277__auto__,G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (p1__26387_SHARP_){
return (taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1__26387_SHARP_) : taoensso.encore.hpred.call(null,p1__26387_SHARP_)).call(null,x);
});})(and__7277__auto____$1,and__7277__auto__,G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))
,more);
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "ks>=":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return taoensso.encore.ks_GT__EQ_(p1,x);
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "not-in":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return !(cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x));
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "not-el":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return !(cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x));
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "=":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1,x);
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "set<=":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return clojure.set.subset_QMARK_(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "set>=":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return clojure.set.superset_QMARK_(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "set=":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
case "in":
return ((function (G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more){
return (function (x){
return cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x);
});
;})(G__26395,vec__26392,seq__26393,first__26394,seq__26393__$1,type,first__26394__$1,seq__26393__$2,p1,first__26394__$2,seq__26393__$3,p2,more))

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}
}
});
/**
 * Implementation detail.
 */
taoensso.encore.hcond = (function taoensso$encore$hcond(hard_QMARK_,ns_str,line,x_,x_form,pred,pred_form){
var vec__26405 = (function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x_) : cljs.core.deref.call(null,x_))], null);
}catch (e26411){if((e26411 instanceof Error)){
var e__25508__auto__ = e26411;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__25508__auto__], null);
} else {
throw e26411;

}
}})();
var _QMARK_x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26405,(0),null);
var _QMARK_x_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26405,(1),null);
var have_x_QMARK_ = (_QMARK_x_err == null);
var vec__26408 = ((have_x_QMARK_)?(function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.hpred(pred).call(null,_QMARK_x)], null);
}catch (e26412){if((e26412 instanceof Error)){
var e__25508__auto__ = e26412;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__25508__auto__], null);
} else {
throw e26412;

}
}})():null);
var pass_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26408,(0),null);
var _QMARK_pred_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26408,(1),null);
if(cljs.core.truth_(pass_QMARK_)){
return _QMARK_x;
} else {
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic(hard_QMARK_,ns_str,line,(function (){var x__8131__auto__ = pred_form;
return cljs.core._conj((function (){var x__8131__auto____$1 = x_form;
return cljs.core._conj(cljs.core.List.EMPTY,x__8131__auto____$1);
})(),x__8131__auto__);
})(),((have_x_QMARK_)?_QMARK_x:_QMARK_x_err),cljs.core.array_seq([_QMARK_pred_err], 0));
}
});
/**
 * Like `name` but fully qualified: includes namespace in string when present.
 */
taoensso.encore.fq_name = (function taoensso$encore$fq_name(x){
if(typeof x === 'string'){
return x;
} else {
var n = cljs.core.name(x);
var temp__4655__auto__ = cljs.core.namespace(x);
if(cljs.core.truth_(temp__4655__auto__)){
var ns = temp__4655__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('');
} else {
return n;
}
}
});
taoensso.encore.explode_keyword = (function taoensso$encore$explode_keyword(k){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(taoensso.encore.fq_name(k),/[\.\/]/);
});
taoensso.encore.merge_keywords = (function taoensso$encore$merge_keywords(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26419 = arguments.length;
var i__8403__auto___26420 = (0);
while(true){
if((i__8403__auto___26420 < len__8402__auto___26419)){
args__8409__auto__.push((arguments[i__8403__auto___26420]));

var G__26421 = (i__8403__auto___26420 + (1));
i__8403__auto___26420 = G__26421;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic = (function (ks,p__26415){
var vec__26416 = p__26415;
var no_slash_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26416,(0),null);
var parts = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.PersistentVector.EMPTY,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.explode_keyword,cljs.core.filterv(cljs.core.identity,ks)));
if(cljs.core.empty_QMARK_(parts)){
return null;
} else {
if(cljs.core.truth_(no_slash_QMARK_)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",parts));
} else {
var ppop = cljs.core.pop(parts);
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(((cljs.core.empty_QMARK_(ppop))?null:clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ppop)),cljs.core.peek(parts));
}
}
});

taoensso.encore.merge_keywords.cljs$lang$maxFixedArity = (1);

taoensso.encore.merge_keywords.cljs$lang$applyTo = (function (seq26413){
var G__26414 = cljs.core.first(seq26413);
var seq26413__$1 = cljs.core.next(seq26413);
return taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic(G__26414,seq26413__$1);
});

taoensso.encore.clamp = (function taoensso$encore$clamp(nmin,nmax,n){
if((n < nmin)){
return nmin;
} else {
if((n > nmax)){
return nmax;
} else {
return n;
}
}
});
taoensso.encore.pow = (function taoensso$encore$pow(n,exp){
return Math.pow(n,exp);
});
taoensso.encore.abs = (function taoensso$encore$abs(n){
if((n < (0))){
return (- n);
} else {
return n;
}
});
taoensso.encore.round = (function taoensso$encore$round(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26429 = arguments.length;
var i__8403__auto___26430 = (0);
while(true){
if((i__8403__auto___26430 < len__8402__auto___26429)){
args__8409__auto__.push((arguments[i__8403__auto___26430]));

var G__26431 = (i__8403__auto___26430 + (1));
i__8403__auto___26430 = G__26431;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__26424){
var vec__26425 = p__26424;
var type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26425,(0),null);
var nplaces = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26425,(1),null);
var n__$1 = n;
var modifier = (cljs.core.truth_(nplaces)?Math.pow(10.0,nplaces):null);
var n_STAR_ = ((cljs.core.not(modifier))?n__$1:(n__$1 * modifier));
var rounded = (function (){var G__26428 = ((((function (){var or__7289__auto__ = type;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.cst$kw$round;
}
})() instanceof cljs.core.Keyword))?(function (){var or__7289__auto__ = type;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.cst$kw$round;
}
})().fqn:null);
switch (G__26428) {
case "round":
return Math.round(n_STAR_);

break;
case "floor":
return Math.floor(n_STAR_);

break;
case "ceil":
return Math.ceil(n_STAR_);

break;
case "trunc":
return cljs.core.long$(n_STAR_);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unknown round type",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,type], null));

}
})();
if(cljs.core.not(modifier)){
return cljs.core.long$(rounded);
} else {
return (rounded / modifier);
}
});

taoensso.encore.round.cljs$lang$maxFixedArity = (1);

taoensso.encore.round.cljs$lang$applyTo = (function (seq26422){
var G__26423 = cljs.core.first(seq26422);
var seq26422__$1 = cljs.core.next(seq26422);
return taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic(G__26423,seq26422__$1);
});

taoensso.encore.round_STAR_ = taoensso.encore.round;
/**
 * Optimized common case.
 */
taoensso.encore.round1 = (function taoensso$encore$round1(n){
return ((function (){var G__26434 = (n * 10.0);
return Math.round(G__26434);
})() / 10.0);
});
/**
 * Optimized common case.
 */
taoensso.encore.round2 = (function taoensso$encore$round2(n){
return ((function (){var G__26436 = (n * 100.0);
return Math.round(G__26436);
})() / 100.0);
});
/**
 * Returns binary exponential backoff value.
 */
taoensso.encore.exp_backoff = (function taoensso$encore$exp_backoff(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26447 = arguments.length;
var i__8403__auto___26448 = (0);
while(true){
if((i__8403__auto___26448 < len__8402__auto___26447)){
args__8409__auto__.push((arguments[i__8403__auto___26448]));

var G__26449 = (i__8403__auto___26448 + (1));
i__8403__auto___26448 = G__26449;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic = (function (nattempt,p__26439){
var vec__26440 = p__26439;
var map__26443 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26440,(0),null);
var map__26443__$1 = ((((!((map__26443 == null)))?((((map__26443.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26443.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26443):map__26443);
var min_SINGLEQUOTE_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26443__$1,cljs.core.cst$kw$min);
var max_SINGLEQUOTE_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26443__$1,cljs.core.cst$kw$max);
var factor = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26443__$1,cljs.core.cst$kw$factor,(1000));
var binary_exp = (function (){var G__26445 = (2);
var G__26446 = (nattempt - (1));
return Math.pow(G__26445,G__26446);
})();
var time = (((binary_exp + cljs.core.rand.cljs$core$IFn$_invoke$arity$1(binary_exp)) * 0.5) * factor);
return cljs.core.long$((function (){var time__$1 = (cljs.core.truth_(min_SINGLEQUOTE_)?(function (){var x__7625__auto__ = min_SINGLEQUOTE_;
var y__7626__auto__ = time;
return ((x__7625__auto__ > y__7626__auto__) ? x__7625__auto__ : y__7626__auto__);
})():time);
var time__$2 = (cljs.core.truth_(max_SINGLEQUOTE_)?(function (){var x__7632__auto__ = max_SINGLEQUOTE_;
var y__7633__auto__ = time__$1;
return ((x__7632__auto__ < y__7633__auto__) ? x__7632__auto__ : y__7633__auto__);
})():time__$1);
return time__$2;
})());
});

taoensso.encore.exp_backoff.cljs$lang$maxFixedArity = (1);

taoensso.encore.exp_backoff.cljs$lang$applyTo = (function (seq26437){
var G__26438 = cljs.core.first(seq26437);
var seq26437__$1 = cljs.core.next(seq26437);
return taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic(G__26438,seq26437__$1);
});

taoensso.encore.now_dt = (function taoensso$encore$now_dt(){
return (new Date());
});
taoensso.encore.now_udt = (function taoensso$encore$now_udt(){
return (new Date()).getTime();
});
/**
 * Useful for testing.
 */
taoensso.encore.now_udt_mock_fn = (function taoensso$encore$now_udt_mock_fn(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26455 = arguments.length;
var i__8403__auto___26456 = (0);
while(true){
if((i__8403__auto___26456 < len__8402__auto___26455)){
args__8409__auto__.push((arguments[i__8403__auto___26456]));

var G__26457 = (i__8403__auto___26456 + (1));
i__8403__auto___26456 = G__26457;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p__26451){
var vec__26452 = p__26451;
var mock_udts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26452,(0),null);
var mock_udts__$1 = (function (){var or__7289__auto__ = mock_udts;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();
}
})();
var idx = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((-1)) : cljs.core.atom.call(null,(-1)));
return ((function (mock_udts__$1,idx,vec__26452,mock_udts){
return (function (){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(mock_udts__$1,cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(idx,cljs.core.inc));
});
;})(mock_udts__$1,idx,vec__26452,mock_udts))
});

taoensso.encore.now_udt_mock_fn.cljs$lang$maxFixedArity = (0);

taoensso.encore.now_udt_mock_fn.cljs$lang$applyTo = (function (seq26450){
return taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26450));
});

taoensso.encore.secs__GT_ms = (function taoensso$encore$secs__GT_ms(secs){
return cljs.core.long$((secs * 1000.0));
});
taoensso.encore.ms__GT_secs = (function taoensso$encore$ms__GT_secs(ms){
return cljs.core.quot(ms,(1000));
});
/**
 * Returns number of milliseconds in period defined by given args.
 */
taoensso.encore.ms = (function taoensso$encore$ms(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26463 = arguments.length;
var i__8403__auto___26464 = (0);
while(true){
if((i__8403__auto___26464 < len__8402__auto___26463)){
args__8409__auto__.push((arguments[i__8403__auto___26464]));

var G__26465 = (i__8403__auto___26464 + (1));
i__8403__auto___26464 = G__26465;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic = (function (p__26459){
var map__26460 = p__26459;
var map__26460__$1 = ((((!((map__26460 == null)))?((((map__26460.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26460.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26460):map__26460);
var opts = map__26460__$1;
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26460__$1,cljs.core.cst$kw$years);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26460__$1,cljs.core.cst$kw$months);
var weeks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26460__$1,cljs.core.cst$kw$weeks);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26460__$1,cljs.core.cst$kw$days);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26460__$1,cljs.core.cst$kw$hours);
var mins = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26460__$1,cljs.core.cst$kw$mins);
var secs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26460__$1,cljs.core.cst$kw$secs);
var msecs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26460__$1,cljs.core.cst$kw$msecs);
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26460__$1,cljs.core.cst$kw$ms);
if(cljs.core.truth_(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (map__26460,map__26460__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms){
return (function (have_in__26462){
return taoensso.encore.hcond(false,"taoensso.encore",666,(new cljs.core.Delay(((function (map__26460,map__26460__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms){
return (function (){
return have_in__26462;
});})(map__26460,map__26460__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms))
,null)),cljs.core.cst$sym$have_DASH_in__26462,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$kw$msecs,null,cljs.core.cst$kw$secs,null,cljs.core.cst$kw$months,null,cljs.core.cst$kw$days,null,cljs.core.cst$kw$mins,null,cljs.core.cst$kw$hours,null,cljs.core.cst$kw$years,null,cljs.core.cst$kw$ms,null,cljs.core.cst$kw$weeks,null], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$kw$msecs,null,cljs.core.cst$kw$secs,null,cljs.core.cst$kw$months,null,cljs.core.cst$kw$days,null,cljs.core.cst$kw$mins,null,cljs.core.cst$kw$hours,null,cljs.core.cst$kw$years,null,cljs.core.cst$kw$ms,null,cljs.core.cst$kw$weeks,null], null), null));
});})(map__26460,map__26460__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms))
,cljs.core.keys(opts)))){
} else {
throw (new Error("Assert failed: (have #{:msecs :secs :months :days :mins :hours :years :ms :weeks} :in (keys opts))"));
}

return taoensso.encore.round((((((((((cljs.core.truth_(years)?(((((years * (1000)) * (60)) * (60)) * (24)) * (365)):0.0) + (cljs.core.truth_(months)?(((((months * (1000)) * (60)) * (60)) * (24)) * 29.53):0.0)) + (cljs.core.truth_(weeks)?(((((weeks * (1000)) * (60)) * (60)) * (24)) * (7)):0.0)) + (cljs.core.truth_(days)?((((days * (1000)) * (60)) * (60)) * (24)):0.0)) + (cljs.core.truth_(hours)?(((hours * (1000)) * (60)) * (60)):0.0)) + (cljs.core.truth_(mins)?((mins * (1000)) * (60)):0.0)) + (cljs.core.truth_(secs)?(secs * (1000)):0.0)) + (cljs.core.truth_(msecs)?msecs:0.0)) + (cljs.core.truth_(ms)?ms:0.0)));
});

taoensso.encore.ms.cljs$lang$maxFixedArity = (0);

taoensso.encore.ms.cljs$lang$applyTo = (function (seq26458){
return taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26458));
});

taoensso.encore.secs = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(taoensso.encore.ms__GT_secs,taoensso.encore.ms);
taoensso.encore.singleton_QMARK_ = (function taoensso$encore$singleton_QMARK_(coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(coll),(1));
} else {
return cljs.core.not(cljs.core.next(coll));
}
});
taoensso.encore.__GT__QMARK_singleton = (function taoensso$encore$__GT__QMARK_singleton(coll){
if(cljs.core.truth_(taoensso.encore.singleton_QMARK_(coll))){
var vec__26473 = coll;
var c1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26473,(0),null);
return c1;
} else {
return null;
}
});
taoensso.encore.__GT_vec = (function taoensso$encore$__GT_vec(x){
if(cljs.core.vector_QMARK_(x)){
return x;
} else {
if(cljs.core.sequential_QMARK_(x)){
return cljs.core.vec(x);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);

}
}
});
taoensso.encore.vsplit_first = (function taoensso$encore$vsplit_first(v){
var vec__26479 = v;
var v1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26479,(0),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v1,(((cljs.core.count(v) > (1)))?cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(v,(1)):null)], null);
});
taoensso.encore.nnil_set = (function taoensso$encore$nnil_set(x){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(taoensso.encore.set_STAR_(x),null);
});
taoensso.encore.conj_some = (function taoensso$encore$conj_some(var_args){
var args26482 = [];
var len__8402__auto___26488 = arguments.length;
var i__8403__auto___26489 = (0);
while(true){
if((i__8403__auto___26489 < len__8402__auto___26488)){
args26482.push((arguments[i__8403__auto___26489]));

var G__26490 = (i__8403__auto___26489 + (1));
i__8403__auto___26489 = G__26490;
continue;
} else {
}
break;
}

var G__26487 = args26482.length;
switch (G__26487) {
case 2:
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args26482.slice((2)),(0),null));
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2 = (function (coll,_QMARK_x){
if(cljs.core.truth_(taoensso.encore.nnil_QMARK_(_QMARK_x))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,_QMARK_x);
} else {
return coll;
}
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic = (function (coll,_QMARK_x,_QMARK_xs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(taoensso.encore.conj_some,taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2(coll,_QMARK_x),_QMARK_xs);
});

taoensso.encore.conj_some.cljs$lang$applyTo = (function (seq26483){
var G__26484 = cljs.core.first(seq26483);
var seq26483__$1 = cljs.core.next(seq26483);
var G__26485 = cljs.core.first(seq26483__$1);
var seq26483__$2 = cljs.core.next(seq26483__$1);
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic(G__26484,G__26485,seq26483__$2);
});

taoensso.encore.conj_some.cljs$lang$maxFixedArity = (2);

/**
 * `run!` from Clojure 1.7+
 */
taoensso.encore.backport_run_BANG_ = (function taoensso$encore$backport_run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__26493_SHARP_,p2__26492_SHARP_){
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(p2__26492_SHARP_) : proc.call(null,p2__26492_SHARP_));
}),null,coll);
});
taoensso.encore.translate_signed_idx = (function taoensso$encore$translate_signed_idx(signed_idx,max_idx){
if((signed_idx >= (0))){
var x__7632__auto__ = signed_idx;
var y__7633__auto__ = max_idx;
return ((x__7632__auto__ < y__7633__auto__) ? x__7632__auto__ : y__7633__auto__);
} else {
var x__7625__auto__ = (0);
var y__7626__auto__ = (signed_idx + max_idx);
return ((x__7625__auto__ > y__7626__auto__) ? x__7625__auto__ : y__7626__auto__);
}
});
/**
 * Returns [<inclusive-start-idx*> <exclusive-end-idx*>] for counted 0-indexed
 *   input (str, vec, etc.) with support for:
 *  * Clamping of indexes beyond limits.
 *  * Max-length -> end-index.
 *  * -ive indexes (as +ive indexes but work from back of input):
 *    (+0) (+1) (+2) (+3) (+4)  ; inclusive +ive indexes
 *      h    e    l    l    o   ; 5 count
 *    (-5) (-4) (-3) (-2) (-1)  ; inclusive -ive indexes
 */
taoensso.encore.sub_indexes = (function taoensso$encore$sub_indexes(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26500 = arguments.length;
var i__8403__auto___26501 = (0);
while(true){
if((i__8403__auto___26501 < len__8402__auto___26500)){
args__8409__auto__.push((arguments[i__8403__auto___26501]));

var G__26502 = (i__8403__auto___26501 + (1));
i__8403__auto___26501 = G__26502;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic = (function (x,start_idx,p__26497){
var map__26498 = p__26497;
var map__26498__$1 = ((((!((map__26498 == null)))?((((map__26498.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26498.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26498):map__26498);
var max_len = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26498__$1,cljs.core.cst$kw$max_DASH_len);
var end_idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26498__$1,cljs.core.cst$kw$end_DASH_idx);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (map__26498,map__26498__$1,max_len,end_idx){
return (function (){
return max_len;
});})(map__26498,map__26498__$1,max_len,end_idx))
,null)),cljs.core.cst$sym$max_DASH_len,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.nneg_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$nneg_DASH_int_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? nneg-int?] max-len)"));
}

var start_idx__$1 = start_idx;
var xlen = cljs.core.count(x);
var start_idx_STAR_ = taoensso.encore.translate_signed_idx(start_idx__$1,xlen);
var end_idx_STAR_ = (cljs.core.truth_(max_len)?(function (){var n1__25685__auto__ = (start_idx_STAR_ + max_len);
var n2__25686__auto__ = xlen;
if((n1__25685__auto__ > n2__25686__auto__)){
return n2__25686__auto__;
} else {
return n1__25685__auto__;
}
})():(cljs.core.truth_(end_idx)?(taoensso.encore.translate_signed_idx(end_idx,xlen) + (1)):xlen
));
if((start_idx_STAR_ > end_idx_STAR_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_idx_STAR_,end_idx_STAR_], null);
}
});

taoensso.encore.sub_indexes.cljs$lang$maxFixedArity = (2);

taoensso.encore.sub_indexes.cljs$lang$applyTo = (function (seq26494){
var G__26495 = cljs.core.first(seq26494);
var seq26494__$1 = cljs.core.next(seq26494);
var G__26496 = cljs.core.first(seq26494__$1);
var seq26494__$2 = cljs.core.next(seq26494__$1);
return taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(G__26495,G__26496,seq26494__$2);
});

/**
 * Like `subvec` but uses `sub-indexes`.
 */
taoensso.encore.subvec_STAR_ = (function taoensso$encore$subvec_STAR_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26513 = arguments.length;
var i__8403__auto___26514 = (0);
while(true){
if((i__8403__auto___26514 < len__8402__auto___26513)){
args__8409__auto__.push((arguments[i__8403__auto___26514]));

var G__26515 = (i__8403__auto___26514 + (1));
i__8403__auto___26514 = G__26515;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (v,start_idx,p__26506){
var vec__26507 = p__26506;
var _QMARK_max_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26507,(0),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__26507,_QMARK_max_len){
return (function (){
return v;
});})(vec__26507,_QMARK_max_len))
,null)),cljs.core.cst$sym$v,cljs.core.vector_QMARK_,cljs.core.cst$sym$vector_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? vector? v)"));
}

var vec__26510 = taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(v,start_idx,cljs.core.array_seq([cljs.core.cst$kw$max_DASH_len,_QMARK_max_len], 0));
var start_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26510,(0),null);
var end_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26510,(1),null);
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start_idx_STAR_,end_idx_STAR_);
});

taoensso.encore.subvec_STAR_.cljs$lang$maxFixedArity = (2);

taoensso.encore.subvec_STAR_.cljs$lang$applyTo = (function (seq26503){
var G__26504 = cljs.core.first(seq26503);
var seq26503__$1 = cljs.core.next(seq26503);
var G__26505 = cljs.core.first(seq26503__$1);
var seq26503__$2 = cljs.core.next(seq26503__$1);
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__26504,G__26505,seq26503__$2);
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.encore.Swapped = (function (new_val,return_val,__meta,__extmap,__hash){
this.new_val = new_val;
this.return_val = return_val;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.encore.Swapped.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7916__auto__,k__7917__auto__){
var self__ = this;
var this__7916__auto____$1 = this;
return this__7916__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7917__auto__,null);
});

taoensso.encore.Swapped.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7918__auto__,k26517,else__7919__auto__){
var self__ = this;
var this__7918__auto____$1 = this;
var G__26519 = (((k26517 instanceof cljs.core.Keyword))?k26517.fqn:null);
switch (G__26519) {
case "new-val":
return self__.new_val;

break;
case "return-val":
return self__.return_val;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26517,else__7919__auto__);

}
});

taoensso.encore.Swapped.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7930__auto__,writer__7931__auto__,opts__7932__auto__){
var self__ = this;
var this__7930__auto____$1 = this;
var pr_pair__7933__auto__ = ((function (this__7930__auto____$1){
return (function (keyval__7934__auto__){
return cljs.core.pr_sequential_writer(writer__7931__auto__,cljs.core.pr_writer,""," ","",opts__7932__auto__,keyval__7934__auto__);
});})(this__7930__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7931__auto__,pr_pair__7933__auto__,"#taoensso.encore.Swapped{",", ","}",opts__7932__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$new_DASH_val,self__.new_val],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$return_DASH_val,self__.return_val],null))], null),self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.encore.Swapped.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26516){
var self__ = this;
var G__26516__$1 = this;
return (new cljs.core.RecordIter((0),G__26516__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_val,cljs.core.cst$kw$return_DASH_val], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

taoensso.encore.Swapped.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7914__auto__){
var self__ = this;
var this__7914__auto____$1 = this;
return self__.__meta;
});

taoensso.encore.Swapped.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7910__auto__){
var self__ = this;
var this__7910__auto____$1 = this;
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.encore.Swapped.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7920__auto__){
var self__ = this;
var this__7920__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7911__auto__){
var self__ = this;
var this__7911__auto____$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_imap(this__7911__auto____$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

taoensso.encore.Swapped.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7912__auto__,other__7913__auto__){
var self__ = this;
var this__7912__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7277__auto__ = other__7913__auto__;
if(cljs.core.truth_(and__7277__auto__)){
return ((this__7912__auto____$1.constructor === other__7913__auto__.constructor)) && (cljs.core.equiv_map(this__7912__auto____$1,other__7913__auto__));
} else {
return and__7277__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.encore.Swapped.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7925__auto__,k__7926__auto__){
var self__ = this;
var this__7925__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$return_DASH_val,null,cljs.core.cst$kw$new_DASH_val,null], null), null),k__7926__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7925__auto____$1),self__.__meta),k__7926__auto__);
} else {
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7926__auto__)),null));
}
});

taoensso.encore.Swapped.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7923__auto__,k__7924__auto__,G__26516){
var self__ = this;
var this__7923__auto____$1 = this;
var pred__26520 = cljs.core.keyword_identical_QMARK_;
var expr__26521 = k__7924__auto__;
if(cljs.core.truth_((function (){var G__26523 = cljs.core.cst$kw$new_DASH_val;
var G__26524 = expr__26521;
return (pred__26520.cljs$core$IFn$_invoke$arity$2 ? pred__26520.cljs$core$IFn$_invoke$arity$2(G__26523,G__26524) : pred__26520.call(null,G__26523,G__26524));
})())){
return (new taoensso.encore.Swapped(G__26516,self__.return_val,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26525 = cljs.core.cst$kw$return_DASH_val;
var G__26526 = expr__26521;
return (pred__26520.cljs$core$IFn$_invoke$arity$2 ? pred__26520.cljs$core$IFn$_invoke$arity$2(G__26525,G__26526) : pred__26520.call(null,G__26525,G__26526));
})())){
return (new taoensso.encore.Swapped(self__.new_val,G__26516,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7924__auto__,G__26516),null));
}
}
});

taoensso.encore.Swapped.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7928__auto__){
var self__ = this;
var this__7928__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$new_DASH_val,self__.new_val],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$return_DASH_val,self__.return_val],null))], null),self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7915__auto__,G__26516){
var self__ = this;
var this__7915__auto____$1 = this;
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,G__26516,self__.__extmap,self__.__hash));
});

taoensso.encore.Swapped.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7921__auto__,entry__7922__auto__){
var self__ = this;
var this__7921__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7922__auto__)){
return this__7921__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7922__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7922__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7921__auto____$1,entry__7922__auto__);
}
});

taoensso.encore.Swapped.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$new_DASH_val,cljs.core.cst$sym$return_DASH_val], null);
});

taoensso.encore.Swapped.cljs$lang$type = true;

taoensso.encore.Swapped.cljs$lang$ctorPrSeq = (function (this__7950__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"taoensso.encore/Swapped");
});

taoensso.encore.Swapped.cljs$lang$ctorPrWriter = (function (this__7950__auto__,writer__7951__auto__){
return cljs.core._write(writer__7951__auto__,"taoensso.encore/Swapped");
});

taoensso.encore.__GT_Swapped = (function taoensso$encore$__GT_Swapped(new_val,return_val){
return (new taoensso.encore.Swapped(new_val,return_val,null,null,null));
});

taoensso.encore.map__GT_Swapped = (function taoensso$encore$map__GT_Swapped(G__26518){
return (new taoensso.encore.Swapped(cljs.core.cst$kw$new_DASH_val.cljs$core$IFn$_invoke$arity$1(G__26518),cljs.core.cst$kw$return_DASH_val.cljs$core$IFn$_invoke$arity$1(G__26518),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26518,cljs.core.cst$kw$new_DASH_val,cljs.core.array_seq([cljs.core.cst$kw$return_DASH_val], 0)),null));
});

taoensso.encore.swapped = (function taoensso$encore$swapped(new_val,return_val){
return (new taoensso.encore.Swapped(new_val,return_val,null,null,null));
});
taoensso.encore.swapped_QMARK_ = (function taoensso$encore$swapped_QMARK_(x){
return (x instanceof taoensso.encore.Swapped);
});
taoensso.encore.swapped_STAR_ = (function taoensso$encore$swapped_STAR_(x){
if(cljs.core.truth_(taoensso.encore.swapped_QMARK_(x))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_val.cljs$core$IFn$_invoke$arity$1(x),cljs.core.cst$kw$return_DASH_val.cljs$core$IFn$_invoke$arity$1(x)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,x], null);
}
});
/**
 * [<new-val> <return-val>]
 */
taoensso.encore.swapped_STAR__in = (function taoensso$encore$swapped_STAR__in(m,ks,f){
if(cljs.core.truth_((function (){var G__26541 = f;
var G__26542 = cljs.core.cst$kw$swap_SLASH_dissoc;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26541,G__26542) : taoensso.encore.kw_identical_QMARK_.call(null,G__26541,G__26542));
})())){
return taoensso.encore.swapped_STAR_((function (){var G__26543 = m;
var G__26544 = cljs.core.butlast(ks);
var G__26545 = cljs.core.last(ks);
return (taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3(G__26543,G__26544,G__26545) : taoensso.encore.dissoc_in.call(null,G__26543,G__26544,G__26545));
})());
} else {
var old_val_in = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(m,ks);
var vec__26546 = taoensso.encore.swapped_STAR_((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(old_val_in) : f.call(null,old_val_in)));
var new_val_in = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26546,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26546,(1),null);
var new_val = (cljs.core.truth_((function (){var G__26549 = new_val_in;
var G__26550 = cljs.core.cst$kw$swap_SLASH_dissoc;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26549,G__26550) : taoensso.encore.kw_identical_QMARK_.call(null,G__26549,G__26550));
})())?(function (){var G__26551 = m;
var G__26552 = cljs.core.butlast(ks);
var G__26553 = cljs.core.last(ks);
return (taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3(G__26551,G__26552,G__26553) : taoensso.encore.dissoc_in.call(null,G__26551,G__26552,G__26553));
})():cljs.core.assoc_in(m,ks,new_val_in));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_val,return_val], null);
}
});
/**
 * Reduces input with
 *   [<type> <ks> <reset-val-or-swap-fn>] or
 *       [<ks> <reset-val-or-swap-fn>] ops.
 */
taoensso.encore.replace_in_STAR_ = (function taoensso$encore$replace_in_STAR_(_QMARK_vf_type,m,ops){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (accum,_QMARK_op){
if(cljs.core.not(_QMARK_op)){
return accum;
} else {
var vec__26558 = ((cljs.core.not(_QMARK_vf_type))?_QMARK_op:cljs.core.cons(_QMARK_vf_type,_QMARK_op));
var vf_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26558,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26558,(1),null);
var valf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26558,(2),null);
var G__26561 = (((vf_type instanceof cljs.core.Keyword))?vf_type.fqn:null);
switch (G__26561) {
case "reset":
if(cljs.core.empty_QMARK_(ks)){
return valf;
} else {
return cljs.core.assoc_in(accum,ks,valf);
}

break;
case "swap":
if(cljs.core.empty_QMARK_(ks)){
return (valf.cljs$core$IFn$_invoke$arity$1 ? valf.cljs$core$IFn$_invoke$arity$1(accum) : valf.call(null,accum));
} else {
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(taoensso.encore.swapped_STAR__in(accum,ks,valf),(0));
}

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(vf_type)].join('')));

}
}
}),m,ops);
});
/**
 * Experimental. For use with `swap!`, etc.
 */
taoensso.encore.replace_in = (function taoensso$encore$replace_in(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26565 = arguments.length;
var i__8403__auto___26566 = (0);
while(true){
if((i__8403__auto___26566 < len__8402__auto___26565)){
args__8409__auto__.push((arguments[i__8403__auto___26566]));

var G__26567 = (i__8403__auto___26566 + (1));
i__8403__auto___26566 = G__26567;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,ops){
return taoensso.encore.replace_in_STAR_(null,m,ops);
});

taoensso.encore.replace_in.cljs$lang$maxFixedArity = (1);

taoensso.encore.replace_in.cljs$lang$applyTo = (function (seq26563){
var G__26564 = cljs.core.first(seq26563);
var seq26563__$1 = cljs.core.next(seq26563);
return taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic(G__26564,seq26563__$1);
});

/**
 * More powerful version of `swap!`:
 *  * Supports optional `update-in` semantics.
 *  * Swap fn can return `(swapped <new-val> <return-val>)` rather than just
 *    <new-val>. This is useful when writing atomic pull fns, etc.
 */
taoensso.encore.swap_in_BANG_ = (function taoensso$encore$swap_in_BANG_(var_args){
var args26568 = [];
var len__8402__auto___26581 = arguments.length;
var i__8403__auto___26582 = (0);
while(true){
if((i__8403__auto___26582 < len__8402__auto___26581)){
args26568.push((arguments[i__8403__auto___26582]));

var G__26583 = (i__8403__auto___26582 + (1));
i__8403__auto___26582 = G__26583;
continue;
} else {
}
break;
}

var G__26574 = args26568.length;
switch (G__26574) {
case 3:
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args26568.slice((3)),(0),null));
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (atom_,ks,f){
if(cljs.core.empty_QMARK_(ks)){
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var vec__26575 = taoensso.encore.swapped_STAR_((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(old_val) : f.call(null,old_val)));
var new_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26575,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26575,(1),null);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return return_val;
}
break;
}
} else {
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var vec__26578 = taoensso.encore.swapped_STAR__in(old_val,ks,f);
var new_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26578,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26578,(1),null);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return return_val;
}
break;
}
}
});

taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (atom_,ks,f,more){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(more);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$more),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count more))"));
}

var pairs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ks,f], null)], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),more));
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var new_val = taoensso.encore.replace_in_STAR_(cljs.core.cst$kw$swap,old_val,pairs);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old_val,cljs.core.cst$kw$new,new_val], null);
}
break;
}
});

taoensso.encore.swap_in_BANG_.cljs$lang$applyTo = (function (seq26569){
var G__26570 = cljs.core.first(seq26569);
var seq26569__$1 = cljs.core.next(seq26569);
var G__26571 = cljs.core.first(seq26569__$1);
var seq26569__$2 = cljs.core.next(seq26569__$1);
var G__26572 = cljs.core.first(seq26569__$2);
var seq26569__$3 = cljs.core.next(seq26569__$2);
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26570,G__26571,G__26572,seq26569__$3);
});

taoensso.encore.swap_in_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Is to `reset!` as `swap-in!` is to `swap!`.
 */
taoensso.encore.reset_in_BANG_ = (function taoensso$encore$reset_in_BANG_(var_args){
var args26585 = [];
var len__8402__auto___26592 = arguments.length;
var i__8403__auto___26593 = (0);
while(true){
if((i__8403__auto___26593 < len__8402__auto___26592)){
args26585.push((arguments[i__8403__auto___26593]));

var G__26594 = (i__8403__auto___26593 + (1));
i__8403__auto___26593 = G__26594;
continue;
} else {
}
break;
}

var G__26591 = args26585.length;
switch (G__26591) {
case 3:
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args26585.slice((3)),(0),null));
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (atom_,ks,new_val){
if(cljs.core.empty_QMARK_(ks)){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(atom_,new_val) : cljs.core.reset_BANG_.call(null,atom_,new_val));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(atom_,(function (old_val){
return cljs.core.assoc_in(old_val,ks,new_val);
}));
}
});

taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (atom_,ks,new_val,more){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(more);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$more),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count more))"));
}

var pairs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ks,new_val], null)], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),more));
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var new_val__$1 = taoensso.encore.replace_in_STAR_(cljs.core.cst$kw$reset,old_val,pairs);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val__$1))){
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old_val,cljs.core.cst$kw$new,new_val__$1], null);
}
break;
}
});

taoensso.encore.reset_in_BANG_.cljs$lang$applyTo = (function (seq26586){
var G__26587 = cljs.core.first(seq26586);
var seq26586__$1 = cljs.core.next(seq26586);
var G__26588 = cljs.core.first(seq26586__$1);
var seq26586__$2 = cljs.core.next(seq26586__$1);
var G__26589 = cljs.core.first(seq26586__$2);
var seq26586__$3 = cljs.core.next(seq26586__$2);
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26587,G__26588,G__26589,seq26586__$3);
});

taoensso.encore.reset_in_BANG_.cljs$lang$maxFixedArity = (3);

taoensso.encore.dissoc_in = (function taoensso$encore$dissoc_in(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26599 = arguments.length;
var i__8403__auto___26600 = (0);
while(true){
if((i__8403__auto___26600 < len__8402__auto___26599)){
args__8409__auto__.push((arguments[i__8403__auto___26600]));

var G__26601 = (i__8403__auto___26600 + (1));
i__8403__auto___26600 = G__26601;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,ks,dissoc_ks){
if(cljs.core.empty_QMARK_(ks)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,m,dissoc_ks);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(cljs.core.update_in,m,ks,cljs.core.dissoc,dissoc_ks);
}
});

taoensso.encore.dissoc_in.cljs$lang$maxFixedArity = (2);

taoensso.encore.dissoc_in.cljs$lang$applyTo = (function (seq26596){
var G__26597 = cljs.core.first(seq26596);
var seq26596__$1 = cljs.core.next(seq26596);
var G__26598 = cljs.core.first(seq26596__$1);
var seq26596__$2 = cljs.core.next(seq26596__$1);
return taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic(G__26597,G__26598,seq26596__$2);
});

taoensso.encore.contains_in_QMARK_ = (function taoensso$encore$contains_in_QMARK_(coll,ks){
return cljs.core.contains_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.butlast(ks)),cljs.core.last(ks));
});
/**
 * Assocs each kv iff its value is not nil.
 */
taoensso.encore.assoc_some = (function taoensso$encore$assoc_some(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26622 = arguments.length;
var i__8403__auto___26623 = (0);
while(true){
if((i__8403__auto___26623 < len__8402__auto___26622)){
args__8409__auto__.push((arguments[i__8403__auto___26623]));

var G__26624 = (i__8403__auto___26623 + (1));
i__8403__auto___26623 = G__26624;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(kvs);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$kvs),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count kvs))"));
}

return cljs.core.into.cljs$core$IFn$_invoke$arity$2((function (){var or__7289__auto__ = m;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__8077__auto__ = (function taoensso$encore$iter__26604(s__26605){
return (new cljs.core.LazySeq(null,(function (){
var s__26605__$1 = s__26605;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__26605__$1);
if(temp__4657__auto__){
var s__26605__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26605__$2)){
var c__8075__auto__ = cljs.core.chunk_first(s__26605__$2);
var size__8076__auto__ = cljs.core.count(c__8075__auto__);
var b__26607 = cljs.core.chunk_buffer(size__8076__auto__);
if((function (){var i__26606 = (0);
while(true){
if((i__26606 < size__8076__auto__)){
var vec__26616 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8075__auto__,i__26606);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26616,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26616,(1),null);
if(!((v == null))){
cljs.core.chunk_append(b__26607,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__26625 = (i__26606 + (1));
i__26606 = G__26625;
continue;
} else {
var G__26626 = (i__26606 + (1));
i__26606 = G__26626;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26607),taoensso$encore$iter__26604(cljs.core.chunk_rest(s__26605__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26607),null);
}
} else {
var vec__26619 = cljs.core.first(s__26605__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26619,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26619,(1),null);
if(!((v == null))){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),taoensso$encore$iter__26604(cljs.core.rest(s__26605__$2)));
} else {
var G__26627 = cljs.core.rest(s__26605__$2);
s__26605__$1 = G__26627;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8077__auto__(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
})());
});

taoensso.encore.assoc_some.cljs$lang$maxFixedArity = (1);

taoensso.encore.assoc_some.cljs$lang$applyTo = (function (seq26602){
var G__26603 = cljs.core.first(seq26602);
var seq26602__$1 = cljs.core.next(seq26602);
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic(G__26603,seq26602__$1);
});

/**
 * Assocs each kv iff its val is truthy.
 */
taoensso.encore.assoc_when = (function taoensso$encore$assoc_when(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26648 = arguments.length;
var i__8403__auto___26649 = (0);
while(true){
if((i__8403__auto___26649 < len__8402__auto___26648)){
args__8409__auto__.push((arguments[i__8403__auto___26649]));

var G__26650 = (i__8403__auto___26649 + (1));
i__8403__auto___26649 = G__26650;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(kvs);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$kvs),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count kvs))"));
}

return cljs.core.into.cljs$core$IFn$_invoke$arity$2((function (){var or__7289__auto__ = m;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__8077__auto__ = (function taoensso$encore$iter__26630(s__26631){
return (new cljs.core.LazySeq(null,(function (){
var s__26631__$1 = s__26631;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__26631__$1);
if(temp__4657__auto__){
var s__26631__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26631__$2)){
var c__8075__auto__ = cljs.core.chunk_first(s__26631__$2);
var size__8076__auto__ = cljs.core.count(c__8075__auto__);
var b__26633 = cljs.core.chunk_buffer(size__8076__auto__);
if((function (){var i__26632 = (0);
while(true){
if((i__26632 < size__8076__auto__)){
var vec__26642 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8075__auto__,i__26632);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26642,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26642,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append(b__26633,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__26651 = (i__26632 + (1));
i__26632 = G__26651;
continue;
} else {
var G__26652 = (i__26632 + (1));
i__26632 = G__26652;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26633),taoensso$encore$iter__26630(cljs.core.chunk_rest(s__26631__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26633),null);
}
} else {
var vec__26645 = cljs.core.first(s__26631__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26645,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26645,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),taoensso$encore$iter__26630(cljs.core.rest(s__26631__$2)));
} else {
var G__26653 = cljs.core.rest(s__26631__$2);
s__26631__$1 = G__26653;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8077__auto__(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
})());
});

taoensso.encore.assoc_when.cljs$lang$maxFixedArity = (1);

taoensso.encore.assoc_when.cljs$lang$applyTo = (function (seq26628){
var G__26629 = cljs.core.first(seq26628);
var seq26628__$1 = cljs.core.next(seq26628);
return taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic(G__26629,seq26628__$1);
});

taoensso.encore.queue_QMARK_ = (function taoensso$encore$queue_QMARK_(x){
return (x instanceof cljs.core.PersistentQueue);
});
/**
 * Returns a PersistentQueue.
 */
taoensso.encore.queue = (function taoensso$encore$queue(var_args){
var args26654 = [];
var len__8402__auto___26657 = arguments.length;
var i__8403__auto___26658 = (0);
while(true){
if((i__8403__auto___26658 < len__8402__auto___26657)){
args26654.push((arguments[i__8403__auto___26658]));

var G__26659 = (i__8403__auto___26658 + (1));
i__8403__auto___26658 = G__26659;
continue;
} else {
}
break;
}

var G__26656 = args26654.length;
switch (G__26656) {
case 0:
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26654.length)].join('')));

}
});

taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentQueue.EMPTY;
});

taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0(),coll);
});

taoensso.encore.queue.cljs$lang$maxFixedArity = 1;

taoensso.encore.queue_STAR_ = (function taoensso$encore$queue_STAR_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26662 = arguments.length;
var i__8403__auto___26663 = (0);
while(true){
if((i__8403__auto___26663 < len__8402__auto___26662)){
args__8409__auto__.push((arguments[i__8403__auto___26663]));

var G__26664 = (i__8403__auto___26663 + (1));
i__8403__auto___26663 = G__26664;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (items){
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1(items);
});

taoensso.encore.queue_STAR_.cljs$lang$maxFixedArity = (0);

taoensso.encore.queue_STAR_.cljs$lang$applyTo = (function (seq26661){
return taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26661));
});

/**
 * (seq     {:a :A}) => ([:a :A])
 * (seq-kvs {:a :A}) => (:a :A)
 */
taoensso.encore.seq_kvs = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce,cljs.core.concat);
/**
 * Like `apply` but assumes last arg is a map whose elements should be applied
 *   to `f` as an unpaired seq:
 *  (mapply (fn [x & {:keys [y z]}] (str x y z)) 1 {:y 2 :z 3})
 *    where fn will receive args as: `(1 :y 2 :z 3)`.
 */
taoensso.encore.mapply = (function taoensso$encore$mapply(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26668 = arguments.length;
var i__8403__auto___26669 = (0);
while(true){
if((i__8403__auto___26669 < len__8402__auto___26668)){
args__8409__auto__.push((arguments[i__8403__auto___26669]));

var G__26670 = (i__8403__auto___26669 + (1));
i__8403__auto___26669 = G__26670;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(args),(function (){var G__26667 = cljs.core.last(args);
return (taoensso.encore.seq_kvs.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.seq_kvs.cljs$core$IFn$_invoke$arity$1(G__26667) : taoensso.encore.seq_kvs.call(null,G__26667));
})()));
});

taoensso.encore.mapply.cljs$lang$maxFixedArity = (1);

taoensso.encore.mapply.cljs$lang$applyTo = (function (seq26665){
var G__26666 = cljs.core.first(seq26665);
var seq26665__$1 = cljs.core.next(seq26665);
return taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic(G__26666,seq26665__$1);
});

/**
 * Workaround for Clojure versions [1.4, 1.5) that blow up on `reduce-kv`s
 *   against a nil coll, Ref. http://dev.clojure.org/jira/browse/CLJ-1098.
 */
taoensso.encore.clj1098 = (function taoensso$encore$clj1098(x){
var or__7289__auto__ = x;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
taoensso.encore.map_kvs = (function taoensso$encore$map_kvs(kf,vf,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var kf__$1 = ((cljs.core.not((function (){var G__26675 = kf;
var G__26676 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26675,G__26676) : taoensso.encore.kw_identical_QMARK_.call(null,G__26675,G__26676));
})()))?kf:(function (k,_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k);
}));
var vf__$1 = ((cljs.core.not((function (){var G__26677 = vf;
var G__26678 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26677,G__26678) : taoensso.encore.kw_identical_QMARK_.call(null,G__26677,G__26678));
})()))?vf:((function (kf__$1){
return (function (_,v){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(v);
});})(kf__$1))
);
return cljs.core.persistent_BANG_(cljs.core.reduce_kv(((function (kf__$1,vf__$1){
return (function (m__$1,k,v){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$1,(cljs.core.truth_(kf__$1)?(kf__$1.cljs$core$IFn$_invoke$arity$2 ? kf__$1.cljs$core$IFn$_invoke$arity$2(k,v) : kf__$1.call(null,k,v)):k),(cljs.core.truth_(vf__$1)?(vf__$1.cljs$core$IFn$_invoke$arity$2 ? vf__$1.cljs$core$IFn$_invoke$arity$2(k,v) : vf__$1.call(null,k,v)):v));
});})(kf__$1,vf__$1))
,cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),m));
}
});
taoensso.encore.map_keys = (function taoensso$encore$map_keys(f,m){
return taoensso.encore.map_kvs((function (k,_){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(k) : f.call(null,k));
}),null,m);
});
taoensso.encore.map_vals = (function taoensso$encore$map_vals(f,m){
return taoensso.encore.map_kvs(null,(function (_,v){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(v) : f.call(null,v));
}),m);
});
taoensso.encore.filter_kvs = (function taoensso$encore$filter_kvs(predk,predv,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((function (){var and__7277__auto__ = (predk.cljs$core$IFn$_invoke$arity$1 ? predk.cljs$core$IFn$_invoke$arity$1(k) : predk.call(null,k));
if(cljs.core.truth_(and__7277__auto__)){
return (predv.cljs$core$IFn$_invoke$arity$1 ? predv.cljs$core$IFn$_invoke$arity$1(v) : predv.call(null,v));
} else {
return and__7277__auto__;
}
})())){
return m__$1;
} else {
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m__$1,k);
}
}),m,m);
}
});
taoensso.encore.filter_keys = (function taoensso$encore$filter_keys(pred,m){
return taoensso.encore.filter_kvs(pred,cljs.core.constantly(true),m);
});
taoensso.encore.filter_vals = (function taoensso$encore$filter_vals(pred,m){
return taoensso.encore.filter_kvs(cljs.core.constantly(true),pred,m);
});
/**
 * Smaller, common-case version of `filter-vals`. Esp useful with `nil?`/`blank?`
 *   pred when constructing maps: {:foo (when _ <...>) :bar (when _ <...>)} in a
 *   way that preservers :or semantics.
 */
taoensso.encore.remove_vals = (function taoensso$encore$remove_vals(pred,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(v) : pred.call(null,v)))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m__$1,k);
} else {
return m__$1;
}
}),m,m);
}
});
taoensso.encore.keywordize_map = (function taoensso$encore$keywordize_map(m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),v);
}),cljs.core.PersistentArrayMap.EMPTY,m);
}
});
/**
 * Cross between `hash-map` & `map-kvs`.
 */
taoensso.encore.as_map = (function taoensso$encore$as_map(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26697 = arguments.length;
var i__8403__auto___26698 = (0);
while(true){
if((i__8403__auto___26698 < len__8402__auto___26697)){
args__8409__auto__.push((arguments[i__8403__auto___26698]));

var G__26699 = (i__8403__auto___26698 + (1));
i__8403__auto___26698 = G__26699;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic = (function (kvs,p__26681){
var vec__26682 = p__26681;
var kf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26682,(0),null);
var vf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26682,(1),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__26682,kf,vf){
return (function (){
return kvs;
});})(vec__26682,kf,vf))
,null)),cljs.core.cst$sym$kvs,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.sequential_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$sequential_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? sequential?] kvs)"));
}

if((function (){
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__26682,kf,vf){
return (function (){
return kf;
});})(vec__26682,kf,vf))
,null)),cljs.core.cst$sym$kf,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.ifn_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$ifn_QMARK_], null)),taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__26682,kf,vf){
return (function (){
return vf;
});})(vec__26682,kf,vf))
,null)),cljs.core.cst$sym$vf,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.ifn_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$ifn_QMARK_], null))], null);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? ifn?] kf vf)"));
}

var _PERCENT_ = ((cljs.core.empty_QMARK_(kvs))?cljs.core.PersistentArrayMap.EMPTY:(function (){var kf__$1 = ((cljs.core.not((function (){var G__26685 = kf;
var G__26686 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26685,G__26686) : taoensso.encore.kw_identical_QMARK_.call(null,G__26685,G__26686));
})()))?kf:((function (vec__26682,kf,vf){
return (function (k,_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k);
});})(vec__26682,kf,vf))
);
var m = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var G__26690 = kvs;
var vec__26691 = G__26690;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26691,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26691,(1),null);
var s = vec__26691;
var m__$1 = m;
var G__26690__$1 = G__26690;
while(true){
var m__$2 = m__$1;
var vec__26694 = G__26690__$1;
var k__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26694,(0),null);
var v__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26694,(1),null);
var s__$1 = vec__26694;
var k__$2 = ((cljs.core.not(kf__$1))?k__$1:(kf__$1.cljs$core$IFn$_invoke$arity$2 ? kf__$1.cljs$core$IFn$_invoke$arity$2(k__$1,v__$1) : kf__$1.call(null,k__$1,v__$1)));
var v__$2 = ((cljs.core.not(vf))?v__$1:(vf.cljs$core$IFn$_invoke$arity$2 ? vf.cljs$core$IFn$_invoke$arity$2(k__$2,v__$1) : vf.call(null,k__$2,v__$1)));
var new_m = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$2,k__$2,v__$2);
var temp__4655__auto__ = cljs.core.nnext(s__$1);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
var G__26700 = new_m;
var G__26701 = n;
m__$1 = G__26700;
G__26690__$1 = G__26701;
continue;
} else {
return cljs.core.persistent_BANG_(new_m);
}
break;
}
})());
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (_PERCENT_,vec__26682,kf,vf){
return (function (){
return _PERCENT_;
});})(_PERCENT_,vec__26682,kf,vf))
,null)),cljs.core.cst$sym$_PERCENT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$map_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? map?] %)"));
}

return _PERCENT_;
});

taoensso.encore.as_map.cljs$lang$maxFixedArity = (1);

taoensso.encore.as_map.cljs$lang$applyTo = (function (seq26679){
var G__26680 = cljs.core.first(seq26679);
var seq26679__$1 = cljs.core.next(seq26679);
return taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic(G__26680,seq26679__$1);
});

/**
 * Faster `zipmap` using transients.
 */
taoensso.encore.fzipmap = (function taoensso$encore$fzipmap(ks,vs){
var m = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks__$1 = cljs.core.seq(ks);
var vs__$1 = cljs.core.seq(vs);
while(true){
if(!((ks__$1) && (vs__$1))){
return cljs.core.persistent_BANG_(m);
} else {
var G__26702 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,cljs.core.first(ks__$1),cljs.core.first(vs__$1));
var G__26703 = cljs.core.next(ks__$1);
var G__26704 = cljs.core.next(vs__$1);
m = G__26702;
ks__$1 = G__26703;
vs__$1 = G__26704;
continue;
}
break;
}
});
/**
 * Like `into` but supports multiple "from"s.
 */
taoensso.encore.into_all = (function taoensso$encore$into_all(var_args){
var args26705 = [];
var len__8402__auto___26711 = arguments.length;
var i__8403__auto___26712 = (0);
while(true){
if((i__8403__auto___26712 < len__8402__auto___26711)){
args26705.push((arguments[i__8403__auto___26712]));

var G__26713 = (i__8403__auto___26712 + (1));
i__8403__auto___26712 = G__26713;
continue;
} else {
}
break;
}

var G__26710 = args26705.length;
switch (G__26710) {
case 2:
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args26705.slice((2)),(0),null));
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(to,from);
});

taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic = (function (to,from,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.into.cljs$core$IFn$_invoke$arity$2(to,from),more);
});

taoensso.encore.into_all.cljs$lang$applyTo = (function (seq26706){
var G__26707 = cljs.core.first(seq26706);
var seq26706__$1 = cljs.core.next(seq26706);
var G__26708 = cljs.core.first(seq26706__$1);
var seq26706__$2 = cljs.core.next(seq26706__$1);
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic(G__26707,G__26708,seq26706__$2);
});

taoensso.encore.into_all.cljs$lang$maxFixedArity = (2);

/**
 * Greedy version of `interleave`, Ref. http://goo.gl/KvzqWb.
 */
taoensso.encore.interleave_all = (function taoensso$encore$interleave_all(var_args){
var args26715 = [];
var len__8402__auto___26721 = arguments.length;
var i__8403__auto___26722 = (0);
while(true){
if((i__8403__auto___26722 < len__8402__auto___26721)){
args26715.push((arguments[i__8403__auto___26722]));

var G__26723 = (i__8403__auto___26722 + (1));
i__8403__auto___26722 = G__26723;
continue;
} else {
}
break;
}

var G__26720 = args26715.length;
switch (G__26720) {
case 0:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args26715.slice((2)),(0),null));
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.List.EMPTY;
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$1 = (function (c1){
return (new cljs.core.LazySeq(null,(function (){
return c1;
}),null,null));
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
if(s1){
return s1;
} else {
if(s2){
return s2;
} else {
return null;
}
}
}
}),null,null));
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0))));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(taoensso.encore.interleave_all,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
}),null,null));
});

taoensso.encore.interleave_all.cljs$lang$applyTo = (function (seq26716){
var G__26717 = cljs.core.first(seq26716);
var seq26716__$1 = cljs.core.next(seq26716);
var G__26718 = cljs.core.first(seq26716__$1);
var seq26716__$2 = cljs.core.next(seq26716__$1);
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic(G__26717,G__26718,seq26716__$2);
});

taoensso.encore.interleave_all.cljs$lang$maxFixedArity = (2);

taoensso.encore.takev = (function taoensso$encore$takev(n,coll){
if(cljs.core.vector_QMARK_(coll)){
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic(coll,(0),cljs.core.array_seq([n], 0));
} else {
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll));
}
});
/**
 * Prefer `set` when order doesn't matter (much faster).
 */
taoensso.encore.distinctv = (function taoensso$encore$distinctv(var_args){
var args26725 = [];
var len__8402__auto___26736 = arguments.length;
var i__8403__auto___26737 = (0);
while(true){
if((i__8403__auto___26737 < len__8402__auto___26736)){
args26725.push((arguments[i__8403__auto___26737]));

var G__26738 = (i__8403__auto___26737 + (1));
i__8403__auto___26737 = G__26738;
continue;
} else {
}
break;
}

var G__26727 = args26725.length;
switch (G__26727) {
case 1:
return taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26725.length)].join('')));

}
});

taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.persistent_BANG_(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__26728,in$){
var vec__26729 = p__26728;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26729,(0),null);
var seen = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26729,(1),null);
if(!(cljs.core.contains_QMARK_(seen,in$))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,in$),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen,in$)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,seen], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$(cljs.core.PersistentVector.EMPTY),cljs.core.PersistentHashSet.EMPTY], null),coll),(0)));
});

taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.persistent_BANG_(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__26732,in$){
var vec__26733 = p__26732;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26733,(0),null);
var seen = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26733,(1),null);
var in_STAR_ = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(in$) : keyfn.call(null,in$));
if(!(cljs.core.contains_QMARK_(seen,in_STAR_))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,in$),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen,in_STAR_)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,seen], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$(cljs.core.PersistentVector.EMPTY),cljs.core.PersistentHashSet.EMPTY], null),coll),(0)));
});

taoensso.encore.distinctv.cljs$lang$maxFixedArity = 2;

/**
 * Like `sort-by` for distinct. Based on clojure.core/distinct.
 */
taoensso.encore.distinct_by = (function taoensso$encore$distinct_by(keyfn,coll){
var step = (function taoensso$encore$distinct_by_$_step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__26756,seen__$1){
while(true){
var vec__26757 = p__26756;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26757,(0),null);
var xs__$1 = vec__26757;
var temp__4657__auto__ = cljs.core.seq(xs__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var v_STAR_ = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(v) : keyfn.call(null,v));
if(cljs.core.contains_QMARK_(seen__$1,v_STAR_)){
var G__26760 = cljs.core.rest(s);
var G__26761 = seen__$1;
p__26756 = G__26760;
seen__$1 = G__26761;
continue;
} else {
return cljs.core.cons(v,taoensso$encore$distinct_by_$_step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,v_STAR_)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});
taoensso.encore.removev = (function taoensso$encore$removev(pred,coll){
return cljs.core.filterv(cljs.core.complement(pred),coll);
});

/**
 * distinctv` transducer.
 */
taoensso.encore.xdistinct = (function taoensso$encore$xdistinct(var_args){
var args26766 = [];
var len__8402__auto___26771 = arguments.length;
var i__8403__auto___26772 = (0);
while(true){
if((i__8403__auto___26772 < len__8402__auto___26771)){
args26766.push((arguments[i__8403__auto___26772]));

var G__26773 = (i__8403__auto___26772 + (1));
i__8403__auto___26772 = G__26773;
continue;
} else {
}
break;
}

var G__26768 = args26766.length;
switch (G__26768) {
case 0:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26766.length)].join('')));

}
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen_ = (function (){var G__26769 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26769) : cljs.core.atom.call(null,G__26769));
})();
return ((function (seen_){
return (function() {
var G__26775 = null;
var G__26775__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__26775__1 = (function (acc){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(acc) : rf.call(null,acc));
});
var G__26775__2 = (function (acc,input){
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen_) : cljs.core.deref.call(null,seen_)),input)){
return acc;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(seen_,cljs.core.conj,input);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(acc,input) : rf.call(null,acc,input));
}
});
G__26775 = function(acc,input){
switch(arguments.length){
case 0:
return G__26775__0.call(this);
case 1:
return G__26775__1.call(this,acc);
case 2:
return G__26775__2.call(this,acc,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__26775.cljs$core$IFn$_invoke$arity$0 = G__26775__0;
G__26775.cljs$core$IFn$_invoke$arity$1 = G__26775__1;
G__26775.cljs$core$IFn$_invoke$arity$2 = G__26775__2;
return G__26775;
})()
;})(seen_))
});
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (function (rf){
var seen_ = (function (){var G__26770 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26770) : cljs.core.atom.call(null,G__26770));
})();
return ((function (seen_){
return (function() {
var G__26776 = null;
var G__26776__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__26776__1 = (function (acc){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(acc) : rf.call(null,acc));
});
var G__26776__2 = (function (acc,input){
var k = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(input) : keyfn.call(null,input));
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen_) : cljs.core.deref.call(null,seen_)),k)){
return acc;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(seen_,cljs.core.conj,k);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(acc,input) : rf.call(null,acc,input));
}
});
G__26776 = function(acc,input){
switch(arguments.length){
case 0:
return G__26776__0.call(this);
case 1:
return G__26776__1.call(this,acc);
case 2:
return G__26776__2.call(this,acc,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__26776.cljs$core$IFn$_invoke$arity$0 = G__26776__0;
G__26776.cljs$core$IFn$_invoke$arity$1 = G__26776__1;
G__26776.cljs$core$IFn$_invoke$arity$2 = G__26776__2;
return G__26776;
})()
;})(seen_))
});
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1(keyfn),coll);
});

taoensso.encore.xdistinct.cljs$lang$maxFixedArity = 2;

/**
 * Reverse comparator.
 */
taoensso.encore.rcompare = (function taoensso$encore$rcompare(x,y){
return cljs.core.compare(y,x);
});
taoensso.encore.nested_merge_with = (function taoensso$encore$nested_merge_with(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26779 = arguments.length;
var i__8403__auto___26780 = (0);
while(true){
if((i__8403__auto___26780 < len__8402__auto___26779)){
args__8409__auto__.push((arguments[i__8403__auto___26780]));

var G__26781 = (i__8403__auto___26780 + (1));
i__8403__auto___26780 = G__26781;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.key(e);
var rv = cljs.core.val(e);
if(!(cljs.core.contains_QMARK_(m,k))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,rv);
} else {
var lv = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if((cljs.core.map_QMARK_(lv)) && (cljs.core.map_QMARK_(rv))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.array_seq([lv,rv], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(lv,rv) : f.call(null,lv,rv)));
}
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__7289__auto__ = m1;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

taoensso.encore.nested_merge_with.cljs$lang$maxFixedArity = (1);

taoensso.encore.nested_merge_with.cljs$lang$applyTo = (function (seq26777){
var G__26778 = cljs.core.first(seq26777);
var seq26777__$1 = cljs.core.next(seq26777);
return taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic(G__26778,seq26777__$1);
});

taoensso.encore.nested_merge = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nested_merge_with,(function (x,y){
if((cljs.core.map_QMARK_(x)) && ((y == null))){
return x;
} else {
return y;
}
}));
/**
 * Returns the 'greatest' element in coll in O(n) time.
 */
taoensso.encore.greatest = (function taoensso$encore$greatest(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26790 = arguments.length;
var i__8403__auto___26791 = (0);
while(true){
if((i__8403__auto___26791 < len__8402__auto___26790)){
args__8409__auto__.push((arguments[i__8403__auto___26791]));

var G__26792 = (i__8403__auto___26791 + (1));
i__8403__auto___26791 = G__26792;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic = (function (coll,p__26786){
var vec__26787 = p__26786;
var _QMARK_comparator = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26787,(0),null);
var comparator = (function (){var or__7289__auto__ = _QMARK_comparator;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return taoensso.encore.rcompare;
}
})();
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(((function (comparator,vec__26787,_QMARK_comparator){
return (function (p1__26782_SHARP_,p2__26783_SHARP_){
if(((comparator.cljs$core$IFn$_invoke$arity$2 ? comparator.cljs$core$IFn$_invoke$arity$2(p1__26782_SHARP_,p2__26783_SHARP_) : comparator.call(null,p1__26782_SHARP_,p2__26783_SHARP_)) > (0))){
return p2__26783_SHARP_;
} else {
return p1__26782_SHARP_;
}
});})(comparator,vec__26787,_QMARK_comparator))
,coll);
});

taoensso.encore.greatest.cljs$lang$maxFixedArity = (1);

taoensso.encore.greatest.cljs$lang$applyTo = (function (seq26784){
var G__26785 = cljs.core.first(seq26784);
var seq26784__$1 = cljs.core.next(seq26784);
return taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic(G__26785,seq26784__$1);
});

/**
 * Returns the 'least' element in coll in O(n) time.
 */
taoensso.encore.least = (function taoensso$encore$least(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26801 = arguments.length;
var i__8403__auto___26802 = (0);
while(true){
if((i__8403__auto___26802 < len__8402__auto___26801)){
args__8409__auto__.push((arguments[i__8403__auto___26802]));

var G__26803 = (i__8403__auto___26802 + (1));
i__8403__auto___26802 = G__26803;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic = (function (coll,p__26797){
var vec__26798 = p__26797;
var _QMARK_comparator = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26798,(0),null);
var comparator = (function (){var or__7289__auto__ = _QMARK_comparator;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return taoensso.encore.rcompare;
}
})();
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(((function (comparator,vec__26798,_QMARK_comparator){
return (function (p1__26793_SHARP_,p2__26794_SHARP_){
if(((comparator.cljs$core$IFn$_invoke$arity$2 ? comparator.cljs$core$IFn$_invoke$arity$2(p1__26793_SHARP_,p2__26794_SHARP_) : comparator.call(null,p1__26793_SHARP_,p2__26794_SHARP_)) < (0))){
return p2__26794_SHARP_;
} else {
return p1__26793_SHARP_;
}
});})(comparator,vec__26798,_QMARK_comparator))
,coll);
});

taoensso.encore.least.cljs$lang$maxFixedArity = (1);

taoensso.encore.least.cljs$lang$applyTo = (function (seq26795){
var G__26796 = cljs.core.first(seq26795);
var seq26795__$1 = cljs.core.next(seq26795);
return taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic(G__26796,seq26795__$1);
});

/**
 * Like `repeatedly` but faster and `conj`s items into given collection.
 */
taoensso.encore.repeatedly_into = (function taoensso$encore$repeatedly_into(coll,n,f){
if((coll instanceof clojure.lang.IEditableCollection)){
var v = cljs.core.transient$(coll);
var idx = (0);
while(true){
if((idx >= n)){
return cljs.core.persistent_BANG_(v);
} else {
var G__26804 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
var G__26805 = (idx + (1));
v = G__26804;
idx = G__26805;
continue;
}
break;
}
} else {
var v = coll;
var idx = (0);
while(true){
if((idx >= n)){
return v;
} else {
var G__26806 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
var G__26807 = (idx + (1));
v = G__26806;
idx = G__26807;
continue;
}
break;
}
}
});
taoensso.encore.undefined__GT_nil = (function taoensso$encore$undefined__GT_nil(x){
if((void 0 === x)){
return null;
} else {
return x;
}
});
taoensso.encore.nil__GT_str = (function taoensso$encore$nil__GT_str(x){
if(((void 0 === x)) || ((x == null))){
return "nil";
} else {
return x;
}
});
taoensso.encore.spaced_str_with_nils = (function taoensso$encore$spaced_str_with_nils(xs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nil__GT_str,xs));
});
taoensso.encore.spaced_str = (function taoensso$encore$spaced_str(xs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.undefined__GT_nil,xs));
});
taoensso.encore.format_STAR_ = (function taoensso$encore$format_STAR_(fmt,args){
var fmt__$1 = (function (){var or__7289__auto__ = fmt;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return "";
}
})();
var args__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nil__GT_str,args);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt__$1,args__$1);
});
/**
 * Like `clojure.core/format` but:
 *  * Returns "" when fmt is nil rather than throwing an NPE.
 *  * Formats nil as "nil" rather than "null".
 *  * Provides ClojureScript support via goog.string.format (this has fewer
 *    formatting options than Clojure's `format`!).
 */
taoensso.encore.format = (function taoensso$encore$format(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26810 = arguments.length;
var i__8403__auto___26811 = (0);
while(true){
if((i__8403__auto___26811 < len__8402__auto___26810)){
args__8409__auto__.push((arguments[i__8403__auto___26811]));

var G__26812 = (i__8403__auto___26811 + (1));
i__8403__auto___26811 = G__26812;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return taoensso.encore.format_STAR_(fmt,args);
});

taoensso.encore.format.cljs$lang$maxFixedArity = (1);

taoensso.encore.format.cljs$lang$applyTo = (function (seq26808){
var G__26809 = cljs.core.first(seq26808);
var seq26808__$1 = cljs.core.next(seq26808);
return taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic(G__26809,seq26808__$1);
});

/**
 * Gives a consistent, flexible, cross-platform substring API built on
 *   `sub-indexes`.
 */
taoensso.encore.substr = (function taoensso$encore$substr(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26823 = arguments.length;
var i__8403__auto___26824 = (0);
while(true){
if((i__8403__auto___26824 < len__8402__auto___26823)){
args__8409__auto__.push((arguments[i__8403__auto___26824]));

var G__26825 = (i__8403__auto___26824 + (1));
i__8403__auto___26824 = G__26825;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic = (function (s,start_idx,p__26816){
var vec__26817 = p__26816;
var _QMARK_max_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26817,(0),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__26817,_QMARK_max_len){
return (function (){
return s;
});})(vec__26817,_QMARK_max_len))
,null)),cljs.core.cst$sym$s,cljs.core.string_QMARK_,cljs.core.cst$sym$string_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? string? s)"));
}

var vec__26820 = taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(s,start_idx,cljs.core.array_seq([cljs.core.cst$kw$max_DASH_len,_QMARK_max_len], 0));
var start_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26820,(0),null);
var end_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26820,(1),null);
return s.substring(start_idx_STAR_,end_idx_STAR_);
});

taoensso.encore.substr.cljs$lang$maxFixedArity = (2);

taoensso.encore.substr.cljs$lang$applyTo = (function (seq26813){
var G__26814 = cljs.core.first(seq26813);
var seq26813__$1 = cljs.core.next(seq26813);
var G__26815 = cljs.core.first(seq26813__$1);
var seq26813__$2 = cljs.core.next(seq26813__$1);
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(G__26814,G__26815,seq26813__$2);
});

taoensso.encore.str_contains_QMARK_ = (function taoensso$encore$str_contains_QMARK_(s,substr){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((-1),s.indexOf(substr));
});
taoensso.encore.str_starts_with_QMARK_ = (function taoensso$encore$str_starts_with_QMARK_(s,substr){
return (s.indexOf(substr) === (0));
});
taoensso.encore.str_ends_with_QMARK_ = (function taoensso$encore$str_ends_with_QMARK_(s,substr){
var s_len = s.length;
var substr_len = substr.length;
if((s_len >= substr_len)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((-1),s.indexOf(substr,(s_len - substr_len)));
} else {
return null;
}
});
taoensso.encore.str__QMARK_index = (function taoensso$encore$str__QMARK_index(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26833 = arguments.length;
var i__8403__auto___26834 = (0);
while(true){
if((i__8403__auto___26834 < len__8402__auto___26833)){
args__8409__auto__.push((arguments[i__8403__auto___26834]));

var G__26835 = (i__8403__auto___26834 + (1));
i__8403__auto___26834 = G__26835;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic = (function (s,substr,p__26829){
var vec__26830 = p__26829;
var start_idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26830,(0),null);
var last_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26830,(1),null);
var start_idx__$1 = ((function (){var or__7289__auto__ = start_idx;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return (0);
}
})() | (0));
var result = ((cljs.core.truth_(last_QMARK_)?s.lastIndexOf(substr,start_idx__$1):s.indexOf(substr,start_idx__$1)) | (0));
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(result,(-1))){
return result;
} else {
return null;
}
});

taoensso.encore.str__QMARK_index.cljs$lang$maxFixedArity = (2);

taoensso.encore.str__QMARK_index.cljs$lang$applyTo = (function (seq26826){
var G__26827 = cljs.core.first(seq26826);
var seq26826__$1 = cljs.core.next(seq26826);
var G__26828 = cljs.core.first(seq26826__$1);
var seq26826__$2 = cljs.core.next(seq26826__$1);
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic(G__26827,G__26828,seq26826__$2);
});

/**
 * Like `clojure.string/join` but ensures no double separators.
 */
taoensso.encore.join_once = (function taoensso$encore$join_once(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26838 = arguments.length;
var i__8403__auto___26839 = (0);
while(true){
if((i__8403__auto___26839 < len__8402__auto___26838)){
args__8409__auto__.push((arguments[i__8403__auto___26839]));

var G__26840 = (i__8403__auto___26839 + (1));
i__8403__auto___26839 = G__26840;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic = (function (separator,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s1,s2){
var s1__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1)].join('');
var s2__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2)].join('');
if(cljs.core.truth_(taoensso.encore.str_ends_with_QMARK_(s1__$1,separator))){
if(cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s2__$1,separator))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1.substring((1)))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
}
} else {
if(cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s2__$1,separator))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s1__$1,"")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s2__$1,""))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(separator),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
}
}
}
}),null,coll);
});

taoensso.encore.join_once.cljs$lang$maxFixedArity = (1);

taoensso.encore.join_once.cljs$lang$applyTo = (function (seq26836){
var G__26837 = cljs.core.first(seq26836);
var seq26836__$1 = cljs.core.next(seq26836);
return taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic(G__26837,seq26836__$1);
});

/**
 * Joins string paths (URLs, file paths, etc.) ensuring correct "/"
 *   interposition.
 */
taoensso.encore.path = (function taoensso$encore$path(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26842 = arguments.length;
var i__8403__auto___26843 = (0);
while(true){
if((i__8403__auto___26843 < len__8402__auto___26842)){
args__8409__auto__.push((arguments[i__8403__auto___26843]));

var G__26844 = (i__8403__auto___26843 + (1));
i__8403__auto___26843 = G__26844;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic = (function (parts){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.join_once,"/",parts);
});

taoensso.encore.path.cljs$lang$maxFixedArity = (0);

taoensso.encore.path.cljs$lang$applyTo = (function (seq26841){
return taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26841));
});

/**
 * Converts all word breaks of any form and length (including line breaks of any
 *   form, tabs, spaces, etc.) to a single regular space.
 */
taoensso.encore.norm_word_breaks = (function taoensso$encore$norm_word_breaks(s){
return clojure.string.replace([cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/\s+/," ");
});
taoensso.encore.count_words = (function taoensso$encore$count_words(s){
if(clojure.string.blank_QMARK_(s)){
return (0);
} else {
return cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/\s+/));
}
});
/**
 * Returns a UUIDv4 string of form "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx",
 *   Ref. http://www.ietf.org/rfc/rfc4122.txt,
 *     https://gist.github.com/franks42/4159427
 */
taoensso.encore.uuid_str = (function taoensso$encore$uuid_str(var_args){
var args26845 = [];
var len__8402__auto___26848 = arguments.length;
var i__8403__auto___26849 = (0);
while(true){
if((i__8403__auto___26849 < len__8402__auto___26848)){
args26845.push((arguments[i__8403__auto___26849]));

var G__26850 = (i__8403__auto___26849 + (1));
i__8403__auto___26849 = G__26850;
continue;
} else {
}
break;
}

var G__26847 = args26845.length;
switch (G__26847) {
case 1:
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26845.length)].join('')));

}
});

taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1 = (function (max_length){
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0(),(0),cljs.core.array_seq([max_length], 0));
});

taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0 = (function (){
var hex = (function (){
return cljs.core.rand_int((15)).toString((16));
});
var rhex = ((8) | ((3) & cljs.core.rand_int((14)))).toString((16));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("4"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rhex),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex())].join('');
});

taoensso.encore.uuid_str.cljs$lang$maxFixedArity = 1;

taoensso.encore.gc_rate = (1.0 / (16000));
taoensso.encore.gc_now_QMARK_ = (function taoensso$encore$gc_now_QMARK_(){
return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0() <= taoensso.encore.gc_rate);
});
/**
 * Swaps associative value at key and returns the new value.
 *   Specialized, fast `swap-in!` for use mostly by memoization utils.
 */
taoensso.encore.swap_val_BANG_ = (function taoensso$encore$swap_val_BANG_(atom_,k,f){
while(true){
var old_m = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var new_v = (function (){var G__26853 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(old_m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__26853) : f.call(null,G__26853));
})();
var new_m = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(old_m,k,new_v);
if(cljs.core.truth_(cljs.core.compare_and_set_BANG_(atom_,old_m,new_m))){
return new_v;
} else {
continue;
}
break;
}
});
/**
 * As `clojure.core/memoize` but uses delays to avoid write races.
 */
taoensso.encore.memoize_ = (function taoensso$encore$memoize_(f){
var cache_ = (function (){var G__26856 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26856) : cljs.core.atom.call(null,G__26856));
})();
return ((function (cache_){
return (function() { 
var G__26858__delegate = function (args){
var G__26857 = (function (){var or__7289__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cache_) : cljs.core.deref.call(null,cache_)),args);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return taoensso.encore.swap_val_BANG_(cache_,args,((function (or__7289__auto__,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_(_QMARK_dv)){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__7289__auto__,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
});})(or__7289__auto__,cache_))
,null));
}
});})(or__7289__auto__,cache_))
);
}
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__26857) : cljs.core.deref.call(null,G__26857));
};
var G__26858 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__26859__i = 0, G__26859__a = new Array(arguments.length -  0);
while (G__26859__i < G__26859__a.length) {G__26859__a[G__26859__i] = arguments[G__26859__i + 0]; ++G__26859__i;}
  args = new cljs.core.IndexedSeq(G__26859__a,0);
} 
return G__26858__delegate.call(this,args);};
G__26858.cljs$lang$maxFixedArity = 0;
G__26858.cljs$lang$applyTo = (function (arglist__26860){
var args = cljs.core.seq(arglist__26860);
return G__26858__delegate(args);
});
G__26858.cljs$core$IFn$_invoke$arity$variadic = G__26858__delegate;
return G__26858;
})()
;
;})(cache_))
});
/**
 * Great for Reactjs render op caching on mobile devices, etc.
 */
taoensso.encore.memoize1 = (function taoensso$encore$memoize1(f){
var cache_ = (function (){var G__26863 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26863) : cljs.core.atom.call(null,G__26863));
})();
return ((function (cache_){
return (function() { 
var G__26865__delegate = function (args){
var G__26864 = (function (){var or__7289__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cache_) : cljs.core.deref.call(null,cache_)),args);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cache_,((function (or__7289__auto__,cache_){
return (function (cache){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cache,args))){
return cache;
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([args,(new cljs.core.Delay(((function (or__7289__auto__,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
});})(or__7289__auto__,cache_))
,null))]);
}
});})(or__7289__auto__,cache_))
),args);
}
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__26864) : cljs.core.deref.call(null,G__26864));
};
var G__26865 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__26866__i = 0, G__26866__a = new Array(arguments.length -  0);
while (G__26866__i < G__26866__a.length) {G__26866__a[G__26866__i] = arguments[G__26866__i + 0]; ++G__26866__i;}
  args = new cljs.core.IndexedSeq(G__26866__a,0);
} 
return G__26865__delegate.call(this,args);};
G__26865.cljs$lang$maxFixedArity = 0;
G__26865.cljs$lang$applyTo = (function (arglist__26867){
var args = cljs.core.seq(arglist__26867);
return G__26865__delegate(args);
});
G__26865.cljs$core$IFn$_invoke$arity$variadic = G__26865__delegate;
return G__26865;
})()
;
;})(cache_))
});
/**
 * Like `(memoize* f)` but takes an explicit cache atom (possibly nil)
 *   and immediately applies memoized f to given arguments.
 */
taoensso.encore.memoized = (function taoensso$encore$memoized(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26873 = arguments.length;
var i__8403__auto___26874 = (0);
while(true){
if((i__8403__auto___26874 < len__8402__auto___26873)){
args__8409__auto__.push((arguments[i__8403__auto___26874]));

var G__26875 = (i__8403__auto___26874 + (1));
i__8403__auto___26874 = G__26875;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic = (function (cache,f,args){
if(cljs.core.not(cache)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
} else {
var G__26872 = taoensso.encore.swap_val_BANG_(cache,args,(function (p1__26868_SHARP_){
if(cljs.core.truth_(p1__26868_SHARP_)){
return p1__26868_SHARP_;
} else {
return (new cljs.core.Delay((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}),null));
}
}));
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__26872) : cljs.core.deref.call(null,G__26872));
}
});

taoensso.encore.memoized.cljs$lang$maxFixedArity = (2);

taoensso.encore.memoized.cljs$lang$applyTo = (function (seq26869){
var G__26870 = cljs.core.first(seq26869);
var seq26869__$1 = cljs.core.next(seq26869);
var G__26871 = cljs.core.first(seq26869__$1);
var seq26869__$2 = cljs.core.next(seq26869__$1);
return taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic(G__26870,G__26871,seq26869__$2);
});

/**
 * Like `clojure.core/memoize` but:
 *  * Uses delays to prevent race conditions on writes.
 *  * Supports auto invalidation & gc with `ttl-ms` option.
 *  * Supports manual invalidation by prepending args with `:mem/del` or `:mem/fresh`.
 *  * Supports cache size limit & gc with `cache-size` option.
 */
taoensso.encore.memoize_STAR_ = (function taoensso$encore$memoize_STAR_(var_args){
var args26878 = [];
var len__8402__auto___26959 = arguments.length;
var i__8403__auto___26960 = (0);
while(true){
if((i__8403__auto___26960 < len__8402__auto___26959)){
args26878.push((arguments[i__8403__auto___26960]));

var G__26961 = (i__8403__auto___26960 + (1));
i__8403__auto___26960 = G__26961;
continue;
} else {
}
break;
}

var G__26880 = args26878.length;
switch (G__26880) {
case 1:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26878.length)].join('')));

}
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
var cache_ = (function (){var G__26881 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26881) : cljs.core.atom.call(null,G__26881));
})();
return ((function (cache_){
return (function() { 
var G__26963__delegate = function (p__26882){
var vec__26883 = p__26882;
var seq__26884 = cljs.core.seq(vec__26883);
var first__26885 = cljs.core.first(seq__26884);
var seq__26884__$1 = cljs.core.next(seq__26884);
var arg1 = first__26885;
var argn = seq__26884__$1;
var args = vec__26883;
if(cljs.core.truth_((function (){var G__26886 = arg1;
var G__26887 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26886,G__26887) : taoensso.encore.kw_identical_QMARK_.call(null,G__26886,G__26887));
})())){
if(cljs.core.truth_((function (){var G__26888 = cljs.core.first(argn);
var G__26889 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26888,G__26889) : taoensso.encore.kw_identical_QMARK_.call(null,G__26888,G__26889));
})())){
var G__26890_26964 = cache_;
var G__26891_26965 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__26890_26964,G__26891_26965) : cljs.core.reset_BANG_.call(null,G__26890_26964,G__26891_26965));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_,cljs.core.dissoc,argn);
}

return null;
} else {
var fresh_QMARK_ = (function (){var G__26892 = arg1;
var G__26893 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26892,G__26893) : taoensso.encore.kw_identical_QMARK_.call(null,G__26892,G__26893));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var G__26894 = (function (){var or__7289__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cache_) : cljs.core.deref.call(null,cache_)),args__$1);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return taoensso.encore.swap_val_BANG_(cache_,args__$1,((function (or__7289__auto__,fresh_QMARK_,args__$1,vec__26883,seq__26884,first__26885,seq__26884__$1,arg1,argn,args,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_((function (){var and__7277__auto__ = _QMARK_dv;
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.not(fresh_QMARK_);
} else {
return and__7277__auto__;
}
})())){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__7289__auto__,fresh_QMARK_,args__$1,vec__26883,seq__26884,first__26885,seq__26884__$1,arg1,argn,args,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(or__7289__auto__,fresh_QMARK_,args__$1,vec__26883,seq__26884,first__26885,seq__26884__$1,arg1,argn,args,cache_))
,null));
}
});})(or__7289__auto__,fresh_QMARK_,args__$1,vec__26883,seq__26884,first__26885,seq__26884__$1,arg1,argn,args,cache_))
);
}
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__26894) : cljs.core.deref.call(null,G__26894));
}
};
var G__26963 = function (var_args){
var p__26882 = null;
if (arguments.length > 0) {
var G__26966__i = 0, G__26966__a = new Array(arguments.length -  0);
while (G__26966__i < G__26966__a.length) {G__26966__a[G__26966__i] = arguments[G__26966__i + 0]; ++G__26966__i;}
  p__26882 = new cljs.core.IndexedSeq(G__26966__a,0);
} 
return G__26963__delegate.call(this,p__26882);};
G__26963.cljs$lang$maxFixedArity = 0;
G__26963.cljs$lang$applyTo = (function (arglist__26967){
var p__26882 = cljs.core.seq(arglist__26967);
return G__26963__delegate(p__26882);
});
G__26963.cljs$core$IFn$_invoke$arity$variadic = G__26963__delegate;
return G__26963;
})()
;
;})(cache_))
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (ttl_ms,f){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return ttl_ms;
}),null)),cljs.core.cst$sym$ttl_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.pos_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_], null));


var cache = (function (){var G__26895 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26895) : cljs.core.atom.call(null,G__26895));
})();
return ((function (cache){
return (function() { 
var G__26968__delegate = function (p__26896){
var vec__26897 = p__26896;
var seq__26898 = cljs.core.seq(vec__26897);
var first__26899 = cljs.core.first(seq__26898);
var seq__26898__$1 = cljs.core.next(seq__26898);
var arg1 = first__26899;
var argn = seq__26898__$1;
var args = vec__26897;
if(cljs.core.truth_((function (){var G__26900 = arg1;
var G__26901 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26900,G__26901) : taoensso.encore.kw_identical_QMARK_.call(null,G__26900,G__26901));
})())){
if(cljs.core.truth_((function (){var G__26902 = cljs.core.first(argn);
var G__26903 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26902,G__26903) : taoensso.encore.kw_identical_QMARK_.call(null,G__26902,G__26903));
})())){
var G__26904_26969 = cache;
var G__26905_26970 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__26904_26969,G__26905_26970) : cljs.core.reset_BANG_.call(null,G__26904_26969,G__26905_26970));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache,cljs.core.dissoc,argn);
}

return null;
} else {
if(cljs.core.truth_(taoensso.encore.gc_now_QMARK_())){
var instant_26971 = taoensso.encore.now_udt();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cache,((function (instant_26971,vec__26897,seq__26898,first__26899,seq__26898__$1,arg1,argn,args,cache){
return (function (m){
return cljs.core.reduce_kv(((function (instant_26971,vec__26897,seq__26898,first__26899,seq__26898__$1,arg1,argn,args,cache){
return (function (m_STAR_,k,p__26906){
var vec__26907 = p__26906;
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26907,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26907,(1),null);
var cv = vec__26907;
if(((instant_26971 - udt) > ttl_ms)){
return m_STAR_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR_,k,cv);
}
});})(instant_26971,vec__26897,seq__26898,first__26899,seq__26898__$1,arg1,argn,args,cache))
,cljs.core.PersistentArrayMap.EMPTY,taoensso.encore.clj1098(m));
});})(instant_26971,vec__26897,seq__26898,first__26899,seq__26898__$1,arg1,argn,args,cache))
);
} else {
}

var fresh_QMARK_ = (function (){var G__26913 = arg1;
var G__26914 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26913,G__26914) : taoensso.encore.kw_identical_QMARK_.call(null,G__26913,G__26914));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var instant = taoensso.encore.now_udt();
var vec__26910 = taoensso.encore.swap_val_BANG_(cache,args__$1,((function (fresh_QMARK_,args__$1,instant,vec__26897,seq__26898,first__26899,seq__26898__$1,arg1,argn,args,cache){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__7277__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = cljs.core.not(fresh_QMARK_);
if(and__7277__auto____$1){
var vec__26918 = _QMARK_cv;
var _dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26918,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26918,(1),null);
return ((instant - udt) < ttl_ms);
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (fresh_QMARK_,args__$1,instant,vec__26897,seq__26898,first__26899,seq__26898__$1,arg1,argn,args,cache){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(fresh_QMARK_,args__$1,instant,vec__26897,seq__26898,first__26899,seq__26898__$1,arg1,argn,args,cache))
,null)),instant], null);
}
});})(fresh_QMARK_,args__$1,instant,vec__26897,seq__26898,first__26899,seq__26898__$1,arg1,argn,args,cache))
);
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26910,(0),null);
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(dv) : cljs.core.deref.call(null,dv));
}
};
var G__26968 = function (var_args){
var p__26896 = null;
if (arguments.length > 0) {
var G__26972__i = 0, G__26972__a = new Array(arguments.length -  0);
while (G__26972__i < G__26972__a.length) {G__26972__a[G__26972__i] = arguments[G__26972__i + 0]; ++G__26972__i;}
  p__26896 = new cljs.core.IndexedSeq(G__26972__a,0);
} 
return G__26968__delegate.call(this,p__26896);};
G__26968.cljs$lang$maxFixedArity = 0;
G__26968.cljs$lang$applyTo = (function (arglist__26973){
var p__26896 = cljs.core.seq(arglist__26973);
return G__26968__delegate(p__26896);
});
G__26968.cljs$core$IFn$_invoke$arity$variadic = G__26968__delegate;
return G__26968;
})()
;
;})(cache))
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (cache_size,ttl_ms,f){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return ttl_ms;
}),null)),cljs.core.cst$sym$ttl_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.pos_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_], null));


taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cache_size;
}),null)),cljs.core.cst$sym$cache_DASH_size,taoensso.encore.pos_int_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_);


var state = (function (){var G__26921 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tick,(0)], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26921) : cljs.core.atom.call(null,G__26921));
})();
return ((function (state){
return (function() { 
var G__26974__delegate = function (p__26922){
var vec__26923 = p__26922;
var seq__26924 = cljs.core.seq(vec__26923);
var first__26925 = cljs.core.first(seq__26924);
var seq__26924__$1 = cljs.core.next(seq__26924);
var arg1 = first__26925;
var argn = seq__26924__$1;
var args = vec__26923;
if(cljs.core.truth_((function (){var G__26926 = arg1;
var G__26927 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26926,G__26927) : taoensso.encore.kw_identical_QMARK_.call(null,G__26926,G__26927));
})())){
if(cljs.core.truth_((function (){var G__26928 = cljs.core.first(argn);
var G__26929 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26928,G__26929) : taoensso.encore.kw_identical_QMARK_.call(null,G__26928,G__26929));
})())){
var G__26930_26975 = state;
var G__26931_26976 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tick,(0)], null);
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__26930_26975,G__26931_26976) : cljs.core.reset_BANG_.call(null,G__26930_26975,G__26931_26976));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state,cljs.core.dissoc,argn);
}

return null;
} else {
if(cljs.core.truth_(taoensso.encore.gc_now_QMARK_())){
var instant_26977 = taoensso.encore.now_udt();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (instant_26977,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state){
return (function (m){
var m_STAR_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,cljs.core.cst$kw$tick);
var m_STAR___$1 = ((cljs.core.not(ttl_ms))?m_STAR_:cljs.core.reduce_kv(((function (m_STAR_,instant_26977,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state){
return (function (m_STAR___$1,k,p__26932){
var vec__26933 = p__26932;
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26933,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26933,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26933,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26933,(3),null);
var cv = vec__26933;
if(((instant_26977 - udt) > ttl_ms)){
return m_STAR___$1;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR___$1,k,cv);
}
});})(m_STAR_,instant_26977,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state))
,cljs.core.PersistentArrayMap.EMPTY,taoensso.encore.clj1098(m_STAR_)));
var n_to_prune = (cljs.core.count(m_STAR___$1) - cache_size);
var m_STAR___$2 = ((!((n_to_prune > (0))))?m_STAR___$1:cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,m_STAR___$1,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_26977,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state){
return (function (p1__26877_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__26877_SHARP_,(1));
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_26977,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state))
,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n_to_prune,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_26977,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state){
return (function (p1__26876_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__26876_SHARP_,(0));
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_26977,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state))
,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_26977,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state){
return (function (k){
var vec__26936 = (m_STAR___$1.cljs$core$IFn$_invoke$arity$1 ? m_STAR___$1.cljs$core$IFn$_invoke$arity$1(k) : m_STAR___$1.call(null,k));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26936,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26936,(1),null);
var tick_lru = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26936,(2),null);
var tick_lfu = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26936,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(tick_lru + tick_lfu),k], null);
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_26977,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state))
,cljs.core.keys(m_STAR___$1)))))));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR___$2,cljs.core.cst$kw$tick,cljs.core.cst$kw$tick.cljs$core$IFn$_invoke$arity$1(m));
});})(instant_26977,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state))
);
} else {
}

var fresh_QMARK_ = (function (){var G__26942 = arg1;
var G__26943 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26942,G__26943) : taoensso.encore.kw_identical_QMARK_.call(null,G__26942,G__26943));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var _QMARK_instant = (cljs.core.truth_(ttl_ms)?taoensso.encore.now_udt():null);
var tick_SINGLEQUOTE_ = cljs.core.cst$kw$tick.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(state) : cljs.core.deref.call(null,state)));
var vec__26939 = taoensso.encore.swap_val_BANG_(state,args__$1,((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__7277__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = cljs.core.not(fresh_QMARK_);
if(and__7277__auto____$1){
var or__7289__auto__ = (_QMARK_instant == null);
if(or__7289__auto__){
return or__7289__auto__;
} else {
var vec__26953 = _QMARK_cv;
var _dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26953,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26953,(1),null);
return ((_QMARK_instant - udt) < ttl_ms);
}
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state))
,null)),_QMARK_instant,tick_SINGLEQUOTE_,(1)], null);
}
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state))
);
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26939,(0),null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__26939,dv,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state){
return (function (m){
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,args__$1);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26956 = temp__4657__auto__;
var dv__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26956,(0),null);
var _QMARK_udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26956,(1),null);
var tick_lru = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26956,(2),null);
var tick_lfu = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26956,(3),null);
var cv = vec__26956;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([m,cljs.core.PersistentArrayMap.createAsIfByAssoc([cljs.core.cst$kw$tick,(tick_SINGLEQUOTE_ + (1)),args__$1,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [dv__$1,_QMARK_udt,tick_SINGLEQUOTE_,(tick_lfu + (1))], null)])], 0));
} else {
return null;
}
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__26939,dv,vec__26923,seq__26924,first__26925,seq__26924__$1,arg1,argn,args,state))
);

return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(dv) : cljs.core.deref.call(null,dv));
}
};
var G__26974 = function (var_args){
var p__26922 = null;
if (arguments.length > 0) {
var G__26978__i = 0, G__26978__a = new Array(arguments.length -  0);
while (G__26978__i < G__26978__a.length) {G__26978__a[G__26978__i] = arguments[G__26978__i + 0]; ++G__26978__i;}
  p__26922 = new cljs.core.IndexedSeq(G__26978__a,0);
} 
return G__26974__delegate.call(this,p__26922);};
G__26974.cljs$lang$maxFixedArity = 0;
G__26974.cljs$lang$applyTo = (function (arglist__26979){
var p__26922 = cljs.core.seq(arglist__26979);
return G__26974__delegate(p__26922);
});
G__26974.cljs$core$IFn$_invoke$arity$variadic = G__26974__delegate;
return G__26974;
})()
;
;})(state))
});

taoensso.encore.memoize_STAR_.cljs$lang$maxFixedArity = 3;

/**
 * Takes one or more rate specs of form [ncalls-limit window-ms ?spec-id] and
 *   returns a (fn [& [req-id])) that returns `nil` (=> all rate limits passed), or
 *   [<ms-wait> <worst-offending-spec-id>] / <ms-wait>.
 */
taoensso.encore.rate_limiter_STAR_ = (function taoensso$encore$rate_limiter_STAR_(specs){
if(cljs.core.empty_QMARK_(specs)){
return cljs.core.constantly(null);
} else {
var vspecs = cljs.core.vec(specs);
var vstates_ = (function (){var G__27068 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__27068) : cljs.core.atom.call(null,G__27068));
})();
var max_win_ms = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(0),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (vspecs,vstates_){
return (function (p__27069){
var vec__27070 = p__27069;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27070,(0),null);
var win_ms = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27070,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27070,(2),null);
var spec = vec__27070;
return win_ms;
});})(vspecs,vstates_))
,vspecs));
var nspecs = cljs.core.count(vspecs);
var nid_specs = cljs.core.count(cljs.core.filterv(((function (vspecs,vstates_,max_win_ms,nspecs){
return (function (p__27073){
var vec__27074 = p__27073;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27074,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27074,(1),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27074,(2),null);
return id;
});})(vspecs,vstates_,max_win_ms,nspecs))
,vspecs));
var _ = ((((nid_specs === (0))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(nid_specs,nspecs)))?null:(function(){throw (new Error("Assert failed: (or (zero? nid-specs) (= nid-specs nspecs))"))})());
var return_ids_QMARK_ = !((nid_specs === (0)));
return ((function (vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function() { 
var taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate = function (p__27077){
var vec__27117 = p__27077;
var req_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27117,(0),null);
var instant = taoensso.encore.now_udt();
if(cljs.core.truth_((function (){var and__7277__auto__ = req_id;
if(cljs.core.truth_(and__7277__auto__)){
return taoensso.encore.gc_now_QMARK_();
} else {
return and__7277__auto__;
}
})())){
taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(vstates_,cljs.core.PersistentVector.EMPTY,((function (instant,vec__27117,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function taoensso$encore$rate_limiter_STAR__$_check_rate_limits_$_gc(m){
var m__$1 = taoensso.encore.clj1098(m);
return cljs.core.reduce_kv(((function (m__$1,instant,vec__27117,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (m_STAR_,req_id__$1,vstate){
var max_udt_win_start = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (m__$1,instant,vec__27117,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (acc,p__27124){
var vec__27125 = p__27124;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27125,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27125,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27125,(2),null);
var x__7625__auto__ = acc;
var y__7626__auto__ = udt;
return ((x__7625__auto__ > y__7626__auto__) ? x__7625__auto__ : y__7626__auto__);
});})(m__$1,instant,vec__27117,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,(0),vstate);
var min_win_ms_elapsed = (instant - max_udt_win_start);
if((min_win_ms_elapsed > max_win_ms)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m_STAR_,req_id__$1);
} else {
return m_STAR_;
}
});})(m__$1,instant,vec__27117,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,m__$1,m__$1);
});})(instant,vec__27117,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
);
} else {
}

return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(vstates_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [req_id], null),((function (instant,vec__27117,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (_QMARK_vstate){
if(cljs.core.not(_QMARK_vstate)){
return taoensso.encore.swapped(cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(nspecs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),instant], null))),null);
} else {
var vec__27128 = (function (){var in_vspecs = vspecs;
var in_vstate = _QMARK_vstate;
var out_vstate = cljs.core.PersistentVector.EMPTY;
var _QMARK_worst_limit_offence = null;
while(true){
var vec__27131 = in_vspecs;
var seq__27132 = cljs.core.seq(vec__27131);
var first__27133 = cljs.core.first(seq__27132);
var seq__27132__$1 = cljs.core.next(seq__27132);
var vec__27134 = first__27133;
var ncalls_limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27134,(0),null);
var win_ms = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27134,(1),null);
var _QMARK_spec_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27134,(2),null);
var next_in_vspecs = seq__27132__$1;
var vec__27137 = in_vstate;
var seq__27138 = cljs.core.seq(vec__27137);
var first__27139 = cljs.core.first(seq__27138);
var seq__27138__$1 = cljs.core.next(seq__27138);
var vec__27140 = first__27139;
var ncalls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27140,(0),null);
var udt_win_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27140,(1),null);
var next_in_vstate = seq__27138__$1;
var win_ms_elapsed = (instant - udt_win_start);
var reset_due_QMARK_ = (win_ms_elapsed >= win_ms);
var rate_limited_QMARK_ = (!(reset_due_QMARK_)) && ((ncalls >= ncalls_limit));
var new_out_vstate = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out_vstate,((reset_due_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),instant], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls,udt_win_start], null)));
var new__QMARK_worst_limit_offence = ((!(rate_limited_QMARK_))?_QMARK_worst_limit_offence:(function (){var ms_wait = (win_ms - win_ms_elapsed);
if((function (){var or__7289__auto__ = (_QMARK_worst_limit_offence == null);
if(or__7289__auto__){
return or__7289__auto__;
} else {
var vec__27146 = _QMARK_worst_limit_offence;
var max_ms_wait = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27146,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27146,(1),null);
return (ms_wait > max_ms_wait);
}
})()){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ms_wait,_QMARK_spec_id], null);
} else {
return _QMARK_worst_limit_offence;
}
})());
if(cljs.core.not(next_in_vspecs)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_out_vstate,new__QMARK_worst_limit_offence], null);
} else {
var G__27156 = next_in_vspecs;
var G__27157 = next_in_vstate;
var G__27158 = new_out_vstate;
var G__27159 = new__QMARK_worst_limit_offence;
in_vspecs = G__27156;
in_vstate = G__27157;
out_vstate = G__27158;
_QMARK_worst_limit_offence = G__27159;
continue;
}
break;
}
})();
var vstate_with_resets = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27128,(0),null);
var _QMARK_worst_limit_offence = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27128,(1),null);
var all_limits_pass_QMARK_ = (_QMARK_worst_limit_offence == null);
var new_vstate = ((!(all_limits_pass_QMARK_))?vstate_with_resets:cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (vec__27128,vstate_with_resets,_QMARK_worst_limit_offence,all_limits_pass_QMARK_,instant,vec__27117,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (p__27149){
var vec__27150 = p__27149;
var ncalls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27150,(0),null);
var udt_win_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27150,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(ncalls + (1)),udt_win_start], null);
});})(vec__27128,vstate_with_resets,_QMARK_worst_limit_offence,all_limits_pass_QMARK_,instant,vec__27117,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,vstate_with_resets));
var result = (function (){var temp__4657__auto__ = _QMARK_worst_limit_offence;
if(cljs.core.truth_(temp__4657__auto__)){
var wlo = temp__4657__auto__;
if(return_ids_QMARK_){
return wlo;
} else {
var vec__27153 = wlo;
var ms_wait = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27153,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27153,(1),null);
return ms_wait;
}
} else {
return null;
}
})();
return taoensso.encore.swapped(new_vstate,result);
}
});})(instant,vec__27117,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
);
};
var taoensso$encore$rate_limiter_STAR__$_check_rate_limits = function (var_args){
var p__27077 = null;
if (arguments.length > 0) {
var G__27160__i = 0, G__27160__a = new Array(arguments.length -  0);
while (G__27160__i < G__27160__a.length) {G__27160__a[G__27160__i] = arguments[G__27160__i + 0]; ++G__27160__i;}
  p__27077 = new cljs.core.IndexedSeq(G__27160__a,0);
} 
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate.call(this,p__27077);};
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$lang$maxFixedArity = 0;
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$lang$applyTo = (function (arglist__27161){
var p__27077 = cljs.core.seq(arglist__27161);
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate(p__27077);
});
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$core$IFn$_invoke$arity$variadic = taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate;
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits;
})()
;
;})(vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
}
});
taoensso.encore.rate_limit = (function taoensso$encore$rate_limit(specs,f){
var rl = taoensso.encore.rate_limiter_STAR_(specs);
return ((function (rl){
return (function() { 
var G__27162__delegate = function (args){
var temp__4655__auto__ = (rl.cljs$core$IFn$_invoke$arity$0 ? rl.cljs$core$IFn$_invoke$arity$0() : rl.call(null));
if(cljs.core.truth_(temp__4655__auto__)){
var backoff = temp__4655__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,backoff], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),null], null);
}
};
var G__27162 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__27163__i = 0, G__27163__a = new Array(arguments.length -  0);
while (G__27163__i < G__27163__a.length) {G__27163__a[G__27163__i] = arguments[G__27163__i + 0]; ++G__27163__i;}
  args = new cljs.core.IndexedSeq(G__27163__a,0);
} 
return G__27162__delegate.call(this,args);};
G__27162.cljs$lang$maxFixedArity = 0;
G__27162.cljs$lang$applyTo = (function (arglist__27164){
var args = cljs.core.seq(arglist__27164);
return G__27162__delegate(args);
});
G__27162.cljs$core$IFn$_invoke$arity$variadic = G__27162__delegate;
return G__27162;
})()
;
;})(rl))
});
taoensso.encore.nano_time = (function (){var temp__4655__auto__ = (function (){var and__7277__auto__ = typeof window !== 'undefined';
if(and__7277__auto__){
return (window["performance"]);
} else {
return and__7277__auto__;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var perf = temp__4655__auto__;
var temp__4655__auto____$1 = (function (){var or__7289__auto__ = (perf["now"]);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = (perf["mozNow"]);
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
var or__7289__auto____$2 = (perf["msNow"]);
if(cljs.core.truth_(or__7289__auto____$2)){
return or__7289__auto____$2;
} else {
var or__7289__auto____$3 = (perf["oNow"]);
if(cljs.core.truth_(or__7289__auto____$3)){
return or__7289__auto____$3;
} else {
return (perf["webkitNow"]);
}
}
}
}
})();
if(cljs.core.truth_(temp__4655__auto____$1)){
var f = temp__4655__auto____$1;
return ((function (f,temp__4655__auto____$1,perf,temp__4655__auto__){
return (function (){
return cljs.core.long$((1000000.0 * f.call(perf)));
});
;})(f,temp__4655__auto____$1,perf,temp__4655__auto__))
} else {
return ((function (temp__4655__auto____$1,perf,temp__4655__auto__){
return (function (){
return (1000000.0 * taoensso.encore.now_udt());
});
;})(temp__4655__auto____$1,perf,temp__4655__auto__))
}
} else {
return ((function (temp__4655__auto__){
return (function (){
return (1000000.0 * taoensso.encore.now_udt());
});
;})(temp__4655__auto__))
}
})();
taoensso.encore.qb_min_times = (function taoensso$encore$qb_min_times(times){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,times);
});
taoensso.encore.console_log = (function (){var temp__4655__auto__ = (function (){var and__7277__auto__ = typeof console !== 'undefined';
if(and__7277__auto__){
return console.log;
} else {
return and__7277__auto__;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var f = temp__4655__auto__;
return ((function (f,temp__4655__auto__){
return (function (xs){
return f.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(xs));
});
;})(f,temp__4655__auto__))
} else {
return ((function (temp__4655__auto__){
return (function (xs){
return null;
});
;})(temp__4655__auto__))
}
})();

taoensso.encore.log = (function taoensso$encore$log(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27176 = arguments.length;
var i__8403__auto___27177 = (0);
while(true){
if((i__8403__auto___27177 < len__8402__auto___27176)){
args__8409__auto__.push((arguments[i__8403__auto___27177]));

var G__27178 = (i__8403__auto___27177 + (1));
i__8403__auto___27177 = G__27178;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(xs) : taoensso.encore.console_log.call(null,xs));
});

taoensso.encore.log.cljs$lang$maxFixedArity = (0);

taoensso.encore.log.cljs$lang$applyTo = (function (seq27165){
return taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27165));
});


taoensso.encore.logp = (function taoensso$encore$logp(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27179 = arguments.length;
var i__8403__auto___27180 = (0);
while(true){
if((i__8403__auto___27180 < len__8402__auto___27179)){
args__8409__auto__.push((arguments[i__8403__auto___27180]));

var G__27181 = (i__8403__auto___27180 + (1));
i__8403__auto___27180 = G__27181;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var G__27167 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.spaced_str(xs)], null);
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(G__27167) : taoensso.encore.console_log.call(null,G__27167));
});

taoensso.encore.logp.cljs$lang$maxFixedArity = (0);

taoensso.encore.logp.cljs$lang$applyTo = (function (seq27166){
return taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27166));
});


taoensso.encore.logf = (function taoensso$encore$logf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27182 = arguments.length;
var i__8403__auto___27183 = (0);
while(true){
if((i__8403__auto___27183 < len__8402__auto___27182)){
args__8409__auto__.push((arguments[i__8403__auto___27183]));

var G__27184 = (i__8403__auto___27183 + (1));
i__8403__auto___27183 = G__27184;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
var G__27170 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.format_STAR_(fmt,xs)], null);
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(G__27170) : taoensso.encore.console_log.call(null,G__27170));
});

taoensso.encore.logf.cljs$lang$maxFixedArity = (1);

taoensso.encore.logf.cljs$lang$applyTo = (function (seq27168){
var G__27169 = cljs.core.first(seq27168);
var seq27168__$1 = cljs.core.next(seq27168);
return taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic(G__27169,seq27168__$1);
});


taoensso.encore.sayp = (function taoensso$encore$sayp(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27185 = arguments.length;
var i__8403__auto___27186 = (0);
while(true){
if((i__8403__auto___27186 < len__8402__auto___27185)){
args__8409__auto__.push((arguments[i__8403__auto___27186]));

var G__27187 = (i__8403__auto___27186 + (1));
i__8403__auto___27186 = G__27187;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var G__27172 = taoensso.encore.spaced_str(xs);
return alert(G__27172);
});

taoensso.encore.sayp.cljs$lang$maxFixedArity = (0);

taoensso.encore.sayp.cljs$lang$applyTo = (function (seq27171){
return taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27171));
});


taoensso.encore.sayf = (function taoensso$encore$sayf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27188 = arguments.length;
var i__8403__auto___27189 = (0);
while(true){
if((i__8403__auto___27189 < len__8402__auto___27188)){
args__8409__auto__.push((arguments[i__8403__auto___27189]));

var G__27190 = (i__8403__auto___27189 + (1));
i__8403__auto___27189 = G__27190;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
var G__27175 = taoensso.encore.format_STAR_(fmt,xs);
return alert(G__27175);
});

taoensso.encore.sayf.cljs$lang$maxFixedArity = (1);

taoensso.encore.sayf.cljs$lang$applyTo = (function (seq27173){
var G__27174 = cljs.core.first(seq27173);
var seq27173__$1 = cljs.core.next(seq27173);
return taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic(G__27174,seq27173__$1);
});

/**
 * Returns browser window's current location. Forgeable.
 */
taoensso.encore.get_window_location = (function taoensso$encore$get_window_location(){
var loc_STAR_ = window.location;
var loc = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$href,loc_STAR_.href,cljs.core.cst$kw$protocol,loc_STAR_.protocol,cljs.core.cst$kw$hostname,loc_STAR_.hostname,cljs.core.cst$kw$host,loc_STAR_.host,cljs.core.cst$kw$pathname,loc_STAR_.pathname,cljs.core.cst$kw$search,loc_STAR_.search,cljs.core.cst$kw$hash,loc_STAR_.hash], null);
return loc;
});
taoensso.encore.xhr_pool_ = (new cljs.core.Delay((function (){
return (new goog.net.XhrIoPool());
}),null));
/**
 * Returns an immediately available XhrIo instance, or nil. The instance must be
 *   released back to pool manually.
 */
taoensso.encore.get_pooled_xhr_BANG_ = (function taoensso$encore$get_pooled_xhr_BANG_(){
var result = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(taoensso.encore.xhr_pool_) : cljs.core.deref.call(null,taoensso.encore.xhr_pool_)).getObject();
if((void 0 === result)){
return null;
} else {
return result;
}
});
/**
 * [uri method get-or-post-params] -> [uri post-content]
 */
taoensso.encore.coerce_xhr_params = (function taoensso$encore$coerce_xhr_params(uri,method,params){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return params;
}),null)),cljs.core.cst$sym$params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$map_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? map?] params)"));
}

var _QMARK_pstr = ((cljs.core.empty_QMARK_(params))?null:(function (){var s = (function (){var G__27193 = (new goog.structs.Map(cljs.core.clj__GT_js(params)));
return goog.Uri.QueryData.createFromMap(G__27193);
})().toString();
if(clojure.string.blank_QMARK_(s)){
return null;
} else {
return s;
}
})());
var G__27194 = (((method instanceof cljs.core.Keyword))?method.fqn:null);
switch (G__27194) {
case "get":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(_QMARK_pstr)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(uri),cljs.core.str.cljs$core$IFn$_invoke$arity$1("?"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_pstr)].join(''):uri),null], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,_QMARK_pstr], null);

break;
case "put":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,_QMARK_pstr], null);

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(method)].join('')));

}
});
/**
 * Alpha - subject to change.
 *   Simple+lightweight Ajax via Google Closure. Returns nil, or the xhr instance.
 *   Ref. https://developers.google.com/closure/library/docs/xhrio.
 * 
 *   (ajax-lite "/my-post-route"
 *  {:method     :post
 *   :params     {:username "Rich Hickey"
 *                :type     "Awesome"}
 *   :headers    {"Foo" "Bar"}
 *   :resp-type  :text
 *   :timeout-ms 7000
 *   :with-credentials? false ; Enable if using CORS (requires xhr v2+)
 *  }
 *  (fn async-callback [resp-map]
 *    (let [{:keys [success? ?status ?error ?content ?content-type]} resp-map]
 *      ;; ?status  - 200, 404, ..., or nil on no response
 *      ;; ?error   - e/o #{:xhr-pool-depleted :exception :http-error :abort
 *      ;;                  :timeout :no-content <http-error-status> nil}
 *      (js/alert (str "Ajax response: " resp-map)))))
 */
taoensso.encore.ajax_lite = (function taoensso$encore$ajax_lite(uri,p__27198,callback){
var map__27229 = p__27198;
var map__27229__$1 = ((((!((map__27229 == null)))?((((map__27229.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27229.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27229):map__27229);
var opts = map__27229__$1;
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27229__$1,cljs.core.cst$kw$method,cljs.core.cst$kw$get);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27229__$1,cljs.core.cst$kw$params);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27229__$1,cljs.core.cst$kw$headers);
var timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27229__$1,cljs.core.cst$kw$timeout_DASH_ms,(10000));
var resp_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27229__$1,cljs.core.cst$kw$resp_DASH_type,cljs.core.cst$kw$auto);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27229__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var progress_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27229__$1,cljs.core.cst$kw$progress_DASH_fn);
var errorf = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27229__$1,cljs.core.cst$kw$errorf,taoensso.encore.logf);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (map__27229,map__27229__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (){
return timeout_ms;
});})(map__27229,map__27229__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
,null)),cljs.core.cst$sym$timeout_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.nneg_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$nneg_DASH_int_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? nneg-int?] timeout-ms)"));
}

var temp__4655__auto__ = taoensso.encore.get_pooled_xhr_BANG_();
if(cljs.core.truth_(temp__4655__auto__)){
var xhr = temp__4655__auto__;
try{var timeout_ms__$1 = (function (){var or__7289__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return timeout_ms;
}
})();
var method_STAR_ = (function (){var G__27235 = (((method instanceof cljs.core.Keyword))?method.fqn:null);
switch (G__27235) {
case "get":
return "GET";

break;
case "post":
return "POST";

break;
case "put":
return "PUT";

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(method)].join('')));

}
})();
var params__$1 = taoensso.encore.map_keys(cljs.core.name,params);
var headers__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, ["X-Requested-With","XMLHTTPRequest"], null),taoensso.encore.map_keys(cljs.core.name,headers)], 0));
var vec__27232 = taoensso.encore.coerce_xhr_params(uri,method,params__$1);
var uri_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27232,(0),null);
var post_content_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27232,(1),null);
var headers_STAR_ = cljs.core.clj__GT_js(((cljs.core.not(post_content_STAR_))?headers__$1:cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(headers__$1,"Content-Type","application/x-www-form-urlencoded; charset=UTF-8")));
var G__27236_27260 = xhr;
var G__27237_27261 = G__27236_27260;
var G__27238_27262 = goog.net.EventType.READY;
var G__27239_27263 = ((function (G__27237_27261,G__27238_27262,G__27236_27260,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__27232,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__27229,map__27229__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (_){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(taoensso.encore.xhr_pool_) : cljs.core.deref.call(null,taoensso.encore.xhr_pool_)).releaseObject(xhr);
});})(G__27237_27261,G__27238_27262,G__27236_27260,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__27232,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__27229,map__27229__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listenOnce(G__27237_27261,G__27238_27262,G__27239_27263);

var G__27240_27264 = G__27236_27260;
var G__27241_27265 = goog.net.EventType.COMPLETE;
var G__27242_27266 = ((function (G__27240_27264,G__27241_27265,G__27236_27260,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__27232,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__27229,map__27229__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function taoensso$encore$ajax_lite_$_wrapped_callback(resp){
var status = xhr.getStatus();
var success_QMARK_ = xhr.isSuccess();
var _QMARK_http_status = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(status,(-1)))?status:null);
var _QMARK_content_type = (cljs.core.truth_(_QMARK_http_status)?xhr.getResponseHeader("Content-Type"):null);
var _QMARK_content = (cljs.core.truth_(_QMARK_http_status)?(function (){var resp_type__$1 = ((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(resp_type,cljs.core.cst$kw$auto)))?resp_type:(function (){var pred__27248 = ((function (status,success_QMARK_,_QMARK_http_status,_QMARK_content_type,G__27240_27264,G__27241_27265,G__27236_27260,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__27232,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__27229,map__27229__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (p1__27197_SHARP_,p2__27196_SHARP_){
return taoensso.encore.str_contains_QMARK_(p2__27196_SHARP_,p1__27197_SHARP_);
});})(status,success_QMARK_,_QMARK_http_status,_QMARK_content_type,G__27240_27264,G__27241_27265,G__27236_27260,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__27232,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__27229,map__27229__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
var expr__27249 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_content_type)].join('');
if(cljs.core.truth_(pred__27248("/edn",expr__27249))){
return cljs.core.cst$kw$edn;
} else {
if(cljs.core.truth_(pred__27248("/json",expr__27249))){
return cljs.core.cst$kw$json;
} else {
if(cljs.core.truth_(pred__27248("/xml",expr__27249))){
return cljs.core.cst$kw$xml;
} else {
if(cljs.core.truth_(pred__27248("/html",expr__27249))){
return cljs.core.cst$kw$text;
} else {
return cljs.core.cst$kw$text;
}
}
}
}
})());
try{var G__27252 = (((resp_type__$1 instanceof cljs.core.Keyword))?resp_type__$1.fqn:null);
switch (G__27252) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
case "xml":
return xhr.getResponseXml();

break;
case "edn":
return cljs.reader.read_string(xhr.getResponseText());

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp_type__$1)].join('')));

}
}catch (e27251){if((e27251 instanceof Error)){
var e = e27251;
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ajax_SLASH_bad_DASH_response_DASH_type,resp_type__$1,cljs.core.cst$kw$ajax_SLASH_resp_DASH_as_DASH_text,xhr.getResponseText()], null);
} else {
throw e27251;

}
}})():null);
var cb_arg = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$raw_DASH_resp,resp,cljs.core.cst$kw$xhr,xhr,cljs.core.cst$kw$success_QMARK_,success_QMARK_,cljs.core.cst$kw$_QMARK_content_DASH_type,(cljs.core.truth_(_QMARK_http_status)?_QMARK_content_type:null),cljs.core.cst$kw$_QMARK_content,_QMARK_content,cljs.core.cst$kw$_QMARK_status,_QMARK_http_status,cljs.core.cst$kw$_QMARK_error,(function (){var or__7289__auto__ = (cljs.core.truth_(_QMARK_http_status)?(function (){var n = _QMARK_http_status;
if(cljs.core.truth_(success_QMARK_)){
return null;
} else {
return _QMARK_http_status;
}
})():cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.createAsIfByAssoc([goog.net.ErrorCode.EXCEPTION,cljs.core.cst$kw$exception,goog.net.ErrorCode.HTTP_ERROR,cljs.core.cst$kw$http_DASH_error,goog.net.ErrorCode.ABORT,cljs.core.cst$kw$abort,goog.net.ErrorCode.TIMEOUT,cljs.core.cst$kw$timeout]),xhr.getLastErrorCode(),cljs.core.cst$kw$unknown));
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
if(((_QMARK_content == null)) && (cljs.core.not(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(204),null,(1223),null], null), null).call(null,_QMARK_http_status)))){
return cljs.core.cst$kw$no_DASH_content;
} else {
return null;
}
}
})()], null);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(cb_arg) : callback.call(null,cb_arg));
});})(G__27240_27264,G__27241_27265,G__27236_27260,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__27232,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__27229,map__27229__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listenOnce(G__27240_27264,G__27241_27265,G__27242_27266);


var temp__4657__auto___27268 = progress_fn;
if(cljs.core.truth_(temp__4657__auto___27268)){
var pf_27269 = temp__4657__auto___27268;
var G__27253_27270 = xhr;
var G__27254_27271 = goog.net.EventType.PROGRESS;
var G__27255_27272 = ((function (G__27253_27270,G__27254_27271,pf_27269,temp__4657__auto___27268,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__27232,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__27229,map__27229__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (ev){
var length_computable_QMARK_ = ev.lengthComputable;
var loaded = ev.loaded;
var total = ev.total;
var _QMARK_ratio = (cljs.core.truth_((function (){var and__7277__auto__ = length_computable_QMARK_;
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(total,(0));
} else {
return and__7277__auto__;
}
})())?(loaded / total):null);
var G__27256 = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$_QMARK_ratio,_QMARK_ratio,cljs.core.cst$kw$length_DASH_computable_QMARK_,length_computable_QMARK_,cljs.core.cst$kw$loaded,loaded,cljs.core.cst$kw$total,total,cljs.core.cst$kw$ev,ev], null);
return (pf_27269.cljs$core$IFn$_invoke$arity$1 ? pf_27269.cljs$core$IFn$_invoke$arity$1(G__27256) : pf_27269.call(null,G__27256));
});})(G__27253_27270,G__27254_27271,pf_27269,temp__4657__auto___27268,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__27232,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__27229,map__27229__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listen(G__27253_27270,G__27254_27271,G__27255_27272);
} else {
}

var G__27257_27273 = xhr;
var temp__4657__auto___27274 = cljs.core.cst$kw$always;
if(cljs.core.truth_(temp__4657__auto___27274)){
var x_27275 = temp__4657__auto___27274;
G__27257_27273.setTimeoutInterval((function (){var or__7289__auto__ = timeout_ms__$1;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return (0);
}
})());
} else {
}

var temp__4657__auto___27276 = with_credentials_QMARK_;
if(cljs.core.truth_(temp__4657__auto___27276)){
var x_27277 = temp__4657__auto___27276;
G__27257_27273.setWithCredentials(true);
} else {
}

var temp__4657__auto___27278 = cljs.core.cst$kw$always;
if(cljs.core.truth_(temp__4657__auto___27278)){
var x_27279 = temp__4657__auto___27278;
G__27257_27273.send(uri_STAR_,method_STAR_,post_content_STAR_,headers_STAR_);
} else {
}


return xhr;
}catch (e27231){if((e27231 instanceof Error)){
var e = e27231;
(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(taoensso.encore.xhr_pool_) : cljs.core.deref.call(null,taoensso.encore.xhr_pool_)).releaseObject(xhr);

return null;
} else {
throw e27231;

}
}} else {
var G__27258_27280 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_QMARK_error,cljs.core.cst$kw$xhr_DASH_pool_DASH_depleted], null);
(callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__27258_27280) : callback.call(null,G__27258_27280));

return null;
}
});
/**
 * Stolen from http://goo.gl/99NSR1.
 */
taoensso.encore.url_encode = (function taoensso$encore$url_encode(s){
if(cljs.core.truth_(s)){
return clojure.string.replace(clojure.string.replace((function (){var G__27283 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join('');
var G__27284 = s;
return encodeURIComponent(G__27283,G__27284);
})(),"*","%2A"),"'","%27");
} else {
return null;
}
});
/**
 * Stolen from http://goo.gl/99NSR1.
 */
taoensso.encore.url_decode = (function taoensso$encore$url_decode(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27291 = arguments.length;
var i__8403__auto___27292 = (0);
while(true){
if((i__8403__auto___27292 < len__8402__auto___27291)){
args__8409__auto__.push((arguments[i__8403__auto___27292]));

var G__27293 = (i__8403__auto___27292 + (1));
i__8403__auto___27292 = G__27293;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__27287){
var vec__27288 = p__27287;
var encoding = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27288,(0),null);
if(cljs.core.truth_(s)){
return decodeURIComponent(s);
} else {
return null;
}
});

taoensso.encore.url_decode.cljs$lang$maxFixedArity = (1);

taoensso.encore.url_decode.cljs$lang$applyTo = (function (seq27285){
var G__27286 = cljs.core.first(seq27285);
var seq27285__$1 = cljs.core.next(seq27285);
return taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(G__27286,seq27285__$1);
});

taoensso.encore.format_query_string = (function taoensso$encore$format_query_string(m){
var param = (function (k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.url_encode(cljs.core.name(k))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.url_encode(v))].join('');
});
var join = ((function (param){
return (function (strs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",strs);
});})(param))
;
if(cljs.core.empty_QMARK_(m)){
return null;
} else {
return join((function (){var iter__8077__auto__ = ((function (param,join){
return (function taoensso$encore$format_query_string_$_iter__27312(s__27313){
return (new cljs.core.LazySeq(null,((function (param,join){
return (function (){
var s__27313__$1 = s__27313;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__27313__$1);
if(temp__4657__auto__){
var s__27313__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27313__$2)){
var c__8075__auto__ = cljs.core.chunk_first(s__27313__$2);
var size__8076__auto__ = cljs.core.count(c__8075__auto__);
var b__27315 = cljs.core.chunk_buffer(size__8076__auto__);
if((function (){var i__27314 = (0);
while(true){
if((i__27314 < size__8076__auto__)){
var vec__27324 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8075__auto__,i__27314);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27324,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27324,(1),null);
cljs.core.chunk_append(b__27315,((cljs.core.sequential_QMARK_(v))?join(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(param,k),(function (){var or__7289__auto__ = cljs.core.seq(v);
if(or__7289__auto__){
return or__7289__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
}
})())):param(k,v)));

var G__27330 = (i__27314 + (1));
i__27314 = G__27330;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27315),taoensso$encore$format_query_string_$_iter__27312(cljs.core.chunk_rest(s__27313__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27315),null);
}
} else {
var vec__27327 = cljs.core.first(s__27313__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27327,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27327,(1),null);
return cljs.core.cons(((cljs.core.sequential_QMARK_(v))?join(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(param,k),(function (){var or__7289__auto__ = cljs.core.seq(v);
if(or__7289__auto__){
return or__7289__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
}
})())):param(k,v)),taoensso$encore$format_query_string_$_iter__27312(cljs.core.rest(s__27313__$2)));
}
} else {
return null;
}
break;
}
});})(param,join))
,null,null));
});})(param,join))
;
return iter__8077__auto__(m);
})());
}
});
taoensso.encore.assoc_conj = (function taoensso$encore$assoc_conj(m,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var temp__4655__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(temp__4655__auto__)){
var cur = temp__4655__auto__;
if(cljs.core.vector_QMARK_(cur)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cur,v);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cur,v], null);
}
} else {
return v;
}
})());
});
/**
 * Based on `ring-codec/form-decode`.
 */
taoensso.encore.parse_query_params = (function taoensso$encore$parse_query_params(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27340 = arguments.length;
var i__8403__auto___27341 = (0);
while(true){
if((i__8403__auto___27341 < len__8402__auto___27340)){
args__8409__auto__.push((arguments[i__8403__auto___27341]));

var G__27342 = (i__8403__auto___27341 + (1));
i__8403__auto___27341 = G__27342;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__27333){
var vec__27334 = p__27333;
var keywordize_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27334,(0),null);
var encoding = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27334,(1),null);
var _PERCENT_ = ((clojure.string.blank_QMARK_(s))?cljs.core.PersistentArrayMap.EMPTY:(function (){var s__$1 = (cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s,"?"))?taoensso.encore.substr(s,(1)):s);
if(cljs.core.not(taoensso.encore.str_contains_QMARK_(s__$1,"="))){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var m = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (s__$1,vec__27334,keywordize_QMARK_,encoding){
return (function (m,param){
var temp__4655__auto__ = clojure.string.split.cljs$core$IFn$_invoke$arity$3(param,/=/,(2));
if(cljs.core.truth_(temp__4655__auto__)){
var vec__27337 = temp__4655__auto__;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27337,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27337,(1),null);
return taoensso.encore.assoc_conj(m,taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(k,cljs.core.array_seq([encoding], 0)),taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(v,cljs.core.array_seq([encoding], 0)));
} else {
return m;
}
});})(s__$1,vec__27334,keywordize_QMARK_,encoding))
,cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2(s__$1,/&/));
if(cljs.core.not(keywordize_QMARK_)){
return m;
} else {
return taoensso.encore.keywordize_map(m);
}
}
})());
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (_PERCENT_,vec__27334,keywordize_QMARK_,encoding){
return (function (){
return _PERCENT_;
});})(_PERCENT_,vec__27334,keywordize_QMARK_,encoding))
,null)),cljs.core.cst$sym$_PERCENT_,cljs.core.map_QMARK_,cljs.core.cst$sym$map_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? map? %)"));
}

return _PERCENT_;
});

taoensso.encore.parse_query_params.cljs$lang$maxFixedArity = (1);

taoensso.encore.parse_query_params.cljs$lang$applyTo = (function (seq27331){
var G__27332 = cljs.core.first(seq27331);
var seq27331__$1 = cljs.core.next(seq27331);
return taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic(G__27332,seq27331__$1);
});

taoensso.encore.merge_url_with_query_string = (function taoensso$encore$merge_url_with_query_string(url,m){
var vec__27346 = clojure.string.split.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join(''),/\?/,(2));
var url__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27346,(0),null);
var _QMARK_qstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27346,(1),null);
var qmap = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(_QMARK_qstr)?taoensso.encore.keywordize_map(taoensso.encore.parse_query_params(_QMARK_qstr)):null),taoensso.encore.keywordize_map(m)], 0));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(url__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var temp__4657__auto__ = taoensso.encore.format_query_string(qmap);
if(cljs.core.truth_(temp__4657__auto__)){
var qstr = temp__4657__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("?"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(qstr)].join('');
} else {
return null;
}
})())].join('');
});
taoensso.encore.memoize_1 = taoensso.encore.memoize1;
taoensso.encore.logging_level = (function (){var G__27349 = cljs.core.cst$kw$debug;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__27349) : cljs.core.atom.call(null,G__27349));
})();
taoensso.encore.set_exp_backoff_timeout_BANG_ = (function taoensso$encore$set_exp_backoff_timeout_BANG_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27356 = arguments.length;
var i__8403__auto___27357 = (0);
while(true){
if((i__8403__auto___27357 < len__8402__auto___27356)){
args__8409__auto__.push((arguments[i__8403__auto___27357]));

var G__27358 = (i__8403__auto___27357 + (1));
i__8403__auto___27357 = G__27358;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (nullary_f,p__27352){
var vec__27353 = p__27352;
var nattempt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27353,(0),null);
return window.setTimeout(nullary_f,taoensso.encore.exp_backoff((function (){var or__7289__auto__ = nattempt;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return (0);
}
})()));
});

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$lang$applyTo = (function (seq27350){
var G__27351 = cljs.core.first(seq27350);
var seq27350__$1 = cljs.core.next(seq27350);
return taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__27351,seq27350__$1);
});

taoensso.encore.keys_EQ_ = (function taoensso$encore$keys_EQ_(m,ks){
return taoensso.encore.ks_EQ_(ks,m);
});
taoensso.encore.keys_LT__EQ_ = (function taoensso$encore$keys_LT__EQ_(m,ks){
return taoensso.encore.ks_LT__EQ_(ks,m);
});
taoensso.encore.keys_GT__EQ_ = (function taoensso$encore$keys_GT__EQ_(m,ks){
return taoensso.encore.ks_GT__EQ_(ks,m);
});
taoensso.encore.keys_EQ_nnil_QMARK_ = (function taoensso$encore$keys_EQ_nnil_QMARK_(m,ks){
return taoensso.encore.ks_nnil_QMARK_(ks,m);
});
taoensso.encore.parse_bool = taoensso.encore.as__QMARK_bool;
taoensso.encore.parse_int = taoensso.encore.as__QMARK_int;
taoensso.encore.parse_float = taoensso.encore.as__QMARK_float;
taoensso.encore.as_bool = (function taoensso$encore$as_bool(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2173,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_bool(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_bool,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.as_int = (function taoensso$encore$as_int(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2174,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_int(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_int,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.as_float = (function taoensso$encore$as_float(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2175,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_float(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_float,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.merge_deep_with = taoensso.encore.nested_merge_with;
taoensso.encore.merge_deep = taoensso.encore.nested_merge;
taoensso.encore.rate_limiter = (function taoensso$encore$rate_limiter(ncalls_limit,window_ms){
return taoensso.encore.rate_limiter_STAR_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls_limit,window_ms], null)], null));
});
taoensso.encore.rate_limited = (function taoensso$encore$rate_limited(ncalls_limit,window_ms,f){
var rl = taoensso.encore.rate_limiter_STAR_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls_limit,window_ms], null)], null));
return ((function (rl){
return (function() { 
var G__27359__delegate = function (args){
var temp__4655__auto__ = (rl.cljs$core$IFn$_invoke$arity$0 ? rl.cljs$core$IFn$_invoke$arity$0() : rl.call(null));
if(cljs.core.truth_(temp__4655__auto__)){
var backoff_ms = temp__4655__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$backoff_DASH_ms,backoff_ms], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$result,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null))], null);
}
};
var G__27359 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__27360__i = 0, G__27360__a = new Array(arguments.length -  0);
while (G__27360__i < G__27360__a.length) {G__27360__a[G__27360__i] = arguments[G__27360__i + 0]; ++G__27360__i;}
  args = new cljs.core.IndexedSeq(G__27360__a,0);
} 
return G__27359__delegate.call(this,args);};
G__27359.cljs$lang$maxFixedArity = 0;
G__27359.cljs$lang$applyTo = (function (arglist__27361){
var args = cljs.core.seq(arglist__27361);
return G__27359__delegate(args);
});
G__27359.cljs$core$IFn$_invoke$arity$variadic = G__27359__delegate;
return G__27359;
})()
;
;})(rl))
});
if(typeof taoensso.encore._STAR_log_level_STAR_ !== 'undefined'){
} else {
/**
 * DEPRECATED
 */
taoensso.encore._STAR_log_level_STAR_ = cljs.core.cst$kw$debug;
}

taoensso.encore.log_QMARK_ = (function (){var __GT_n = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$trace,(1),cljs.core.cst$kw$debug,(2),cljs.core.cst$kw$info,(3),cljs.core.cst$kw$warn,(4),cljs.core.cst$kw$error,(5),cljs.core.cst$kw$fatal,(6),cljs.core.cst$kw$report,(7)], null);
return ((function (__GT_n){
return (function (level){
return ((__GT_n.cljs$core$IFn$_invoke$arity$1 ? __GT_n.cljs$core$IFn$_invoke$arity$1(level) : __GT_n.call(null,level)) >= (__GT_n.cljs$core$IFn$_invoke$arity$1 ? __GT_n.cljs$core$IFn$_invoke$arity$1(taoensso.encore._STAR_log_level_STAR_) : __GT_n.call(null,taoensso.encore._STAR_log_level_STAR_)));
});
;})(__GT_n))
})();

taoensso.encore.tracef = (function taoensso$encore$tracef(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27383 = arguments.length;
var i__8403__auto___27384 = (0);
while(true){
if((i__8403__auto___27384 < len__8402__auto___27383)){
args__8409__auto__.push((arguments[i__8403__auto___27384]));

var G__27385 = (i__8403__auto___27384 + (1));
i__8403__auto___27384 = G__27385;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__27364 = cljs.core.cst$kw$trace;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__27364) : taoensso.encore.log_QMARK_.call(null,G__27364));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.tracef.cljs$lang$maxFixedArity = (1);

taoensso.encore.tracef.cljs$lang$applyTo = (function (seq27362){
var G__27363 = cljs.core.first(seq27362);
var seq27362__$1 = cljs.core.next(seq27362);
return taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic(G__27363,seq27362__$1);
});


taoensso.encore.debugf = (function taoensso$encore$debugf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27386 = arguments.length;
var i__8403__auto___27387 = (0);
while(true){
if((i__8403__auto___27387 < len__8402__auto___27386)){
args__8409__auto__.push((arguments[i__8403__auto___27387]));

var G__27388 = (i__8403__auto___27387 + (1));
i__8403__auto___27387 = G__27388;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__27367 = cljs.core.cst$kw$debug;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__27367) : taoensso.encore.log_QMARK_.call(null,G__27367));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.debugf.cljs$lang$maxFixedArity = (1);

taoensso.encore.debugf.cljs$lang$applyTo = (function (seq27365){
var G__27366 = cljs.core.first(seq27365);
var seq27365__$1 = cljs.core.next(seq27365);
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic(G__27366,seq27365__$1);
});


taoensso.encore.infof = (function taoensso$encore$infof(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27389 = arguments.length;
var i__8403__auto___27390 = (0);
while(true){
if((i__8403__auto___27390 < len__8402__auto___27389)){
args__8409__auto__.push((arguments[i__8403__auto___27390]));

var G__27391 = (i__8403__auto___27390 + (1));
i__8403__auto___27390 = G__27391;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__27370 = cljs.core.cst$kw$info;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__27370) : taoensso.encore.log_QMARK_.call(null,G__27370));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.infof.cljs$lang$maxFixedArity = (1);

taoensso.encore.infof.cljs$lang$applyTo = (function (seq27368){
var G__27369 = cljs.core.first(seq27368);
var seq27368__$1 = cljs.core.next(seq27368);
return taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic(G__27369,seq27368__$1);
});


taoensso.encore.warnf = (function taoensso$encore$warnf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27392 = arguments.length;
var i__8403__auto___27393 = (0);
while(true){
if((i__8403__auto___27393 < len__8402__auto___27392)){
args__8409__auto__.push((arguments[i__8403__auto___27393]));

var G__27394 = (i__8403__auto___27393 + (1));
i__8403__auto___27393 = G__27394;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__27373 = cljs.core.cst$kw$warn;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__27373) : taoensso.encore.log_QMARK_.call(null,G__27373));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("WARN: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.warnf.cljs$lang$maxFixedArity = (1);

taoensso.encore.warnf.cljs$lang$applyTo = (function (seq27371){
var G__27372 = cljs.core.first(seq27371);
var seq27371__$1 = cljs.core.next(seq27371);
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic(G__27372,seq27371__$1);
});


taoensso.encore.errorf = (function taoensso$encore$errorf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27395 = arguments.length;
var i__8403__auto___27396 = (0);
while(true){
if((i__8403__auto___27396 < len__8402__auto___27395)){
args__8409__auto__.push((arguments[i__8403__auto___27396]));

var G__27397 = (i__8403__auto___27396 + (1));
i__8403__auto___27396 = G__27397;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__27376 = cljs.core.cst$kw$error;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__27376) : taoensso.encore.log_QMARK_.call(null,G__27376));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ERROR: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.errorf.cljs$lang$maxFixedArity = (1);

taoensso.encore.errorf.cljs$lang$applyTo = (function (seq27374){
var G__27375 = cljs.core.first(seq27374);
var seq27374__$1 = cljs.core.next(seq27374);
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic(G__27375,seq27374__$1);
});


taoensso.encore.fatalf = (function taoensso$encore$fatalf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27398 = arguments.length;
var i__8403__auto___27399 = (0);
while(true){
if((i__8403__auto___27399 < len__8402__auto___27398)){
args__8409__auto__.push((arguments[i__8403__auto___27399]));

var G__27400 = (i__8403__auto___27399 + (1));
i__8403__auto___27399 = G__27400;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__27379 = cljs.core.cst$kw$fatal;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__27379) : taoensso.encore.log_QMARK_.call(null,G__27379));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FATAL: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.fatalf.cljs$lang$maxFixedArity = (1);

taoensso.encore.fatalf.cljs$lang$applyTo = (function (seq27377){
var G__27378 = cljs.core.first(seq27377);
var seq27377__$1 = cljs.core.next(seq27377);
return taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic(G__27378,seq27377__$1);
});


taoensso.encore.reportf = (function taoensso$encore$reportf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27401 = arguments.length;
var i__8403__auto___27402 = (0);
while(true){
if((i__8403__auto___27402 < len__8402__auto___27401)){
args__8409__auto__.push((arguments[i__8403__auto___27402]));

var G__27403 = (i__8403__auto___27402 + (1));
i__8403__auto___27402 = G__27403;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__27382 = cljs.core.cst$kw$report;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__27382) : taoensso.encore.log_QMARK_.call(null,G__27382));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.reportf.cljs$lang$maxFixedArity = (1);

taoensso.encore.reportf.cljs$lang$applyTo = (function (seq27380){
var G__27381 = cljs.core.first(seq27380);
var seq27380__$1 = cljs.core.next(seq27380);
return taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic(G__27381,seq27380__$1);
});

