// Compiled by ClojureScript 1.9.518 {:static-fns true, :optimize-constants true}
goog.provide('taoensso.sente.packers.transit');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.reader');
goog.require('taoensso.encore');
goog.require('cognitect.transit');
goog.require('taoensso.sente.interfaces');
taoensso.sente.packers.transit.get_charset = (function taoensso$sente$packers$transit$get_charset(transit_fmt){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(transit_fmt,cljs.core.cst$kw$msgpack)){
return "ISO-8859-1";
} else {
return "UTF-8";
}
});

/**
* @constructor
 * @implements {taoensso.sente.interfaces.IPacker}
*/
taoensso.sente.packers.transit.TransitPacker = (function (transit_fmt){
this.transit_fmt = transit_fmt;
})
taoensso.sente.packers.transit.TransitPacker.prototype.taoensso$sente$interfaces$IPacker$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.packers.transit.TransitPacker.prototype.taoensso$sente$interfaces$IPacker$pack$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
return cognitect.transit.write(cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1(self__.transit_fmt),x);
});

taoensso.sente.packers.transit.TransitPacker.prototype.taoensso$sente$interfaces$IPacker$unpack$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return cognitect.transit.read(cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(self__.transit_fmt),s);
});

taoensso.sente.packers.transit.TransitPacker.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$transit_DASH_fmt], null);
});

taoensso.sente.packers.transit.TransitPacker.cljs$lang$type = true;

taoensso.sente.packers.transit.TransitPacker.cljs$lang$ctorStr = "taoensso.sente.packers.transit/TransitPacker";

taoensso.sente.packers.transit.TransitPacker.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"taoensso.sente.packers.transit/TransitPacker");
});

taoensso.sente.packers.transit.__GT_TransitPacker = (function taoensso$sente$packers$transit$__GT_TransitPacker(transit_fmt){
return (new taoensso.sente.packers.transit.TransitPacker(transit_fmt));
});

taoensso.sente.packers.transit.edn_packer = taoensso.sente.interfaces.edn_packer;
taoensso.sente.packers.transit.json_packer = taoensso.sente.packers.transit.__GT_TransitPacker(cljs.core.cst$kw$json);
taoensso.sente.packers.transit.max_flexi_format_QMARK_ = (function taoensso$sente$packers$transit$max_flexi_format_QMARK_(fmt){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fmt,cljs.core.cst$kw$json);
});
taoensso.sente.packers.transit.max_flexi_format = (function (){var ordered_formats = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.cst$kw$edn,cljs.core.cst$kw$json], null);
var scored_formats = cljs.core.zipmap(ordered_formats,cljs.core.next(cljs.core.range.cljs$core$IFn$_invoke$arity$0()));
return ((function (ordered_formats,scored_formats){
return (function (xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,scored_formats,xs);
});
;})(ordered_formats,scored_formats))
})();
taoensso.sente.packers.transit.auto_flexi_format = (function taoensso$sente$packers$transit$auto_flexi_format(x){
if(typeof x === 'string'){
var c = cljs.core.count(x);
if((c > (300))){
return cljs.core.cst$kw$json;
} else {
return null;
}
} else {
if((cljs.core.sequential_QMARK_(x)) && (cljs.core.counted_QMARK_(x))){
var c = cljs.core.count(x);
if((c > (20))){
return cljs.core.cst$kw$json;
} else {
return null;
}
} else {
return null;
}
}
});

/**
* @constructor
 * @implements {taoensso.sente.interfaces.IPacker}
*/
taoensso.sente.packers.transit.FlexiPacker = (function (default_fmt){
this.default_fmt = default_fmt;
})
taoensso.sente.packers.transit.FlexiPacker.prototype.taoensso$sente$interfaces$IPacker$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.packers.transit.FlexiPacker.prototype.taoensso$sente$interfaces$IPacker$pack$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
var _QMARK_meta_format = (function (){var temp__4657__auto__ = cljs.core.meta(x);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
var G__26999 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keys(m));
return (taoensso.sente.packers.transit.max_flexi_format.cljs$core$IFn$_invoke$arity$1 ? taoensso.sente.packers.transit.max_flexi_format.cljs$core$IFn$_invoke$arity$1(G__26999) : taoensso.sente.packers.transit.max_flexi_format.call(null,G__26999));
} else {
return null;
}
})();
var _QMARK_auto_format = (cljs.core.truth_(_QMARK_meta_format)?null:taoensso.sente.packers.transit.auto_flexi_format(x));
var fmt = (function (){var G__27000 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_auto_format,_QMARK_meta_format,self__.default_fmt], null);
return (taoensso.sente.packers.transit.max_flexi_format.cljs$core$IFn$_invoke$arity$1 ? taoensso.sente.packers.transit.max_flexi_format.cljs$core$IFn$_invoke$arity$1(G__27000) : taoensso.sente.packers.transit.max_flexi_format.call(null,G__27000));
})();
var G__27001 = (((fmt instanceof cljs.core.Keyword))?fmt.fqn:null);
switch (G__27001) {
case "json":
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("j"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.sente.interfaces.pack(taoensso.sente.packers.transit.json_packer,x))].join('');

break;
case "edn":
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("e"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.sente.interfaces.pack(taoensso.sente.packers.transit.edn_packer,x))].join('');

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join('')));

}
});

taoensso.sente.packers.transit.FlexiPacker.prototype.taoensso$sente$interfaces$IPacker$unpack$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
var prefix = taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(s,(0),cljs.core.array_seq([(1)], 0));
var s_STAR_ = taoensso.encore.substr(s,(1));
var G__27002 = prefix;
switch (G__27002) {
case "j":
return taoensso.sente.interfaces.unpack(taoensso.sente.packers.transit.json_packer,s_STAR_);

break;
case "e":
return taoensso.sente.interfaces.unpack(taoensso.sente.packers.transit.edn_packer,s_STAR_);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Malformed FlexiPacker data: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$s,s], null));

}
});

taoensso.sente.packers.transit.FlexiPacker.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$default_DASH_fmt], null);
});

taoensso.sente.packers.transit.FlexiPacker.cljs$lang$type = true;

taoensso.sente.packers.transit.FlexiPacker.cljs$lang$ctorStr = "taoensso.sente.packers.transit/FlexiPacker";

taoensso.sente.packers.transit.FlexiPacker.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"taoensso.sente.packers.transit/FlexiPacker");
});

taoensso.sente.packers.transit.__GT_FlexiPacker = (function taoensso$sente$packers$transit$__GT_FlexiPacker(default_fmt){
return (new taoensso.sente.packers.transit.FlexiPacker(default_fmt));
});

/**
 * Experimental (pre-alpha): subject to change.
 *   Returns an IPacker implementation that un/packs data with a variable format
 *   determined by the data's size, metadata, or the provided `default-fmt` when no
 *   metadata is present.
 * 
 *   (def fpack (partial pack (get-flexi-packer :edn)))
 *   (fpack ^:edn     {:a :A :b :B}) => "e{:a :A, :b :B}"
 *   (fpack ^:json    {:a :A :b :B}) => "j["^ ","~:a","~:A","~:b","~:B"]"
 *   (fpack ^:msgpack {:a :A :b :B}  => "m£~:a£~:A£~:b£~:B"
 */
taoensso.sente.packers.transit.get_flexi_packer = (function taoensso$sente$packers$transit$get_flexi_packer(var_args){
var args__8409__auto__ = [];
var len__8402__auto___27010 = arguments.length;
var i__8403__auto___27011 = (0);
while(true){
if((i__8403__auto___27011 < len__8402__auto___27010)){
args__8409__auto__.push((arguments[i__8403__auto___27011]));

var G__27012 = (i__8403__auto___27011 + (1));
i__8403__auto___27011 = G__27012;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.sente.packers.transit.get_flexi_packer.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.sente.packers.transit.get_flexi_packer.cljs$core$IFn$_invoke$arity$variadic = (function (p__27006){
var vec__27007 = p__27006;
var _QMARK_default_fmt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27007,(0),null);
var default_fmt = (function (){var or__7289__auto__ = _QMARK_default_fmt;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.cst$kw$edn;
}
})();
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$json_DASH_verbose,null,cljs.core.cst$kw$edn,null,cljs.core.cst$kw$json,null], null), null).call(null,default_fmt))){
} else {
throw (new Error("Assert failed: (#{:json-verbose :edn :json} default-fmt)"));
}

return taoensso.sente.packers.transit.__GT_FlexiPacker(default_fmt);
});

taoensso.sente.packers.transit.get_flexi_packer.cljs$lang$maxFixedArity = (0);

taoensso.sente.packers.transit.get_flexi_packer.cljs$lang$applyTo = (function (seq27005){
return taoensso.sente.packers.transit.get_flexi_packer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27005));
});

taoensso.sente.packers.transit.default_flexi_packer = taoensso.sente.packers.transit.get_flexi_packer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$edn], 0));
