// Compiled by ClojureScript 1.9.518 {:static-fns true, :optimize-constants true}
goog.provide('taoensso.sente');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('taoensso.encore');
goog.require('taoensso.sente.interfaces');
taoensso.sente.set_logging_level_BANG_ = (function taoensso$sente$set_logging_level_BANG_(level){
return taoensso.encore._STAR_log_level_STAR_ = level;
});
/**
 * Alpha - subject to change.
 *   Simple+lightweight Ajax via Google Closure. Returns nil, or the xhr instance.
 *   Ref. https://developers.google.com/closure/library/docs/xhrio.
 * 
 *   (ajax-call "/my-post-route"
 *  {:method     :post
 *   :params     {:username "Rich Hickey"
 *                :type     "Awesome"}
 *   :headers    {"Foo" "Bar"}
 *   :resp-type  :text
 *   :timeout-ms 7000
 *   :with-credentials? false ; Enable if using CORS (requires xhr v2+)
 *  }
 *  (fn async-callback [resp-map]
 *    (let [{:keys [success? ?status ?error ?content ?content-type]} resp-map]
 *      ;; ?status  - 200, 404, ..., or nil on no response
 *      ;; ?error   - e/o #{:xhr-pool-depleted :exception :http-error :abort
 *      ;;                  :timeout :no-content <http-error-status> nil}
 *      (js/alert (str "Ajax response: " resp-map)))))
 */
taoensso.sente.ajax_call = taoensso.encore.ajax_lite;
taoensso.sente.validate_event = (function taoensso$sente$validate_event(x){
if(!(cljs.core.vector_QMARK_(x))){
return cljs.core.cst$kw$wrong_DASH_type;
} else {
if(cljs.core.not(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(1),null,(2),null], null), null).call(null,cljs.core.count(x)))){
return cljs.core.cst$kw$wrong_DASH_length;
} else {
var vec__26492 = x;
var ev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26492,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26492,(1),null);
if(!((ev_id instanceof cljs.core.Keyword))){
return cljs.core.cst$kw$wrong_DASH_id_DASH_type;
} else {
if(cljs.core.not(cljs.core.namespace(ev_id))){
return cljs.core.cst$kw$unnamespaced_DASH_id;
} else {
return null;

}
}

}
}
});
/**
 * Valid [ev-id ?ev-data] form?
 */
taoensso.sente.event_QMARK_ = (function taoensso$sente$event_QMARK_(x){
return (taoensso.sente.validate_event(x) == null);
});
taoensso.sente.as_event = (function taoensso$sente$as_event(x){
if(cljs.core.truth_(taoensso.sente.event_QMARK_(x))){
return x;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$chsk_SLASH_bad_DASH_event,x], null);
}
});
taoensso.sente.assert_event = (function taoensso$sente$assert_event(x){
var temp__4657__auto__ = taoensso.sente.validate_event(x);
if(cljs.core.truth_(temp__4657__auto__)){
var _QMARK_err = temp__4657__auto__;
var err_fmt = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__26496 = (((_QMARK_err instanceof cljs.core.Keyword))?_QMARK_err.fqn:null);
switch (G__26496) {
case "wrong-type":
return "Malformed event (wrong type).";

break;
case "wrong-length":
return "Malformed event (wrong length).";

break;
case "wrong-id-type":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "unnamespaced-id":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "else":
return "Malformed event (unknown error).";

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_err)].join('')));

}
})()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" Event should be of `[ev-id ?ev-data]` form: %s")].join('');
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic(err_fmt,cljs.core.array_seq([[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')], 0)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$malformed_DASH_event,x], null));
} else {
return null;
}
});
taoensso.sente.event_msg_QMARK_ = (function taoensso$sente$event_msg_QMARK_(x){
var and__7277__auto__ = cljs.core.map_QMARK_(x);
if(and__7277__auto__){
var and__7277__auto____$1 = taoensso.encore.keys_EQ_(x,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$ch_DASH_recv,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$event,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$_QMARK_data,null,cljs.core.cst$kw$send_DASH_fn,null], null), null));
if(cljs.core.truth_(and__7277__auto____$1)){
var map__26500 = x;
var map__26500__$1 = ((((!((map__26500 == null)))?((((map__26500.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26500.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26500):map__26500);
var ch_recv = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26500__$1,cljs.core.cst$kw$ch_DASH_recv);
var send_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26500__$1,cljs.core.cst$kw$send_DASH_fn);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26500__$1,cljs.core.cst$kw$state);
var event = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26500__$1,cljs.core.cst$kw$event);
var and__7277__auto____$2 = taoensso.encore.chan_QMARK_(ch_recv);
if(cljs.core.truth_(and__7277__auto____$2)){
var and__7277__auto____$3 = cljs.core.ifn_QMARK_(send_fn);
if(and__7277__auto____$3){
var and__7277__auto____$4 = taoensso.encore.atom_QMARK_(state);
if(cljs.core.truth_(and__7277__auto____$4)){
return taoensso.sente.event_QMARK_(event);
} else {
return and__7277__auto____$4;
}
} else {
return and__7277__auto____$3;
}
} else {
return and__7277__auto____$2;
}
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
});
/**
 * Note that cb reply need _not_ be `event` form!
 */
taoensso.sente.cb_success_QMARK_ = (function taoensso$sente$cb_success_QMARK_(cb_reply_clj){
return cljs.core.not(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$chsk_SLASH_closed,null,cljs.core.cst$kw$chsk_SLASH_error,null,cljs.core.cst$kw$chsk_SLASH_timeout,null], null), null).call(null,cb_reply_clj));
});
/**
 * pstr->clj
 */
taoensso.sente.unpack_STAR_ = (function taoensso$sente$unpack_STAR_(packer,pstr){
try{return taoensso.sente.interfaces.unpack(packer,taoensso.encore.hcond(false,"taoensso.sente",215,(new cljs.core.Delay((function (){
return pstr;
}),null)),cljs.core.cst$sym$pstr,cljs.core.string_QMARK_,cljs.core.cst$sym$string_QMARK_));
}catch (e26503){var t = e26503;
taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic("Bad package: %s (%s)",cljs.core.array_seq([pstr,t], 0));

throw t;
}});
taoensso.sente.with__QMARK_meta = (function taoensso$sente$with__QMARK_meta(x,_QMARK_m){
if(cljs.core.seq(_QMARK_m)){
return cljs.core.with_meta(x,_QMARK_m);
} else {
return x;
}
});
/**
 * clj->prefixed-pstr
 */
taoensso.sente.pack_STAR_ = (function taoensso$sente$pack_STAR_(var_args){
var args26504 = [];
var len__8402__auto___26507 = arguments.length;
var i__8403__auto___26508 = (0);
while(true){
if((i__8403__auto___26508 < len__8402__auto___26507)){
args26504.push((arguments[i__8403__auto___26508]));

var G__26509 = (i__8403__auto___26508 + (1));
i__8403__auto___26508 = G__26509;
continue;
} else {
}
break;
}

var G__26506 = args26504.length;
switch (G__26506) {
case 3:
return taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26504.length)].join('')));

}
});

taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (packer,_QMARK_packer_meta,clj){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.sente.interfaces.pack(packer,taoensso.sente.with__QMARK_meta(clj,_QMARK_packer_meta)))].join('');
});

taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (packer,_QMARK_packer_meta,clj,_QMARK_cb_uuid){
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(_QMARK_cb_uuid,cljs.core.cst$kw$ajax_DASH_cb))?(0):_QMARK_cb_uuid);
var wrapped_clj = (cljs.core.truth_(_QMARK_cb_uuid__$1)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,_QMARK_cb_uuid__$1], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj], null));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("+"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.sente.interfaces.pack(packer,taoensso.sente.with__QMARK_meta(wrapped_clj,_QMARK_packer_meta)))].join('');
});

taoensso.sente.pack_STAR_.cljs$lang$maxFixedArity = 4;

taoensso.sente.pack = (function taoensso$sente$pack(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26512 = arguments.length;
var i__8403__auto___26513 = (0);
while(true){
if((i__8403__auto___26513 < len__8402__auto___26512)){
args__8409__auto__.push((arguments[i__8403__auto___26513]));

var G__26514 = (i__8403__auto___26513 + (1));
i__8403__auto___26513 = G__26514;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var pstr = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(taoensso.sente.pack_STAR_,args);
taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic("Packing: %s -> %s",cljs.core.array_seq([args,pstr], 0));

return pstr;
});

taoensso.sente.pack.cljs$lang$maxFixedArity = (0);

taoensso.sente.pack.cljs$lang$applyTo = (function (seq26511){
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26511));
});

/**
 * prefixed-pstr->[clj ?cb-uuid]
 */
taoensso.sente.unpack = (function taoensso$sente$unpack(packer,prefixed_pstr){
taoensso.encore.hcond(false,"taoensso.sente",null,(new cljs.core.Delay((function (){
return prefixed_pstr;
}),null)),cljs.core.cst$sym$prefixed_DASH_pstr,cljs.core.string_QMARK_,cljs.core.cst$sym$string_QMARK_);


var prefix = taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(prefixed_pstr,(0),cljs.core.array_seq([(1)], 0));
var pstr = taoensso.encore.substr(prefixed_pstr,(1));
var clj = taoensso.sente.unpack_STAR_(packer,pstr);
var wrapped_QMARK_ = (function (){var G__26522 = prefix;
switch (G__26522) {
case "-":
return false;

break;
case "+":
return true;

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)].join('')));

}
})();
var vec__26519 = (cljs.core.truth_(wrapped_QMARK_)?clj:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,null], null));
var clj__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26519,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26519,(1),null);
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),_QMARK_cb_uuid))?cljs.core.cst$kw$ajax_DASH_cb:_QMARK_cb_uuid);
taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic("Unpacking: %s -> %s",cljs.core.array_seq([prefixed_pstr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null)], 0));

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null);
});

/**
 * @interface
 */
taoensso.sente.IChSocket = function(){};

/**
 * Implementation detail.
 */
taoensso.sente.chsk_init_BANG_ = (function taoensso$sente$chsk_init_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_init_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_init_BANG_$arity$1(chsk);
} else {
var x__7957__auto__ = (((chsk == null))?null:chsk);
var m__7958__auto__ = (taoensso.sente.chsk_init_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(chsk) : m__7958__auto__.call(null,chsk));
} else {
var m__7958__auto____$1 = (taoensso.sente.chsk_init_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(chsk) : m__7958__auto____$1.call(null,chsk));
} else {
throw cljs.core.missing_protocol("IChSocket.chsk-init!",chsk);
}
}
}
});

/**
 * Kills socket, stops auto-reconnects.
 */
taoensso.sente.chsk_destroy_BANG_ = (function taoensso$sente$chsk_destroy_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1(chsk);
} else {
var x__7957__auto__ = (((chsk == null))?null:chsk);
var m__7958__auto__ = (taoensso.sente.chsk_destroy_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(chsk) : m__7958__auto__.call(null,chsk));
} else {
var m__7958__auto____$1 = (taoensso.sente.chsk_destroy_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(chsk) : m__7958__auto____$1.call(null,chsk));
} else {
throw cljs.core.missing_protocol("IChSocket.chsk-destroy!",chsk);
}
}
}
});

/**
 * Drops connection, allows auto-reconnect. Useful for reauthenticating after login/logout.
 */
taoensso.sente.chsk_reconnect_BANG_ = (function taoensso$sente$chsk_reconnect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1(chsk);
} else {
var x__7957__auto__ = (((chsk == null))?null:chsk);
var m__7958__auto__ = (taoensso.sente.chsk_reconnect_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(chsk) : m__7958__auto__.call(null,chsk));
} else {
var m__7958__auto____$1 = (taoensso.sente.chsk_reconnect_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(chsk) : m__7958__auto____$1.call(null,chsk));
} else {
throw cljs.core.missing_protocol("IChSocket.chsk-reconnect!",chsk);
}
}
}
});

/**
 * Implementation detail.
 */
taoensso.sente.chsk_send_BANG__STAR_ = (function taoensso$sente$chsk_send_BANG__STAR_(chsk,ev,opts){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_send_BANG__STAR_$arity$3 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_send_BANG__STAR_$arity$3(chsk,ev,opts);
} else {
var x__7957__auto__ = (((chsk == null))?null:chsk);
var m__7958__auto__ = (taoensso.sente.chsk_send_BANG__STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(chsk,ev,opts) : m__7958__auto__.call(null,chsk,ev,opts));
} else {
var m__7958__auto____$1 = (taoensso.sente.chsk_send_BANG__STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(chsk,ev,opts) : m__7958__auto____$1.call(null,chsk,ev,opts));
} else {
throw cljs.core.missing_protocol("IChSocket.chsk-send!*",chsk);
}
}
}
});

/**
 * Sends `[ev-id ev-?data :as event]`, returns true on apparent success.
 */
taoensso.sente.chsk_send_BANG_ = (function taoensso$sente$chsk_send_BANG_(var_args){
var args26524 = [];
var len__8402__auto___26527 = arguments.length;
var i__8403__auto___26528 = (0);
while(true){
if((i__8403__auto___26528 < len__8402__auto___26527)){
args26524.push((arguments[i__8403__auto___26528]));

var G__26529 = (i__8403__auto___26528 + (1));
i__8403__auto___26528 = G__26529;
continue;
} else {
}
break;
}

var G__26526 = args26524.length;
switch (G__26526) {
case 2:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args26524.length)].join('')));

}
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (chsk,ev){
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3(chsk,ev,cljs.core.PersistentArrayMap.EMPTY);
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (chsk,ev,_QMARK_timeout_ms,_QMARK_cb){
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3(chsk,ev,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$timeout_DASH_ms,_QMARK_timeout_ms,cljs.core.cst$kw$cb,_QMARK_cb], null));
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (chsk,ev,opts){
taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic("Chsk send: (%s) %s",cljs.core.array_seq([cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$cb,cljs.core.boolean$(cljs.core.cst$kw$cb.cljs$core$IFn$_invoke$arity$1(opts))),ev], 0));

return taoensso.sente.chsk_send_BANG__STAR_(chsk,ev,opts);
});

taoensso.sente.chsk_send_BANG_.cljs$lang$maxFixedArity = 4;

taoensso.sente.assert_send_args = (function taoensso$sente$assert_send_args(x,_QMARK_timeout_ms,_QMARK_cb){
taoensso.sente.assert_event(x);

if(cljs.core.truth_((function (){var or__7289__auto__ = ((_QMARK_timeout_ms == null)) && ((_QMARK_cb == null));
if(or__7289__auto__){
return or__7289__auto__;
} else {
return taoensso.encore.nneg_int_QMARK_(_QMARK_timeout_ms);
}
})())){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic("cb requires a timeout; timeout-ms should be a +ive integer: %s",cljs.core.array_seq([_QMARK_timeout_ms], 0))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(or (and (nil? ?timeout-ms) (nil? ?cb)) (and (enc/nneg-int? ?timeout-ms)))")].join('')));
}

if(cljs.core.truth_((function (){var or__7289__auto__ = (_QMARK_cb == null);
if(or__7289__auto__){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = cljs.core.ifn_QMARK_(_QMARK_cb);
if(or__7289__auto____$1){
return or__7289__auto____$1;
} else {
return taoensso.encore.chan_QMARK_(_QMARK_cb);
}
}
})())){
return null;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic("cb should be nil, an ifn, or a channel: %s",cljs.core.array_seq([cljs.core.type(_QMARK_cb)], 0))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(or (nil? ?cb) (ifn? ?cb) (enc/chan? ?cb))")].join('')));
}
});
taoensso.sente.pull_unused_cb_fn_BANG_ = (function taoensso$sente$pull_unused_cb_fn_BANG_(cbs_waiting_,_QMARK_cb_uuid){
var temp__4657__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4657__auto__)){
var cb_uuid = temp__4657__auto__;
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid], null),((function (cb_uuid,temp__4657__auto__){
return (function (_QMARK_f){
return taoensso.encore.swapped(cljs.core.cst$kw$swap_SLASH_dissoc,_QMARK_f);
});})(cb_uuid,temp__4657__auto__))
);
} else {
return null;
}
});
taoensso.sente.merge_GT_chsk_state_BANG_ = (function taoensso$sente$merge_GT_chsk_state_BANG_(p__26531,merge_state){
var map__26537 = p__26531;
var map__26537__$1 = ((((!((map__26537 == null)))?((((map__26537.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26537.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26537):map__26537);
var chsk = map__26537__$1;
var chs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26537__$1,cljs.core.cst$kw$chs);
var state_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26537__$1,cljs.core.cst$kw$state_);
var vec__26539 = taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(state_,cljs.core.PersistentVector.EMPTY,((function (map__26537,map__26537__$1,chsk,chs,state_){
return (function (old_state){
var new_state = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([old_state,merge_state], 0));
var new_state__$1 = ((cljs.core.not((function (){var and__7277__auto__ = cljs.core.cst$kw$requested_DASH_reconnect_DASH_pending_QMARK_.cljs$core$IFn$_invoke$arity$1(old_state);
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = cljs.core.cst$kw$open_QMARK_.cljs$core$IFn$_invoke$arity$1(new_state);
if(cljs.core.truth_(and__7277__auto____$1)){
return cljs.core.not(cljs.core.cst$kw$open_QMARK_.cljs$core$IFn$_invoke$arity$1(old_state));
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
})()))?new_state:cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new_state,cljs.core.cst$kw$requested_DASH_reconnect_DASH_pending_QMARK_),cljs.core.cst$kw$requested_DASH_reconnect_QMARK_,true));
return taoensso.encore.swapped(new_state__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_state,new_state__$1], null));
});})(map__26537,map__26537__$1,chsk,chs,state_))
);
var old_state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26539,(0),null);
var new_state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26539,(1),null);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_state,new_state)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(chs),new_state);

return new_state;
} else {
return null;
}
});
/**
 * Experimental, undocumented. Allows a core.async channel to be provided
 *   instead of a cb-fn. The channel will receive values of form
 *   [<event-id>.cb <reply>].
 */
taoensso.sente.cb_chan_as_fn = (function taoensso$sente$cb_chan_as_fn(_QMARK_cb,ev){
if(((_QMARK_cb == null)) || (cljs.core.ifn_QMARK_(_QMARK_cb))){
return _QMARK_cb;
} else {
taoensso.encore.hcond(false,"taoensso.sente",null,(new cljs.core.Delay((function (){
return _QMARK_cb;
}),null)),cljs.core.cst$sym$_QMARK_cb,taoensso.encore.chan_QMARK_,cljs.core.cst$sym$enc_SLASH_chan_QMARK_);


taoensso.sente.assert_event(ev);

var vec__26545 = ev;
var ev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26545,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26545,(1),null);
var cb_ch = _QMARK_cb;
return ((function (vec__26545,ev_id,_,cb_ch){
return (function (reply){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cb_ch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.fq_name(ev_id)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".cb")].join('')),reply], null));
});
;})(vec__26545,ev_id,_,cb_ch))
}
});
taoensso.sente.receive_buffered_evs_BANG_ = (function taoensso$sente$receive_buffered_evs_BANG_(chs,clj){
taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic("receive-buffered-evs!: %s",cljs.core.array_seq([clj], 0));

var buffered_evs = taoensso.encore.hcond(false,"taoensso.sente",739,(new cljs.core.Delay((function (){
return clj;
}),null)),cljs.core.cst$sym$clj,cljs.core.vector_QMARK_,cljs.core.cst$sym$vector_QMARK_);
var seq__26552 = cljs.core.seq(buffered_evs);
var chunk__26553 = null;
var count__26554 = (0);
var i__26555 = (0);
while(true){
if((i__26555 < count__26554)){
var ev = chunk__26553.cljs$core$IIndexed$_nth$arity$2(null,i__26555);
taoensso.sente.assert_event(ev);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$_LT_server.cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__26556 = seq__26552;
var G__26557 = chunk__26553;
var G__26558 = count__26554;
var G__26559 = (i__26555 + (1));
seq__26552 = G__26556;
chunk__26553 = G__26557;
count__26554 = G__26558;
i__26555 = G__26559;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__26552);
if(temp__4657__auto__){
var seq__26552__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26552__$1)){
var c__8108__auto__ = cljs.core.chunk_first(seq__26552__$1);
var G__26560 = cljs.core.chunk_rest(seq__26552__$1);
var G__26561 = c__8108__auto__;
var G__26562 = cljs.core.count(c__8108__auto__);
var G__26563 = (0);
seq__26552 = G__26560;
chunk__26553 = G__26561;
count__26554 = G__26562;
i__26555 = G__26563;
continue;
} else {
var ev = cljs.core.first(seq__26552__$1);
taoensso.sente.assert_event(ev);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$_LT_server.cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__26564 = cljs.core.next(seq__26552__$1);
var G__26565 = null;
var G__26566 = (0);
var G__26567 = (0);
seq__26552 = G__26564;
chunk__26553 = G__26565;
count__26554 = G__26566;
i__26555 = G__26567;
continue;
}
} else {
return null;
}
}
break;
}
});
taoensso.sente.handle_when_handshake_BANG_ = (function taoensso$sente$handle_when_handshake_BANG_(chsk,chs,clj){
var handshake_QMARK_ = (cljs.core.vector_QMARK_(clj)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(clj),cljs.core.cst$kw$chsk_SLASH_handshake));
taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic("handle-when-handshake (%s): %s",cljs.core.array_seq([((handshake_QMARK_)?cljs.core.cst$kw$handshake:cljs.core.cst$kw$non_DASH_handshake),clj], 0));

if(handshake_QMARK_){
var vec__26574 = clj;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26574,(0),null);
var vec__26577 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26574,(1),null);
var _QMARK_uid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26577,(0),null);
var _QMARK_csrf_token = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26577,(1),null);
var _QMARK_handshake_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26577,(2),null);
var handshake_ev = vec__26574;
if(clojure.string.blank_QMARK_(_QMARK_csrf_token)){
taoensso.encore.warnf("SECURITY WARNING: no CSRF token available for use by Sente");
} else {
}

taoensso.sente.merge_GT_chsk_state_BANG_(chsk,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$open_QMARK_,true,cljs.core.cst$kw$uid,_QMARK_uid,cljs.core.cst$kw$csrf_DASH_token,_QMARK_csrf_token], null));

taoensso.sente.assert_event(handshake_ev);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$internal.cljs$core$IFn$_invoke$arity$1(chs),handshake_ev);

return cljs.core.cst$kw$handled;
} else {
return null;
}
});
taoensso.sente.set_exp_backoff_timeout_BANG_ = (function taoensso$sente$set_exp_backoff_timeout_BANG_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26586 = arguments.length;
var i__8403__auto___26587 = (0);
while(true){
if((i__8403__auto___26587 < len__8402__auto___26586)){
args__8409__auto__.push((arguments[i__8403__auto___26587]));

var G__26588 = (i__8403__auto___26587 + (1));
i__8403__auto___26587 = G__26588;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (nullary_f,p__26582){
var vec__26583 = p__26582;
var nattempt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26583,(0),null);
return window.setTimeout(nullary_f,taoensso.encore.exp_backoff((function (){var or__7289__auto__ = nattempt;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return (0);
}
})()));
});

taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$lang$applyTo = (function (seq26580){
var G__26581 = cljs.core.first(seq26580);
var seq26580__$1 = cljs.core.next(seq26580);
return taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26581,seq26580__$1);
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChWebSocket = (function (client_id,url,chs,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,nattempt_,cbs_waiting_,state_,packer,__meta,__extmap,__hash){
this.client_id = client_id;
this.url = url;
this.chs = chs;
this.socket_ = socket_;
this.kalive_ms = kalive_ms;
this.kalive_timer_ = kalive_timer_;
this.kalive_due_QMARK__ = kalive_due_QMARK__;
this.nattempt_ = nattempt_;
this.cbs_waiting_ = cbs_waiting_;
this.state_ = state_;
this.packer = packer;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7916__auto__,k__7917__auto__){
var self__ = this;
var this__7916__auto____$1 = this;
return this__7916__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7917__auto__,null);
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7918__auto__,k26590,else__7919__auto__){
var self__ = this;
var this__7918__auto____$1 = this;
var G__26592 = (((k26590 instanceof cljs.core.Keyword))?k26590.fqn:null);
switch (G__26592) {
case "client-id":
return self__.client_id;

break;
case "kalive-ms":
return self__.kalive_ms;

break;
case "nattempt_":
return self__.nattempt_;

break;
case "packer":
return self__.packer;

break;
case "chs":
return self__.chs;

break;
case "socket_":
return self__.socket_;

break;
case "url":
return self__.url;

break;
case "kalive-due?_":
return self__.kalive_due_QMARK__;

break;
case "cbs-waiting_":
return self__.cbs_waiting_;

break;
case "kalive-timer_":
return self__.kalive_timer_;

break;
case "state_":
return self__.state_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26590,else__7919__auto__);

}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7930__auto__,writer__7931__auto__,opts__7932__auto__){
var self__ = this;
var this__7930__auto____$1 = this;
var pr_pair__7933__auto__ = ((function (this__7930__auto____$1){
return (function (keyval__7934__auto__){
return cljs.core.pr_sequential_writer(writer__7931__auto__,cljs.core.pr_writer,""," ","",opts__7932__auto__,keyval__7934__auto__);
});})(this__7930__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7931__auto__,pr_pair__7933__auto__,"#taoensso.sente.ChWebSocket{",", ","}",opts__7932__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$client_DASH_id,self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$url,self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$chs,self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$socket_,self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$kalive_DASH_ms,self__.kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$kalive_DASH_timer_,self__.kalive_timer_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$kalive_DASH_due_QMARK__,self__.kalive_due_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$nattempt_,self__.nattempt_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$cbs_DASH_waiting_,self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state_,self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$packer,self__.packer],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26589){
var self__ = this;
var G__26589__$1 = this;
return (new cljs.core.RecordIter((0),G__26589__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$client_DASH_id,cljs.core.cst$kw$url,cljs.core.cst$kw$chs,cljs.core.cst$kw$socket_,cljs.core.cst$kw$kalive_DASH_ms,cljs.core.cst$kw$kalive_DASH_timer_,cljs.core.cst$kw$kalive_DASH_due_QMARK__,cljs.core.cst$kw$nattempt_,cljs.core.cst$kw$cbs_DASH_waiting_,cljs.core.cst$kw$state_,cljs.core.cst$kw$packer], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7914__auto__){
var self__ = this;
var this__7914__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7910__auto__){
var self__ = this;
var this__7910__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7920__auto__){
var self__ = this;
var this__7920__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7911__auto__){
var self__ = this;
var this__7911__auto____$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_imap(this__7911__auto____$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7912__auto__,other__7913__auto__){
var self__ = this;
var this__7912__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7277__auto__ = other__7913__auto__;
if(cljs.core.truth_(and__7277__auto__)){
return ((this__7912__auto____$1.constructor === other__7913__auto__.constructor)) && (cljs.core.equiv_map(this__7912__auto____$1,other__7913__auto__));
} else {
return and__7277__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7925__auto__,k__7926__auto__){
var self__ = this;
var this__7925__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$client_DASH_id,null,cljs.core.cst$kw$kalive_DASH_ms,null,cljs.core.cst$kw$nattempt_,null,cljs.core.cst$kw$packer,null,cljs.core.cst$kw$chs,null,cljs.core.cst$kw$socket_,null,cljs.core.cst$kw$url,null,cljs.core.cst$kw$kalive_DASH_due_QMARK__,null,cljs.core.cst$kw$cbs_DASH_waiting_,null,cljs.core.cst$kw$kalive_DASH_timer_,null,cljs.core.cst$kw$state_,null], null), null),k__7926__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7925__auto____$1),self__.__meta),k__7926__auto__);
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7926__auto__)),null));
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7923__auto__,k__7924__auto__,G__26589){
var self__ = this;
var this__7923__auto____$1 = this;
var pred__26593 = cljs.core.keyword_identical_QMARK_;
var expr__26594 = k__7924__auto__;
if(cljs.core.truth_((function (){var G__26596 = cljs.core.cst$kw$client_DASH_id;
var G__26597 = expr__26594;
return (pred__26593.cljs$core$IFn$_invoke$arity$2 ? pred__26593.cljs$core$IFn$_invoke$arity$2(G__26596,G__26597) : pred__26593.call(null,G__26596,G__26597));
})())){
return (new taoensso.sente.ChWebSocket(G__26589,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26598 = cljs.core.cst$kw$url;
var G__26599 = expr__26594;
return (pred__26593.cljs$core$IFn$_invoke$arity$2 ? pred__26593.cljs$core$IFn$_invoke$arity$2(G__26598,G__26599) : pred__26593.call(null,G__26598,G__26599));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,G__26589,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26600 = cljs.core.cst$kw$chs;
var G__26601 = expr__26594;
return (pred__26593.cljs$core$IFn$_invoke$arity$2 ? pred__26593.cljs$core$IFn$_invoke$arity$2(G__26600,G__26601) : pred__26593.call(null,G__26600,G__26601));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,G__26589,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26602 = cljs.core.cst$kw$socket_;
var G__26603 = expr__26594;
return (pred__26593.cljs$core$IFn$_invoke$arity$2 ? pred__26593.cljs$core$IFn$_invoke$arity$2(G__26602,G__26603) : pred__26593.call(null,G__26602,G__26603));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,G__26589,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26604 = cljs.core.cst$kw$kalive_DASH_ms;
var G__26605 = expr__26594;
return (pred__26593.cljs$core$IFn$_invoke$arity$2 ? pred__26593.cljs$core$IFn$_invoke$arity$2(G__26604,G__26605) : pred__26593.call(null,G__26604,G__26605));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,G__26589,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26606 = cljs.core.cst$kw$kalive_DASH_timer_;
var G__26607 = expr__26594;
return (pred__26593.cljs$core$IFn$_invoke$arity$2 ? pred__26593.cljs$core$IFn$_invoke$arity$2(G__26606,G__26607) : pred__26593.call(null,G__26606,G__26607));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,G__26589,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26608 = cljs.core.cst$kw$kalive_DASH_due_QMARK__;
var G__26609 = expr__26594;
return (pred__26593.cljs$core$IFn$_invoke$arity$2 ? pred__26593.cljs$core$IFn$_invoke$arity$2(G__26608,G__26609) : pred__26593.call(null,G__26608,G__26609));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,G__26589,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26610 = cljs.core.cst$kw$nattempt_;
var G__26611 = expr__26594;
return (pred__26593.cljs$core$IFn$_invoke$arity$2 ? pred__26593.cljs$core$IFn$_invoke$arity$2(G__26610,G__26611) : pred__26593.call(null,G__26610,G__26611));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,G__26589,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26612 = cljs.core.cst$kw$cbs_DASH_waiting_;
var G__26613 = expr__26594;
return (pred__26593.cljs$core$IFn$_invoke$arity$2 ? pred__26593.cljs$core$IFn$_invoke$arity$2(G__26612,G__26613) : pred__26593.call(null,G__26612,G__26613));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,G__26589,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26614 = cljs.core.cst$kw$state_;
var G__26615 = expr__26594;
return (pred__26593.cljs$core$IFn$_invoke$arity$2 ? pred__26593.cljs$core$IFn$_invoke$arity$2(G__26614,G__26615) : pred__26593.call(null,G__26614,G__26615));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,G__26589,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26616 = cljs.core.cst$kw$packer;
var G__26617 = expr__26594;
return (pred__26593.cljs$core$IFn$_invoke$arity$2 ? pred__26593.cljs$core$IFn$_invoke$arity$2(G__26616,G__26617) : pred__26593.call(null,G__26616,G__26617));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,G__26589,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7924__auto__,G__26589),null));
}
}
}
}
}
}
}
}
}
}
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7928__auto__){
var self__ = this;
var this__7928__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$client_DASH_id,self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$url,self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$chs,self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$socket_,self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$kalive_DASH_ms,self__.kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$kalive_DASH_timer_,self__.kalive_timer_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$kalive_DASH_due_QMARK__,self__.kalive_due_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$nattempt_,self__.nattempt_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$cbs_DASH_waiting_,self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state_,self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$packer,self__.packer],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7915__auto__,G__26589){
var self__ = this;
var this__7915__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,G__26589,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7921__auto__,entry__7922__auto__){
var self__ = this;
var this__7921__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7922__auto__)){
return this__7921__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7922__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7922__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7921__auto____$1,entry__7922__auto__);
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_send_BANG__STAR_$arity$3 = (function (chsk,ev,p__26618){
var self__ = this;
var map__26619 = p__26618;
var map__26619__$1 = ((((!((map__26619 == null)))?((((map__26619.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26619.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26619):map__26619);
var opts = map__26619__$1;
var _QMARK_timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26619__$1,cljs.core.cst$kw$timeout_DASH_ms);
var _QMARK_cb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26619__$1,cljs.core.cst$kw$cb);
var flush_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26619__$1,cljs.core.cst$kw$flush_QMARK_);
var chsk__$1 = this;
taoensso.sente.assert_send_args(ev,_QMARK_timeout_ms,_QMARK_cb);

var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn(_QMARK_cb,ev);
if(cljs.core.not(cljs.core.cst$kw$open_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.state_) : cljs.core.deref.call(null,self__.state_))))){
taoensso.encore.warnf("Chsk send against closed chsk.");

if(cljs.core.truth_(_QMARK_cb_fn)){
var G__26621 = cljs.core.cst$kw$chsk_SLASH_closed;
return (_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(G__26621) : _QMARK_cb_fn.call(null,G__26621));
} else {
return null;
}
} else {
var _QMARK_cb_uuid = (cljs.core.truth_(_QMARK_cb_fn)?taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1((6)):null);
var ppstr = taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.packer,cljs.core.meta(ev),ev,_QMARK_cb_uuid], 0));
var temp__4657__auto___26668 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4657__auto___26668)){
var cb_uuid_26669 = temp__4657__auto___26668;
taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid_26669], null),taoensso.encore.hcond(false,"taoensso.sente",804,(new cljs.core.Delay(((function (cb_uuid_26669,temp__4657__auto___26668,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__26619,map__26619__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return _QMARK_cb_fn;
});})(cb_uuid_26669,temp__4657__auto___26668,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__26619,map__26619__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),cljs.core.cst$sym$_QMARK_cb_DASH_fn,taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_));

var temp__4657__auto___26670__$1 = _QMARK_timeout_ms;
if(cljs.core.truth_(temp__4657__auto___26670__$1)){
var timeout_ms_26671 = temp__4657__auto___26670__$1;
var c__15051__auto___26672 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___26672,timeout_ms_26671,temp__4657__auto___26670__$1,cb_uuid_26669,temp__4657__auto___26668,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__26619,map__26619__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___26672,timeout_ms_26671,temp__4657__auto___26670__$1,cb_uuid_26669,temp__4657__auto___26668,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__26619,map__26619__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (state_26632){
var state_val_26633 = (state_26632[(1)]);
if((state_val_26633 === (1))){
var inst_26622 = cljs.core.async.timeout(timeout_ms_26671);
var state_26632__$1 = state_26632;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26632__$1,(2),inst_26622);
} else {
if((state_val_26633 === (2))){
var inst_26625 = (state_26632[(7)]);
var inst_26624 = (state_26632[(2)]);
var inst_26625__$1 = taoensso.sente.pull_unused_cb_fn_BANG_(self__.cbs_waiting_,_QMARK_cb_uuid);
var state_26632__$1 = (function (){var statearr_26634 = state_26632;
(statearr_26634[(8)] = inst_26624);

(statearr_26634[(7)] = inst_26625__$1);

return statearr_26634;
})();
if(cljs.core.truth_(inst_26625__$1)){
var statearr_26635_26673 = state_26632__$1;
(statearr_26635_26673[(1)] = (3));

} else {
var statearr_26636_26674 = state_26632__$1;
(statearr_26636_26674[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26633 === (3))){
var inst_26625 = (state_26632[(7)]);
var inst_26627 = (function (){var G__26637 = cljs.core.cst$kw$chsk_SLASH_timeout;
return (inst_26625.cljs$core$IFn$_invoke$arity$1 ? inst_26625.cljs$core$IFn$_invoke$arity$1(G__26637) : inst_26625.call(null,G__26637));
})();
var state_26632__$1 = state_26632;
var statearr_26638_26675 = state_26632__$1;
(statearr_26638_26675[(2)] = inst_26627);

(statearr_26638_26675[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26633 === (4))){
var state_26632__$1 = state_26632;
var statearr_26639_26676 = state_26632__$1;
(statearr_26639_26676[(2)] = null);

(statearr_26639_26676[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26633 === (5))){
var inst_26630 = (state_26632[(2)]);
var state_26632__$1 = state_26632;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26632__$1,inst_26630);
} else {
return null;
}
}
}
}
}
});})(c__15051__auto___26672,timeout_ms_26671,temp__4657__auto___26670__$1,cb_uuid_26669,temp__4657__auto___26668,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__26619,map__26619__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
;
return ((function (switch__14927__auto__,c__15051__auto___26672,timeout_ms_26671,temp__4657__auto___26670__$1,cb_uuid_26669,temp__4657__auto___26668,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__26619,map__26619__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function() {
var taoensso$sente$state_machine__14928__auto__ = null;
var taoensso$sente$state_machine__14928__auto____0 = (function (){
var statearr_26643 = [null,null,null,null,null,null,null,null,null];
(statearr_26643[(0)] = taoensso$sente$state_machine__14928__auto__);

(statearr_26643[(1)] = (1));

return statearr_26643;
});
var taoensso$sente$state_machine__14928__auto____1 = (function (state_26632){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_26632);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e26644){if((e26644 instanceof Object)){
var ex__14931__auto__ = e26644;
var statearr_26645_26677 = state_26632;
(statearr_26645_26677[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_26632);

return cljs.core.cst$kw$recur;
} else {
throw e26644;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__26678 = state_26632;
state_26632 = G__26678;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
taoensso$sente$state_machine__14928__auto__ = function(state_26632){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__14928__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__14928__auto____1.call(this,state_26632);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
taoensso$sente$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__14928__auto____0;
taoensso$sente$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__14928__auto____1;
return taoensso$sente$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___26672,timeout_ms_26671,temp__4657__auto___26670__$1,cb_uuid_26669,temp__4657__auto___26668,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__26619,map__26619__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
})();
var state__15053__auto__ = (function (){var statearr_26646 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_26646[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___26672);

return statearr_26646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___26672,timeout_ms_26671,temp__4657__auto___26670__$1,cb_uuid_26669,temp__4657__auto___26668,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__26619,map__26619__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
);

} else {
}
} else {
}

try{(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.socket_) : cljs.core.deref.call(null,self__.socket_)).send(ppstr);

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.kalive_due_QMARK__,false) : cljs.core.reset_BANG_.call(null,self__.kalive_due_QMARK__,false));

return cljs.core.cst$kw$apparent_DASH_success;
}catch (e26647){if((e26647 instanceof Error)){
var e = e26647;
taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic("Chsk send error: %s",cljs.core.array_seq([e], 0));

var temp__4657__auto___26679 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4657__auto___26679)){
var cb_uuid_26680 = temp__4657__auto___26679;
var cb_fn_STAR__26681 = (function (){var or__7289__auto__ = taoensso.sente.pull_unused_cb_fn_BANG_(self__.cbs_waiting_,cb_uuid_26680);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return taoensso.encore.hcond(false,"taoensso.sente",818,(new cljs.core.Delay(((function (or__7289__auto__,cb_uuid_26680,temp__4657__auto___26679,e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__26619,map__26619__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return _QMARK_cb_fn;
});})(or__7289__auto__,cb_uuid_26680,temp__4657__auto___26679,e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__26619,map__26619__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),cljs.core.cst$sym$_QMARK_cb_DASH_fn,taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
}
})();
var G__26648_26682 = cljs.core.cst$kw$chsk_SLASH_error;
(cb_fn_STAR__26681.cljs$core$IFn$_invoke$arity$1 ? cb_fn_STAR__26681.cljs$core$IFn$_invoke$arity$1(G__26648_26682) : cb_fn_STAR__26681.call(null,G__26648_26682));
} else {
}

return false;
} else {
throw e26647;

}
}}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$open_QMARK_,false,cljs.core.cst$kw$requested_DASH_reconnect_DASH_pending_QMARK_,true], null));

var temp__4657__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.socket_) : cljs.core.deref.call(null,self__.socket_));
if(cljs.core.truth_(temp__4657__auto__)){
var s = temp__4657__auto__;
return s.close((3000),"SENTE_RECONNECT");
} else {
return null;
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$open_QMARK_,false,cljs.core.cst$kw$destroyed_QMARK_,true], null));

var temp__4657__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.socket_) : cljs.core.deref.call(null,self__.socket_));
if(cljs.core.truth_(temp__4657__auto__)){
var s = temp__4657__auto__;
return s.close((1000),"CLOSE_NORMAL");
} else {
return null;
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_init_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var temp__4657__auto__ = (function (){var or__7289__auto__ = (window["WebSocket"]);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return (window["MozWebSocket"]);
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var WebSocket = temp__4657__auto__;
((function (WebSocket,temp__4657__auto__,chsk__$1){
return (function taoensso$sente$connect_BANG_(){
if(cljs.core.truth_(cljs.core.cst$kw$destroyed_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.state_) : cljs.core.deref.call(null,self__.state_))))){
return null;
} else {
var retry_BANG_ = ((function (WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
var nattempt_STAR_ = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.nattempt_,cljs.core.inc);
window.clearInterval((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.kalive_timer_) : cljs.core.deref.call(null,self__.kalive_timer_)));

taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic("Chsk is closed: will try reconnect (%s).",cljs.core.array_seq([nattempt_STAR_], 0));

return taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(taoensso$sente$connect_BANG_,cljs.core.array_seq([nattempt_STAR_], 0));
});})(WebSocket,temp__4657__auto__,chsk__$1))
;
var temp__4655__auto__ = (function (){try{return (new WebSocket(taoensso.encore.merge_url_with_query_string(self__.url,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$client_DASH_id,self__.client_id], null))));
}catch (e26658){if((e26658 instanceof Error)){
var e = e26658;
taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic("WebSocket js/Error: %s",cljs.core.array_seq([e], 0));

return null;
} else {
throw e26658;

}
}})();
if(cljs.core.truth_(temp__4655__auto__)){
var socket = temp__4655__auto__;
var G__26659 = self__.socket_;
var G__26660 = (function (){var G__26661 = socket;
(G__26661["onerror"] = ((function (G__26661,G__26659,socket,temp__4655__auto__,retry_BANG_,WebSocket,temp__4657__auto__,chsk__$1){
return (function (ws_ev){
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic("WebSocket error: %s",cljs.core.array_seq([ws_ev], 0));
});})(G__26661,G__26659,socket,temp__4655__auto__,retry_BANG_,WebSocket,temp__4657__auto__,chsk__$1))
);

(G__26661["onmessage"] = ((function (G__26661,G__26659,socket,temp__4655__auto__,retry_BANG_,WebSocket,temp__4657__auto__,chsk__$1){
return (function (ws_ev){
var ppstr = (ws_ev["data"]);
var vec__26662 = taoensso.sente.unpack(self__.packer,ppstr);
var clj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26662,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26662,(1),null);
var or__7289__auto__ = (function (){var and__7277__auto__ = taoensso.sente.handle_when_handshake_BANG_(chsk__$1,self__.chs,clj);
if(cljs.core.truth_(and__7277__auto__)){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.nattempt_,(0)) : cljs.core.reset_BANG_.call(null,self__.nattempt_,(0)));
} else {
return and__7277__auto__;
}
})();
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var temp__4655__auto____$1 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4655__auto____$1)){
var cb_uuid = temp__4655__auto____$1;
var temp__4655__auto____$2 = taoensso.sente.pull_unused_cb_fn_BANG_(self__.cbs_waiting_,cb_uuid);
if(cljs.core.truth_(temp__4655__auto____$2)){
var cb_fn = temp__4655__auto____$2;
return (cb_fn.cljs$core$IFn$_invoke$arity$1 ? cb_fn.cljs$core$IFn$_invoke$arity$1(clj) : cb_fn.call(null,clj));
} else {
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic("Cb reply w/o local cb-fn: %s",cljs.core.array_seq([clj], 0));
}
} else {
var buffered_evs = clj;
return taoensso.sente.receive_buffered_evs_BANG_(self__.chs,buffered_evs);
}
}
});})(G__26661,G__26659,socket,temp__4655__auto__,retry_BANG_,WebSocket,temp__4657__auto__,chsk__$1))
);

(G__26661["onopen"] = ((function (G__26661,G__26659,socket,temp__4655__auto__,retry_BANG_,WebSocket,temp__4657__auto__,chsk__$1){
return (function (_ws_ev){
var G__26665 = self__.kalive_timer_;
var G__26666 = window.setInterval(((function (G__26665,G__26661,G__26659,socket,temp__4655__auto__,retry_BANG_,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
if(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.kalive_due_QMARK__) : cljs.core.deref.call(null,self__.kalive_due_QMARK__)))){
taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2(chsk__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$chsk_SLASH_ws_DASH_ping], null));
} else {
}

return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.kalive_due_QMARK__,true) : cljs.core.reset_BANG_.call(null,self__.kalive_due_QMARK__,true));
});})(G__26665,G__26661,G__26659,socket,temp__4655__auto__,retry_BANG_,WebSocket,temp__4657__auto__,chsk__$1))
,self__.kalive_ms);
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__26665,G__26666) : cljs.core.reset_BANG_.call(null,G__26665,G__26666));
});})(G__26661,G__26659,socket,temp__4655__auto__,retry_BANG_,WebSocket,temp__4657__auto__,chsk__$1))
);

(G__26661["onclose"] = ((function (G__26661,G__26659,socket,temp__4655__auto__,retry_BANG_,WebSocket,temp__4657__auto__,chsk__$1){
return (function (_ws_ev){
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$open_QMARK_,false], null));

return retry_BANG_();
});})(G__26661,G__26659,socket,temp__4655__auto__,retry_BANG_,WebSocket,temp__4657__auto__,chsk__$1))
);

return G__26661;
})();
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__26659,G__26660) : cljs.core.reset_BANG_.call(null,G__26659,G__26660));
} else {
return retry_BANG_();
}
}
});})(WebSocket,temp__4657__auto__,chsk__$1))
.call(null);

return chsk__$1;
} else {
return null;
}
});

taoensso.sente.ChWebSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$client_DASH_id,cljs.core.cst$sym$url,cljs.core.cst$sym$chs,cljs.core.cst$sym$socket_,cljs.core.cst$sym$kalive_DASH_ms,cljs.core.cst$sym$kalive_DASH_timer_,cljs.core.cst$sym$kalive_DASH_due_QMARK__,cljs.core.cst$sym$nattempt_,cljs.core.cst$sym$cbs_DASH_waiting_,cljs.core.cst$sym$state_,cljs.core.cst$sym$packer], null);
});

taoensso.sente.ChWebSocket.cljs$lang$type = true;

taoensso.sente.ChWebSocket.cljs$lang$ctorPrSeq = (function (this__7950__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"taoensso.sente/ChWebSocket");
});

taoensso.sente.ChWebSocket.cljs$lang$ctorPrWriter = (function (this__7950__auto__,writer__7951__auto__){
return cljs.core._write(writer__7951__auto__,"taoensso.sente/ChWebSocket");
});

taoensso.sente.__GT_ChWebSocket = (function taoensso$sente$__GT_ChWebSocket(client_id,url,chs,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,nattempt_,cbs_waiting_,state_,packer){
return (new taoensso.sente.ChWebSocket(client_id,url,chs,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,nattempt_,cbs_waiting_,state_,packer,null,null,null));
});

taoensso.sente.map__GT_ChWebSocket = (function taoensso$sente$map__GT_ChWebSocket(G__26591){
return (new taoensso.sente.ChWebSocket(cljs.core.cst$kw$client_DASH_id.cljs$core$IFn$_invoke$arity$1(G__26591),cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(G__26591),cljs.core.cst$kw$chs.cljs$core$IFn$_invoke$arity$1(G__26591),cljs.core.cst$kw$socket_.cljs$core$IFn$_invoke$arity$1(G__26591),cljs.core.cst$kw$kalive_DASH_ms.cljs$core$IFn$_invoke$arity$1(G__26591),cljs.core.cst$kw$kalive_DASH_timer_.cljs$core$IFn$_invoke$arity$1(G__26591),cljs.core.cst$kw$kalive_DASH_due_QMARK__.cljs$core$IFn$_invoke$arity$1(G__26591),cljs.core.cst$kw$nattempt_.cljs$core$IFn$_invoke$arity$1(G__26591),cljs.core.cst$kw$cbs_DASH_waiting_.cljs$core$IFn$_invoke$arity$1(G__26591),cljs.core.cst$kw$state_.cljs$core$IFn$_invoke$arity$1(G__26591),cljs.core.cst$kw$packer.cljs$core$IFn$_invoke$arity$1(G__26591),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26591,cljs.core.cst$kw$client_DASH_id,cljs.core.array_seq([cljs.core.cst$kw$url,cljs.core.cst$kw$chs,cljs.core.cst$kw$socket_,cljs.core.cst$kw$kalive_DASH_ms,cljs.core.cst$kw$kalive_DASH_timer_,cljs.core.cst$kw$kalive_DASH_due_QMARK__,cljs.core.cst$kw$nattempt_,cljs.core.cst$kw$cbs_DASH_waiting_,cljs.core.cst$kw$state_,cljs.core.cst$kw$packer], 0)),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChAjaxSocket = (function (client_id,url,chs,timeout_ms,ajax_opts,curr_xhr_,state_,packer,__meta,__extmap,__hash){
this.client_id = client_id;
this.url = url;
this.chs = chs;
this.timeout_ms = timeout_ms;
this.ajax_opts = ajax_opts;
this.curr_xhr_ = curr_xhr_;
this.state_ = state_;
this.packer = packer;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7916__auto__,k__7917__auto__){
var self__ = this;
var this__7916__auto____$1 = this;
return this__7916__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7917__auto__,null);
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7918__auto__,k26684,else__7919__auto__){
var self__ = this;
var this__7918__auto____$1 = this;
var G__26686 = (((k26684 instanceof cljs.core.Keyword))?k26684.fqn:null);
switch (G__26686) {
case "client-id":
return self__.client_id;

break;
case "url":
return self__.url;

break;
case "chs":
return self__.chs;

break;
case "timeout-ms":
return self__.timeout_ms;

break;
case "ajax-opts":
return self__.ajax_opts;

break;
case "curr-xhr_":
return self__.curr_xhr_;

break;
case "state_":
return self__.state_;

break;
case "packer":
return self__.packer;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26684,else__7919__auto__);

}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7930__auto__,writer__7931__auto__,opts__7932__auto__){
var self__ = this;
var this__7930__auto____$1 = this;
var pr_pair__7933__auto__ = ((function (this__7930__auto____$1){
return (function (keyval__7934__auto__){
return cljs.core.pr_sequential_writer(writer__7931__auto__,cljs.core.pr_writer,""," ","",opts__7932__auto__,keyval__7934__auto__);
});})(this__7930__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7931__auto__,pr_pair__7933__auto__,"#taoensso.sente.ChAjaxSocket{",", ","}",opts__7932__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$client_DASH_id,self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$url,self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$chs,self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$timeout_DASH_ms,self__.timeout_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$ajax_DASH_opts,self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$curr_DASH_xhr_,self__.curr_xhr_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state_,self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$packer,self__.packer],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26683){
var self__ = this;
var G__26683__$1 = this;
return (new cljs.core.RecordIter((0),G__26683__$1,8,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$client_DASH_id,cljs.core.cst$kw$url,cljs.core.cst$kw$chs,cljs.core.cst$kw$timeout_DASH_ms,cljs.core.cst$kw$ajax_DASH_opts,cljs.core.cst$kw$curr_DASH_xhr_,cljs.core.cst$kw$state_,cljs.core.cst$kw$packer], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7914__auto__){
var self__ = this;
var this__7914__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7910__auto__){
var self__ = this;
var this__7910__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7920__auto__){
var self__ = this;
var this__7920__auto____$1 = this;
return (8 + cljs.core.count(self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7911__auto__){
var self__ = this;
var this__7911__auto____$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_imap(this__7911__auto____$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7912__auto__,other__7913__auto__){
var self__ = this;
var this__7912__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7277__auto__ = other__7913__auto__;
if(cljs.core.truth_(and__7277__auto__)){
return ((this__7912__auto____$1.constructor === other__7913__auto__.constructor)) && (cljs.core.equiv_map(this__7912__auto____$1,other__7913__auto__));
} else {
return and__7277__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7925__auto__,k__7926__auto__){
var self__ = this;
var this__7925__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$curr_DASH_xhr_,null,cljs.core.cst$kw$client_DASH_id,null,cljs.core.cst$kw$packer,null,cljs.core.cst$kw$chs,null,cljs.core.cst$kw$url,null,cljs.core.cst$kw$ajax_DASH_opts,null,cljs.core.cst$kw$timeout_DASH_ms,null,cljs.core.cst$kw$state_,null], null), null),k__7926__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7925__auto____$1),self__.__meta),k__7926__auto__);
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7926__auto__)),null));
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7923__auto__,k__7924__auto__,G__26683){
var self__ = this;
var this__7923__auto____$1 = this;
var pred__26687 = cljs.core.keyword_identical_QMARK_;
var expr__26688 = k__7924__auto__;
if(cljs.core.truth_((function (){var G__26690 = cljs.core.cst$kw$client_DASH_id;
var G__26691 = expr__26688;
return (pred__26687.cljs$core$IFn$_invoke$arity$2 ? pred__26687.cljs$core$IFn$_invoke$arity$2(G__26690,G__26691) : pred__26687.call(null,G__26690,G__26691));
})())){
return (new taoensso.sente.ChAjaxSocket(G__26683,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26692 = cljs.core.cst$kw$url;
var G__26693 = expr__26688;
return (pred__26687.cljs$core$IFn$_invoke$arity$2 ? pred__26687.cljs$core$IFn$_invoke$arity$2(G__26692,G__26693) : pred__26687.call(null,G__26692,G__26693));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,G__26683,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26694 = cljs.core.cst$kw$chs;
var G__26695 = expr__26688;
return (pred__26687.cljs$core$IFn$_invoke$arity$2 ? pred__26687.cljs$core$IFn$_invoke$arity$2(G__26694,G__26695) : pred__26687.call(null,G__26694,G__26695));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,G__26683,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26696 = cljs.core.cst$kw$timeout_DASH_ms;
var G__26697 = expr__26688;
return (pred__26687.cljs$core$IFn$_invoke$arity$2 ? pred__26687.cljs$core$IFn$_invoke$arity$2(G__26696,G__26697) : pred__26687.call(null,G__26696,G__26697));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,G__26683,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26698 = cljs.core.cst$kw$ajax_DASH_opts;
var G__26699 = expr__26688;
return (pred__26687.cljs$core$IFn$_invoke$arity$2 ? pred__26687.cljs$core$IFn$_invoke$arity$2(G__26698,G__26699) : pred__26687.call(null,G__26698,G__26699));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,G__26683,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26700 = cljs.core.cst$kw$curr_DASH_xhr_;
var G__26701 = expr__26688;
return (pred__26687.cljs$core$IFn$_invoke$arity$2 ? pred__26687.cljs$core$IFn$_invoke$arity$2(G__26700,G__26701) : pred__26687.call(null,G__26700,G__26701));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,G__26683,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26702 = cljs.core.cst$kw$state_;
var G__26703 = expr__26688;
return (pred__26687.cljs$core$IFn$_invoke$arity$2 ? pred__26687.cljs$core$IFn$_invoke$arity$2(G__26702,G__26703) : pred__26687.call(null,G__26702,G__26703));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,G__26683,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26704 = cljs.core.cst$kw$packer;
var G__26705 = expr__26688;
return (pred__26687.cljs$core$IFn$_invoke$arity$2 ? pred__26687.cljs$core$IFn$_invoke$arity$2(G__26704,G__26705) : pred__26687.call(null,G__26704,G__26705));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,G__26683,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7924__auto__,G__26683),null));
}
}
}
}
}
}
}
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7928__auto__){
var self__ = this;
var this__7928__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$client_DASH_id,self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$url,self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$chs,self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$timeout_DASH_ms,self__.timeout_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$ajax_DASH_opts,self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$curr_DASH_xhr_,self__.curr_xhr_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state_,self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$packer,self__.packer],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7915__auto__,G__26683){
var self__ = this;
var this__7915__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,G__26683,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7921__auto__,entry__7922__auto__){
var self__ = this;
var this__7921__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7922__auto__)){
return this__7921__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7922__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7922__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7921__auto____$1,entry__7922__auto__);
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_send_BANG__STAR_$arity$3 = (function (chsk,ev,p__26706){
var self__ = this;
var map__26707 = p__26706;
var map__26707__$1 = ((((!((map__26707 == null)))?((((map__26707.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26707.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26707):map__26707);
var opts = map__26707__$1;
var _QMARK_timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26707__$1,cljs.core.cst$kw$timeout_DASH_ms);
var _QMARK_cb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26707__$1,cljs.core.cst$kw$cb);
var flush_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26707__$1,cljs.core.cst$kw$flush_QMARK_);
var chsk__$1 = this;
taoensso.sente.assert_send_args(ev,_QMARK_timeout_ms,_QMARK_cb);

var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn(_QMARK_cb,ev);
if(cljs.core.not(cljs.core.cst$kw$open_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.state_) : cljs.core.deref.call(null,self__.state_))))){
taoensso.encore.warnf("Chsk send against closed chsk.");

if(cljs.core.truth_(_QMARK_cb_fn)){
var G__26709 = cljs.core.cst$kw$chsk_SLASH_closed;
return (_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(G__26709) : _QMARK_cb_fn.call(null,G__26709));
} else {
return null;
}
} else {
var G__26710_26761 = self__.url;
var G__26711_26762 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$method,cljs.core.cst$kw$post,cljs.core.cst$kw$timeout_DASH_ms,_QMARK_timeout_ms,cljs.core.cst$kw$resp_DASH_type,cljs.core.cst$kw$text,cljs.core.cst$kw$params,(function (){var ppstr = taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.packer,cljs.core.meta(ev),ev,(cljs.core.truth_(_QMARK_cb_fn)?cljs.core.cst$kw$ajax_DASH_cb:null)], 0));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$_,taoensso.encore.now_udt(),cljs.core.cst$kw$csrf_DASH_token,cljs.core.cst$kw$csrf_DASH_token.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.state_) : cljs.core.deref.call(null,self__.state_))),cljs.core.cst$kw$ppstr,ppstr], null);
})()], null)], 0));
var G__26712_26763 = ((function (G__26710_26761,G__26711_26762,_QMARK_cb_fn,chsk__$1,map__26707,map__26707__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function taoensso$sente$ajax_cb(p__26713){
var map__26721 = p__26713;
var map__26721__$1 = ((((!((map__26721 == null)))?((((map__26721.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26721.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26721):map__26721);
var _QMARK_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26721__$1,cljs.core.cst$kw$_QMARK_error);
var _QMARK_content = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26721__$1,cljs.core.cst$kw$_QMARK_content);
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(_QMARK_error,cljs.core.cst$kw$timeout)){
if(cljs.core.truth_(_QMARK_cb_fn)){
var G__26723 = cljs.core.cst$kw$chsk_SLASH_timeout;
return (_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(G__26723) : _QMARK_cb_fn.call(null,G__26723));
} else {
return null;
}
} else {
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$open_QMARK_,false], null));

if(cljs.core.truth_(_QMARK_cb_fn)){
var G__26724 = cljs.core.cst$kw$chsk_SLASH_error;
return (_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(G__26724) : _QMARK_cb_fn.call(null,G__26724));
} else {
return null;
}
}
} else {
var content = _QMARK_content;
var resp_ppstr = content;
var vec__26725 = taoensso.sente.unpack(self__.packer,resp_ppstr);
var resp_clj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26725,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26725,(1),null);
if(cljs.core.truth_(_QMARK_cb_fn)){
(_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(resp_clj) : _QMARK_cb_fn.call(null,resp_clj));
} else {
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(resp_clj,cljs.core.cst$kw$chsk_SLASH_dummy_DASH_cb_DASH_200)){
taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic("Cb reply w/o local cb-fn: %s",cljs.core.array_seq([resp_clj], 0));
} else {
}
}

return taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$open_QMARK_,true], null));
}
});})(G__26710_26761,G__26711_26762,_QMARK_cb_fn,chsk__$1,map__26707,map__26707__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
;
(taoensso.sente.ajax_call.cljs$core$IFn$_invoke$arity$3 ? taoensso.sente.ajax_call.cljs$core$IFn$_invoke$arity$3(G__26710_26761,G__26711_26762,G__26712_26763) : taoensso.sente.ajax_call.call(null,G__26710_26761,G__26711_26762,G__26712_26763));

return cljs.core.cst$kw$apparent_DASH_success;
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$open_QMARK_,false,cljs.core.cst$kw$requested_DASH_reconnect_DASH_pending_QMARK_,true], null));

var temp__4657__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.curr_xhr_) : cljs.core.deref.call(null,self__.curr_xhr_));
if(cljs.core.truth_(temp__4657__auto__)){
var x = temp__4657__auto__;
return x.abort();
} else {
return null;
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$open_QMARK_,false,cljs.core.cst$kw$destroyed_QMARK_,true], null));

var temp__4657__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.curr_xhr_) : cljs.core.deref.call(null,self__.curr_xhr_));
if(cljs.core.truth_(temp__4657__auto__)){
var x = temp__4657__auto__;
return x.abort();
} else {
return null;
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_init_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
((function (chsk__$1){
return (function taoensso$sente$async_poll_for_update_BANG_(nattempt){
taoensso.encore.tracef("async-poll-for-update!");

if(cljs.core.truth_(cljs.core.cst$kw$destroyed_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.state_) : cljs.core.deref.call(null,self__.state_))))){
return null;
} else {
var retry_BANG_ = ((function (chsk__$1){
return (function (){
var nattempt_STAR_ = (nattempt + (1));
taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic("Chsk is closed: will try reconnect (%s).",cljs.core.array_seq([nattempt_STAR_], 0));

return taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso$sente$async_poll_for_update_BANG_,nattempt_STAR_),cljs.core.array_seq([nattempt_STAR_], 0));
});})(chsk__$1))
;
var G__26744 = self__.curr_xhr_;
var G__26745 = (function (){var G__26746 = self__.url;
var G__26747 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$method,cljs.core.cst$kw$get,cljs.core.cst$kw$timeout_DASH_ms,self__.timeout_ms,cljs.core.cst$kw$resp_DASH_type,cljs.core.cst$kw$text,cljs.core.cst$kw$params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$_,taoensso.encore.now_udt(),cljs.core.cst$kw$client_DASH_id,self__.client_id], null),(cljs.core.truth_(cljs.core.cst$kw$open_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.state_) : cljs.core.deref.call(null,self__.state_))))?null:new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$handshake_QMARK_,true], null))], 0))], null)], 0));
var G__26748 = ((function (G__26746,G__26747,G__26744,retry_BANG_,chsk__$1){
return (function taoensso$sente$async_poll_for_update_BANG__$_ajax_cb(p__26749){
var map__26755 = p__26749;
var map__26755__$1 = ((((!((map__26755 == null)))?((((map__26755.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26755.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26755):map__26755);
var _QMARK_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26755__$1,cljs.core.cst$kw$_QMARK_error);
var _QMARK_content = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26755__$1,cljs.core.cst$kw$_QMARK_content);
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(_QMARK_error,cljs.core.cst$kw$timeout)){
return taoensso$sente$async_poll_for_update_BANG_((0));
} else {
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$open_QMARK_,false], null));

return retry_BANG_();

}
} else {
var content = _QMARK_content;
var ppstr = content;
var vec__26757 = taoensso.sente.unpack(self__.packer,ppstr);
var clj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26757,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26757,(1),null);
var or__7289__auto___26764 = taoensso.sente.handle_when_handshake_BANG_(chsk__$1,self__.chs,clj);
if(cljs.core.truth_(or__7289__auto___26764)){
} else {
var buffered_evs_26765 = clj;
taoensso.sente.receive_buffered_evs_BANG_(self__.chs,buffered_evs_26765);

taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$open_QMARK_,true], null));
}

return taoensso$sente$async_poll_for_update_BANG_((0));
}
});})(G__26746,G__26747,G__26744,retry_BANG_,chsk__$1))
;
return (taoensso.sente.ajax_call.cljs$core$IFn$_invoke$arity$3 ? taoensso.sente.ajax_call.cljs$core$IFn$_invoke$arity$3(G__26746,G__26747,G__26748) : taoensso.sente.ajax_call.call(null,G__26746,G__26747,G__26748));
})();
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__26744,G__26745) : cljs.core.reset_BANG_.call(null,G__26744,G__26745));
}
});})(chsk__$1))
.call(null,(0));

return chsk__$1;
});

taoensso.sente.ChAjaxSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$client_DASH_id,cljs.core.cst$sym$url,cljs.core.cst$sym$chs,cljs.core.cst$sym$timeout_DASH_ms,cljs.core.cst$sym$ajax_DASH_opts,cljs.core.cst$sym$curr_DASH_xhr_,cljs.core.cst$sym$state_,cljs.core.cst$sym$packer], null);
});

taoensso.sente.ChAjaxSocket.cljs$lang$type = true;

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrSeq = (function (this__7950__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrWriter = (function (this__7950__auto__,writer__7951__auto__){
return cljs.core._write(writer__7951__auto__,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.__GT_ChAjaxSocket = (function taoensso$sente$__GT_ChAjaxSocket(client_id,url,chs,timeout_ms,ajax_opts,curr_xhr_,state_,packer){
return (new taoensso.sente.ChAjaxSocket(client_id,url,chs,timeout_ms,ajax_opts,curr_xhr_,state_,packer,null,null,null));
});

taoensso.sente.map__GT_ChAjaxSocket = (function taoensso$sente$map__GT_ChAjaxSocket(G__26685){
return (new taoensso.sente.ChAjaxSocket(cljs.core.cst$kw$client_DASH_id.cljs$core$IFn$_invoke$arity$1(G__26685),cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(G__26685),cljs.core.cst$kw$chs.cljs$core$IFn$_invoke$arity$1(G__26685),cljs.core.cst$kw$timeout_DASH_ms.cljs$core$IFn$_invoke$arity$1(G__26685),cljs.core.cst$kw$ajax_DASH_opts.cljs$core$IFn$_invoke$arity$1(G__26685),cljs.core.cst$kw$curr_DASH_xhr_.cljs$core$IFn$_invoke$arity$1(G__26685),cljs.core.cst$kw$state_.cljs$core$IFn$_invoke$arity$1(G__26685),cljs.core.cst$kw$packer.cljs$core$IFn$_invoke$arity$1(G__26685),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26685,cljs.core.cst$kw$client_DASH_id,cljs.core.array_seq([cljs.core.cst$kw$url,cljs.core.cst$kw$chs,cljs.core.cst$kw$timeout_DASH_ms,cljs.core.cst$kw$ajax_DASH_opts,cljs.core.cst$kw$curr_DASH_xhr_,cljs.core.cst$kw$state_,cljs.core.cst$kw$packer], 0)),null));
});

/**
 * (ƒ [path window-location websocket?]) -> server-side chsk route URL string.
 * 
 *  * path       - As provided to client-side `make-channel-socket!` fn
 *                 (usu. "/chsk").
 *  * websocket? - True for WebSocket connections, false for Ajax (long-polling)
 *                 connections.
 *  * window-location - Map with keys:
 *    :href     ; "http://www.example.org:80/foo/bar?q=baz#bang"
 *    :protocol ; "http:" ; Note the :
 *    :hostname ; "example.org"
 *    :host     ; "example.org:80"
 *    :pathname ; "/foo/bar"
 *    :search   ; "?q=baz"
 *    :hash     ; "#bang"
 * 
 *   Note that the *same* URL is used for: WebSockets, POSTs, GETs. Server-side
 *   routes should be configured accordingly.
 */
taoensso.sente.default_chsk_url_fn = (function taoensso$sente$default_chsk_url_fn(path,p__26766,websocket_QMARK_){
var map__26769 = p__26766;
var map__26769__$1 = ((((!((map__26769 == null)))?((((map__26769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26769.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26769):map__26769);
var window_location = map__26769__$1;
var protocol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26769__$1,cljs.core.cst$kw$protocol);
var host = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26769__$1,cljs.core.cst$kw$host);
var pathname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26769__$1,cljs.core.cst$kw$pathname);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.not(websocket_QMARK_))?protocol:((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,"https:"))?"wss:":"ws:"))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(host),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__7289__auto__ = path;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return pathname;
}
})())].join('');
});
/**
 * Returns a map with keys:
 *  :ch-recv ; core.async channel to receive `event-msg`s (internal or from clients).
 *           ; May `put!` (inject) arbitrary `event`s to this channel.
 *  :send-fn ; (fn [event & [?timeout-ms ?cb-fn]]) for client>server send.
 *  :state   ; Watchable, read-only (atom {:type _ :open? _ :uid _ :csrf-token _}).
 *  :chsk    ; IChSocket implementer. You can usu. ignore this.
 * 
 *   Common options:
 *  :type         ; e/o #{:auto :ws :ajax}. You'll usually want the default (:auto)
 *  :ws-kalive-ms ; Ping to keep a WebSocket conn alive if no activity w/in given
 *                ; number of milliseconds
 *  :lp-kalive-ms ; Ping to keep a long-polling (Ajax) conn alive ''
 *  :chsk-url-fn  ; Please see `default-chsk-url-fn` for details
 *  :packer       ; :edn (default), or an IPacker implementation (experimental)
 *  :ajax-opts    ; Base opts map provided to `ajax-call`
 */
taoensso.sente.make_channel_socket_BANG_ = (function taoensso$sente$make_channel_socket_BANG_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26813 = arguments.length;
var i__8403__auto___26814 = (0);
while(true){
if((i__8403__auto___26814 < len__8402__auto___26813)){
args__8409__auto__.push((arguments[i__8403__auto___26814]));

var G__26815 = (i__8403__auto___26814 + (1));
i__8403__auto___26814 = G__26815;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.sente.make_channel_socket_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.sente.make_channel_socket_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (path,p__26773){
var vec__26774 = p__26773;
var map__26777 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26774,(0),null);
var map__26777__$1 = ((((!((map__26777 == null)))?((((map__26777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26777.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26777):map__26777);
var opts = map__26777__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26777__$1,cljs.core.cst$kw$type,cljs.core.cst$kw$auto);
var recv_buf_or_n = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26777__$1,cljs.core.cst$kw$recv_DASH_buf_DASH_or_DASH_n,cljs.core.async.sliding_buffer((2048)));
var ws_kalive_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26777__$1,cljs.core.cst$kw$ws_DASH_kalive_DASH_ms,(25000));
var lp_timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26777__$1,cljs.core.cst$kw$lp_DASH_timeout_DASH_ms,(25000));
var chsk_url_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26777__$1,cljs.core.cst$kw$chsk_DASH_url_DASH_fn,taoensso.sente.default_chsk_url_fn);
var packer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26777__$1,cljs.core.cst$kw$packer,cljs.core.cst$kw$edn);
var client_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26777__$1,cljs.core.cst$kw$client_DASH_id,(function (){var or__7289__auto__ = cljs.core.cst$kw$client_DASH_uuid.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();
}
})());
var ajax_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26777__$1,cljs.core.cst$kw$ajax_DASH_opts);
var _deprecated_more_opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26774,(1),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.sente",null,(new cljs.core.Delay(((function (vec__26774,map__26777,map__26777__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts){
return (function (){
return type;
});})(vec__26774,map__26777,map__26777__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts))
,null)),cljs.core.cst$sym$type,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$in,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$ws,null,cljs.core.cst$kw$ajax,null,cljs.core.cst$kw$auto,null], null), null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$in,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$ws,null,cljs.core.cst$kw$ajax,null,cljs.core.cst$kw$auto,null], null), null)], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:in #{:ws :ajax :auto}] type)"));
}

if((function (){
taoensso.encore.hcond(false,"taoensso.sente",null,(new cljs.core.Delay(((function (vec__26774,map__26777,map__26777__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts){
return (function (){
return client_id;
});})(vec__26774,map__26777,map__26777__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts))
,null)),cljs.core.cst$sym$client_DASH_id,taoensso.encore.nblank_str_QMARK_,cljs.core.cst$sym$enc_SLASH_nblank_DASH_str_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? enc/nblank-str? client-id)"));
}

if(!((_deprecated_more_opts == null))){
taoensso.encore.warnf("`make-channel-socket!` fn signature CHANGED with Sente v0.10.0.");
} else {
}

if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$lp_DASH_timeout)){
taoensso.encore.warnf(":lp-timeout opt has CHANGED; please use :lp-timout-ms.");
} else {
}

var packer__$1 = taoensso.sente.interfaces.coerce_packer(packer);
var window_location = taoensso.encore.get_window_location();
var private_chs = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$state,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((10))),cljs.core.cst$kw$internal,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((10))),cljs.core.cst$kw$_LT_server,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(recv_buf_or_n)], null);
var ever_opened_QMARK__ = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false) : cljs.core.atom.call(null,false));
var state_STAR_ = ((function (packer__$1,window_location,private_chs,ever_opened_QMARK__,vec__26774,map__26777,map__26777__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts){
return (function (state){
if(cljs.core.truth_((function (){var or__7289__auto__ = cljs.core.not(cljs.core.cst$kw$open_QMARK_.cljs$core$IFn$_invoke$arity$1(state));
if(or__7289__auto__){
return or__7289__auto__;
} else {
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ever_opened_QMARK__) : cljs.core.deref.call(null,ever_opened_QMARK__));
}
})())){
return state;
} else {
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(ever_opened_QMARK__,true) : cljs.core.reset_BANG_.call(null,ever_opened_QMARK__,true));

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$first_DASH_open_QMARK_,true);
}
});})(packer__$1,window_location,private_chs,ever_opened_QMARK__,vec__26774,map__26777,map__26777__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts))
;
var public_ch_recv = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$internal.cljs$core$IFn$_invoke$arity$1(private_chs),cljs.core.async.map_LT_(((function (packer__$1,window_location,private_chs,ever_opened_QMARK__,state_STAR_,vec__26774,map__26777,map__26777__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts){
return (function (state){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$chsk_SLASH_state,state_STAR_(state)], null);
});})(packer__$1,window_location,private_chs,ever_opened_QMARK__,state_STAR_,vec__26774,map__26777,map__26777__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts))
,cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(private_chs)),cljs.core.async.map_LT_(((function (packer__$1,window_location,private_chs,ever_opened_QMARK__,state_STAR_,vec__26774,map__26777,map__26777__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts){
return (function (ev){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$chsk_SLASH_recv,ev], null);
});})(packer__$1,window_location,private_chs,ever_opened_QMARK__,state_STAR_,vec__26774,map__26777,map__26777__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts))
,cljs.core.cst$kw$_LT_server.cljs$core$IFn$_invoke$arity$1(private_chs))], null));
var chsk = (function (){var or__7289__auto__ = (function (){var and__7277__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(type,cljs.core.cst$kw$ajax);
if(and__7277__auto__){
return taoensso.sente.chsk_init_BANG_(taoensso.sente.map__GT_ChWebSocket(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$client_DASH_id,cljs.core.cst$kw$kalive_DASH_ms,cljs.core.cst$kw$nattempt_,cljs.core.cst$kw$packer,cljs.core.cst$kw$chs,cljs.core.cst$kw$socket_,cljs.core.cst$kw$url,cljs.core.cst$kw$kalive_DASH_due_QMARK__,cljs.core.cst$kw$cbs_DASH_waiting_,cljs.core.cst$kw$kalive_DASH_timer_,cljs.core.cst$kw$state_],[client_id,ws_kalive_ms,(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0))),packer__$1,private_chs,(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null)),(function (){var G__26794 = path;
var G__26795 = window_location;
var G__26796 = cljs.core.cst$kw$ws;
return (chsk_url_fn.cljs$core$IFn$_invoke$arity$3 ? chsk_url_fn.cljs$core$IFn$_invoke$arity$3(G__26794,G__26795,G__26796) : chsk_url_fn.call(null,G__26794,G__26795,G__26796));
})(),(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true)),(function (){var G__26797 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26797) : cljs.core.atom.call(null,G__26797));
})(),(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null)),(function (){var G__26798 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$ws,cljs.core.cst$kw$open_QMARK_,false,cljs.core.cst$kw$destroyed_QMARK_,false], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26798) : cljs.core.atom.call(null,G__26798));
})()])));
} else {
return and__7277__auto__;
}
})();
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var and__7277__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(type,cljs.core.cst$kw$ws);
if(and__7277__auto__){
return taoensso.sente.chsk_init_BANG_(taoensso.sente.map__GT_ChAjaxSocket(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$client_DASH_id,client_id,cljs.core.cst$kw$url,(function (){var G__26803 = path;
var G__26804 = window_location;
var G__26805 = cljs.core.not(cljs.core.cst$kw$ws);
return (chsk_url_fn.cljs$core$IFn$_invoke$arity$3 ? chsk_url_fn.cljs$core$IFn$_invoke$arity$3(G__26803,G__26804,G__26805) : chsk_url_fn.call(null,G__26803,G__26804,G__26805));
})(),cljs.core.cst$kw$chs,private_chs,cljs.core.cst$kw$packer,packer__$1,cljs.core.cst$kw$timeout_DASH_ms,lp_timeout_ms,cljs.core.cst$kw$ajax_DASH_opts,ajax_opts,cljs.core.cst$kw$curr_DASH_xhr_,(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null)),cljs.core.cst$kw$state_,(function (){var G__26806 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$ajax,cljs.core.cst$kw$open_QMARK_,false,cljs.core.cst$kw$destroyed_QMARK_,false], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26806) : cljs.core.atom.call(null,G__26806));
})()], null)));
} else {
return and__7277__auto__;
}
}
})();
var _ = (cljs.core.truth_(chsk)?null:(function(){throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Failed to create channel socket"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("chsk")].join('')))})());
var send_fn = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.sente.chsk_send_BANG_,chsk);
var public_ch_recv__$1 = cljs.core.async.map_LT_(((function (packer__$1,window_location,private_chs,ever_opened_QMARK__,state_STAR_,public_ch_recv,chsk,_,send_fn,vec__26774,map__26777,map__26777__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts){
return (function taoensso$sente$ev__GT_ev_msg(ev){
var vec__26810 = taoensso.sente.as_event(ev);
var ev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26810,(0),null);
var ev__QMARK_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26810,(1),null);
var ev__$1 = vec__26810;
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$ch_DASH_recv,public_ch_recv,cljs.core.cst$kw$send_DASH_fn,send_fn,cljs.core.cst$kw$state,cljs.core.cst$kw$state_.cljs$core$IFn$_invoke$arity$1(chsk),cljs.core.cst$kw$event,ev__$1,cljs.core.cst$kw$id,ev_id,cljs.core.cst$kw$_QMARK_data,ev__QMARK_data], null);
});})(packer__$1,window_location,private_chs,ever_opened_QMARK__,state_STAR_,public_ch_recv,chsk,_,send_fn,vec__26774,map__26777,map__26777__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts))
,public_ch_recv);
if(cljs.core.truth_(chsk)){
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$chsk,chsk,cljs.core.cst$kw$ch_DASH_recv,public_ch_recv__$1,cljs.core.cst$kw$send_DASH_fn,send_fn,cljs.core.cst$kw$state,cljs.core.cst$kw$state_.cljs$core$IFn$_invoke$arity$1(chsk)], null);
} else {
return null;
}
});

taoensso.sente.make_channel_socket_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.make_channel_socket_BANG_.cljs$lang$applyTo = (function (seq26771){
var G__26772 = cljs.core.first(seq26771);
var seq26771__$1 = cljs.core.next(seq26771);
return taoensso.sente.make_channel_socket_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26772,seq26771__$1);
});

/**
 * Creates a go-loop to call `(event-msg-handler <event-msg>)` and returns a
 *   `(fn stop! [])`. Catches & logs errors. Advanced users may choose to instead
 *   write their own loop against `ch-recv`.
 */
taoensso.sente.start_chsk_router_BANG_ = (function taoensso$sente$start_chsk_router_BANG_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26951 = arguments.length;
var i__8403__auto___26952 = (0);
while(true){
if((i__8403__auto___26952 < len__8402__auto___26951)){
args__8409__auto__.push((arguments[i__8403__auto___26952]));

var G__26953 = (i__8403__auto___26952 + (1));
i__8403__auto___26952 = G__26953;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.sente.start_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.sente.start_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__26819){
var vec__26820 = p__26819;
var map__26823 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26820,(0),null);
var map__26823__$1 = ((((!((map__26823 == null)))?((((map__26823.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26823.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26823):map__26823);
var opts = map__26823__$1;
var trace_evs_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26823__$1,cljs.core.cst$kw$trace_DASH_evs_QMARK_);
var ch_ctrl = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__15051__auto___26954 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___26954,ch_ctrl,vec__26820,map__26823,map__26823__$1,opts,trace_evs_QMARK_){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___26954,ch_ctrl,vec__26820,map__26823,map__26823__$1,opts,trace_evs_QMARK_){
return (function (state_26900){
var state_val_26901 = (state_26900[(1)]);
if((state_val_26901 === (7))){
var inst_26838 = (state_26900[(2)]);
var inst_26839 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26838,(0),null);
var inst_26840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26838,(1),null);
var inst_26841 = (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(inst_26840,ch_ctrl) : taoensso.encore.kw_identical_QMARK_.call(null,inst_26840,ch_ctrl));
var state_26900__$1 = (function (){var statearr_26902 = state_26900;
(statearr_26902[(7)] = inst_26839);

return statearr_26902;
})();
if(cljs.core.truth_(inst_26841)){
var statearr_26903_26955 = state_26900__$1;
(statearr_26903_26955[(1)] = (8));

} else {
var statearr_26904_26956 = state_26900__$1;
(statearr_26904_26956[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (20))){
var inst_26886 = (state_26900[(2)]);
var state_26900__$1 = state_26900;
var statearr_26905_26957 = state_26900__$1;
(statearr_26905_26957[(2)] = inst_26886);

(statearr_26905_26957[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (27))){
var inst_26865 = (state_26900[(8)]);
var inst_26882 = (event_msg_handler.cljs$core$IFn$_invoke$arity$1 ? event_msg_handler.cljs$core$IFn$_invoke$arity$1(inst_26865) : event_msg_handler.call(null,inst_26865));
var state_26900__$1 = state_26900;
var statearr_26906_26958 = state_26900__$1;
(statearr_26906_26958[(2)] = inst_26882);

(statearr_26906_26958[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (1))){
var state_26900__$1 = state_26900;
var statearr_26907_26959 = state_26900__$1;
(statearr_26907_26959[(2)] = null);

(statearr_26907_26959[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (24))){
var state_26900__$1 = state_26900;
var statearr_26908_26960 = state_26900__$1;
(statearr_26908_26960[(2)] = null);

(statearr_26908_26960[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (4))){
var inst_26890 = (state_26900[(2)]);
var inst_26891 = (function (){var G__26909 = cljs.core.cst$kw$taoensso$sente_SLASH_stop;
var G__26910 = inst_26890;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26909,G__26910) : taoensso.encore.kw_identical_QMARK_.call(null,G__26909,G__26910));
})();
var state_26900__$1 = state_26900;
if(cljs.core.truth_(inst_26891)){
var statearr_26911_26961 = state_26900__$1;
(statearr_26911_26961[(1)] = (29));

} else {
var statearr_26912_26962 = state_26900__$1;
(statearr_26912_26962[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (15))){
var state_26900__$1 = state_26900;
var statearr_26913_26963 = state_26900__$1;
(statearr_26913_26963[(2)] = false);

(statearr_26913_26963[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (21))){
var inst_26866 = (state_26900[(9)]);
var inst_26867 = (state_26900[(2)]);
var inst_26868 = taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic("Chsk router handling error (%s): %s",cljs.core.array_seq([inst_26866,inst_26867], 0));
var state_26900__$1 = state_26900;
var statearr_26914_26964 = state_26900__$1;
(statearr_26914_26964[(2)] = inst_26868);


cljs.core.async.impl.ioc_helpers.process_exception(state_26900__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (31))){
var inst_26896 = (state_26900[(2)]);
var state_26900__$1 = state_26900;
var statearr_26915_26965 = state_26900__$1;
(statearr_26915_26965[(2)] = inst_26896);

(statearr_26915_26965[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (13))){
var inst_26860 = (state_26900[(2)]);
var state_26900__$1 = state_26900;
if(cljs.core.truth_(inst_26860)){
var statearr_26916_26966 = state_26900__$1;
(statearr_26916_26966[(1)] = (17));

} else {
var statearr_26917_26967 = state_26900__$1;
(statearr_26917_26967[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (22))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_26900,(21),Error,null,(20));
var state_26900__$1 = state_26900;
if(cljs.core.truth_(trace_evs_QMARK_)){
var statearr_26918_26968 = state_26900__$1;
(statearr_26918_26968[(1)] = (23));

} else {
var statearr_26919_26969 = state_26900__$1;
(statearr_26919_26969[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (29))){
var state_26900__$1 = state_26900;
var statearr_26920_26970 = state_26900__$1;
(statearr_26920_26970[(2)] = null);

(statearr_26920_26970[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (6))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_26900,(5),Error,null,(4));
var inst_26834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26835 = [ch_recv,ch_ctrl];
var inst_26836 = (new cljs.core.PersistentVector(null,2,(5),inst_26834,inst_26835,null));
var state_26900__$1 = state_26900;
return cljs.core.async.ioc_alts_BANG_(state_26900__$1,(7),inst_26836);
} else {
if((state_val_26901 === (28))){
var inst_26884 = (state_26900[(2)]);
var state_26900__$1 = (function (){var statearr_26921 = state_26900;
(statearr_26921[(10)] = inst_26884);

return statearr_26921;
})();
var statearr_26922_26971 = state_26900__$1;
(statearr_26922_26971[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception(state_26900__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (25))){
var inst_26865 = (state_26900[(8)]);
var inst_26876 = (state_26900[(2)]);
var inst_26877 = taoensso.sente.event_msg_QMARK_(inst_26865);
var inst_26878 = cljs.core.not(inst_26877);
var state_26900__$1 = (function (){var statearr_26923 = state_26900;
(statearr_26923[(11)] = inst_26876);

return statearr_26923;
})();
if(inst_26878){
var statearr_26924_26972 = state_26900__$1;
(statearr_26924_26972[(1)] = (26));

} else {
var statearr_26925_26973 = state_26900__$1;
(statearr_26925_26973[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (17))){
var inst_26839 = (state_26900[(7)]);
var inst_26862 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_26839);
var state_26900__$1 = state_26900;
var statearr_26926_26974 = state_26900__$1;
(statearr_26926_26974[(2)] = inst_26862);

(statearr_26926_26974[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (3))){
var inst_26898 = (state_26900[(2)]);
var state_26900__$1 = state_26900;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26900__$1,inst_26898);
} else {
if((state_val_26901 === (12))){
var state_26900__$1 = state_26900;
var statearr_26927_26975 = state_26900__$1;
(statearr_26927_26975[(2)] = false);

(statearr_26927_26975[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (2))){
var state_26900__$1 = state_26900;
var statearr_26928_26976 = state_26900__$1;
(statearr_26928_26976[(2)] = null);

(statearr_26928_26976[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (23))){
var inst_26866 = (state_26900[(9)]);
var inst_26873 = taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic("Pre-handler event: %s",cljs.core.array_seq([inst_26866], 0));
var state_26900__$1 = state_26900;
var statearr_26929_26977 = state_26900__$1;
(statearr_26929_26977[(2)] = inst_26873);

(statearr_26929_26977[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (19))){
var inst_26865 = (state_26900[(8)]);
var inst_26865__$1 = (state_26900[(2)]);
var inst_26866 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26865__$1,cljs.core.cst$kw$event);
var state_26900__$1 = (function (){var statearr_26930 = state_26900;
(statearr_26930[(8)] = inst_26865__$1);

(statearr_26930[(9)] = inst_26866);

return statearr_26930;
})();
var statearr_26931_26978 = state_26900__$1;
(statearr_26931_26978[(2)] = null);

(statearr_26931_26978[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (11))){
var inst_26839 = (state_26900[(7)]);
var inst_26849 = inst_26839.cljs$lang$protocol_mask$partition0$;
var inst_26850 = (inst_26849 & (64));
var inst_26851 = inst_26839.cljs$core$ISeq$;
var inst_26852 = (cljs.core.PROTOCOL_SENTINEL === inst_26851);
var inst_26853 = (inst_26850) || (inst_26852);
var state_26900__$1 = state_26900;
if(cljs.core.truth_(inst_26853)){
var statearr_26932_26979 = state_26900__$1;
(statearr_26932_26979[(1)] = (14));

} else {
var statearr_26933_26980 = state_26900__$1;
(statearr_26933_26980[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (9))){
var inst_26839 = (state_26900[(7)]);
var inst_26846 = (inst_26839 == null);
var inst_26847 = cljs.core.not(inst_26846);
var state_26900__$1 = state_26900;
if(inst_26847){
var statearr_26934_26981 = state_26900__$1;
(statearr_26934_26981[(1)] = (11));

} else {
var statearr_26935_26982 = state_26900__$1;
(statearr_26935_26982[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (5))){
var inst_26826 = (state_26900[(2)]);
var inst_26827 = taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic("Chsk router channel error (%s)!",cljs.core.array_seq([inst_26826], 0));
var state_26900__$1 = state_26900;
var statearr_26936_26983 = state_26900__$1;
(statearr_26936_26983[(2)] = inst_26827);


cljs.core.async.impl.ioc_helpers.process_exception(state_26900__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (14))){
var state_26900__$1 = state_26900;
var statearr_26937_26984 = state_26900__$1;
(statearr_26937_26984[(2)] = true);

(statearr_26937_26984[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (26))){
var inst_26866 = (state_26900[(9)]);
var inst_26880 = taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic("Bad event: %s",cljs.core.array_seq([inst_26866], 0));
var state_26900__$1 = state_26900;
var statearr_26938_26985 = state_26900__$1;
(statearr_26938_26985[(2)] = inst_26880);

(statearr_26938_26985[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (16))){
var inst_26857 = (state_26900[(2)]);
var state_26900__$1 = state_26900;
var statearr_26939_26986 = state_26900__$1;
(statearr_26939_26986[(2)] = inst_26857);

(statearr_26939_26986[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (30))){
var state_26900__$1 = state_26900;
var statearr_26940_26987 = state_26900__$1;
(statearr_26940_26987[(2)] = null);

(statearr_26940_26987[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (10))){
var inst_26888 = (state_26900[(2)]);
var state_26900__$1 = state_26900;
var statearr_26941_26988 = state_26900__$1;
(statearr_26941_26988[(2)] = inst_26888);


cljs.core.async.impl.ioc_helpers.process_exception(state_26900__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (18))){
var inst_26839 = (state_26900[(7)]);
var state_26900__$1 = state_26900;
var statearr_26942_26989 = state_26900__$1;
(statearr_26942_26989[(2)] = inst_26839);

(statearr_26942_26989[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26901 === (8))){
var state_26900__$1 = state_26900;
var statearr_26943_26990 = state_26900__$1;
(statearr_26943_26990[(2)] = cljs.core.cst$kw$taoensso$sente_SLASH_stop);

(statearr_26943_26990[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___26954,ch_ctrl,vec__26820,map__26823,map__26823__$1,opts,trace_evs_QMARK_))
;
return ((function (switch__14927__auto__,c__15051__auto___26954,ch_ctrl,vec__26820,map__26823,map__26823__$1,opts,trace_evs_QMARK_){
return (function() {
var taoensso$sente$state_machine__14928__auto__ = null;
var taoensso$sente$state_machine__14928__auto____0 = (function (){
var statearr_26947 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26947[(0)] = taoensso$sente$state_machine__14928__auto__);

(statearr_26947[(1)] = (1));

return statearr_26947;
});
var taoensso$sente$state_machine__14928__auto____1 = (function (state_26900){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_26900);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e26948){if((e26948 instanceof Object)){
var ex__14931__auto__ = e26948;
var statearr_26949_26991 = state_26900;
(statearr_26949_26991[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_26900);

return cljs.core.cst$kw$recur;
} else {
throw e26948;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__26992 = state_26900;
state_26900 = G__26992;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
taoensso$sente$state_machine__14928__auto__ = function(state_26900){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__14928__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__14928__auto____1.call(this,state_26900);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
taoensso$sente$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__14928__auto____0;
taoensso$sente$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__14928__auto____1;
return taoensso$sente$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___26954,ch_ctrl,vec__26820,map__26823,map__26823__$1,opts,trace_evs_QMARK_))
})();
var state__15053__auto__ = (function (){var statearr_26950 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_26950[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___26954);

return statearr_26950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___26954,ch_ctrl,vec__26820,map__26823,map__26823__$1,opts,trace_evs_QMARK_))
);


return ((function (ch_ctrl,vec__26820,map__26823,map__26823__$1,opts,trace_evs_QMARK_){
return (function taoensso$sente$stop_BANG_(){
return cljs.core.async.close_BANG_(ch_ctrl);
});
;})(ch_ctrl,vec__26820,map__26823,map__26823__$1,opts,trace_evs_QMARK_))
});

taoensso.sente.start_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

taoensso.sente.start_chsk_router_BANG_.cljs$lang$applyTo = (function (seq26816){
var G__26817 = cljs.core.first(seq26816);
var seq26816__$1 = cljs.core.next(seq26816);
var G__26818 = cljs.core.first(seq26816__$1);
var seq26816__$2 = cljs.core.next(seq26816__$1);
return taoensso.sente.start_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26817,G__26818,seq26816__$2);
});

/**
 * DEPRECATED: Please use `start-chsk-router!` instead.
 */
taoensso.sente.start_chsk_router_loop_BANG_ = (function taoensso$sente$start_chsk_router_loop_BANG_(event_handler,ch_recv){
return taoensso.sente.start_chsk_router_BANG_(ch_recv,(function (ev_msg){
var G__26995 = cljs.core.cst$kw$event.cljs$core$IFn$_invoke$arity$1(ev_msg);
var G__26996 = cljs.core.cst$kw$ch_DASH_recv.cljs$core$IFn$_invoke$arity$1(ev_msg);
return (event_handler.cljs$core$IFn$_invoke$arity$2 ? event_handler.cljs$core$IFn$_invoke$arity$2(G__26995,G__26996) : event_handler.call(null,G__26995,G__26996));
}));
});
