// Compiled by ClojureScript 1.9.518 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async15099 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15099 = (function (f,meta15100){
this.f = f;
this.meta15100 = meta15100;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15099.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15101,meta15100__$1){
var self__ = this;
var _15101__$1 = this;
return (new cljs.core.async.t_cljs$core$async15099(self__.f,meta15100__$1));
});

cljs.core.async.t_cljs$core$async15099.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15101){
var self__ = this;
var _15101__$1 = this;
return self__.meta15100;
});

cljs.core.async.t_cljs$core$async15099.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15099.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async15099.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async15099.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$meta15100], null);
});

cljs.core.async.t_cljs$core$async15099.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15099.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15099";

cljs.core.async.t_cljs$core$async15099.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async15099");
});

cljs.core.async.__GT_t_cljs$core$async15099 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async15099(f__$1,meta15100){
return (new cljs.core.async.t_cljs$core$async15099(f__$1,meta15100));
});

}

return (new cljs.core.async.t_cljs$core$async15099(f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args15104 = [];
var len__8402__auto___15107 = arguments.length;
var i__8403__auto___15108 = (0);
while(true){
if((i__8403__auto___15108 < len__8402__auto___15107)){
args15104.push((arguments[i__8403__auto___15108]));

var G__15109 = (i__8403__auto___15108 + (1));
i__8403__auto___15108 = G__15109;
continue;
} else {
}
break;
}

var G__15106 = args15104.length;
switch (G__15106) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15104.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args15111 = [];
var len__8402__auto___15114 = arguments.length;
var i__8403__auto___15115 = (0);
while(true){
if((i__8403__auto___15115 < len__8402__auto___15114)){
args15111.push((arguments[i__8403__auto___15115]));

var G__15116 = (i__8403__auto___15115 + (1));
i__8403__auto___15115 = G__15116;
continue;
} else {
}
break;
}

var G__15113 = args15111.length;
switch (G__15113) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15111.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_15118 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_15118) : fn1.call(null,val_15118));
} else {
cljs.core.async.impl.dispatch.run(((function (val_15118,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_15118) : fn1.call(null,val_15118));
});})(val_15118,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args15119 = [];
var len__8402__auto___15122 = arguments.length;
var i__8403__auto___15123 = (0);
while(true){
if((i__8403__auto___15123 < len__8402__auto___15122)){
args15119.push((arguments[i__8403__auto___15123]));

var G__15124 = (i__8403__auto___15123 + (1));
i__8403__auto___15123 = G__15124;
continue;
} else {
}
break;
}

var G__15121 = args15119.length;
switch (G__15121) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15119.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8212__auto___15126 = n;
var x_15127 = (0);
while(true){
if((x_15127 < n__8212__auto___15126)){
(a[x_15127] = (0));

var G__15128 = (x_15127 + (1));
x_15127 = G__15128;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__15129 = (i + (1));
i = G__15129;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async15133 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15133 = (function (flag,meta15134){
this.flag = flag;
this.meta15134 = meta15134;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15133.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_15135,meta15134__$1){
var self__ = this;
var _15135__$1 = this;
return (new cljs.core.async.t_cljs$core$async15133(self__.flag,meta15134__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async15133.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_15135){
var self__ = this;
var _15135__$1 = this;
return self__.meta15134;
});})(flag))
;

cljs.core.async.t_cljs$core$async15133.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15133.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async15133.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async15133.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta15134], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async15133.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15133.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15133";

cljs.core.async.t_cljs$core$async15133.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async15133");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async15133 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async15133(flag__$1,meta15134){
return (new cljs.core.async.t_cljs$core$async15133(flag__$1,meta15134));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async15133(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async15139 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15139 = (function (flag,cb,meta15140){
this.flag = flag;
this.cb = cb;
this.meta15140 = meta15140;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15139.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15141,meta15140__$1){
var self__ = this;
var _15141__$1 = this;
return (new cljs.core.async.t_cljs$core$async15139(self__.flag,self__.cb,meta15140__$1));
});

cljs.core.async.t_cljs$core$async15139.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15141){
var self__ = this;
var _15141__$1 = this;
return self__.meta15140;
});

cljs.core.async.t_cljs$core$async15139.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15139.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async15139.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async15139.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta15140], null);
});

cljs.core.async.t_cljs$core$async15139.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15139.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15139";

cljs.core.async.t_cljs$core$async15139.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async15139");
});

cljs.core.async.__GT_t_cljs$core$async15139 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async15139(flag__$1,cb__$1,meta15140){
return (new cljs.core.async.t_cljs$core$async15139(flag__$1,cb__$1,meta15140));
});

}

return (new cljs.core.async.t_cljs$core$async15139(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__15142_SHARP_){
var G__15146 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__15142_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__15146) : fret.call(null,G__15146));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__15143_SHARP_){
var G__15147 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__15143_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__15147) : fret.call(null,G__15147));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__7289__auto__ = wport;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return port;
}
})()], null));
} else {
var G__15148 = (i + (1));
i = G__15148;
continue;
}
} else {
return null;
}
break;
}
})();
var or__7289__auto__ = ret;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__7277__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__7277__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___15154 = arguments.length;
var i__8403__auto___15155 = (0);
while(true){
if((i__8403__auto___15155 < len__8402__auto___15154)){
args__8409__auto__.push((arguments[i__8403__auto___15155]));

var G__15156 = (i__8403__auto___15155 + (1));
i__8403__auto___15155 = G__15156;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__15151){
var map__15152 = p__15151;
var map__15152__$1 = ((((!((map__15152 == null)))?((((map__15152.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15152.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15152):map__15152);
var opts = map__15152__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq15149){
var G__15150 = cljs.core.first(seq15149);
var seq15149__$1 = cljs.core.next(seq15149);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15150,seq15149__$1);
});

/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args15157 = [];
var len__8402__auto___15207 = arguments.length;
var i__8403__auto___15208 = (0);
while(true){
if((i__8403__auto___15208 < len__8402__auto___15207)){
args15157.push((arguments[i__8403__auto___15208]));

var G__15209 = (i__8403__auto___15208 + (1));
i__8403__auto___15208 = G__15209;
continue;
} else {
}
break;
}

var G__15159 = args15157.length;
switch (G__15159) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15157.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__15051__auto___15211 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___15211){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___15211){
return (function (state_15183){
var state_val_15184 = (state_15183[(1)]);
if((state_val_15184 === (7))){
var inst_15179 = (state_15183[(2)]);
var state_15183__$1 = state_15183;
var statearr_15185_15212 = state_15183__$1;
(statearr_15185_15212[(2)] = inst_15179);

(statearr_15185_15212[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15184 === (1))){
var state_15183__$1 = state_15183;
var statearr_15186_15213 = state_15183__$1;
(statearr_15186_15213[(2)] = null);

(statearr_15186_15213[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15184 === (4))){
var inst_15162 = (state_15183[(7)]);
var inst_15162__$1 = (state_15183[(2)]);
var inst_15163 = (inst_15162__$1 == null);
var state_15183__$1 = (function (){var statearr_15187 = state_15183;
(statearr_15187[(7)] = inst_15162__$1);

return statearr_15187;
})();
if(cljs.core.truth_(inst_15163)){
var statearr_15188_15214 = state_15183__$1;
(statearr_15188_15214[(1)] = (5));

} else {
var statearr_15189_15215 = state_15183__$1;
(statearr_15189_15215[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15184 === (13))){
var state_15183__$1 = state_15183;
var statearr_15190_15216 = state_15183__$1;
(statearr_15190_15216[(2)] = null);

(statearr_15190_15216[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15184 === (6))){
var inst_15162 = (state_15183[(7)]);
var state_15183__$1 = state_15183;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15183__$1,(11),to,inst_15162);
} else {
if((state_val_15184 === (3))){
var inst_15181 = (state_15183[(2)]);
var state_15183__$1 = state_15183;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15183__$1,inst_15181);
} else {
if((state_val_15184 === (12))){
var state_15183__$1 = state_15183;
var statearr_15191_15217 = state_15183__$1;
(statearr_15191_15217[(2)] = null);

(statearr_15191_15217[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15184 === (2))){
var state_15183__$1 = state_15183;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15183__$1,(4),from);
} else {
if((state_val_15184 === (11))){
var inst_15172 = (state_15183[(2)]);
var state_15183__$1 = state_15183;
if(cljs.core.truth_(inst_15172)){
var statearr_15192_15218 = state_15183__$1;
(statearr_15192_15218[(1)] = (12));

} else {
var statearr_15193_15219 = state_15183__$1;
(statearr_15193_15219[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15184 === (9))){
var state_15183__$1 = state_15183;
var statearr_15194_15220 = state_15183__$1;
(statearr_15194_15220[(2)] = null);

(statearr_15194_15220[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15184 === (5))){
var state_15183__$1 = state_15183;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15195_15221 = state_15183__$1;
(statearr_15195_15221[(1)] = (8));

} else {
var statearr_15196_15222 = state_15183__$1;
(statearr_15196_15222[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15184 === (14))){
var inst_15177 = (state_15183[(2)]);
var state_15183__$1 = state_15183;
var statearr_15197_15223 = state_15183__$1;
(statearr_15197_15223[(2)] = inst_15177);

(statearr_15197_15223[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15184 === (10))){
var inst_15169 = (state_15183[(2)]);
var state_15183__$1 = state_15183;
var statearr_15198_15224 = state_15183__$1;
(statearr_15198_15224[(2)] = inst_15169);

(statearr_15198_15224[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15184 === (8))){
var inst_15166 = cljs.core.async.close_BANG_(to);
var state_15183__$1 = state_15183;
var statearr_15199_15225 = state_15183__$1;
(statearr_15199_15225[(2)] = inst_15166);

(statearr_15199_15225[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___15211))
;
return ((function (switch__14927__auto__,c__15051__auto___15211){
return (function() {
var cljs$core$async$state_machine__14928__auto__ = null;
var cljs$core$async$state_machine__14928__auto____0 = (function (){
var statearr_15203 = [null,null,null,null,null,null,null,null];
(statearr_15203[(0)] = cljs$core$async$state_machine__14928__auto__);

(statearr_15203[(1)] = (1));

return statearr_15203;
});
var cljs$core$async$state_machine__14928__auto____1 = (function (state_15183){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_15183);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e15204){if((e15204 instanceof Object)){
var ex__14931__auto__ = e15204;
var statearr_15205_15226 = state_15183;
(statearr_15205_15226[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15183);

return cljs.core.cst$kw$recur;
} else {
throw e15204;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__15227 = state_15183;
state_15183 = G__15227;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$state_machine__14928__auto__ = function(state_15183){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14928__auto____1.call(this,state_15183);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14928__auto____0;
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14928__auto____1;
return cljs$core$async$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___15211))
})();
var state__15053__auto__ = (function (){var statearr_15206 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_15206[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___15211);

return statearr_15206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___15211))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__15415){
var vec__15416 = p__15415;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15416,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15416,(1),null);
var job = vec__15416;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__15051__auto___15602 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___15602,res,vec__15416,v,p,job,jobs,results){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___15602,res,vec__15416,v,p,job,jobs,results){
return (function (state_15423){
var state_val_15424 = (state_15423[(1)]);
if((state_val_15424 === (1))){
var state_15423__$1 = state_15423;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15423__$1,(2),res,v);
} else {
if((state_val_15424 === (2))){
var inst_15420 = (state_15423[(2)]);
var inst_15421 = cljs.core.async.close_BANG_(res);
var state_15423__$1 = (function (){var statearr_15425 = state_15423;
(statearr_15425[(7)] = inst_15420);

return statearr_15425;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_15423__$1,inst_15421);
} else {
return null;
}
}
});})(c__15051__auto___15602,res,vec__15416,v,p,job,jobs,results))
;
return ((function (switch__14927__auto__,c__15051__auto___15602,res,vec__15416,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0 = (function (){
var statearr_15429 = [null,null,null,null,null,null,null,null];
(statearr_15429[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__);

(statearr_15429[(1)] = (1));

return statearr_15429;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1 = (function (state_15423){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_15423);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e15430){if((e15430 instanceof Object)){
var ex__14931__auto__ = e15430;
var statearr_15431_15603 = state_15423;
(statearr_15431_15603[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15423);

return cljs.core.cst$kw$recur;
} else {
throw e15430;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__15604 = state_15423;
state_15423 = G__15604;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__ = function(state_15423){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1.call(this,state_15423);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___15602,res,vec__15416,v,p,job,jobs,results))
})();
var state__15053__auto__ = (function (){var statearr_15432 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_15432[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___15602);

return statearr_15432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___15602,res,vec__15416,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__15433){
var vec__15434 = p__15433;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15434,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15434,(1),null);
var job = vec__15434;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__8212__auto___15605 = n;
var __15606 = (0);
while(true){
if((__15606 < n__8212__auto___15605)){
var G__15437_15607 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__15437_15607) {
case "compute":
var c__15051__auto___15609 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15606,c__15051__auto___15609,G__15437_15607,n__8212__auto___15605,jobs,results,process,async){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (__15606,c__15051__auto___15609,G__15437_15607,n__8212__auto___15605,jobs,results,process,async){
return (function (state_15450){
var state_val_15451 = (state_15450[(1)]);
if((state_val_15451 === (1))){
var state_15450__$1 = state_15450;
var statearr_15452_15610 = state_15450__$1;
(statearr_15452_15610[(2)] = null);

(statearr_15452_15610[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15451 === (2))){
var state_15450__$1 = state_15450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15450__$1,(4),jobs);
} else {
if((state_val_15451 === (3))){
var inst_15448 = (state_15450[(2)]);
var state_15450__$1 = state_15450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15450__$1,inst_15448);
} else {
if((state_val_15451 === (4))){
var inst_15440 = (state_15450[(2)]);
var inst_15441 = process(inst_15440);
var state_15450__$1 = state_15450;
if(cljs.core.truth_(inst_15441)){
var statearr_15453_15611 = state_15450__$1;
(statearr_15453_15611[(1)] = (5));

} else {
var statearr_15454_15612 = state_15450__$1;
(statearr_15454_15612[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15451 === (5))){
var state_15450__$1 = state_15450;
var statearr_15455_15613 = state_15450__$1;
(statearr_15455_15613[(2)] = null);

(statearr_15455_15613[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15451 === (6))){
var state_15450__$1 = state_15450;
var statearr_15456_15614 = state_15450__$1;
(statearr_15456_15614[(2)] = null);

(statearr_15456_15614[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15451 === (7))){
var inst_15446 = (state_15450[(2)]);
var state_15450__$1 = state_15450;
var statearr_15457_15615 = state_15450__$1;
(statearr_15457_15615[(2)] = inst_15446);

(statearr_15457_15615[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__15606,c__15051__auto___15609,G__15437_15607,n__8212__auto___15605,jobs,results,process,async))
;
return ((function (__15606,switch__14927__auto__,c__15051__auto___15609,G__15437_15607,n__8212__auto___15605,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0 = (function (){
var statearr_15461 = [null,null,null,null,null,null,null];
(statearr_15461[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__);

(statearr_15461[(1)] = (1));

return statearr_15461;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1 = (function (state_15450){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_15450);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e15462){if((e15462 instanceof Object)){
var ex__14931__auto__ = e15462;
var statearr_15463_15616 = state_15450;
(statearr_15463_15616[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15450);

return cljs.core.cst$kw$recur;
} else {
throw e15462;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__15617 = state_15450;
state_15450 = G__15617;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__ = function(state_15450){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1.call(this,state_15450);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__;
})()
;})(__15606,switch__14927__auto__,c__15051__auto___15609,G__15437_15607,n__8212__auto___15605,jobs,results,process,async))
})();
var state__15053__auto__ = (function (){var statearr_15464 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_15464[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___15609);

return statearr_15464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(__15606,c__15051__auto___15609,G__15437_15607,n__8212__auto___15605,jobs,results,process,async))
);


break;
case "async":
var c__15051__auto___15618 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15606,c__15051__auto___15618,G__15437_15607,n__8212__auto___15605,jobs,results,process,async){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (__15606,c__15051__auto___15618,G__15437_15607,n__8212__auto___15605,jobs,results,process,async){
return (function (state_15477){
var state_val_15478 = (state_15477[(1)]);
if((state_val_15478 === (1))){
var state_15477__$1 = state_15477;
var statearr_15479_15619 = state_15477__$1;
(statearr_15479_15619[(2)] = null);

(statearr_15479_15619[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (2))){
var state_15477__$1 = state_15477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15477__$1,(4),jobs);
} else {
if((state_val_15478 === (3))){
var inst_15475 = (state_15477[(2)]);
var state_15477__$1 = state_15477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15477__$1,inst_15475);
} else {
if((state_val_15478 === (4))){
var inst_15467 = (state_15477[(2)]);
var inst_15468 = async(inst_15467);
var state_15477__$1 = state_15477;
if(cljs.core.truth_(inst_15468)){
var statearr_15480_15620 = state_15477__$1;
(statearr_15480_15620[(1)] = (5));

} else {
var statearr_15481_15621 = state_15477__$1;
(statearr_15481_15621[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (5))){
var state_15477__$1 = state_15477;
var statearr_15482_15622 = state_15477__$1;
(statearr_15482_15622[(2)] = null);

(statearr_15482_15622[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (6))){
var state_15477__$1 = state_15477;
var statearr_15483_15623 = state_15477__$1;
(statearr_15483_15623[(2)] = null);

(statearr_15483_15623[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (7))){
var inst_15473 = (state_15477[(2)]);
var state_15477__$1 = state_15477;
var statearr_15484_15624 = state_15477__$1;
(statearr_15484_15624[(2)] = inst_15473);

(statearr_15484_15624[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__15606,c__15051__auto___15618,G__15437_15607,n__8212__auto___15605,jobs,results,process,async))
;
return ((function (__15606,switch__14927__auto__,c__15051__auto___15618,G__15437_15607,n__8212__auto___15605,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0 = (function (){
var statearr_15488 = [null,null,null,null,null,null,null];
(statearr_15488[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__);

(statearr_15488[(1)] = (1));

return statearr_15488;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1 = (function (state_15477){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_15477);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e15489){if((e15489 instanceof Object)){
var ex__14931__auto__ = e15489;
var statearr_15490_15625 = state_15477;
(statearr_15490_15625[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15477);

return cljs.core.cst$kw$recur;
} else {
throw e15489;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__15626 = state_15477;
state_15477 = G__15626;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__ = function(state_15477){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1.call(this,state_15477);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__;
})()
;})(__15606,switch__14927__auto__,c__15051__auto___15618,G__15437_15607,n__8212__auto___15605,jobs,results,process,async))
})();
var state__15053__auto__ = (function (){var statearr_15491 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_15491[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___15618);

return statearr_15491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(__15606,c__15051__auto___15618,G__15437_15607,n__8212__auto___15605,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__15627 = (__15606 + (1));
__15606 = G__15627;
continue;
} else {
}
break;
}

var c__15051__auto___15628 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___15628,jobs,results,process,async){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___15628,jobs,results,process,async){
return (function (state_15513){
var state_val_15514 = (state_15513[(1)]);
if((state_val_15514 === (1))){
var state_15513__$1 = state_15513;
var statearr_15515_15629 = state_15513__$1;
(statearr_15515_15629[(2)] = null);

(statearr_15515_15629[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15514 === (2))){
var state_15513__$1 = state_15513;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15513__$1,(4),from);
} else {
if((state_val_15514 === (3))){
var inst_15511 = (state_15513[(2)]);
var state_15513__$1 = state_15513;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15513__$1,inst_15511);
} else {
if((state_val_15514 === (4))){
var inst_15494 = (state_15513[(7)]);
var inst_15494__$1 = (state_15513[(2)]);
var inst_15495 = (inst_15494__$1 == null);
var state_15513__$1 = (function (){var statearr_15516 = state_15513;
(statearr_15516[(7)] = inst_15494__$1);

return statearr_15516;
})();
if(cljs.core.truth_(inst_15495)){
var statearr_15517_15630 = state_15513__$1;
(statearr_15517_15630[(1)] = (5));

} else {
var statearr_15518_15631 = state_15513__$1;
(statearr_15518_15631[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15514 === (5))){
var inst_15497 = cljs.core.async.close_BANG_(jobs);
var state_15513__$1 = state_15513;
var statearr_15519_15632 = state_15513__$1;
(statearr_15519_15632[(2)] = inst_15497);

(statearr_15519_15632[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15514 === (6))){
var inst_15499 = (state_15513[(8)]);
var inst_15494 = (state_15513[(7)]);
var inst_15499__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_15500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15501 = [inst_15494,inst_15499__$1];
var inst_15502 = (new cljs.core.PersistentVector(null,2,(5),inst_15500,inst_15501,null));
var state_15513__$1 = (function (){var statearr_15520 = state_15513;
(statearr_15520[(8)] = inst_15499__$1);

return statearr_15520;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15513__$1,(8),jobs,inst_15502);
} else {
if((state_val_15514 === (7))){
var inst_15509 = (state_15513[(2)]);
var state_15513__$1 = state_15513;
var statearr_15521_15633 = state_15513__$1;
(statearr_15521_15633[(2)] = inst_15509);

(statearr_15521_15633[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15514 === (8))){
var inst_15499 = (state_15513[(8)]);
var inst_15504 = (state_15513[(2)]);
var state_15513__$1 = (function (){var statearr_15522 = state_15513;
(statearr_15522[(9)] = inst_15504);

return statearr_15522;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15513__$1,(9),results,inst_15499);
} else {
if((state_val_15514 === (9))){
var inst_15506 = (state_15513[(2)]);
var state_15513__$1 = (function (){var statearr_15523 = state_15513;
(statearr_15523[(10)] = inst_15506);

return statearr_15523;
})();
var statearr_15524_15634 = state_15513__$1;
(statearr_15524_15634[(2)] = null);

(statearr_15524_15634[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___15628,jobs,results,process,async))
;
return ((function (switch__14927__auto__,c__15051__auto___15628,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0 = (function (){
var statearr_15528 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15528[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__);

(statearr_15528[(1)] = (1));

return statearr_15528;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1 = (function (state_15513){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_15513);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e15529){if((e15529 instanceof Object)){
var ex__14931__auto__ = e15529;
var statearr_15530_15635 = state_15513;
(statearr_15530_15635[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15513);

return cljs.core.cst$kw$recur;
} else {
throw e15529;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__15636 = state_15513;
state_15513 = G__15636;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__ = function(state_15513){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1.call(this,state_15513);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___15628,jobs,results,process,async))
})();
var state__15053__auto__ = (function (){var statearr_15531 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_15531[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___15628);

return statearr_15531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___15628,jobs,results,process,async))
);


var c__15051__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto__,jobs,results,process,async){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto__,jobs,results,process,async){
return (function (state_15569){
var state_val_15570 = (state_15569[(1)]);
if((state_val_15570 === (7))){
var inst_15565 = (state_15569[(2)]);
var state_15569__$1 = state_15569;
var statearr_15571_15637 = state_15569__$1;
(statearr_15571_15637[(2)] = inst_15565);

(statearr_15571_15637[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (20))){
var state_15569__$1 = state_15569;
var statearr_15572_15638 = state_15569__$1;
(statearr_15572_15638[(2)] = null);

(statearr_15572_15638[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (1))){
var state_15569__$1 = state_15569;
var statearr_15573_15639 = state_15569__$1;
(statearr_15573_15639[(2)] = null);

(statearr_15573_15639[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (4))){
var inst_15534 = (state_15569[(7)]);
var inst_15534__$1 = (state_15569[(2)]);
var inst_15535 = (inst_15534__$1 == null);
var state_15569__$1 = (function (){var statearr_15574 = state_15569;
(statearr_15574[(7)] = inst_15534__$1);

return statearr_15574;
})();
if(cljs.core.truth_(inst_15535)){
var statearr_15575_15640 = state_15569__$1;
(statearr_15575_15640[(1)] = (5));

} else {
var statearr_15576_15641 = state_15569__$1;
(statearr_15576_15641[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (15))){
var inst_15547 = (state_15569[(8)]);
var state_15569__$1 = state_15569;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15569__$1,(18),to,inst_15547);
} else {
if((state_val_15570 === (21))){
var inst_15560 = (state_15569[(2)]);
var state_15569__$1 = state_15569;
var statearr_15577_15642 = state_15569__$1;
(statearr_15577_15642[(2)] = inst_15560);

(statearr_15577_15642[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (13))){
var inst_15562 = (state_15569[(2)]);
var state_15569__$1 = (function (){var statearr_15578 = state_15569;
(statearr_15578[(9)] = inst_15562);

return statearr_15578;
})();
var statearr_15579_15643 = state_15569__$1;
(statearr_15579_15643[(2)] = null);

(statearr_15579_15643[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (6))){
var inst_15534 = (state_15569[(7)]);
var state_15569__$1 = state_15569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15569__$1,(11),inst_15534);
} else {
if((state_val_15570 === (17))){
var inst_15555 = (state_15569[(2)]);
var state_15569__$1 = state_15569;
if(cljs.core.truth_(inst_15555)){
var statearr_15580_15644 = state_15569__$1;
(statearr_15580_15644[(1)] = (19));

} else {
var statearr_15581_15645 = state_15569__$1;
(statearr_15581_15645[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (3))){
var inst_15567 = (state_15569[(2)]);
var state_15569__$1 = state_15569;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15569__$1,inst_15567);
} else {
if((state_val_15570 === (12))){
var inst_15544 = (state_15569[(10)]);
var state_15569__$1 = state_15569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15569__$1,(14),inst_15544);
} else {
if((state_val_15570 === (2))){
var state_15569__$1 = state_15569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15569__$1,(4),results);
} else {
if((state_val_15570 === (19))){
var state_15569__$1 = state_15569;
var statearr_15582_15646 = state_15569__$1;
(statearr_15582_15646[(2)] = null);

(statearr_15582_15646[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (11))){
var inst_15544 = (state_15569[(2)]);
var state_15569__$1 = (function (){var statearr_15583 = state_15569;
(statearr_15583[(10)] = inst_15544);

return statearr_15583;
})();
var statearr_15584_15647 = state_15569__$1;
(statearr_15584_15647[(2)] = null);

(statearr_15584_15647[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (9))){
var state_15569__$1 = state_15569;
var statearr_15585_15648 = state_15569__$1;
(statearr_15585_15648[(2)] = null);

(statearr_15585_15648[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (5))){
var state_15569__$1 = state_15569;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15586_15649 = state_15569__$1;
(statearr_15586_15649[(1)] = (8));

} else {
var statearr_15587_15650 = state_15569__$1;
(statearr_15587_15650[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (14))){
var inst_15549 = (state_15569[(11)]);
var inst_15547 = (state_15569[(8)]);
var inst_15547__$1 = (state_15569[(2)]);
var inst_15548 = (inst_15547__$1 == null);
var inst_15549__$1 = cljs.core.not(inst_15548);
var state_15569__$1 = (function (){var statearr_15588 = state_15569;
(statearr_15588[(11)] = inst_15549__$1);

(statearr_15588[(8)] = inst_15547__$1);

return statearr_15588;
})();
if(inst_15549__$1){
var statearr_15589_15651 = state_15569__$1;
(statearr_15589_15651[(1)] = (15));

} else {
var statearr_15590_15652 = state_15569__$1;
(statearr_15590_15652[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (16))){
var inst_15549 = (state_15569[(11)]);
var state_15569__$1 = state_15569;
var statearr_15591_15653 = state_15569__$1;
(statearr_15591_15653[(2)] = inst_15549);

(statearr_15591_15653[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (10))){
var inst_15541 = (state_15569[(2)]);
var state_15569__$1 = state_15569;
var statearr_15592_15654 = state_15569__$1;
(statearr_15592_15654[(2)] = inst_15541);

(statearr_15592_15654[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (18))){
var inst_15552 = (state_15569[(2)]);
var state_15569__$1 = state_15569;
var statearr_15593_15655 = state_15569__$1;
(statearr_15593_15655[(2)] = inst_15552);

(statearr_15593_15655[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15570 === (8))){
var inst_15538 = cljs.core.async.close_BANG_(to);
var state_15569__$1 = state_15569;
var statearr_15594_15656 = state_15569__$1;
(statearr_15594_15656[(2)] = inst_15538);

(statearr_15594_15656[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto__,jobs,results,process,async))
;
return ((function (switch__14927__auto__,c__15051__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0 = (function (){
var statearr_15598 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15598[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__);

(statearr_15598[(1)] = (1));

return statearr_15598;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1 = (function (state_15569){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_15569);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e15599){if((e15599 instanceof Object)){
var ex__14931__auto__ = e15599;
var statearr_15600_15657 = state_15569;
(statearr_15600_15657[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15569);

return cljs.core.cst$kw$recur;
} else {
throw e15599;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__15658 = state_15569;
state_15569 = G__15658;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__ = function(state_15569){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1.call(this,state_15569);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14928__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto__,jobs,results,process,async))
})();
var state__15053__auto__ = (function (){var statearr_15601 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_15601[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto__);

return statearr_15601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto__,jobs,results,process,async))
);

return c__15051__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args15659 = [];
var len__8402__auto___15662 = arguments.length;
var i__8403__auto___15663 = (0);
while(true){
if((i__8403__auto___15663 < len__8402__auto___15662)){
args15659.push((arguments[i__8403__auto___15663]));

var G__15664 = (i__8403__auto___15663 + (1));
i__8403__auto___15663 = G__15664;
continue;
} else {
}
break;
}

var G__15661 = args15659.length;
switch (G__15661) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15659.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args15666 = [];
var len__8402__auto___15669 = arguments.length;
var i__8403__auto___15670 = (0);
while(true){
if((i__8403__auto___15670 < len__8402__auto___15669)){
args15666.push((arguments[i__8403__auto___15670]));

var G__15671 = (i__8403__auto___15670 + (1));
i__8403__auto___15670 = G__15671;
continue;
} else {
}
break;
}

var G__15668 = args15666.length;
switch (G__15668) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15666.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args15673 = [];
var len__8402__auto___15726 = arguments.length;
var i__8403__auto___15727 = (0);
while(true){
if((i__8403__auto___15727 < len__8402__auto___15726)){
args15673.push((arguments[i__8403__auto___15727]));

var G__15728 = (i__8403__auto___15727 + (1));
i__8403__auto___15727 = G__15728;
continue;
} else {
}
break;
}

var G__15675 = args15673.length;
switch (G__15675) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15673.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__15051__auto___15730 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___15730,tc,fc){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___15730,tc,fc){
return (function (state_15701){
var state_val_15702 = (state_15701[(1)]);
if((state_val_15702 === (7))){
var inst_15697 = (state_15701[(2)]);
var state_15701__$1 = state_15701;
var statearr_15703_15731 = state_15701__$1;
(statearr_15703_15731[(2)] = inst_15697);

(statearr_15703_15731[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15702 === (1))){
var state_15701__$1 = state_15701;
var statearr_15704_15732 = state_15701__$1;
(statearr_15704_15732[(2)] = null);

(statearr_15704_15732[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15702 === (4))){
var inst_15678 = (state_15701[(7)]);
var inst_15678__$1 = (state_15701[(2)]);
var inst_15679 = (inst_15678__$1 == null);
var state_15701__$1 = (function (){var statearr_15705 = state_15701;
(statearr_15705[(7)] = inst_15678__$1);

return statearr_15705;
})();
if(cljs.core.truth_(inst_15679)){
var statearr_15706_15733 = state_15701__$1;
(statearr_15706_15733[(1)] = (5));

} else {
var statearr_15707_15734 = state_15701__$1;
(statearr_15707_15734[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15702 === (13))){
var state_15701__$1 = state_15701;
var statearr_15708_15735 = state_15701__$1;
(statearr_15708_15735[(2)] = null);

(statearr_15708_15735[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15702 === (6))){
var inst_15678 = (state_15701[(7)]);
var inst_15684 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_15678) : p.call(null,inst_15678));
var state_15701__$1 = state_15701;
if(cljs.core.truth_(inst_15684)){
var statearr_15709_15736 = state_15701__$1;
(statearr_15709_15736[(1)] = (9));

} else {
var statearr_15710_15737 = state_15701__$1;
(statearr_15710_15737[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15702 === (3))){
var inst_15699 = (state_15701[(2)]);
var state_15701__$1 = state_15701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15701__$1,inst_15699);
} else {
if((state_val_15702 === (12))){
var state_15701__$1 = state_15701;
var statearr_15711_15738 = state_15701__$1;
(statearr_15711_15738[(2)] = null);

(statearr_15711_15738[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15702 === (2))){
var state_15701__$1 = state_15701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15701__$1,(4),ch);
} else {
if((state_val_15702 === (11))){
var inst_15678 = (state_15701[(7)]);
var inst_15688 = (state_15701[(2)]);
var state_15701__$1 = state_15701;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15701__$1,(8),inst_15688,inst_15678);
} else {
if((state_val_15702 === (9))){
var state_15701__$1 = state_15701;
var statearr_15712_15739 = state_15701__$1;
(statearr_15712_15739[(2)] = tc);

(statearr_15712_15739[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15702 === (5))){
var inst_15681 = cljs.core.async.close_BANG_(tc);
var inst_15682 = cljs.core.async.close_BANG_(fc);
var state_15701__$1 = (function (){var statearr_15713 = state_15701;
(statearr_15713[(8)] = inst_15681);

return statearr_15713;
})();
var statearr_15714_15740 = state_15701__$1;
(statearr_15714_15740[(2)] = inst_15682);

(statearr_15714_15740[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15702 === (14))){
var inst_15695 = (state_15701[(2)]);
var state_15701__$1 = state_15701;
var statearr_15715_15741 = state_15701__$1;
(statearr_15715_15741[(2)] = inst_15695);

(statearr_15715_15741[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15702 === (10))){
var state_15701__$1 = state_15701;
var statearr_15716_15742 = state_15701__$1;
(statearr_15716_15742[(2)] = fc);

(statearr_15716_15742[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15702 === (8))){
var inst_15690 = (state_15701[(2)]);
var state_15701__$1 = state_15701;
if(cljs.core.truth_(inst_15690)){
var statearr_15717_15743 = state_15701__$1;
(statearr_15717_15743[(1)] = (12));

} else {
var statearr_15718_15744 = state_15701__$1;
(statearr_15718_15744[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___15730,tc,fc))
;
return ((function (switch__14927__auto__,c__15051__auto___15730,tc,fc){
return (function() {
var cljs$core$async$state_machine__14928__auto__ = null;
var cljs$core$async$state_machine__14928__auto____0 = (function (){
var statearr_15722 = [null,null,null,null,null,null,null,null,null];
(statearr_15722[(0)] = cljs$core$async$state_machine__14928__auto__);

(statearr_15722[(1)] = (1));

return statearr_15722;
});
var cljs$core$async$state_machine__14928__auto____1 = (function (state_15701){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_15701);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e15723){if((e15723 instanceof Object)){
var ex__14931__auto__ = e15723;
var statearr_15724_15745 = state_15701;
(statearr_15724_15745[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15701);

return cljs.core.cst$kw$recur;
} else {
throw e15723;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__15746 = state_15701;
state_15701 = G__15746;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$state_machine__14928__auto__ = function(state_15701){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14928__auto____1.call(this,state_15701);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14928__auto____0;
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14928__auto____1;
return cljs$core$async$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___15730,tc,fc))
})();
var state__15053__auto__ = (function (){var statearr_15725 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_15725[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___15730);

return statearr_15725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___15730,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__15051__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto__){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto__){
return (function (state_15793){
var state_val_15794 = (state_15793[(1)]);
if((state_val_15794 === (1))){
var inst_15779 = init;
var state_15793__$1 = (function (){var statearr_15795 = state_15793;
(statearr_15795[(7)] = inst_15779);

return statearr_15795;
})();
var statearr_15796_15811 = state_15793__$1;
(statearr_15796_15811[(2)] = null);

(statearr_15796_15811[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15794 === (2))){
var state_15793__$1 = state_15793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15793__$1,(4),ch);
} else {
if((state_val_15794 === (3))){
var inst_15791 = (state_15793[(2)]);
var state_15793__$1 = state_15793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15793__$1,inst_15791);
} else {
if((state_val_15794 === (4))){
var inst_15782 = (state_15793[(8)]);
var inst_15782__$1 = (state_15793[(2)]);
var inst_15783 = (inst_15782__$1 == null);
var state_15793__$1 = (function (){var statearr_15797 = state_15793;
(statearr_15797[(8)] = inst_15782__$1);

return statearr_15797;
})();
if(cljs.core.truth_(inst_15783)){
var statearr_15798_15812 = state_15793__$1;
(statearr_15798_15812[(1)] = (5));

} else {
var statearr_15799_15813 = state_15793__$1;
(statearr_15799_15813[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15794 === (5))){
var inst_15779 = (state_15793[(7)]);
var state_15793__$1 = state_15793;
var statearr_15800_15814 = state_15793__$1;
(statearr_15800_15814[(2)] = inst_15779);

(statearr_15800_15814[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15794 === (6))){
var inst_15782 = (state_15793[(8)]);
var inst_15779 = (state_15793[(7)]);
var inst_15786 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_15779,inst_15782) : f.call(null,inst_15779,inst_15782));
var inst_15779__$1 = inst_15786;
var state_15793__$1 = (function (){var statearr_15801 = state_15793;
(statearr_15801[(7)] = inst_15779__$1);

return statearr_15801;
})();
var statearr_15802_15815 = state_15793__$1;
(statearr_15802_15815[(2)] = null);

(statearr_15802_15815[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15794 === (7))){
var inst_15789 = (state_15793[(2)]);
var state_15793__$1 = state_15793;
var statearr_15803_15816 = state_15793__$1;
(statearr_15803_15816[(2)] = inst_15789);

(statearr_15803_15816[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__15051__auto__))
;
return ((function (switch__14927__auto__,c__15051__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14928__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14928__auto____0 = (function (){
var statearr_15807 = [null,null,null,null,null,null,null,null,null];
(statearr_15807[(0)] = cljs$core$async$reduce_$_state_machine__14928__auto__);

(statearr_15807[(1)] = (1));

return statearr_15807;
});
var cljs$core$async$reduce_$_state_machine__14928__auto____1 = (function (state_15793){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_15793);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e15808){if((e15808 instanceof Object)){
var ex__14931__auto__ = e15808;
var statearr_15809_15817 = state_15793;
(statearr_15809_15817[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15793);

return cljs.core.cst$kw$recur;
} else {
throw e15808;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__15818 = state_15793;
state_15793 = G__15818;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14928__auto__ = function(state_15793){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14928__auto____1.call(this,state_15793);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14928__auto____0;
cljs$core$async$reduce_$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14928__auto____1;
return cljs$core$async$reduce_$_state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto__))
})();
var state__15053__auto__ = (function (){var statearr_15810 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_15810[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto__);

return statearr_15810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto__))
);

return c__15051__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15819 = [];
var len__8402__auto___15871 = arguments.length;
var i__8403__auto___15872 = (0);
while(true){
if((i__8403__auto___15872 < len__8402__auto___15871)){
args15819.push((arguments[i__8403__auto___15872]));

var G__15873 = (i__8403__auto___15872 + (1));
i__8403__auto___15872 = G__15873;
continue;
} else {
}
break;
}

var G__15821 = args15819.length;
switch (G__15821) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15819.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__15051__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto__){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto__){
return (function (state_15846){
var state_val_15847 = (state_15846[(1)]);
if((state_val_15847 === (7))){
var inst_15828 = (state_15846[(2)]);
var state_15846__$1 = state_15846;
var statearr_15848_15875 = state_15846__$1;
(statearr_15848_15875[(2)] = inst_15828);

(statearr_15848_15875[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15847 === (1))){
var inst_15822 = cljs.core.seq(coll);
var inst_15823 = inst_15822;
var state_15846__$1 = (function (){var statearr_15849 = state_15846;
(statearr_15849[(7)] = inst_15823);

return statearr_15849;
})();
var statearr_15850_15876 = state_15846__$1;
(statearr_15850_15876[(2)] = null);

(statearr_15850_15876[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15847 === (4))){
var inst_15823 = (state_15846[(7)]);
var inst_15826 = cljs.core.first(inst_15823);
var state_15846__$1 = state_15846;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15846__$1,(7),ch,inst_15826);
} else {
if((state_val_15847 === (13))){
var inst_15840 = (state_15846[(2)]);
var state_15846__$1 = state_15846;
var statearr_15851_15877 = state_15846__$1;
(statearr_15851_15877[(2)] = inst_15840);

(statearr_15851_15877[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15847 === (6))){
var inst_15831 = (state_15846[(2)]);
var state_15846__$1 = state_15846;
if(cljs.core.truth_(inst_15831)){
var statearr_15852_15878 = state_15846__$1;
(statearr_15852_15878[(1)] = (8));

} else {
var statearr_15853_15879 = state_15846__$1;
(statearr_15853_15879[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15847 === (3))){
var inst_15844 = (state_15846[(2)]);
var state_15846__$1 = state_15846;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15846__$1,inst_15844);
} else {
if((state_val_15847 === (12))){
var state_15846__$1 = state_15846;
var statearr_15854_15880 = state_15846__$1;
(statearr_15854_15880[(2)] = null);

(statearr_15854_15880[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15847 === (2))){
var inst_15823 = (state_15846[(7)]);
var state_15846__$1 = state_15846;
if(cljs.core.truth_(inst_15823)){
var statearr_15855_15881 = state_15846__$1;
(statearr_15855_15881[(1)] = (4));

} else {
var statearr_15856_15882 = state_15846__$1;
(statearr_15856_15882[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15847 === (11))){
var inst_15837 = cljs.core.async.close_BANG_(ch);
var state_15846__$1 = state_15846;
var statearr_15857_15883 = state_15846__$1;
(statearr_15857_15883[(2)] = inst_15837);

(statearr_15857_15883[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15847 === (9))){
var state_15846__$1 = state_15846;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15858_15884 = state_15846__$1;
(statearr_15858_15884[(1)] = (11));

} else {
var statearr_15859_15885 = state_15846__$1;
(statearr_15859_15885[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15847 === (5))){
var inst_15823 = (state_15846[(7)]);
var state_15846__$1 = state_15846;
var statearr_15860_15886 = state_15846__$1;
(statearr_15860_15886[(2)] = inst_15823);

(statearr_15860_15886[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15847 === (10))){
var inst_15842 = (state_15846[(2)]);
var state_15846__$1 = state_15846;
var statearr_15861_15887 = state_15846__$1;
(statearr_15861_15887[(2)] = inst_15842);

(statearr_15861_15887[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15847 === (8))){
var inst_15823 = (state_15846[(7)]);
var inst_15833 = cljs.core.next(inst_15823);
var inst_15823__$1 = inst_15833;
var state_15846__$1 = (function (){var statearr_15862 = state_15846;
(statearr_15862[(7)] = inst_15823__$1);

return statearr_15862;
})();
var statearr_15863_15888 = state_15846__$1;
(statearr_15863_15888[(2)] = null);

(statearr_15863_15888[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto__))
;
return ((function (switch__14927__auto__,c__15051__auto__){
return (function() {
var cljs$core$async$state_machine__14928__auto__ = null;
var cljs$core$async$state_machine__14928__auto____0 = (function (){
var statearr_15867 = [null,null,null,null,null,null,null,null];
(statearr_15867[(0)] = cljs$core$async$state_machine__14928__auto__);

(statearr_15867[(1)] = (1));

return statearr_15867;
});
var cljs$core$async$state_machine__14928__auto____1 = (function (state_15846){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_15846);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e15868){if((e15868 instanceof Object)){
var ex__14931__auto__ = e15868;
var statearr_15869_15889 = state_15846;
(statearr_15869_15889[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15846);

return cljs.core.cst$kw$recur;
} else {
throw e15868;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__15890 = state_15846;
state_15846 = G__15890;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$state_machine__14928__auto__ = function(state_15846){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14928__auto____1.call(this,state_15846);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14928__auto____0;
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14928__auto____1;
return cljs$core$async$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto__))
})();
var state__15053__auto__ = (function (){var statearr_15870 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_15870[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto__);

return statearr_15870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto__))
);

return c__15051__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7957__auto__ = (((_ == null))?null:_);
var m__7958__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7958__auto__.call(null,_));
} else {
var m__7958__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7958__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7958__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7958__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7958__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7958__auto__.call(null,m,ch));
} else {
var m__7958__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7958__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7958__auto__.call(null,m));
} else {
var m__7958__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7958__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__16119 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16119) : cljs.core.atom.call(null,G__16119));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16120 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16120 = (function (ch,cs,meta16121){
this.ch = ch;
this.cs = cs;
this.meta16121 = meta16121;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16120.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_16122,meta16121__$1){
var self__ = this;
var _16122__$1 = this;
return (new cljs.core.async.t_cljs$core$async16120(self__.ch,self__.cs,meta16121__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async16120.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_16122){
var self__ = this;
var _16122__$1 = this;
return self__.meta16121;
});})(cs))
;

cljs.core.async.t_cljs$core$async16120.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16120.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async16120.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16120.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async16120.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async16120.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__16123_16347 = self__.cs;
var G__16124_16348 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__16123_16347,G__16124_16348) : cljs.core.reset_BANG_.call(null,G__16123_16347,G__16124_16348));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async16120.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta16121], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async16120.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16120.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16120";

cljs.core.async.t_cljs$core$async16120.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async16120");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async16120 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async16120(ch__$1,cs__$1,meta16121){
return (new cljs.core.async.t_cljs$core$async16120(ch__$1,cs__$1,meta16121));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async16120(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__15051__auto___16349 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___16349,cs,m,dchan,dctr,done){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___16349,cs,m,dchan,dctr,done){
return (function (state_16259){
var state_val_16260 = (state_16259[(1)]);
if((state_val_16260 === (7))){
var inst_16255 = (state_16259[(2)]);
var state_16259__$1 = state_16259;
var statearr_16261_16350 = state_16259__$1;
(statearr_16261_16350[(2)] = inst_16255);

(statearr_16261_16350[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (20))){
var inst_16158 = (state_16259[(7)]);
var inst_16170 = cljs.core.first(inst_16158);
var inst_16171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16170,(0),null);
var inst_16172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16170,(1),null);
var state_16259__$1 = (function (){var statearr_16262 = state_16259;
(statearr_16262[(8)] = inst_16171);

return statearr_16262;
})();
if(cljs.core.truth_(inst_16172)){
var statearr_16263_16351 = state_16259__$1;
(statearr_16263_16351[(1)] = (22));

} else {
var statearr_16264_16352 = state_16259__$1;
(statearr_16264_16352[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (27))){
var inst_16200 = (state_16259[(9)]);
var inst_16207 = (state_16259[(10)]);
var inst_16127 = (state_16259[(11)]);
var inst_16202 = (state_16259[(12)]);
var inst_16207__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16200,inst_16202);
var inst_16208 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_16207__$1,inst_16127,done);
var state_16259__$1 = (function (){var statearr_16265 = state_16259;
(statearr_16265[(10)] = inst_16207__$1);

return statearr_16265;
})();
if(cljs.core.truth_(inst_16208)){
var statearr_16266_16353 = state_16259__$1;
(statearr_16266_16353[(1)] = (30));

} else {
var statearr_16267_16354 = state_16259__$1;
(statearr_16267_16354[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (1))){
var state_16259__$1 = state_16259;
var statearr_16268_16355 = state_16259__$1;
(statearr_16268_16355[(2)] = null);

(statearr_16268_16355[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (24))){
var inst_16158 = (state_16259[(7)]);
var inst_16177 = (state_16259[(2)]);
var inst_16178 = cljs.core.next(inst_16158);
var inst_16136 = inst_16178;
var inst_16137 = null;
var inst_16138 = (0);
var inst_16139 = (0);
var state_16259__$1 = (function (){var statearr_16269 = state_16259;
(statearr_16269[(13)] = inst_16177);

(statearr_16269[(14)] = inst_16138);

(statearr_16269[(15)] = inst_16139);

(statearr_16269[(16)] = inst_16137);

(statearr_16269[(17)] = inst_16136);

return statearr_16269;
})();
var statearr_16270_16356 = state_16259__$1;
(statearr_16270_16356[(2)] = null);

(statearr_16270_16356[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (39))){
var state_16259__$1 = state_16259;
var statearr_16274_16357 = state_16259__$1;
(statearr_16274_16357[(2)] = null);

(statearr_16274_16357[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (4))){
var inst_16127 = (state_16259[(11)]);
var inst_16127__$1 = (state_16259[(2)]);
var inst_16128 = (inst_16127__$1 == null);
var state_16259__$1 = (function (){var statearr_16275 = state_16259;
(statearr_16275[(11)] = inst_16127__$1);

return statearr_16275;
})();
if(cljs.core.truth_(inst_16128)){
var statearr_16276_16358 = state_16259__$1;
(statearr_16276_16358[(1)] = (5));

} else {
var statearr_16277_16359 = state_16259__$1;
(statearr_16277_16359[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (15))){
var inst_16138 = (state_16259[(14)]);
var inst_16139 = (state_16259[(15)]);
var inst_16137 = (state_16259[(16)]);
var inst_16136 = (state_16259[(17)]);
var inst_16154 = (state_16259[(2)]);
var inst_16155 = (inst_16139 + (1));
var tmp16271 = inst_16138;
var tmp16272 = inst_16137;
var tmp16273 = inst_16136;
var inst_16136__$1 = tmp16273;
var inst_16137__$1 = tmp16272;
var inst_16138__$1 = tmp16271;
var inst_16139__$1 = inst_16155;
var state_16259__$1 = (function (){var statearr_16278 = state_16259;
(statearr_16278[(14)] = inst_16138__$1);

(statearr_16278[(15)] = inst_16139__$1);

(statearr_16278[(16)] = inst_16137__$1);

(statearr_16278[(17)] = inst_16136__$1);

(statearr_16278[(18)] = inst_16154);

return statearr_16278;
})();
var statearr_16279_16360 = state_16259__$1;
(statearr_16279_16360[(2)] = null);

(statearr_16279_16360[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (21))){
var inst_16181 = (state_16259[(2)]);
var state_16259__$1 = state_16259;
var statearr_16283_16361 = state_16259__$1;
(statearr_16283_16361[(2)] = inst_16181);

(statearr_16283_16361[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (31))){
var inst_16207 = (state_16259[(10)]);
var inst_16211 = done(null);
var inst_16212 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_16207);
var state_16259__$1 = (function (){var statearr_16284 = state_16259;
(statearr_16284[(19)] = inst_16211);

return statearr_16284;
})();
var statearr_16285_16362 = state_16259__$1;
(statearr_16285_16362[(2)] = inst_16212);

(statearr_16285_16362[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (32))){
var inst_16200 = (state_16259[(9)]);
var inst_16199 = (state_16259[(20)]);
var inst_16201 = (state_16259[(21)]);
var inst_16202 = (state_16259[(12)]);
var inst_16214 = (state_16259[(2)]);
var inst_16215 = (inst_16202 + (1));
var tmp16280 = inst_16200;
var tmp16281 = inst_16199;
var tmp16282 = inst_16201;
var inst_16199__$1 = tmp16281;
var inst_16200__$1 = tmp16280;
var inst_16201__$1 = tmp16282;
var inst_16202__$1 = inst_16215;
var state_16259__$1 = (function (){var statearr_16286 = state_16259;
(statearr_16286[(9)] = inst_16200__$1);

(statearr_16286[(20)] = inst_16199__$1);

(statearr_16286[(21)] = inst_16201__$1);

(statearr_16286[(22)] = inst_16214);

(statearr_16286[(12)] = inst_16202__$1);

return statearr_16286;
})();
var statearr_16287_16363 = state_16259__$1;
(statearr_16287_16363[(2)] = null);

(statearr_16287_16363[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (40))){
var inst_16227 = (state_16259[(23)]);
var inst_16231 = done(null);
var inst_16232 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_16227);
var state_16259__$1 = (function (){var statearr_16288 = state_16259;
(statearr_16288[(24)] = inst_16231);

return statearr_16288;
})();
var statearr_16289_16364 = state_16259__$1;
(statearr_16289_16364[(2)] = inst_16232);

(statearr_16289_16364[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (33))){
var inst_16218 = (state_16259[(25)]);
var inst_16220 = cljs.core.chunked_seq_QMARK_(inst_16218);
var state_16259__$1 = state_16259;
if(inst_16220){
var statearr_16290_16365 = state_16259__$1;
(statearr_16290_16365[(1)] = (36));

} else {
var statearr_16291_16366 = state_16259__$1;
(statearr_16291_16366[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (13))){
var inst_16148 = (state_16259[(26)]);
var inst_16151 = cljs.core.async.close_BANG_(inst_16148);
var state_16259__$1 = state_16259;
var statearr_16292_16367 = state_16259__$1;
(statearr_16292_16367[(2)] = inst_16151);

(statearr_16292_16367[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (22))){
var inst_16171 = (state_16259[(8)]);
var inst_16174 = cljs.core.async.close_BANG_(inst_16171);
var state_16259__$1 = state_16259;
var statearr_16293_16368 = state_16259__$1;
(statearr_16293_16368[(2)] = inst_16174);

(statearr_16293_16368[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (36))){
var inst_16218 = (state_16259[(25)]);
var inst_16222 = cljs.core.chunk_first(inst_16218);
var inst_16223 = cljs.core.chunk_rest(inst_16218);
var inst_16224 = cljs.core.count(inst_16222);
var inst_16199 = inst_16223;
var inst_16200 = inst_16222;
var inst_16201 = inst_16224;
var inst_16202 = (0);
var state_16259__$1 = (function (){var statearr_16294 = state_16259;
(statearr_16294[(9)] = inst_16200);

(statearr_16294[(20)] = inst_16199);

(statearr_16294[(21)] = inst_16201);

(statearr_16294[(12)] = inst_16202);

return statearr_16294;
})();
var statearr_16295_16369 = state_16259__$1;
(statearr_16295_16369[(2)] = null);

(statearr_16295_16369[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (41))){
var inst_16218 = (state_16259[(25)]);
var inst_16234 = (state_16259[(2)]);
var inst_16235 = cljs.core.next(inst_16218);
var inst_16199 = inst_16235;
var inst_16200 = null;
var inst_16201 = (0);
var inst_16202 = (0);
var state_16259__$1 = (function (){var statearr_16296 = state_16259;
(statearr_16296[(9)] = inst_16200);

(statearr_16296[(27)] = inst_16234);

(statearr_16296[(20)] = inst_16199);

(statearr_16296[(21)] = inst_16201);

(statearr_16296[(12)] = inst_16202);

return statearr_16296;
})();
var statearr_16297_16370 = state_16259__$1;
(statearr_16297_16370[(2)] = null);

(statearr_16297_16370[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (43))){
var state_16259__$1 = state_16259;
var statearr_16298_16371 = state_16259__$1;
(statearr_16298_16371[(2)] = null);

(statearr_16298_16371[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (29))){
var inst_16243 = (state_16259[(2)]);
var state_16259__$1 = state_16259;
var statearr_16299_16372 = state_16259__$1;
(statearr_16299_16372[(2)] = inst_16243);

(statearr_16299_16372[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (44))){
var inst_16252 = (state_16259[(2)]);
var state_16259__$1 = (function (){var statearr_16300 = state_16259;
(statearr_16300[(28)] = inst_16252);

return statearr_16300;
})();
var statearr_16301_16373 = state_16259__$1;
(statearr_16301_16373[(2)] = null);

(statearr_16301_16373[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (6))){
var inst_16191 = (state_16259[(29)]);
var inst_16190 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_16191__$1 = cljs.core.keys(inst_16190);
var inst_16192 = cljs.core.count(inst_16191__$1);
var inst_16193 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_16192) : cljs.core.reset_BANG_.call(null,dctr,inst_16192));
var inst_16198 = cljs.core.seq(inst_16191__$1);
var inst_16199 = inst_16198;
var inst_16200 = null;
var inst_16201 = (0);
var inst_16202 = (0);
var state_16259__$1 = (function (){var statearr_16302 = state_16259;
(statearr_16302[(30)] = inst_16193);

(statearr_16302[(9)] = inst_16200);

(statearr_16302[(20)] = inst_16199);

(statearr_16302[(21)] = inst_16201);

(statearr_16302[(29)] = inst_16191__$1);

(statearr_16302[(12)] = inst_16202);

return statearr_16302;
})();
var statearr_16303_16374 = state_16259__$1;
(statearr_16303_16374[(2)] = null);

(statearr_16303_16374[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (28))){
var inst_16199 = (state_16259[(20)]);
var inst_16218 = (state_16259[(25)]);
var inst_16218__$1 = cljs.core.seq(inst_16199);
var state_16259__$1 = (function (){var statearr_16304 = state_16259;
(statearr_16304[(25)] = inst_16218__$1);

return statearr_16304;
})();
if(inst_16218__$1){
var statearr_16305_16375 = state_16259__$1;
(statearr_16305_16375[(1)] = (33));

} else {
var statearr_16306_16376 = state_16259__$1;
(statearr_16306_16376[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (25))){
var inst_16201 = (state_16259[(21)]);
var inst_16202 = (state_16259[(12)]);
var inst_16204 = (inst_16202 < inst_16201);
var inst_16205 = inst_16204;
var state_16259__$1 = state_16259;
if(cljs.core.truth_(inst_16205)){
var statearr_16307_16377 = state_16259__$1;
(statearr_16307_16377[(1)] = (27));

} else {
var statearr_16308_16378 = state_16259__$1;
(statearr_16308_16378[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (34))){
var state_16259__$1 = state_16259;
var statearr_16309_16379 = state_16259__$1;
(statearr_16309_16379[(2)] = null);

(statearr_16309_16379[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (17))){
var state_16259__$1 = state_16259;
var statearr_16310_16380 = state_16259__$1;
(statearr_16310_16380[(2)] = null);

(statearr_16310_16380[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (3))){
var inst_16257 = (state_16259[(2)]);
var state_16259__$1 = state_16259;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16259__$1,inst_16257);
} else {
if((state_val_16260 === (12))){
var inst_16186 = (state_16259[(2)]);
var state_16259__$1 = state_16259;
var statearr_16311_16381 = state_16259__$1;
(statearr_16311_16381[(2)] = inst_16186);

(statearr_16311_16381[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (2))){
var state_16259__$1 = state_16259;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16259__$1,(4),ch);
} else {
if((state_val_16260 === (23))){
var state_16259__$1 = state_16259;
var statearr_16312_16382 = state_16259__$1;
(statearr_16312_16382[(2)] = null);

(statearr_16312_16382[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (35))){
var inst_16241 = (state_16259[(2)]);
var state_16259__$1 = state_16259;
var statearr_16313_16383 = state_16259__$1;
(statearr_16313_16383[(2)] = inst_16241);

(statearr_16313_16383[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (19))){
var inst_16158 = (state_16259[(7)]);
var inst_16162 = cljs.core.chunk_first(inst_16158);
var inst_16163 = cljs.core.chunk_rest(inst_16158);
var inst_16164 = cljs.core.count(inst_16162);
var inst_16136 = inst_16163;
var inst_16137 = inst_16162;
var inst_16138 = inst_16164;
var inst_16139 = (0);
var state_16259__$1 = (function (){var statearr_16314 = state_16259;
(statearr_16314[(14)] = inst_16138);

(statearr_16314[(15)] = inst_16139);

(statearr_16314[(16)] = inst_16137);

(statearr_16314[(17)] = inst_16136);

return statearr_16314;
})();
var statearr_16315_16384 = state_16259__$1;
(statearr_16315_16384[(2)] = null);

(statearr_16315_16384[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (11))){
var inst_16158 = (state_16259[(7)]);
var inst_16136 = (state_16259[(17)]);
var inst_16158__$1 = cljs.core.seq(inst_16136);
var state_16259__$1 = (function (){var statearr_16316 = state_16259;
(statearr_16316[(7)] = inst_16158__$1);

return statearr_16316;
})();
if(inst_16158__$1){
var statearr_16317_16385 = state_16259__$1;
(statearr_16317_16385[(1)] = (16));

} else {
var statearr_16318_16386 = state_16259__$1;
(statearr_16318_16386[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (9))){
var inst_16188 = (state_16259[(2)]);
var state_16259__$1 = state_16259;
var statearr_16319_16387 = state_16259__$1;
(statearr_16319_16387[(2)] = inst_16188);

(statearr_16319_16387[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (5))){
var inst_16134 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_16135 = cljs.core.seq(inst_16134);
var inst_16136 = inst_16135;
var inst_16137 = null;
var inst_16138 = (0);
var inst_16139 = (0);
var state_16259__$1 = (function (){var statearr_16320 = state_16259;
(statearr_16320[(14)] = inst_16138);

(statearr_16320[(15)] = inst_16139);

(statearr_16320[(16)] = inst_16137);

(statearr_16320[(17)] = inst_16136);

return statearr_16320;
})();
var statearr_16321_16388 = state_16259__$1;
(statearr_16321_16388[(2)] = null);

(statearr_16321_16388[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (14))){
var state_16259__$1 = state_16259;
var statearr_16322_16389 = state_16259__$1;
(statearr_16322_16389[(2)] = null);

(statearr_16322_16389[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (45))){
var inst_16249 = (state_16259[(2)]);
var state_16259__$1 = state_16259;
var statearr_16323_16390 = state_16259__$1;
(statearr_16323_16390[(2)] = inst_16249);

(statearr_16323_16390[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (26))){
var inst_16191 = (state_16259[(29)]);
var inst_16245 = (state_16259[(2)]);
var inst_16246 = cljs.core.seq(inst_16191);
var state_16259__$1 = (function (){var statearr_16324 = state_16259;
(statearr_16324[(31)] = inst_16245);

return statearr_16324;
})();
if(inst_16246){
var statearr_16325_16391 = state_16259__$1;
(statearr_16325_16391[(1)] = (42));

} else {
var statearr_16326_16392 = state_16259__$1;
(statearr_16326_16392[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (16))){
var inst_16158 = (state_16259[(7)]);
var inst_16160 = cljs.core.chunked_seq_QMARK_(inst_16158);
var state_16259__$1 = state_16259;
if(inst_16160){
var statearr_16327_16393 = state_16259__$1;
(statearr_16327_16393[(1)] = (19));

} else {
var statearr_16328_16394 = state_16259__$1;
(statearr_16328_16394[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (38))){
var inst_16238 = (state_16259[(2)]);
var state_16259__$1 = state_16259;
var statearr_16329_16395 = state_16259__$1;
(statearr_16329_16395[(2)] = inst_16238);

(statearr_16329_16395[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (30))){
var state_16259__$1 = state_16259;
var statearr_16330_16396 = state_16259__$1;
(statearr_16330_16396[(2)] = null);

(statearr_16330_16396[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (10))){
var inst_16139 = (state_16259[(15)]);
var inst_16137 = (state_16259[(16)]);
var inst_16147 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16137,inst_16139);
var inst_16148 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16147,(0),null);
var inst_16149 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16147,(1),null);
var state_16259__$1 = (function (){var statearr_16331 = state_16259;
(statearr_16331[(26)] = inst_16148);

return statearr_16331;
})();
if(cljs.core.truth_(inst_16149)){
var statearr_16332_16397 = state_16259__$1;
(statearr_16332_16397[(1)] = (13));

} else {
var statearr_16333_16398 = state_16259__$1;
(statearr_16333_16398[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (18))){
var inst_16184 = (state_16259[(2)]);
var state_16259__$1 = state_16259;
var statearr_16334_16399 = state_16259__$1;
(statearr_16334_16399[(2)] = inst_16184);

(statearr_16334_16399[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (42))){
var state_16259__$1 = state_16259;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16259__$1,(45),dchan);
} else {
if((state_val_16260 === (37))){
var inst_16227 = (state_16259[(23)]);
var inst_16218 = (state_16259[(25)]);
var inst_16127 = (state_16259[(11)]);
var inst_16227__$1 = cljs.core.first(inst_16218);
var inst_16228 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_16227__$1,inst_16127,done);
var state_16259__$1 = (function (){var statearr_16335 = state_16259;
(statearr_16335[(23)] = inst_16227__$1);

return statearr_16335;
})();
if(cljs.core.truth_(inst_16228)){
var statearr_16336_16400 = state_16259__$1;
(statearr_16336_16400[(1)] = (39));

} else {
var statearr_16337_16401 = state_16259__$1;
(statearr_16337_16401[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16260 === (8))){
var inst_16138 = (state_16259[(14)]);
var inst_16139 = (state_16259[(15)]);
var inst_16141 = (inst_16139 < inst_16138);
var inst_16142 = inst_16141;
var state_16259__$1 = state_16259;
if(cljs.core.truth_(inst_16142)){
var statearr_16338_16402 = state_16259__$1;
(statearr_16338_16402[(1)] = (10));

} else {
var statearr_16339_16403 = state_16259__$1;
(statearr_16339_16403[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___16349,cs,m,dchan,dctr,done))
;
return ((function (switch__14927__auto__,c__15051__auto___16349,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14928__auto__ = null;
var cljs$core$async$mult_$_state_machine__14928__auto____0 = (function (){
var statearr_16343 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16343[(0)] = cljs$core$async$mult_$_state_machine__14928__auto__);

(statearr_16343[(1)] = (1));

return statearr_16343;
});
var cljs$core$async$mult_$_state_machine__14928__auto____1 = (function (state_16259){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_16259);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e16344){if((e16344 instanceof Object)){
var ex__14931__auto__ = e16344;
var statearr_16345_16404 = state_16259;
(statearr_16345_16404[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16259);

return cljs.core.cst$kw$recur;
} else {
throw e16344;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__16405 = state_16259;
state_16259 = G__16405;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14928__auto__ = function(state_16259){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14928__auto____1.call(this,state_16259);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14928__auto____0;
cljs$core$async$mult_$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14928__auto____1;
return cljs$core$async$mult_$_state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___16349,cs,m,dchan,dctr,done))
})();
var state__15053__auto__ = (function (){var statearr_16346 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_16346[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___16349);

return statearr_16346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___16349,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args16406 = [];
var len__8402__auto___16409 = arguments.length;
var i__8403__auto___16410 = (0);
while(true){
if((i__8403__auto___16410 < len__8402__auto___16409)){
args16406.push((arguments[i__8403__auto___16410]));

var G__16411 = (i__8403__auto___16410 + (1));
i__8403__auto___16410 = G__16411;
continue;
} else {
}
break;
}

var G__16408 = args16406.length;
switch (G__16408) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16406.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7958__auto__.call(null,m,ch));
} else {
var m__7958__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7958__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7958__auto__.call(null,m,ch));
} else {
var m__7958__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7958__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7958__auto__.call(null,m));
} else {
var m__7958__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7958__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7958__auto__.call(null,m,state_map));
} else {
var m__7958__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7958__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7958__auto__.call(null,m,mode));
} else {
var m__7958__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7958__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___16423 = arguments.length;
var i__8403__auto___16424 = (0);
while(true){
if((i__8403__auto___16424 < len__8402__auto___16423)){
args__8409__auto__.push((arguments[i__8403__auto___16424]));

var G__16425 = (i__8403__auto___16424 + (1));
i__8403__auto___16424 = G__16425;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((3) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8410__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__16417){
var map__16418 = p__16417;
var map__16418__$1 = ((((!((map__16418 == null)))?((((map__16418.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16418.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16418):map__16418);
var opts = map__16418__$1;
var statearr_16420_16426 = state;
(statearr_16420_16426[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__16418,map__16418__$1,opts){
return (function (val){
var statearr_16421_16427 = state;
(statearr_16421_16427[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__16418,map__16418__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_16422_16428 = state;
(statearr_16422_16428[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq16413){
var G__16414 = cljs.core.first(seq16413);
var seq16413__$1 = cljs.core.next(seq16413);
var G__16415 = cljs.core.first(seq16413__$1);
var seq16413__$2 = cljs.core.next(seq16413__$1);
var G__16416 = cljs.core.first(seq16413__$2);
var seq16413__$3 = cljs.core.next(seq16413__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16414,G__16415,G__16416,seq16413__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__16600 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16600) : cljs.core.atom.call(null,G__16600));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__16601 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16601) : cljs.core.atom.call(null,G__16601));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16602 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16602 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta16603){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta16603 = meta16603;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16602.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16604,meta16603__$1){
var self__ = this;
var _16604__$1 = this;
return (new cljs.core.async.t_cljs$core$async16602(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta16603__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16602.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16604){
var self__ = this;
var _16604__$1 = this;
return self__.meta16603;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16602.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16602.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16602.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16602.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16602.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16602.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__16605_16771 = self__.cs;
var G__16606_16772 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__16605_16771,G__16606_16772) : cljs.core.reset_BANG_.call(null,G__16605_16771,G__16606_16772));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16602.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16602.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16602.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta16603], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16602.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16602.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16602";

cljs.core.async.t_cljs$core$async16602.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async16602");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async16602 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async16602(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta16603){
return (new cljs.core.async.t_cljs$core$async16602(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta16603));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async16602(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__15051__auto___16773 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___16773,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___16773,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_16708){
var state_val_16709 = (state_16708[(1)]);
if((state_val_16709 === (7))){
var inst_16623 = (state_16708[(2)]);
var state_16708__$1 = state_16708;
var statearr_16710_16774 = state_16708__$1;
(statearr_16710_16774[(2)] = inst_16623);

(statearr_16710_16774[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (20))){
var inst_16635 = (state_16708[(7)]);
var state_16708__$1 = state_16708;
var statearr_16711_16775 = state_16708__$1;
(statearr_16711_16775[(2)] = inst_16635);

(statearr_16711_16775[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (27))){
var state_16708__$1 = state_16708;
var statearr_16712_16776 = state_16708__$1;
(statearr_16712_16776[(2)] = null);

(statearr_16712_16776[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (1))){
var inst_16610 = (state_16708[(8)]);
var inst_16610__$1 = calc_state();
var inst_16612 = (inst_16610__$1 == null);
var inst_16613 = cljs.core.not(inst_16612);
var state_16708__$1 = (function (){var statearr_16713 = state_16708;
(statearr_16713[(8)] = inst_16610__$1);

return statearr_16713;
})();
if(inst_16613){
var statearr_16714_16777 = state_16708__$1;
(statearr_16714_16777[(1)] = (2));

} else {
var statearr_16715_16778 = state_16708__$1;
(statearr_16715_16778[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (24))){
var inst_16659 = (state_16708[(9)]);
var inst_16682 = (state_16708[(10)]);
var inst_16668 = (state_16708[(11)]);
var inst_16682__$1 = (inst_16659.cljs$core$IFn$_invoke$arity$1 ? inst_16659.cljs$core$IFn$_invoke$arity$1(inst_16668) : inst_16659.call(null,inst_16668));
var state_16708__$1 = (function (){var statearr_16716 = state_16708;
(statearr_16716[(10)] = inst_16682__$1);

return statearr_16716;
})();
if(cljs.core.truth_(inst_16682__$1)){
var statearr_16717_16779 = state_16708__$1;
(statearr_16717_16779[(1)] = (29));

} else {
var statearr_16718_16780 = state_16708__$1;
(statearr_16718_16780[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (4))){
var inst_16626 = (state_16708[(2)]);
var state_16708__$1 = state_16708;
if(cljs.core.truth_(inst_16626)){
var statearr_16719_16781 = state_16708__$1;
(statearr_16719_16781[(1)] = (8));

} else {
var statearr_16720_16782 = state_16708__$1;
(statearr_16720_16782[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (15))){
var inst_16653 = (state_16708[(2)]);
var state_16708__$1 = state_16708;
if(cljs.core.truth_(inst_16653)){
var statearr_16721_16783 = state_16708__$1;
(statearr_16721_16783[(1)] = (19));

} else {
var statearr_16722_16784 = state_16708__$1;
(statearr_16722_16784[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (21))){
var inst_16658 = (state_16708[(12)]);
var inst_16658__$1 = (state_16708[(2)]);
var inst_16659 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16658__$1,cljs.core.cst$kw$solos);
var inst_16660 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16658__$1,cljs.core.cst$kw$mutes);
var inst_16661 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16658__$1,cljs.core.cst$kw$reads);
var state_16708__$1 = (function (){var statearr_16723 = state_16708;
(statearr_16723[(13)] = inst_16660);

(statearr_16723[(12)] = inst_16658__$1);

(statearr_16723[(9)] = inst_16659);

return statearr_16723;
})();
return cljs.core.async.ioc_alts_BANG_(state_16708__$1,(22),inst_16661);
} else {
if((state_val_16709 === (31))){
var inst_16690 = (state_16708[(2)]);
var state_16708__$1 = state_16708;
if(cljs.core.truth_(inst_16690)){
var statearr_16724_16785 = state_16708__$1;
(statearr_16724_16785[(1)] = (32));

} else {
var statearr_16725_16786 = state_16708__$1;
(statearr_16725_16786[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (32))){
var inst_16667 = (state_16708[(14)]);
var state_16708__$1 = state_16708;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16708__$1,(35),out,inst_16667);
} else {
if((state_val_16709 === (33))){
var inst_16658 = (state_16708[(12)]);
var inst_16635 = inst_16658;
var state_16708__$1 = (function (){var statearr_16726 = state_16708;
(statearr_16726[(7)] = inst_16635);

return statearr_16726;
})();
var statearr_16727_16787 = state_16708__$1;
(statearr_16727_16787[(2)] = null);

(statearr_16727_16787[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (13))){
var inst_16635 = (state_16708[(7)]);
var inst_16642 = inst_16635.cljs$lang$protocol_mask$partition0$;
var inst_16643 = (inst_16642 & (64));
var inst_16644 = inst_16635.cljs$core$ISeq$;
var inst_16645 = (cljs.core.PROTOCOL_SENTINEL === inst_16644);
var inst_16646 = (inst_16643) || (inst_16645);
var state_16708__$1 = state_16708;
if(cljs.core.truth_(inst_16646)){
var statearr_16728_16788 = state_16708__$1;
(statearr_16728_16788[(1)] = (16));

} else {
var statearr_16729_16789 = state_16708__$1;
(statearr_16729_16789[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (22))){
var inst_16667 = (state_16708[(14)]);
var inst_16668 = (state_16708[(11)]);
var inst_16666 = (state_16708[(2)]);
var inst_16667__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16666,(0),null);
var inst_16668__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16666,(1),null);
var inst_16669 = (inst_16667__$1 == null);
var inst_16670 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16668__$1,change);
var inst_16671 = (inst_16669) || (inst_16670);
var state_16708__$1 = (function (){var statearr_16730 = state_16708;
(statearr_16730[(14)] = inst_16667__$1);

(statearr_16730[(11)] = inst_16668__$1);

return statearr_16730;
})();
if(cljs.core.truth_(inst_16671)){
var statearr_16731_16790 = state_16708__$1;
(statearr_16731_16790[(1)] = (23));

} else {
var statearr_16732_16791 = state_16708__$1;
(statearr_16732_16791[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (36))){
var inst_16658 = (state_16708[(12)]);
var inst_16635 = inst_16658;
var state_16708__$1 = (function (){var statearr_16733 = state_16708;
(statearr_16733[(7)] = inst_16635);

return statearr_16733;
})();
var statearr_16734_16792 = state_16708__$1;
(statearr_16734_16792[(2)] = null);

(statearr_16734_16792[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (29))){
var inst_16682 = (state_16708[(10)]);
var state_16708__$1 = state_16708;
var statearr_16735_16793 = state_16708__$1;
(statearr_16735_16793[(2)] = inst_16682);

(statearr_16735_16793[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (6))){
var state_16708__$1 = state_16708;
var statearr_16736_16794 = state_16708__$1;
(statearr_16736_16794[(2)] = false);

(statearr_16736_16794[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (28))){
var inst_16678 = (state_16708[(2)]);
var inst_16679 = calc_state();
var inst_16635 = inst_16679;
var state_16708__$1 = (function (){var statearr_16737 = state_16708;
(statearr_16737[(15)] = inst_16678);

(statearr_16737[(7)] = inst_16635);

return statearr_16737;
})();
var statearr_16738_16795 = state_16708__$1;
(statearr_16738_16795[(2)] = null);

(statearr_16738_16795[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (25))){
var inst_16704 = (state_16708[(2)]);
var state_16708__$1 = state_16708;
var statearr_16739_16796 = state_16708__$1;
(statearr_16739_16796[(2)] = inst_16704);

(statearr_16739_16796[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (34))){
var inst_16702 = (state_16708[(2)]);
var state_16708__$1 = state_16708;
var statearr_16740_16797 = state_16708__$1;
(statearr_16740_16797[(2)] = inst_16702);

(statearr_16740_16797[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (17))){
var state_16708__$1 = state_16708;
var statearr_16741_16798 = state_16708__$1;
(statearr_16741_16798[(2)] = false);

(statearr_16741_16798[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (3))){
var state_16708__$1 = state_16708;
var statearr_16742_16799 = state_16708__$1;
(statearr_16742_16799[(2)] = false);

(statearr_16742_16799[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (12))){
var inst_16706 = (state_16708[(2)]);
var state_16708__$1 = state_16708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16708__$1,inst_16706);
} else {
if((state_val_16709 === (2))){
var inst_16610 = (state_16708[(8)]);
var inst_16615 = inst_16610.cljs$lang$protocol_mask$partition0$;
var inst_16616 = (inst_16615 & (64));
var inst_16617 = inst_16610.cljs$core$ISeq$;
var inst_16618 = (cljs.core.PROTOCOL_SENTINEL === inst_16617);
var inst_16619 = (inst_16616) || (inst_16618);
var state_16708__$1 = state_16708;
if(cljs.core.truth_(inst_16619)){
var statearr_16743_16800 = state_16708__$1;
(statearr_16743_16800[(1)] = (5));

} else {
var statearr_16744_16801 = state_16708__$1;
(statearr_16744_16801[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (23))){
var inst_16667 = (state_16708[(14)]);
var inst_16673 = (inst_16667 == null);
var state_16708__$1 = state_16708;
if(cljs.core.truth_(inst_16673)){
var statearr_16745_16802 = state_16708__$1;
(statearr_16745_16802[(1)] = (26));

} else {
var statearr_16746_16803 = state_16708__$1;
(statearr_16746_16803[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (35))){
var inst_16693 = (state_16708[(2)]);
var state_16708__$1 = state_16708;
if(cljs.core.truth_(inst_16693)){
var statearr_16747_16804 = state_16708__$1;
(statearr_16747_16804[(1)] = (36));

} else {
var statearr_16748_16805 = state_16708__$1;
(statearr_16748_16805[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (19))){
var inst_16635 = (state_16708[(7)]);
var inst_16655 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_16635);
var state_16708__$1 = state_16708;
var statearr_16749_16806 = state_16708__$1;
(statearr_16749_16806[(2)] = inst_16655);

(statearr_16749_16806[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (11))){
var inst_16635 = (state_16708[(7)]);
var inst_16639 = (inst_16635 == null);
var inst_16640 = cljs.core.not(inst_16639);
var state_16708__$1 = state_16708;
if(inst_16640){
var statearr_16750_16807 = state_16708__$1;
(statearr_16750_16807[(1)] = (13));

} else {
var statearr_16751_16808 = state_16708__$1;
(statearr_16751_16808[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (9))){
var inst_16610 = (state_16708[(8)]);
var state_16708__$1 = state_16708;
var statearr_16752_16809 = state_16708__$1;
(statearr_16752_16809[(2)] = inst_16610);

(statearr_16752_16809[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (5))){
var state_16708__$1 = state_16708;
var statearr_16753_16810 = state_16708__$1;
(statearr_16753_16810[(2)] = true);

(statearr_16753_16810[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (14))){
var state_16708__$1 = state_16708;
var statearr_16754_16811 = state_16708__$1;
(statearr_16754_16811[(2)] = false);

(statearr_16754_16811[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (26))){
var inst_16668 = (state_16708[(11)]);
var inst_16675 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_16668);
var state_16708__$1 = state_16708;
var statearr_16755_16812 = state_16708__$1;
(statearr_16755_16812[(2)] = inst_16675);

(statearr_16755_16812[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (16))){
var state_16708__$1 = state_16708;
var statearr_16756_16813 = state_16708__$1;
(statearr_16756_16813[(2)] = true);

(statearr_16756_16813[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (38))){
var inst_16698 = (state_16708[(2)]);
var state_16708__$1 = state_16708;
var statearr_16757_16814 = state_16708__$1;
(statearr_16757_16814[(2)] = inst_16698);

(statearr_16757_16814[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (30))){
var inst_16660 = (state_16708[(13)]);
var inst_16659 = (state_16708[(9)]);
var inst_16668 = (state_16708[(11)]);
var inst_16685 = cljs.core.empty_QMARK_(inst_16659);
var inst_16686 = (inst_16660.cljs$core$IFn$_invoke$arity$1 ? inst_16660.cljs$core$IFn$_invoke$arity$1(inst_16668) : inst_16660.call(null,inst_16668));
var inst_16687 = cljs.core.not(inst_16686);
var inst_16688 = (inst_16685) && (inst_16687);
var state_16708__$1 = state_16708;
var statearr_16758_16815 = state_16708__$1;
(statearr_16758_16815[(2)] = inst_16688);

(statearr_16758_16815[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (10))){
var inst_16610 = (state_16708[(8)]);
var inst_16631 = (state_16708[(2)]);
var inst_16632 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16631,cljs.core.cst$kw$solos);
var inst_16633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16631,cljs.core.cst$kw$mutes);
var inst_16634 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16631,cljs.core.cst$kw$reads);
var inst_16635 = inst_16610;
var state_16708__$1 = (function (){var statearr_16759 = state_16708;
(statearr_16759[(16)] = inst_16634);

(statearr_16759[(17)] = inst_16633);

(statearr_16759[(18)] = inst_16632);

(statearr_16759[(7)] = inst_16635);

return statearr_16759;
})();
var statearr_16760_16816 = state_16708__$1;
(statearr_16760_16816[(2)] = null);

(statearr_16760_16816[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (18))){
var inst_16650 = (state_16708[(2)]);
var state_16708__$1 = state_16708;
var statearr_16761_16817 = state_16708__$1;
(statearr_16761_16817[(2)] = inst_16650);

(statearr_16761_16817[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (37))){
var state_16708__$1 = state_16708;
var statearr_16762_16818 = state_16708__$1;
(statearr_16762_16818[(2)] = null);

(statearr_16762_16818[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16709 === (8))){
var inst_16610 = (state_16708[(8)]);
var inst_16628 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_16610);
var state_16708__$1 = state_16708;
var statearr_16763_16819 = state_16708__$1;
(statearr_16763_16819[(2)] = inst_16628);

(statearr_16763_16819[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___16773,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14927__auto__,c__15051__auto___16773,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14928__auto__ = null;
var cljs$core$async$mix_$_state_machine__14928__auto____0 = (function (){
var statearr_16767 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16767[(0)] = cljs$core$async$mix_$_state_machine__14928__auto__);

(statearr_16767[(1)] = (1));

return statearr_16767;
});
var cljs$core$async$mix_$_state_machine__14928__auto____1 = (function (state_16708){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_16708);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e16768){if((e16768 instanceof Object)){
var ex__14931__auto__ = e16768;
var statearr_16769_16820 = state_16708;
(statearr_16769_16820[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16708);

return cljs.core.cst$kw$recur;
} else {
throw e16768;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__16821 = state_16708;
state_16708 = G__16821;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14928__auto__ = function(state_16708){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14928__auto____1.call(this,state_16708);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14928__auto____0;
cljs$core$async$mix_$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14928__auto____1;
return cljs$core$async$mix_$_state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___16773,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__15053__auto__ = (function (){var statearr_16770 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_16770[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___16773);

return statearr_16770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___16773,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7957__auto__ = (((p == null))?null:p);
var m__7958__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7958__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7958__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7958__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7957__auto__ = (((p == null))?null:p);
var m__7958__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7958__auto__.call(null,p,v,ch));
} else {
var m__7958__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7958__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16822 = [];
var len__8402__auto___16825 = arguments.length;
var i__8403__auto___16826 = (0);
while(true){
if((i__8403__auto___16826 < len__8402__auto___16825)){
args16822.push((arguments[i__8403__auto___16826]));

var G__16827 = (i__8403__auto___16826 + (1));
i__8403__auto___16826 = G__16827;
continue;
} else {
}
break;
}

var G__16824 = args16822.length;
switch (G__16824) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16822.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7957__auto__ = (((p == null))?null:p);
var m__7958__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7958__auto__.call(null,p));
} else {
var m__7958__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7958__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7957__auto__ = (((p == null))?null:p);
var m__7958__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7958__auto__.call(null,p,v));
} else {
var m__7958__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7958__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16830 = [];
var len__8402__auto___16958 = arguments.length;
var i__8403__auto___16959 = (0);
while(true){
if((i__8403__auto___16959 < len__8402__auto___16958)){
args16830.push((arguments[i__8403__auto___16959]));

var G__16960 = (i__8403__auto___16959 + (1));
i__8403__auto___16959 = G__16960;
continue;
} else {
}
break;
}

var G__16832 = args16830.length;
switch (G__16832) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16830.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__16833 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16833) : cljs.core.atom.call(null,G__16833));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__7289__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__7289__auto__,mults){
return (function (p1__16829_SHARP_){
if(cljs.core.truth_((p1__16829_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16829_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__16829_SHARP_.call(null,topic)))){
return p1__16829_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16829_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__7289__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16834 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16834 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16835){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16835 = meta16835;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16834.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16836,meta16835__$1){
var self__ = this;
var _16836__$1 = this;
return (new cljs.core.async.t_cljs$core$async16834(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16835__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16834.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16836){
var self__ = this;
var _16836__$1 = this;
return self__.meta16835;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16834.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16834.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16834.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16834.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16834.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16834.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__16837 = self__.mults;
var G__16838 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__16837,G__16838) : cljs.core.reset_BANG_.call(null,G__16837,G__16838));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16834.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16834.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta16835], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16834.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16834.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16834";

cljs.core.async.t_cljs$core$async16834.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async16834");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16834 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16834(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16835){
return (new cljs.core.async.t_cljs$core$async16834(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16835));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16834(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__15051__auto___16962 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___16962,mults,ensure_mult,p){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___16962,mults,ensure_mult,p){
return (function (state_16910){
var state_val_16911 = (state_16910[(1)]);
if((state_val_16911 === (7))){
var inst_16906 = (state_16910[(2)]);
var state_16910__$1 = state_16910;
var statearr_16912_16963 = state_16910__$1;
(statearr_16912_16963[(2)] = inst_16906);

(statearr_16912_16963[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (20))){
var state_16910__$1 = state_16910;
var statearr_16913_16964 = state_16910__$1;
(statearr_16913_16964[(2)] = null);

(statearr_16913_16964[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (1))){
var state_16910__$1 = state_16910;
var statearr_16914_16965 = state_16910__$1;
(statearr_16914_16965[(2)] = null);

(statearr_16914_16965[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (24))){
var inst_16889 = (state_16910[(7)]);
var inst_16898 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_16889);
var state_16910__$1 = state_16910;
var statearr_16915_16966 = state_16910__$1;
(statearr_16915_16966[(2)] = inst_16898);

(statearr_16915_16966[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (4))){
var inst_16841 = (state_16910[(8)]);
var inst_16841__$1 = (state_16910[(2)]);
var inst_16842 = (inst_16841__$1 == null);
var state_16910__$1 = (function (){var statearr_16916 = state_16910;
(statearr_16916[(8)] = inst_16841__$1);

return statearr_16916;
})();
if(cljs.core.truth_(inst_16842)){
var statearr_16917_16967 = state_16910__$1;
(statearr_16917_16967[(1)] = (5));

} else {
var statearr_16918_16968 = state_16910__$1;
(statearr_16918_16968[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (15))){
var inst_16883 = (state_16910[(2)]);
var state_16910__$1 = state_16910;
var statearr_16919_16969 = state_16910__$1;
(statearr_16919_16969[(2)] = inst_16883);

(statearr_16919_16969[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (21))){
var inst_16903 = (state_16910[(2)]);
var state_16910__$1 = (function (){var statearr_16920 = state_16910;
(statearr_16920[(9)] = inst_16903);

return statearr_16920;
})();
var statearr_16921_16970 = state_16910__$1;
(statearr_16921_16970[(2)] = null);

(statearr_16921_16970[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (13))){
var inst_16865 = (state_16910[(10)]);
var inst_16867 = cljs.core.chunked_seq_QMARK_(inst_16865);
var state_16910__$1 = state_16910;
if(inst_16867){
var statearr_16922_16971 = state_16910__$1;
(statearr_16922_16971[(1)] = (16));

} else {
var statearr_16923_16972 = state_16910__$1;
(statearr_16923_16972[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (22))){
var inst_16895 = (state_16910[(2)]);
var state_16910__$1 = state_16910;
if(cljs.core.truth_(inst_16895)){
var statearr_16924_16973 = state_16910__$1;
(statearr_16924_16973[(1)] = (23));

} else {
var statearr_16925_16974 = state_16910__$1;
(statearr_16925_16974[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (6))){
var inst_16841 = (state_16910[(8)]);
var inst_16889 = (state_16910[(7)]);
var inst_16891 = (state_16910[(11)]);
var inst_16889__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_16841) : topic_fn.call(null,inst_16841));
var inst_16890 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_16891__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16890,inst_16889__$1);
var state_16910__$1 = (function (){var statearr_16926 = state_16910;
(statearr_16926[(7)] = inst_16889__$1);

(statearr_16926[(11)] = inst_16891__$1);

return statearr_16926;
})();
if(cljs.core.truth_(inst_16891__$1)){
var statearr_16927_16975 = state_16910__$1;
(statearr_16927_16975[(1)] = (19));

} else {
var statearr_16928_16976 = state_16910__$1;
(statearr_16928_16976[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (25))){
var inst_16900 = (state_16910[(2)]);
var state_16910__$1 = state_16910;
var statearr_16929_16977 = state_16910__$1;
(statearr_16929_16977[(2)] = inst_16900);

(statearr_16929_16977[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (17))){
var inst_16865 = (state_16910[(10)]);
var inst_16874 = cljs.core.first(inst_16865);
var inst_16875 = cljs.core.async.muxch_STAR_(inst_16874);
var inst_16876 = cljs.core.async.close_BANG_(inst_16875);
var inst_16877 = cljs.core.next(inst_16865);
var inst_16851 = inst_16877;
var inst_16852 = null;
var inst_16853 = (0);
var inst_16854 = (0);
var state_16910__$1 = (function (){var statearr_16930 = state_16910;
(statearr_16930[(12)] = inst_16851);

(statearr_16930[(13)] = inst_16852);

(statearr_16930[(14)] = inst_16853);

(statearr_16930[(15)] = inst_16854);

(statearr_16930[(16)] = inst_16876);

return statearr_16930;
})();
var statearr_16931_16978 = state_16910__$1;
(statearr_16931_16978[(2)] = null);

(statearr_16931_16978[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (3))){
var inst_16908 = (state_16910[(2)]);
var state_16910__$1 = state_16910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16910__$1,inst_16908);
} else {
if((state_val_16911 === (12))){
var inst_16885 = (state_16910[(2)]);
var state_16910__$1 = state_16910;
var statearr_16932_16979 = state_16910__$1;
(statearr_16932_16979[(2)] = inst_16885);

(statearr_16932_16979[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (2))){
var state_16910__$1 = state_16910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16910__$1,(4),ch);
} else {
if((state_val_16911 === (23))){
var state_16910__$1 = state_16910;
var statearr_16933_16980 = state_16910__$1;
(statearr_16933_16980[(2)] = null);

(statearr_16933_16980[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (19))){
var inst_16841 = (state_16910[(8)]);
var inst_16891 = (state_16910[(11)]);
var inst_16893 = cljs.core.async.muxch_STAR_(inst_16891);
var state_16910__$1 = state_16910;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16910__$1,(22),inst_16893,inst_16841);
} else {
if((state_val_16911 === (11))){
var inst_16865 = (state_16910[(10)]);
var inst_16851 = (state_16910[(12)]);
var inst_16865__$1 = cljs.core.seq(inst_16851);
var state_16910__$1 = (function (){var statearr_16934 = state_16910;
(statearr_16934[(10)] = inst_16865__$1);

return statearr_16934;
})();
if(inst_16865__$1){
var statearr_16935_16981 = state_16910__$1;
(statearr_16935_16981[(1)] = (13));

} else {
var statearr_16936_16982 = state_16910__$1;
(statearr_16936_16982[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (9))){
var inst_16887 = (state_16910[(2)]);
var state_16910__$1 = state_16910;
var statearr_16937_16983 = state_16910__$1;
(statearr_16937_16983[(2)] = inst_16887);

(statearr_16937_16983[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (5))){
var inst_16848 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_16849 = cljs.core.vals(inst_16848);
var inst_16850 = cljs.core.seq(inst_16849);
var inst_16851 = inst_16850;
var inst_16852 = null;
var inst_16853 = (0);
var inst_16854 = (0);
var state_16910__$1 = (function (){var statearr_16938 = state_16910;
(statearr_16938[(12)] = inst_16851);

(statearr_16938[(13)] = inst_16852);

(statearr_16938[(14)] = inst_16853);

(statearr_16938[(15)] = inst_16854);

return statearr_16938;
})();
var statearr_16939_16984 = state_16910__$1;
(statearr_16939_16984[(2)] = null);

(statearr_16939_16984[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (14))){
var state_16910__$1 = state_16910;
var statearr_16943_16985 = state_16910__$1;
(statearr_16943_16985[(2)] = null);

(statearr_16943_16985[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (16))){
var inst_16865 = (state_16910[(10)]);
var inst_16869 = cljs.core.chunk_first(inst_16865);
var inst_16870 = cljs.core.chunk_rest(inst_16865);
var inst_16871 = cljs.core.count(inst_16869);
var inst_16851 = inst_16870;
var inst_16852 = inst_16869;
var inst_16853 = inst_16871;
var inst_16854 = (0);
var state_16910__$1 = (function (){var statearr_16944 = state_16910;
(statearr_16944[(12)] = inst_16851);

(statearr_16944[(13)] = inst_16852);

(statearr_16944[(14)] = inst_16853);

(statearr_16944[(15)] = inst_16854);

return statearr_16944;
})();
var statearr_16945_16986 = state_16910__$1;
(statearr_16945_16986[(2)] = null);

(statearr_16945_16986[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (10))){
var inst_16851 = (state_16910[(12)]);
var inst_16852 = (state_16910[(13)]);
var inst_16853 = (state_16910[(14)]);
var inst_16854 = (state_16910[(15)]);
var inst_16859 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16852,inst_16854);
var inst_16860 = cljs.core.async.muxch_STAR_(inst_16859);
var inst_16861 = cljs.core.async.close_BANG_(inst_16860);
var inst_16862 = (inst_16854 + (1));
var tmp16940 = inst_16851;
var tmp16941 = inst_16852;
var tmp16942 = inst_16853;
var inst_16851__$1 = tmp16940;
var inst_16852__$1 = tmp16941;
var inst_16853__$1 = tmp16942;
var inst_16854__$1 = inst_16862;
var state_16910__$1 = (function (){var statearr_16946 = state_16910;
(statearr_16946[(12)] = inst_16851__$1);

(statearr_16946[(13)] = inst_16852__$1);

(statearr_16946[(14)] = inst_16853__$1);

(statearr_16946[(17)] = inst_16861);

(statearr_16946[(15)] = inst_16854__$1);

return statearr_16946;
})();
var statearr_16947_16987 = state_16910__$1;
(statearr_16947_16987[(2)] = null);

(statearr_16947_16987[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (18))){
var inst_16880 = (state_16910[(2)]);
var state_16910__$1 = state_16910;
var statearr_16948_16988 = state_16910__$1;
(statearr_16948_16988[(2)] = inst_16880);

(statearr_16948_16988[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16911 === (8))){
var inst_16853 = (state_16910[(14)]);
var inst_16854 = (state_16910[(15)]);
var inst_16856 = (inst_16854 < inst_16853);
var inst_16857 = inst_16856;
var state_16910__$1 = state_16910;
if(cljs.core.truth_(inst_16857)){
var statearr_16949_16989 = state_16910__$1;
(statearr_16949_16989[(1)] = (10));

} else {
var statearr_16950_16990 = state_16910__$1;
(statearr_16950_16990[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___16962,mults,ensure_mult,p))
;
return ((function (switch__14927__auto__,c__15051__auto___16962,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14928__auto__ = null;
var cljs$core$async$state_machine__14928__auto____0 = (function (){
var statearr_16954 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16954[(0)] = cljs$core$async$state_machine__14928__auto__);

(statearr_16954[(1)] = (1));

return statearr_16954;
});
var cljs$core$async$state_machine__14928__auto____1 = (function (state_16910){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_16910);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e16955){if((e16955 instanceof Object)){
var ex__14931__auto__ = e16955;
var statearr_16956_16991 = state_16910;
(statearr_16956_16991[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16910);

return cljs.core.cst$kw$recur;
} else {
throw e16955;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__16992 = state_16910;
state_16910 = G__16992;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$state_machine__14928__auto__ = function(state_16910){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14928__auto____1.call(this,state_16910);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14928__auto____0;
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14928__auto____1;
return cljs$core$async$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___16962,mults,ensure_mult,p))
})();
var state__15053__auto__ = (function (){var statearr_16957 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_16957[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___16962);

return statearr_16957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___16962,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args16993 = [];
var len__8402__auto___16996 = arguments.length;
var i__8403__auto___16997 = (0);
while(true){
if((i__8403__auto___16997 < len__8402__auto___16996)){
args16993.push((arguments[i__8403__auto___16997]));

var G__16998 = (i__8403__auto___16997 + (1));
i__8403__auto___16997 = G__16998;
continue;
} else {
}
break;
}

var G__16995 = args16993.length;
switch (G__16995) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16993.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args17000 = [];
var len__8402__auto___17003 = arguments.length;
var i__8403__auto___17004 = (0);
while(true){
if((i__8403__auto___17004 < len__8402__auto___17003)){
args17000.push((arguments[i__8403__auto___17004]));

var G__17005 = (i__8403__auto___17004 + (1));
i__8403__auto___17004 = G__17005;
continue;
} else {
}
break;
}

var G__17002 = args17000.length;
switch (G__17002) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17000.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args17007 = [];
var len__8402__auto___17078 = arguments.length;
var i__8403__auto___17079 = (0);
while(true){
if((i__8403__auto___17079 < len__8402__auto___17078)){
args17007.push((arguments[i__8403__auto___17079]));

var G__17080 = (i__8403__auto___17079 + (1));
i__8403__auto___17079 = G__17080;
continue;
} else {
}
break;
}

var G__17009 = args17007.length;
switch (G__17009) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17007.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__15051__auto___17082 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___17082,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___17082,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_17048){
var state_val_17049 = (state_17048[(1)]);
if((state_val_17049 === (7))){
var state_17048__$1 = state_17048;
var statearr_17050_17083 = state_17048__$1;
(statearr_17050_17083[(2)] = null);

(statearr_17050_17083[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17049 === (1))){
var state_17048__$1 = state_17048;
var statearr_17051_17084 = state_17048__$1;
(statearr_17051_17084[(2)] = null);

(statearr_17051_17084[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17049 === (4))){
var inst_17012 = (state_17048[(7)]);
var inst_17014 = (inst_17012 < cnt);
var state_17048__$1 = state_17048;
if(cljs.core.truth_(inst_17014)){
var statearr_17052_17085 = state_17048__$1;
(statearr_17052_17085[(1)] = (6));

} else {
var statearr_17053_17086 = state_17048__$1;
(statearr_17053_17086[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17049 === (15))){
var inst_17044 = (state_17048[(2)]);
var state_17048__$1 = state_17048;
var statearr_17054_17087 = state_17048__$1;
(statearr_17054_17087[(2)] = inst_17044);

(statearr_17054_17087[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17049 === (13))){
var inst_17037 = cljs.core.async.close_BANG_(out);
var state_17048__$1 = state_17048;
var statearr_17055_17088 = state_17048__$1;
(statearr_17055_17088[(2)] = inst_17037);

(statearr_17055_17088[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17049 === (6))){
var state_17048__$1 = state_17048;
var statearr_17056_17089 = state_17048__$1;
(statearr_17056_17089[(2)] = null);

(statearr_17056_17089[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17049 === (3))){
var inst_17046 = (state_17048[(2)]);
var state_17048__$1 = state_17048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17048__$1,inst_17046);
} else {
if((state_val_17049 === (12))){
var inst_17034 = (state_17048[(8)]);
var inst_17034__$1 = (state_17048[(2)]);
var inst_17035 = cljs.core.some(cljs.core.nil_QMARK_,inst_17034__$1);
var state_17048__$1 = (function (){var statearr_17057 = state_17048;
(statearr_17057[(8)] = inst_17034__$1);

return statearr_17057;
})();
if(cljs.core.truth_(inst_17035)){
var statearr_17058_17090 = state_17048__$1;
(statearr_17058_17090[(1)] = (13));

} else {
var statearr_17059_17091 = state_17048__$1;
(statearr_17059_17091[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17049 === (2))){
var inst_17011 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_17012 = (0);
var state_17048__$1 = (function (){var statearr_17060 = state_17048;
(statearr_17060[(9)] = inst_17011);

(statearr_17060[(7)] = inst_17012);

return statearr_17060;
})();
var statearr_17061_17092 = state_17048__$1;
(statearr_17061_17092[(2)] = null);

(statearr_17061_17092[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17049 === (11))){
var inst_17012 = (state_17048[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_17048,(10),Object,null,(9));
var inst_17021 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_17012) : chs__$1.call(null,inst_17012));
var inst_17022 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_17012) : done.call(null,inst_17012));
var inst_17023 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_17021,inst_17022);
var state_17048__$1 = state_17048;
var statearr_17062_17093 = state_17048__$1;
(statearr_17062_17093[(2)] = inst_17023);


cljs.core.async.impl.ioc_helpers.process_exception(state_17048__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_17049 === (9))){
var inst_17012 = (state_17048[(7)]);
var inst_17025 = (state_17048[(2)]);
var inst_17026 = (inst_17012 + (1));
var inst_17012__$1 = inst_17026;
var state_17048__$1 = (function (){var statearr_17063 = state_17048;
(statearr_17063[(10)] = inst_17025);

(statearr_17063[(7)] = inst_17012__$1);

return statearr_17063;
})();
var statearr_17064_17094 = state_17048__$1;
(statearr_17064_17094[(2)] = null);

(statearr_17064_17094[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17049 === (5))){
var inst_17032 = (state_17048[(2)]);
var state_17048__$1 = (function (){var statearr_17065 = state_17048;
(statearr_17065[(11)] = inst_17032);

return statearr_17065;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17048__$1,(12),dchan);
} else {
if((state_val_17049 === (14))){
var inst_17034 = (state_17048[(8)]);
var inst_17039 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_17034);
var state_17048__$1 = state_17048;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17048__$1,(16),out,inst_17039);
} else {
if((state_val_17049 === (16))){
var inst_17041 = (state_17048[(2)]);
var state_17048__$1 = (function (){var statearr_17066 = state_17048;
(statearr_17066[(12)] = inst_17041);

return statearr_17066;
})();
var statearr_17067_17095 = state_17048__$1;
(statearr_17067_17095[(2)] = null);

(statearr_17067_17095[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17049 === (10))){
var inst_17016 = (state_17048[(2)]);
var inst_17017 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_17048__$1 = (function (){var statearr_17068 = state_17048;
(statearr_17068[(13)] = inst_17016);

return statearr_17068;
})();
var statearr_17069_17096 = state_17048__$1;
(statearr_17069_17096[(2)] = inst_17017);


cljs.core.async.impl.ioc_helpers.process_exception(state_17048__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_17049 === (8))){
var inst_17030 = (state_17048[(2)]);
var state_17048__$1 = state_17048;
var statearr_17070_17097 = state_17048__$1;
(statearr_17070_17097[(2)] = inst_17030);

(statearr_17070_17097[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___17082,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14927__auto__,c__15051__auto___17082,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14928__auto__ = null;
var cljs$core$async$state_machine__14928__auto____0 = (function (){
var statearr_17074 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17074[(0)] = cljs$core$async$state_machine__14928__auto__);

(statearr_17074[(1)] = (1));

return statearr_17074;
});
var cljs$core$async$state_machine__14928__auto____1 = (function (state_17048){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_17048);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e17075){if((e17075 instanceof Object)){
var ex__14931__auto__ = e17075;
var statearr_17076_17098 = state_17048;
(statearr_17076_17098[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17048);

return cljs.core.cst$kw$recur;
} else {
throw e17075;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__17099 = state_17048;
state_17048 = G__17099;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$state_machine__14928__auto__ = function(state_17048){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14928__auto____1.call(this,state_17048);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14928__auto____0;
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14928__auto____1;
return cljs$core$async$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___17082,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__15053__auto__ = (function (){var statearr_17077 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_17077[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___17082);

return statearr_17077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___17082,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args17101 = [];
var len__8402__auto___17159 = arguments.length;
var i__8403__auto___17160 = (0);
while(true){
if((i__8403__auto___17160 < len__8402__auto___17159)){
args17101.push((arguments[i__8403__auto___17160]));

var G__17161 = (i__8403__auto___17160 + (1));
i__8403__auto___17160 = G__17161;
continue;
} else {
}
break;
}

var G__17103 = args17101.length;
switch (G__17103) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17101.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15051__auto___17163 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___17163,out){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___17163,out){
return (function (state_17135){
var state_val_17136 = (state_17135[(1)]);
if((state_val_17136 === (7))){
var inst_17114 = (state_17135[(7)]);
var inst_17115 = (state_17135[(8)]);
var inst_17114__$1 = (state_17135[(2)]);
var inst_17115__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17114__$1,(0),null);
var inst_17116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17114__$1,(1),null);
var inst_17117 = (inst_17115__$1 == null);
var state_17135__$1 = (function (){var statearr_17137 = state_17135;
(statearr_17137[(7)] = inst_17114__$1);

(statearr_17137[(8)] = inst_17115__$1);

(statearr_17137[(9)] = inst_17116);

return statearr_17137;
})();
if(cljs.core.truth_(inst_17117)){
var statearr_17138_17164 = state_17135__$1;
(statearr_17138_17164[(1)] = (8));

} else {
var statearr_17139_17165 = state_17135__$1;
(statearr_17139_17165[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17136 === (1))){
var inst_17104 = cljs.core.vec(chs);
var inst_17105 = inst_17104;
var state_17135__$1 = (function (){var statearr_17140 = state_17135;
(statearr_17140[(10)] = inst_17105);

return statearr_17140;
})();
var statearr_17141_17166 = state_17135__$1;
(statearr_17141_17166[(2)] = null);

(statearr_17141_17166[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17136 === (4))){
var inst_17105 = (state_17135[(10)]);
var state_17135__$1 = state_17135;
return cljs.core.async.ioc_alts_BANG_(state_17135__$1,(7),inst_17105);
} else {
if((state_val_17136 === (6))){
var inst_17131 = (state_17135[(2)]);
var state_17135__$1 = state_17135;
var statearr_17142_17167 = state_17135__$1;
(statearr_17142_17167[(2)] = inst_17131);

(statearr_17142_17167[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17136 === (3))){
var inst_17133 = (state_17135[(2)]);
var state_17135__$1 = state_17135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17135__$1,inst_17133);
} else {
if((state_val_17136 === (2))){
var inst_17105 = (state_17135[(10)]);
var inst_17107 = cljs.core.count(inst_17105);
var inst_17108 = (inst_17107 > (0));
var state_17135__$1 = state_17135;
if(cljs.core.truth_(inst_17108)){
var statearr_17144_17168 = state_17135__$1;
(statearr_17144_17168[(1)] = (4));

} else {
var statearr_17145_17169 = state_17135__$1;
(statearr_17145_17169[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17136 === (11))){
var inst_17105 = (state_17135[(10)]);
var inst_17124 = (state_17135[(2)]);
var tmp17143 = inst_17105;
var inst_17105__$1 = tmp17143;
var state_17135__$1 = (function (){var statearr_17146 = state_17135;
(statearr_17146[(10)] = inst_17105__$1);

(statearr_17146[(11)] = inst_17124);

return statearr_17146;
})();
var statearr_17147_17170 = state_17135__$1;
(statearr_17147_17170[(2)] = null);

(statearr_17147_17170[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17136 === (9))){
var inst_17115 = (state_17135[(8)]);
var state_17135__$1 = state_17135;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17135__$1,(11),out,inst_17115);
} else {
if((state_val_17136 === (5))){
var inst_17129 = cljs.core.async.close_BANG_(out);
var state_17135__$1 = state_17135;
var statearr_17148_17171 = state_17135__$1;
(statearr_17148_17171[(2)] = inst_17129);

(statearr_17148_17171[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17136 === (10))){
var inst_17127 = (state_17135[(2)]);
var state_17135__$1 = state_17135;
var statearr_17149_17172 = state_17135__$1;
(statearr_17149_17172[(2)] = inst_17127);

(statearr_17149_17172[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17136 === (8))){
var inst_17105 = (state_17135[(10)]);
var inst_17114 = (state_17135[(7)]);
var inst_17115 = (state_17135[(8)]);
var inst_17116 = (state_17135[(9)]);
var inst_17119 = (function (){var cs = inst_17105;
var vec__17110 = inst_17114;
var v = inst_17115;
var c = inst_17116;
return ((function (cs,vec__17110,v,c,inst_17105,inst_17114,inst_17115,inst_17116,state_val_17136,c__15051__auto___17163,out){
return (function (p1__17100_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__17100_SHARP_);
});
;})(cs,vec__17110,v,c,inst_17105,inst_17114,inst_17115,inst_17116,state_val_17136,c__15051__auto___17163,out))
})();
var inst_17120 = cljs.core.filterv(inst_17119,inst_17105);
var inst_17105__$1 = inst_17120;
var state_17135__$1 = (function (){var statearr_17150 = state_17135;
(statearr_17150[(10)] = inst_17105__$1);

return statearr_17150;
})();
var statearr_17151_17173 = state_17135__$1;
(statearr_17151_17173[(2)] = null);

(statearr_17151_17173[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___17163,out))
;
return ((function (switch__14927__auto__,c__15051__auto___17163,out){
return (function() {
var cljs$core$async$state_machine__14928__auto__ = null;
var cljs$core$async$state_machine__14928__auto____0 = (function (){
var statearr_17155 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17155[(0)] = cljs$core$async$state_machine__14928__auto__);

(statearr_17155[(1)] = (1));

return statearr_17155;
});
var cljs$core$async$state_machine__14928__auto____1 = (function (state_17135){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_17135);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e17156){if((e17156 instanceof Object)){
var ex__14931__auto__ = e17156;
var statearr_17157_17174 = state_17135;
(statearr_17157_17174[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17135);

return cljs.core.cst$kw$recur;
} else {
throw e17156;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__17175 = state_17135;
state_17135 = G__17175;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$state_machine__14928__auto__ = function(state_17135){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14928__auto____1.call(this,state_17135);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14928__auto____0;
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14928__auto____1;
return cljs$core$async$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___17163,out))
})();
var state__15053__auto__ = (function (){var statearr_17158 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_17158[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___17163);

return statearr_17158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___17163,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args17176 = [];
var len__8402__auto___17225 = arguments.length;
var i__8403__auto___17226 = (0);
while(true){
if((i__8403__auto___17226 < len__8402__auto___17225)){
args17176.push((arguments[i__8403__auto___17226]));

var G__17227 = (i__8403__auto___17226 + (1));
i__8403__auto___17226 = G__17227;
continue;
} else {
}
break;
}

var G__17178 = args17176.length;
switch (G__17178) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17176.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15051__auto___17229 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___17229,out){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___17229,out){
return (function (state_17202){
var state_val_17203 = (state_17202[(1)]);
if((state_val_17203 === (7))){
var inst_17184 = (state_17202[(7)]);
var inst_17184__$1 = (state_17202[(2)]);
var inst_17185 = (inst_17184__$1 == null);
var inst_17186 = cljs.core.not(inst_17185);
var state_17202__$1 = (function (){var statearr_17204 = state_17202;
(statearr_17204[(7)] = inst_17184__$1);

return statearr_17204;
})();
if(inst_17186){
var statearr_17205_17230 = state_17202__$1;
(statearr_17205_17230[(1)] = (8));

} else {
var statearr_17206_17231 = state_17202__$1;
(statearr_17206_17231[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17203 === (1))){
var inst_17179 = (0);
var state_17202__$1 = (function (){var statearr_17207 = state_17202;
(statearr_17207[(8)] = inst_17179);

return statearr_17207;
})();
var statearr_17208_17232 = state_17202__$1;
(statearr_17208_17232[(2)] = null);

(statearr_17208_17232[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17203 === (4))){
var state_17202__$1 = state_17202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17202__$1,(7),ch);
} else {
if((state_val_17203 === (6))){
var inst_17197 = (state_17202[(2)]);
var state_17202__$1 = state_17202;
var statearr_17209_17233 = state_17202__$1;
(statearr_17209_17233[(2)] = inst_17197);

(statearr_17209_17233[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17203 === (3))){
var inst_17199 = (state_17202[(2)]);
var inst_17200 = cljs.core.async.close_BANG_(out);
var state_17202__$1 = (function (){var statearr_17210 = state_17202;
(statearr_17210[(9)] = inst_17199);

return statearr_17210;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17202__$1,inst_17200);
} else {
if((state_val_17203 === (2))){
var inst_17179 = (state_17202[(8)]);
var inst_17181 = (inst_17179 < n);
var state_17202__$1 = state_17202;
if(cljs.core.truth_(inst_17181)){
var statearr_17211_17234 = state_17202__$1;
(statearr_17211_17234[(1)] = (4));

} else {
var statearr_17212_17235 = state_17202__$1;
(statearr_17212_17235[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17203 === (11))){
var inst_17179 = (state_17202[(8)]);
var inst_17189 = (state_17202[(2)]);
var inst_17190 = (inst_17179 + (1));
var inst_17179__$1 = inst_17190;
var state_17202__$1 = (function (){var statearr_17213 = state_17202;
(statearr_17213[(10)] = inst_17189);

(statearr_17213[(8)] = inst_17179__$1);

return statearr_17213;
})();
var statearr_17214_17236 = state_17202__$1;
(statearr_17214_17236[(2)] = null);

(statearr_17214_17236[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17203 === (9))){
var state_17202__$1 = state_17202;
var statearr_17215_17237 = state_17202__$1;
(statearr_17215_17237[(2)] = null);

(statearr_17215_17237[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17203 === (5))){
var state_17202__$1 = state_17202;
var statearr_17216_17238 = state_17202__$1;
(statearr_17216_17238[(2)] = null);

(statearr_17216_17238[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17203 === (10))){
var inst_17194 = (state_17202[(2)]);
var state_17202__$1 = state_17202;
var statearr_17217_17239 = state_17202__$1;
(statearr_17217_17239[(2)] = inst_17194);

(statearr_17217_17239[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17203 === (8))){
var inst_17184 = (state_17202[(7)]);
var state_17202__$1 = state_17202;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17202__$1,(11),out,inst_17184);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___17229,out))
;
return ((function (switch__14927__auto__,c__15051__auto___17229,out){
return (function() {
var cljs$core$async$state_machine__14928__auto__ = null;
var cljs$core$async$state_machine__14928__auto____0 = (function (){
var statearr_17221 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17221[(0)] = cljs$core$async$state_machine__14928__auto__);

(statearr_17221[(1)] = (1));

return statearr_17221;
});
var cljs$core$async$state_machine__14928__auto____1 = (function (state_17202){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_17202);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e17222){if((e17222 instanceof Object)){
var ex__14931__auto__ = e17222;
var statearr_17223_17240 = state_17202;
(statearr_17223_17240[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17202);

return cljs.core.cst$kw$recur;
} else {
throw e17222;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__17241 = state_17202;
state_17202 = G__17241;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$state_machine__14928__auto__ = function(state_17202){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14928__auto____1.call(this,state_17202);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14928__auto____0;
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14928__auto____1;
return cljs$core$async$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___17229,out))
})();
var state__15053__auto__ = (function (){var statearr_17224 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_17224[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___17229);

return statearr_17224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___17229,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async17251 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17251 = (function (f,ch,meta17252){
this.f = f;
this.ch = ch;
this.meta17252 = meta17252;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17251.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17253,meta17252__$1){
var self__ = this;
var _17253__$1 = this;
return (new cljs.core.async.t_cljs$core$async17251(self__.f,self__.ch,meta17252__$1));
});

cljs.core.async.t_cljs$core$async17251.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17253){
var self__ = this;
var _17253__$1 = this;
return self__.meta17252;
});

cljs.core.async.t_cljs$core$async17251.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17251.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async17251.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async17251.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17251.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async17254 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17254 = (function (f,ch,meta17252,_,fn1,meta17255){
this.f = f;
this.ch = ch;
this.meta17252 = meta17252;
this._ = _;
this.fn1 = fn1;
this.meta17255 = meta17255;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17254.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_17256,meta17255__$1){
var self__ = this;
var _17256__$1 = this;
return (new cljs.core.async.t_cljs$core$async17254(self__.f,self__.ch,self__.meta17252,self__._,self__.fn1,meta17255__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async17254.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_17256){
var self__ = this;
var _17256__$1 = this;
return self__.meta17255;
});})(___$1))
;

cljs.core.async.t_cljs$core$async17254.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17254.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async17254.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__17242_SHARP_){
var G__17257 = (((p1__17242_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__17242_SHARP_) : self__.f.call(null,p1__17242_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__17257) : f1.call(null,G__17257));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async17254.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17252,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async17251], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta17255], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async17254.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17254.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17254";

cljs.core.async.t_cljs$core$async17254.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async17254");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async17254 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17254(f__$1,ch__$1,meta17252__$1,___$2,fn1__$1,meta17255){
return (new cljs.core.async.t_cljs$core$async17254(f__$1,ch__$1,meta17252__$1,___$2,fn1__$1,meta17255));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async17254(self__.f,self__.ch,self__.meta17252,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__7277__auto__ = ret;
if(cljs.core.truth_(and__7277__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__7277__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__17258 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__17258) : self__.f.call(null,G__17258));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async17251.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17251.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async17251.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17252], null);
});

cljs.core.async.t_cljs$core$async17251.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17251.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17251";

cljs.core.async.t_cljs$core$async17251.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async17251");
});

cljs.core.async.__GT_t_cljs$core$async17251 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17251(f__$1,ch__$1,meta17252){
return (new cljs.core.async.t_cljs$core$async17251(f__$1,ch__$1,meta17252));
});

}

return (new cljs.core.async.t_cljs$core$async17251(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async17262 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17262 = (function (f,ch,meta17263){
this.f = f;
this.ch = ch;
this.meta17263 = meta17263;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17262.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17264,meta17263__$1){
var self__ = this;
var _17264__$1 = this;
return (new cljs.core.async.t_cljs$core$async17262(self__.f,self__.ch,meta17263__$1));
});

cljs.core.async.t_cljs$core$async17262.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17264){
var self__ = this;
var _17264__$1 = this;
return self__.meta17263;
});

cljs.core.async.t_cljs$core$async17262.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17262.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async17262.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17262.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async17262.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17262.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async17262.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17263], null);
});

cljs.core.async.t_cljs$core$async17262.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17262.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17262";

cljs.core.async.t_cljs$core$async17262.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async17262");
});

cljs.core.async.__GT_t_cljs$core$async17262 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async17262(f__$1,ch__$1,meta17263){
return (new cljs.core.async.t_cljs$core$async17262(f__$1,ch__$1,meta17263));
});

}

return (new cljs.core.async.t_cljs$core$async17262(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async17268 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17268 = (function (p,ch,meta17269){
this.p = p;
this.ch = ch;
this.meta17269 = meta17269;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17270,meta17269__$1){
var self__ = this;
var _17270__$1 = this;
return (new cljs.core.async.t_cljs$core$async17268(self__.p,self__.ch,meta17269__$1));
});

cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17270){
var self__ = this;
var _17270__$1 = this;
return self__.meta17269;
});

cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async17268.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17269], null);
});

cljs.core.async.t_cljs$core$async17268.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17268.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17268";

cljs.core.async.t_cljs$core$async17268.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async17268");
});

cljs.core.async.__GT_t_cljs$core$async17268 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async17268(p__$1,ch__$1,meta17269){
return (new cljs.core.async.t_cljs$core$async17268(p__$1,ch__$1,meta17269));
});

}

return (new cljs.core.async.t_cljs$core$async17268(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args17271 = [];
var len__8402__auto___17315 = arguments.length;
var i__8403__auto___17316 = (0);
while(true){
if((i__8403__auto___17316 < len__8402__auto___17315)){
args17271.push((arguments[i__8403__auto___17316]));

var G__17317 = (i__8403__auto___17316 + (1));
i__8403__auto___17316 = G__17317;
continue;
} else {
}
break;
}

var G__17273 = args17271.length;
switch (G__17273) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17271.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15051__auto___17319 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___17319,out){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___17319,out){
return (function (state_17294){
var state_val_17295 = (state_17294[(1)]);
if((state_val_17295 === (7))){
var inst_17290 = (state_17294[(2)]);
var state_17294__$1 = state_17294;
var statearr_17296_17320 = state_17294__$1;
(statearr_17296_17320[(2)] = inst_17290);

(statearr_17296_17320[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17295 === (1))){
var state_17294__$1 = state_17294;
var statearr_17297_17321 = state_17294__$1;
(statearr_17297_17321[(2)] = null);

(statearr_17297_17321[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17295 === (4))){
var inst_17276 = (state_17294[(7)]);
var inst_17276__$1 = (state_17294[(2)]);
var inst_17277 = (inst_17276__$1 == null);
var state_17294__$1 = (function (){var statearr_17298 = state_17294;
(statearr_17298[(7)] = inst_17276__$1);

return statearr_17298;
})();
if(cljs.core.truth_(inst_17277)){
var statearr_17299_17322 = state_17294__$1;
(statearr_17299_17322[(1)] = (5));

} else {
var statearr_17300_17323 = state_17294__$1;
(statearr_17300_17323[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17295 === (6))){
var inst_17276 = (state_17294[(7)]);
var inst_17281 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17276) : p.call(null,inst_17276));
var state_17294__$1 = state_17294;
if(cljs.core.truth_(inst_17281)){
var statearr_17301_17324 = state_17294__$1;
(statearr_17301_17324[(1)] = (8));

} else {
var statearr_17302_17325 = state_17294__$1;
(statearr_17302_17325[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17295 === (3))){
var inst_17292 = (state_17294[(2)]);
var state_17294__$1 = state_17294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17294__$1,inst_17292);
} else {
if((state_val_17295 === (2))){
var state_17294__$1 = state_17294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17294__$1,(4),ch);
} else {
if((state_val_17295 === (11))){
var inst_17284 = (state_17294[(2)]);
var state_17294__$1 = state_17294;
var statearr_17303_17326 = state_17294__$1;
(statearr_17303_17326[(2)] = inst_17284);

(statearr_17303_17326[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17295 === (9))){
var state_17294__$1 = state_17294;
var statearr_17304_17327 = state_17294__$1;
(statearr_17304_17327[(2)] = null);

(statearr_17304_17327[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17295 === (5))){
var inst_17279 = cljs.core.async.close_BANG_(out);
var state_17294__$1 = state_17294;
var statearr_17305_17328 = state_17294__$1;
(statearr_17305_17328[(2)] = inst_17279);

(statearr_17305_17328[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17295 === (10))){
var inst_17287 = (state_17294[(2)]);
var state_17294__$1 = (function (){var statearr_17306 = state_17294;
(statearr_17306[(8)] = inst_17287);

return statearr_17306;
})();
var statearr_17307_17329 = state_17294__$1;
(statearr_17307_17329[(2)] = null);

(statearr_17307_17329[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17295 === (8))){
var inst_17276 = (state_17294[(7)]);
var state_17294__$1 = state_17294;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17294__$1,(11),out,inst_17276);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___17319,out))
;
return ((function (switch__14927__auto__,c__15051__auto___17319,out){
return (function() {
var cljs$core$async$state_machine__14928__auto__ = null;
var cljs$core$async$state_machine__14928__auto____0 = (function (){
var statearr_17311 = [null,null,null,null,null,null,null,null,null];
(statearr_17311[(0)] = cljs$core$async$state_machine__14928__auto__);

(statearr_17311[(1)] = (1));

return statearr_17311;
});
var cljs$core$async$state_machine__14928__auto____1 = (function (state_17294){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_17294);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e17312){if((e17312 instanceof Object)){
var ex__14931__auto__ = e17312;
var statearr_17313_17330 = state_17294;
(statearr_17313_17330[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17294);

return cljs.core.cst$kw$recur;
} else {
throw e17312;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__17331 = state_17294;
state_17294 = G__17331;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$state_machine__14928__auto__ = function(state_17294){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14928__auto____1.call(this,state_17294);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14928__auto____0;
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14928__auto____1;
return cljs$core$async$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___17319,out))
})();
var state__15053__auto__ = (function (){var statearr_17314 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_17314[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___17319);

return statearr_17314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___17319,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args17332 = [];
var len__8402__auto___17335 = arguments.length;
var i__8403__auto___17336 = (0);
while(true){
if((i__8403__auto___17336 < len__8402__auto___17335)){
args17332.push((arguments[i__8403__auto___17336]));

var G__17337 = (i__8403__auto___17336 + (1));
i__8403__auto___17336 = G__17337;
continue;
} else {
}
break;
}

var G__17334 = args17332.length;
switch (G__17334) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17332.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__15051__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto__){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto__){
return (function (state_17504){
var state_val_17505 = (state_17504[(1)]);
if((state_val_17505 === (7))){
var inst_17500 = (state_17504[(2)]);
var state_17504__$1 = state_17504;
var statearr_17506_17547 = state_17504__$1;
(statearr_17506_17547[(2)] = inst_17500);

(statearr_17506_17547[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (20))){
var inst_17470 = (state_17504[(7)]);
var inst_17481 = (state_17504[(2)]);
var inst_17482 = cljs.core.next(inst_17470);
var inst_17456 = inst_17482;
var inst_17457 = null;
var inst_17458 = (0);
var inst_17459 = (0);
var state_17504__$1 = (function (){var statearr_17507 = state_17504;
(statearr_17507[(8)] = inst_17481);

(statearr_17507[(9)] = inst_17456);

(statearr_17507[(10)] = inst_17459);

(statearr_17507[(11)] = inst_17457);

(statearr_17507[(12)] = inst_17458);

return statearr_17507;
})();
var statearr_17508_17548 = state_17504__$1;
(statearr_17508_17548[(2)] = null);

(statearr_17508_17548[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (1))){
var state_17504__$1 = state_17504;
var statearr_17509_17549 = state_17504__$1;
(statearr_17509_17549[(2)] = null);

(statearr_17509_17549[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (4))){
var inst_17445 = (state_17504[(13)]);
var inst_17445__$1 = (state_17504[(2)]);
var inst_17446 = (inst_17445__$1 == null);
var state_17504__$1 = (function (){var statearr_17510 = state_17504;
(statearr_17510[(13)] = inst_17445__$1);

return statearr_17510;
})();
if(cljs.core.truth_(inst_17446)){
var statearr_17511_17550 = state_17504__$1;
(statearr_17511_17550[(1)] = (5));

} else {
var statearr_17512_17551 = state_17504__$1;
(statearr_17512_17551[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (15))){
var state_17504__$1 = state_17504;
var statearr_17516_17552 = state_17504__$1;
(statearr_17516_17552[(2)] = null);

(statearr_17516_17552[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (21))){
var state_17504__$1 = state_17504;
var statearr_17517_17553 = state_17504__$1;
(statearr_17517_17553[(2)] = null);

(statearr_17517_17553[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (13))){
var inst_17456 = (state_17504[(9)]);
var inst_17459 = (state_17504[(10)]);
var inst_17457 = (state_17504[(11)]);
var inst_17458 = (state_17504[(12)]);
var inst_17466 = (state_17504[(2)]);
var inst_17467 = (inst_17459 + (1));
var tmp17513 = inst_17456;
var tmp17514 = inst_17457;
var tmp17515 = inst_17458;
var inst_17456__$1 = tmp17513;
var inst_17457__$1 = tmp17514;
var inst_17458__$1 = tmp17515;
var inst_17459__$1 = inst_17467;
var state_17504__$1 = (function (){var statearr_17518 = state_17504;
(statearr_17518[(14)] = inst_17466);

(statearr_17518[(9)] = inst_17456__$1);

(statearr_17518[(10)] = inst_17459__$1);

(statearr_17518[(11)] = inst_17457__$1);

(statearr_17518[(12)] = inst_17458__$1);

return statearr_17518;
})();
var statearr_17519_17554 = state_17504__$1;
(statearr_17519_17554[(2)] = null);

(statearr_17519_17554[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (22))){
var state_17504__$1 = state_17504;
var statearr_17520_17555 = state_17504__$1;
(statearr_17520_17555[(2)] = null);

(statearr_17520_17555[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (6))){
var inst_17445 = (state_17504[(13)]);
var inst_17454 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17445) : f.call(null,inst_17445));
var inst_17455 = cljs.core.seq(inst_17454);
var inst_17456 = inst_17455;
var inst_17457 = null;
var inst_17458 = (0);
var inst_17459 = (0);
var state_17504__$1 = (function (){var statearr_17521 = state_17504;
(statearr_17521[(9)] = inst_17456);

(statearr_17521[(10)] = inst_17459);

(statearr_17521[(11)] = inst_17457);

(statearr_17521[(12)] = inst_17458);

return statearr_17521;
})();
var statearr_17522_17556 = state_17504__$1;
(statearr_17522_17556[(2)] = null);

(statearr_17522_17556[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (17))){
var inst_17470 = (state_17504[(7)]);
var inst_17474 = cljs.core.chunk_first(inst_17470);
var inst_17475 = cljs.core.chunk_rest(inst_17470);
var inst_17476 = cljs.core.count(inst_17474);
var inst_17456 = inst_17475;
var inst_17457 = inst_17474;
var inst_17458 = inst_17476;
var inst_17459 = (0);
var state_17504__$1 = (function (){var statearr_17523 = state_17504;
(statearr_17523[(9)] = inst_17456);

(statearr_17523[(10)] = inst_17459);

(statearr_17523[(11)] = inst_17457);

(statearr_17523[(12)] = inst_17458);

return statearr_17523;
})();
var statearr_17524_17557 = state_17504__$1;
(statearr_17524_17557[(2)] = null);

(statearr_17524_17557[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (3))){
var inst_17502 = (state_17504[(2)]);
var state_17504__$1 = state_17504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17504__$1,inst_17502);
} else {
if((state_val_17505 === (12))){
var inst_17490 = (state_17504[(2)]);
var state_17504__$1 = state_17504;
var statearr_17525_17558 = state_17504__$1;
(statearr_17525_17558[(2)] = inst_17490);

(statearr_17525_17558[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (2))){
var state_17504__$1 = state_17504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17504__$1,(4),in$);
} else {
if((state_val_17505 === (23))){
var inst_17498 = (state_17504[(2)]);
var state_17504__$1 = state_17504;
var statearr_17526_17559 = state_17504__$1;
(statearr_17526_17559[(2)] = inst_17498);

(statearr_17526_17559[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (19))){
var inst_17485 = (state_17504[(2)]);
var state_17504__$1 = state_17504;
var statearr_17527_17560 = state_17504__$1;
(statearr_17527_17560[(2)] = inst_17485);

(statearr_17527_17560[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (11))){
var inst_17470 = (state_17504[(7)]);
var inst_17456 = (state_17504[(9)]);
var inst_17470__$1 = cljs.core.seq(inst_17456);
var state_17504__$1 = (function (){var statearr_17528 = state_17504;
(statearr_17528[(7)] = inst_17470__$1);

return statearr_17528;
})();
if(inst_17470__$1){
var statearr_17529_17561 = state_17504__$1;
(statearr_17529_17561[(1)] = (14));

} else {
var statearr_17530_17562 = state_17504__$1;
(statearr_17530_17562[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (9))){
var inst_17492 = (state_17504[(2)]);
var inst_17493 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_17504__$1 = (function (){var statearr_17531 = state_17504;
(statearr_17531[(15)] = inst_17492);

return statearr_17531;
})();
if(cljs.core.truth_(inst_17493)){
var statearr_17532_17563 = state_17504__$1;
(statearr_17532_17563[(1)] = (21));

} else {
var statearr_17533_17564 = state_17504__$1;
(statearr_17533_17564[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (5))){
var inst_17448 = cljs.core.async.close_BANG_(out);
var state_17504__$1 = state_17504;
var statearr_17534_17565 = state_17504__$1;
(statearr_17534_17565[(2)] = inst_17448);

(statearr_17534_17565[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (14))){
var inst_17470 = (state_17504[(7)]);
var inst_17472 = cljs.core.chunked_seq_QMARK_(inst_17470);
var state_17504__$1 = state_17504;
if(inst_17472){
var statearr_17535_17566 = state_17504__$1;
(statearr_17535_17566[(1)] = (17));

} else {
var statearr_17536_17567 = state_17504__$1;
(statearr_17536_17567[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (16))){
var inst_17488 = (state_17504[(2)]);
var state_17504__$1 = state_17504;
var statearr_17537_17568 = state_17504__$1;
(statearr_17537_17568[(2)] = inst_17488);

(statearr_17537_17568[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17505 === (10))){
var inst_17459 = (state_17504[(10)]);
var inst_17457 = (state_17504[(11)]);
var inst_17464 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17457,inst_17459);
var state_17504__$1 = state_17504;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17504__$1,(13),out,inst_17464);
} else {
if((state_val_17505 === (18))){
var inst_17470 = (state_17504[(7)]);
var inst_17479 = cljs.core.first(inst_17470);
var state_17504__$1 = state_17504;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17504__$1,(20),out,inst_17479);
} else {
if((state_val_17505 === (8))){
var inst_17459 = (state_17504[(10)]);
var inst_17458 = (state_17504[(12)]);
var inst_17461 = (inst_17459 < inst_17458);
var inst_17462 = inst_17461;
var state_17504__$1 = state_17504;
if(cljs.core.truth_(inst_17462)){
var statearr_17538_17569 = state_17504__$1;
(statearr_17538_17569[(1)] = (10));

} else {
var statearr_17539_17570 = state_17504__$1;
(statearr_17539_17570[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto__))
;
return ((function (switch__14927__auto__,c__15051__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14928__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14928__auto____0 = (function (){
var statearr_17543 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17543[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14928__auto__);

(statearr_17543[(1)] = (1));

return statearr_17543;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14928__auto____1 = (function (state_17504){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_17504);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e17544){if((e17544 instanceof Object)){
var ex__14931__auto__ = e17544;
var statearr_17545_17571 = state_17504;
(statearr_17545_17571[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17504);

return cljs.core.cst$kw$recur;
} else {
throw e17544;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__17572 = state_17504;
state_17504 = G__17572;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14928__auto__ = function(state_17504){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14928__auto____1.call(this,state_17504);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14928__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14928__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto__))
})();
var state__15053__auto__ = (function (){var statearr_17546 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_17546[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto__);

return statearr_17546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto__))
);

return c__15051__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args17573 = [];
var len__8402__auto___17576 = arguments.length;
var i__8403__auto___17577 = (0);
while(true){
if((i__8403__auto___17577 < len__8402__auto___17576)){
args17573.push((arguments[i__8403__auto___17577]));

var G__17578 = (i__8403__auto___17577 + (1));
i__8403__auto___17577 = G__17578;
continue;
} else {
}
break;
}

var G__17575 = args17573.length;
switch (G__17575) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17573.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args17580 = [];
var len__8402__auto___17583 = arguments.length;
var i__8403__auto___17584 = (0);
while(true){
if((i__8403__auto___17584 < len__8402__auto___17583)){
args17580.push((arguments[i__8403__auto___17584]));

var G__17585 = (i__8403__auto___17584 + (1));
i__8403__auto___17584 = G__17585;
continue;
} else {
}
break;
}

var G__17582 = args17580.length;
switch (G__17582) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17580.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args17587 = [];
var len__8402__auto___17638 = arguments.length;
var i__8403__auto___17639 = (0);
while(true){
if((i__8403__auto___17639 < len__8402__auto___17638)){
args17587.push((arguments[i__8403__auto___17639]));

var G__17640 = (i__8403__auto___17639 + (1));
i__8403__auto___17639 = G__17640;
continue;
} else {
}
break;
}

var G__17589 = args17587.length;
switch (G__17589) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17587.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15051__auto___17642 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___17642,out){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___17642,out){
return (function (state_17613){
var state_val_17614 = (state_17613[(1)]);
if((state_val_17614 === (7))){
var inst_17608 = (state_17613[(2)]);
var state_17613__$1 = state_17613;
var statearr_17615_17643 = state_17613__$1;
(statearr_17615_17643[(2)] = inst_17608);

(statearr_17615_17643[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17614 === (1))){
var inst_17590 = null;
var state_17613__$1 = (function (){var statearr_17616 = state_17613;
(statearr_17616[(7)] = inst_17590);

return statearr_17616;
})();
var statearr_17617_17644 = state_17613__$1;
(statearr_17617_17644[(2)] = null);

(statearr_17617_17644[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17614 === (4))){
var inst_17593 = (state_17613[(8)]);
var inst_17593__$1 = (state_17613[(2)]);
var inst_17594 = (inst_17593__$1 == null);
var inst_17595 = cljs.core.not(inst_17594);
var state_17613__$1 = (function (){var statearr_17618 = state_17613;
(statearr_17618[(8)] = inst_17593__$1);

return statearr_17618;
})();
if(inst_17595){
var statearr_17619_17645 = state_17613__$1;
(statearr_17619_17645[(1)] = (5));

} else {
var statearr_17620_17646 = state_17613__$1;
(statearr_17620_17646[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17614 === (6))){
var state_17613__$1 = state_17613;
var statearr_17621_17647 = state_17613__$1;
(statearr_17621_17647[(2)] = null);

(statearr_17621_17647[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17614 === (3))){
var inst_17610 = (state_17613[(2)]);
var inst_17611 = cljs.core.async.close_BANG_(out);
var state_17613__$1 = (function (){var statearr_17622 = state_17613;
(statearr_17622[(9)] = inst_17610);

return statearr_17622;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17613__$1,inst_17611);
} else {
if((state_val_17614 === (2))){
var state_17613__$1 = state_17613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17613__$1,(4),ch);
} else {
if((state_val_17614 === (11))){
var inst_17593 = (state_17613[(8)]);
var inst_17602 = (state_17613[(2)]);
var inst_17590 = inst_17593;
var state_17613__$1 = (function (){var statearr_17623 = state_17613;
(statearr_17623[(10)] = inst_17602);

(statearr_17623[(7)] = inst_17590);

return statearr_17623;
})();
var statearr_17624_17648 = state_17613__$1;
(statearr_17624_17648[(2)] = null);

(statearr_17624_17648[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17614 === (9))){
var inst_17593 = (state_17613[(8)]);
var state_17613__$1 = state_17613;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17613__$1,(11),out,inst_17593);
} else {
if((state_val_17614 === (5))){
var inst_17593 = (state_17613[(8)]);
var inst_17590 = (state_17613[(7)]);
var inst_17597 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17593,inst_17590);
var state_17613__$1 = state_17613;
if(inst_17597){
var statearr_17626_17649 = state_17613__$1;
(statearr_17626_17649[(1)] = (8));

} else {
var statearr_17627_17650 = state_17613__$1;
(statearr_17627_17650[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17614 === (10))){
var inst_17605 = (state_17613[(2)]);
var state_17613__$1 = state_17613;
var statearr_17628_17651 = state_17613__$1;
(statearr_17628_17651[(2)] = inst_17605);

(statearr_17628_17651[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17614 === (8))){
var inst_17590 = (state_17613[(7)]);
var tmp17625 = inst_17590;
var inst_17590__$1 = tmp17625;
var state_17613__$1 = (function (){var statearr_17629 = state_17613;
(statearr_17629[(7)] = inst_17590__$1);

return statearr_17629;
})();
var statearr_17630_17652 = state_17613__$1;
(statearr_17630_17652[(2)] = null);

(statearr_17630_17652[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___17642,out))
;
return ((function (switch__14927__auto__,c__15051__auto___17642,out){
return (function() {
var cljs$core$async$state_machine__14928__auto__ = null;
var cljs$core$async$state_machine__14928__auto____0 = (function (){
var statearr_17634 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17634[(0)] = cljs$core$async$state_machine__14928__auto__);

(statearr_17634[(1)] = (1));

return statearr_17634;
});
var cljs$core$async$state_machine__14928__auto____1 = (function (state_17613){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_17613);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e17635){if((e17635 instanceof Object)){
var ex__14931__auto__ = e17635;
var statearr_17636_17653 = state_17613;
(statearr_17636_17653[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17613);

return cljs.core.cst$kw$recur;
} else {
throw e17635;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__17654 = state_17613;
state_17613 = G__17654;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$state_machine__14928__auto__ = function(state_17613){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14928__auto____1.call(this,state_17613);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14928__auto____0;
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14928__auto____1;
return cljs$core$async$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___17642,out))
})();
var state__15053__auto__ = (function (){var statearr_17637 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_17637[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___17642);

return statearr_17637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___17642,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args17655 = [];
var len__8402__auto___17725 = arguments.length;
var i__8403__auto___17726 = (0);
while(true){
if((i__8403__auto___17726 < len__8402__auto___17725)){
args17655.push((arguments[i__8403__auto___17726]));

var G__17727 = (i__8403__auto___17726 + (1));
i__8403__auto___17726 = G__17727;
continue;
} else {
}
break;
}

var G__17657 = args17655.length;
switch (G__17657) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17655.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15051__auto___17729 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___17729,out){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___17729,out){
return (function (state_17695){
var state_val_17696 = (state_17695[(1)]);
if((state_val_17696 === (7))){
var inst_17691 = (state_17695[(2)]);
var state_17695__$1 = state_17695;
var statearr_17697_17730 = state_17695__$1;
(statearr_17697_17730[(2)] = inst_17691);

(statearr_17697_17730[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17696 === (1))){
var inst_17658 = (new Array(n));
var inst_17659 = inst_17658;
var inst_17660 = (0);
var state_17695__$1 = (function (){var statearr_17698 = state_17695;
(statearr_17698[(7)] = inst_17659);

(statearr_17698[(8)] = inst_17660);

return statearr_17698;
})();
var statearr_17699_17731 = state_17695__$1;
(statearr_17699_17731[(2)] = null);

(statearr_17699_17731[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17696 === (4))){
var inst_17663 = (state_17695[(9)]);
var inst_17663__$1 = (state_17695[(2)]);
var inst_17664 = (inst_17663__$1 == null);
var inst_17665 = cljs.core.not(inst_17664);
var state_17695__$1 = (function (){var statearr_17700 = state_17695;
(statearr_17700[(9)] = inst_17663__$1);

return statearr_17700;
})();
if(inst_17665){
var statearr_17701_17732 = state_17695__$1;
(statearr_17701_17732[(1)] = (5));

} else {
var statearr_17702_17733 = state_17695__$1;
(statearr_17702_17733[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17696 === (15))){
var inst_17685 = (state_17695[(2)]);
var state_17695__$1 = state_17695;
var statearr_17703_17734 = state_17695__$1;
(statearr_17703_17734[(2)] = inst_17685);

(statearr_17703_17734[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17696 === (13))){
var state_17695__$1 = state_17695;
var statearr_17704_17735 = state_17695__$1;
(statearr_17704_17735[(2)] = null);

(statearr_17704_17735[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17696 === (6))){
var inst_17660 = (state_17695[(8)]);
var inst_17681 = (inst_17660 > (0));
var state_17695__$1 = state_17695;
if(cljs.core.truth_(inst_17681)){
var statearr_17705_17736 = state_17695__$1;
(statearr_17705_17736[(1)] = (12));

} else {
var statearr_17706_17737 = state_17695__$1;
(statearr_17706_17737[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17696 === (3))){
var inst_17693 = (state_17695[(2)]);
var state_17695__$1 = state_17695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17695__$1,inst_17693);
} else {
if((state_val_17696 === (12))){
var inst_17659 = (state_17695[(7)]);
var inst_17683 = cljs.core.vec(inst_17659);
var state_17695__$1 = state_17695;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17695__$1,(15),out,inst_17683);
} else {
if((state_val_17696 === (2))){
var state_17695__$1 = state_17695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17695__$1,(4),ch);
} else {
if((state_val_17696 === (11))){
var inst_17675 = (state_17695[(2)]);
var inst_17676 = (new Array(n));
var inst_17659 = inst_17676;
var inst_17660 = (0);
var state_17695__$1 = (function (){var statearr_17707 = state_17695;
(statearr_17707[(7)] = inst_17659);

(statearr_17707[(10)] = inst_17675);

(statearr_17707[(8)] = inst_17660);

return statearr_17707;
})();
var statearr_17708_17738 = state_17695__$1;
(statearr_17708_17738[(2)] = null);

(statearr_17708_17738[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17696 === (9))){
var inst_17659 = (state_17695[(7)]);
var inst_17673 = cljs.core.vec(inst_17659);
var state_17695__$1 = state_17695;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17695__$1,(11),out,inst_17673);
} else {
if((state_val_17696 === (5))){
var inst_17659 = (state_17695[(7)]);
var inst_17660 = (state_17695[(8)]);
var inst_17663 = (state_17695[(9)]);
var inst_17668 = (state_17695[(11)]);
var inst_17667 = (inst_17659[inst_17660] = inst_17663);
var inst_17668__$1 = (inst_17660 + (1));
var inst_17669 = (inst_17668__$1 < n);
var state_17695__$1 = (function (){var statearr_17709 = state_17695;
(statearr_17709[(12)] = inst_17667);

(statearr_17709[(11)] = inst_17668__$1);

return statearr_17709;
})();
if(cljs.core.truth_(inst_17669)){
var statearr_17710_17739 = state_17695__$1;
(statearr_17710_17739[(1)] = (8));

} else {
var statearr_17711_17740 = state_17695__$1;
(statearr_17711_17740[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17696 === (14))){
var inst_17688 = (state_17695[(2)]);
var inst_17689 = cljs.core.async.close_BANG_(out);
var state_17695__$1 = (function (){var statearr_17713 = state_17695;
(statearr_17713[(13)] = inst_17688);

return statearr_17713;
})();
var statearr_17714_17741 = state_17695__$1;
(statearr_17714_17741[(2)] = inst_17689);

(statearr_17714_17741[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17696 === (10))){
var inst_17679 = (state_17695[(2)]);
var state_17695__$1 = state_17695;
var statearr_17715_17742 = state_17695__$1;
(statearr_17715_17742[(2)] = inst_17679);

(statearr_17715_17742[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17696 === (8))){
var inst_17659 = (state_17695[(7)]);
var inst_17668 = (state_17695[(11)]);
var tmp17712 = inst_17659;
var inst_17659__$1 = tmp17712;
var inst_17660 = inst_17668;
var state_17695__$1 = (function (){var statearr_17716 = state_17695;
(statearr_17716[(7)] = inst_17659__$1);

(statearr_17716[(8)] = inst_17660);

return statearr_17716;
})();
var statearr_17717_17743 = state_17695__$1;
(statearr_17717_17743[(2)] = null);

(statearr_17717_17743[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___17729,out))
;
return ((function (switch__14927__auto__,c__15051__auto___17729,out){
return (function() {
var cljs$core$async$state_machine__14928__auto__ = null;
var cljs$core$async$state_machine__14928__auto____0 = (function (){
var statearr_17721 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17721[(0)] = cljs$core$async$state_machine__14928__auto__);

(statearr_17721[(1)] = (1));

return statearr_17721;
});
var cljs$core$async$state_machine__14928__auto____1 = (function (state_17695){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_17695);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e17722){if((e17722 instanceof Object)){
var ex__14931__auto__ = e17722;
var statearr_17723_17744 = state_17695;
(statearr_17723_17744[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17695);

return cljs.core.cst$kw$recur;
} else {
throw e17722;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__17745 = state_17695;
state_17695 = G__17745;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$state_machine__14928__auto__ = function(state_17695){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14928__auto____1.call(this,state_17695);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14928__auto____0;
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14928__auto____1;
return cljs$core$async$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___17729,out))
})();
var state__15053__auto__ = (function (){var statearr_17724 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_17724[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___17729);

return statearr_17724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___17729,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17746 = [];
var len__8402__auto___17820 = arguments.length;
var i__8403__auto___17821 = (0);
while(true){
if((i__8403__auto___17821 < len__8402__auto___17820)){
args17746.push((arguments[i__8403__auto___17821]));

var G__17822 = (i__8403__auto___17821 + (1));
i__8403__auto___17821 = G__17822;
continue;
} else {
}
break;
}

var G__17748 = args17746.length;
switch (G__17748) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17746.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15051__auto___17824 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15051__auto___17824,out){
return (function (){
var f__15052__auto__ = (function (){var switch__14927__auto__ = ((function (c__15051__auto___17824,out){
return (function (state_17790){
var state_val_17791 = (state_17790[(1)]);
if((state_val_17791 === (7))){
var inst_17786 = (state_17790[(2)]);
var state_17790__$1 = state_17790;
var statearr_17792_17825 = state_17790__$1;
(statearr_17792_17825[(2)] = inst_17786);

(statearr_17792_17825[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17791 === (1))){
var inst_17749 = [];
var inst_17750 = inst_17749;
var inst_17751 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_17790__$1 = (function (){var statearr_17793 = state_17790;
(statearr_17793[(7)] = inst_17750);

(statearr_17793[(8)] = inst_17751);

return statearr_17793;
})();
var statearr_17794_17826 = state_17790__$1;
(statearr_17794_17826[(2)] = null);

(statearr_17794_17826[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17791 === (4))){
var inst_17754 = (state_17790[(9)]);
var inst_17754__$1 = (state_17790[(2)]);
var inst_17755 = (inst_17754__$1 == null);
var inst_17756 = cljs.core.not(inst_17755);
var state_17790__$1 = (function (){var statearr_17795 = state_17790;
(statearr_17795[(9)] = inst_17754__$1);

return statearr_17795;
})();
if(inst_17756){
var statearr_17796_17827 = state_17790__$1;
(statearr_17796_17827[(1)] = (5));

} else {
var statearr_17797_17828 = state_17790__$1;
(statearr_17797_17828[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17791 === (15))){
var inst_17780 = (state_17790[(2)]);
var state_17790__$1 = state_17790;
var statearr_17798_17829 = state_17790__$1;
(statearr_17798_17829[(2)] = inst_17780);

(statearr_17798_17829[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17791 === (13))){
var state_17790__$1 = state_17790;
var statearr_17799_17830 = state_17790__$1;
(statearr_17799_17830[(2)] = null);

(statearr_17799_17830[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17791 === (6))){
var inst_17750 = (state_17790[(7)]);
var inst_17775 = inst_17750.length;
var inst_17776 = (inst_17775 > (0));
var state_17790__$1 = state_17790;
if(cljs.core.truth_(inst_17776)){
var statearr_17800_17831 = state_17790__$1;
(statearr_17800_17831[(1)] = (12));

} else {
var statearr_17801_17832 = state_17790__$1;
(statearr_17801_17832[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17791 === (3))){
var inst_17788 = (state_17790[(2)]);
var state_17790__$1 = state_17790;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17790__$1,inst_17788);
} else {
if((state_val_17791 === (12))){
var inst_17750 = (state_17790[(7)]);
var inst_17778 = cljs.core.vec(inst_17750);
var state_17790__$1 = state_17790;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17790__$1,(15),out,inst_17778);
} else {
if((state_val_17791 === (2))){
var state_17790__$1 = state_17790;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17790__$1,(4),ch);
} else {
if((state_val_17791 === (11))){
var inst_17758 = (state_17790[(10)]);
var inst_17754 = (state_17790[(9)]);
var inst_17768 = (state_17790[(2)]);
var inst_17769 = [];
var inst_17770 = inst_17769.push(inst_17754);
var inst_17750 = inst_17769;
var inst_17751 = inst_17758;
var state_17790__$1 = (function (){var statearr_17802 = state_17790;
(statearr_17802[(11)] = inst_17768);

(statearr_17802[(7)] = inst_17750);

(statearr_17802[(12)] = inst_17770);

(statearr_17802[(8)] = inst_17751);

return statearr_17802;
})();
var statearr_17803_17833 = state_17790__$1;
(statearr_17803_17833[(2)] = null);

(statearr_17803_17833[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17791 === (9))){
var inst_17750 = (state_17790[(7)]);
var inst_17766 = cljs.core.vec(inst_17750);
var state_17790__$1 = state_17790;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17790__$1,(11),out,inst_17766);
} else {
if((state_val_17791 === (5))){
var inst_17758 = (state_17790[(10)]);
var inst_17754 = (state_17790[(9)]);
var inst_17751 = (state_17790[(8)]);
var inst_17758__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17754) : f.call(null,inst_17754));
var inst_17759 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17758__$1,inst_17751);
var inst_17760 = cljs.core.keyword_identical_QMARK_(inst_17751,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_17761 = (inst_17759) || (inst_17760);
var state_17790__$1 = (function (){var statearr_17804 = state_17790;
(statearr_17804[(10)] = inst_17758__$1);

return statearr_17804;
})();
if(cljs.core.truth_(inst_17761)){
var statearr_17805_17834 = state_17790__$1;
(statearr_17805_17834[(1)] = (8));

} else {
var statearr_17806_17835 = state_17790__$1;
(statearr_17806_17835[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17791 === (14))){
var inst_17783 = (state_17790[(2)]);
var inst_17784 = cljs.core.async.close_BANG_(out);
var state_17790__$1 = (function (){var statearr_17808 = state_17790;
(statearr_17808[(13)] = inst_17783);

return statearr_17808;
})();
var statearr_17809_17836 = state_17790__$1;
(statearr_17809_17836[(2)] = inst_17784);

(statearr_17809_17836[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17791 === (10))){
var inst_17773 = (state_17790[(2)]);
var state_17790__$1 = state_17790;
var statearr_17810_17837 = state_17790__$1;
(statearr_17810_17837[(2)] = inst_17773);

(statearr_17810_17837[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17791 === (8))){
var inst_17758 = (state_17790[(10)]);
var inst_17750 = (state_17790[(7)]);
var inst_17754 = (state_17790[(9)]);
var inst_17763 = inst_17750.push(inst_17754);
var tmp17807 = inst_17750;
var inst_17750__$1 = tmp17807;
var inst_17751 = inst_17758;
var state_17790__$1 = (function (){var statearr_17811 = state_17790;
(statearr_17811[(14)] = inst_17763);

(statearr_17811[(7)] = inst_17750__$1);

(statearr_17811[(8)] = inst_17751);

return statearr_17811;
})();
var statearr_17812_17838 = state_17790__$1;
(statearr_17812_17838[(2)] = null);

(statearr_17812_17838[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15051__auto___17824,out))
;
return ((function (switch__14927__auto__,c__15051__auto___17824,out){
return (function() {
var cljs$core$async$state_machine__14928__auto__ = null;
var cljs$core$async$state_machine__14928__auto____0 = (function (){
var statearr_17816 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17816[(0)] = cljs$core$async$state_machine__14928__auto__);

(statearr_17816[(1)] = (1));

return statearr_17816;
});
var cljs$core$async$state_machine__14928__auto____1 = (function (state_17790){
while(true){
var ret_value__14929__auto__ = (function (){try{while(true){
var result__14930__auto__ = switch__14927__auto__(state_17790);
if(cljs.core.keyword_identical_QMARK_(result__14930__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14930__auto__;
}
break;
}
}catch (e17817){if((e17817 instanceof Object)){
var ex__14931__auto__ = e17817;
var statearr_17818_17839 = state_17790;
(statearr_17818_17839[(5)] = ex__14931__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17790);

return cljs.core.cst$kw$recur;
} else {
throw e17817;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14929__auto__,cljs.core.cst$kw$recur)){
var G__17840 = state_17790;
state_17790 = G__17840;
continue;
} else {
return ret_value__14929__auto__;
}
break;
}
});
cljs$core$async$state_machine__14928__auto__ = function(state_17790){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14928__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14928__auto____1.call(this,state_17790);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14928__auto____0;
cljs$core$async$state_machine__14928__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14928__auto____1;
return cljs$core$async$state_machine__14928__auto__;
})()
;})(switch__14927__auto__,c__15051__auto___17824,out))
})();
var state__15053__auto__ = (function (){var statearr_17819 = (f__15052__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15052__auto__.cljs$core$IFn$_invoke$arity$0() : f__15052__auto__.call(null));
(statearr_17819[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15051__auto___17824);

return statearr_17819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15053__auto__);
});})(c__15051__auto___17824,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

