(ns hoplon.indexed-db
  (:require [javelin.core :as j]
            [hoplon.indexed-db.factory :as factory]
            [hoplon.indexed-db.opendbrequest :as req]
            [hoplon.indexed-db.database :as db]
            [hoplon.indexed-db.transaction :as tx])
  (:require-macros hoplon.indexed-db))

(def indexedDB (.-indexedDB js/window))

(def open-database (partial factory/open indexedDB))

(def database-upgrade req/onupgradeneeded)

(def object-store tx/objectStore)

(def object-stores db/objectStoreNames)

(defn create-stores [db stores]
  (let [current (db/objectStoreNames db)]
    (doseq [store stores]
      (when-not (.contains current store)
        (db/createObjectStore db store)))))

(defn delete-stores [db stores]
  (let [current (db/objectStoreNames db)]
    (doseq [store current]
      (when-not (contains? (set stores) store)
        (db/deleteObjectStore db store)))))

(def get-transaction db/transaction)

(defn get-result [event]
  (.-result (.-target event)))

(defn when-success [tx callback]
  (.addEventListener tx "success" callback))

(defn when-error [tx callback]
  (.addEventListener tx "error" callback))

(defn when-upgrading [tx callback]
  (.addEventListener tx "upgradeneeded" callback))

(defn object-store= [db store key]
  (let [ostore (j/cell nil)
        ostore! (partial reset! ostore)]
    (when-success db
      (fn [event]
        (let [store (-> event (get-result) (get-transaction store)  (object-store store))]
          (when-success (.get store key)
            (with-result result
              (ostore! (js->clj result :keywordize-keys true)))))))
    (j/cell= ostore
      #(when-success db
        (fn [event]
          (let [store (-> event (get-result) (get-transaction store "readwrite")  (object-store store))]
            (when-success (.put s % key)
              (with-result result
                (ostore! (js->clj result :keywordize-keys true))))))))))
