(ns hoplon.indexed-db)

(defmacro with-result [name & body]
  `(fn [event#]
    (let [~name (get-result event#)]
      ~@body)))

(defmacro with-transaction [store & body]
  `(with-result db#
    (let [tx# (get-transaction db# ~(str store) "readwrite")
          ~store (object-store tx# ~(str store))]
      ~@body)))
