(ns hoplon.indexed-db)

(defmacro with-result [name & body]
  `(fn [event#]
    (let [~name (get-result event#)]
      ~@body)))


(defmacro with-transaction [store & body]
  `(with-result db#
    (let [~store (-> db# (get-transaction ~(str store) "readwrite") (object-store ~(str store)))]
      ~@body)))
