(ns hoplon.indexed-db
  (:require [javelin.core :as j]
            [hoplon.indexed-db.factory :as factory]
            [hoplon.indexed-db.opendbrequest :as req]
            [hoplon.indexed-db.database :as db]
            [hoplon.indexed-db.transaction :as tx])
  (:require-macros hoplon.indexed-db))

(def indexedDB (.-indexedDB js/window))

(def open-database (partial factory/open indexedDB))

(def database-error req/onerror)

(def database-success req/onsuccess)

(def database-upgrade req/onupgradeneeded)

(def object-store tx/objectStore)

(def object-stores db/objectStoreNames)

(defn create-stores [db stores]
  (let [current (db/objectStoreNames db)]
    (doseq [store stores]
      (when-not (.contains current store)
        (db/createObjectStore db store)))))

(defn delete-stores [db stores]
  (let [current (db/objectStoreNames db)]
    (doseq [store current]
      (when-not (contains? (set stores) store)
        (db/deleteObjectStore db store)))))

(def get-transaction db/transaction)

(defn get-result [event]
  (.-result (.-target event)))

(defn when-success [tx callback]
  (.addEventListener tx "success" callback))
