(ns hoplon.indexed-db
  (:require [javelin.core :as j]
            [hoplon.protocols.idbdatabase :as idbdb])
  (:require-macros hoplon.indexed-db))

(def indexedDB (.-indexedDB js/window))

(extend-type js/IDBFactory
  IDBFactory
  (open
    ([this name]
     (.open this name))
    ([this name version]
     (.open this name version)))
  (deleteDatabase [this name]
    (.deleteDatabase this name))
  (databases [this]
    (.deleteDatabase this)))

(extend-type js/IDBOpenDBRequest
  IDBOpenDBRequest
  (onerror [this callback]
    (.addEventListener this "error" callback))
  (onsuccess [this callback]
    (.addEventListener this "success" callback))
  (onupgradeneeded [this callback]
    (.addEventListener this "upgradeneeded" callback)))
