(ns hoplon.debug
  (:require
    #?@(:browser [["debug" :as dbg]])))

#?(:browser
    (defn debug! [namespaces]
      (.setItem (.-localStorage js/window) "debug" namespaces)))

(defn debug [namespace]
  #?(:browser (dbg namespace)
     :cljs    (fn [& args] (apply js/console.debug (str "[" namespace "]") args))))
