(ns hoplon.debug
  (:require
    #?@(:browser [["debug" :as dbg]])))

#?(:browser nil
   :cljs (def ^:dynamic *debug* (atom nil)))

#?(:browser nil
   :cljs (defmulti debug! (fn [mode namespace messages] mode)))

#?(:browser nil
   :cljs (defmethod debug! ::debug
           [_ namespace args]
           (apply js/console.debug (str "[" namespace "]") args)))

#?(:browser nil
   :cljs (defmethod debug! ::log
           [_ namespace args]
           (apply js/console.log (str "[" namespace "]") args)))

(defn debug [namespace]
  #?(:browser (dbg namespace)
     :cljs    (fn [& args] (debug! @*debug* namespace args))))
