(ns hoplon.debug)

(def ^:dynamic *debug* (atom nil))

(defmulti debug! (fn [mode namespace messages] mode))

(defmethod debug! ::debug
  [_ namespace args]
  (apply js/console.debug (str "[" namespace "]") args))

(defmethod debug! ::log
  [_ namespace args]
  (apply js/console.log (str "[" namespace "]") args))

; (defmethod debug! ::default
;   [_ namespace args]
;   (debug! ::debug namespace args))

(defn debug [namespace]
  (fn [& args]
    (debug! @*debug* namespace args)))
