# cirque

![Cirque du soleil](http://i.giphy.com/bJpjrYpEmUnrW.gif)

Originally a fork of [jxa/resque-clojure](https://github.com/jxa/resque-clojure).

Resque (pronounced like "rescue") is a Redis-backed library for creating background jobs,
placing those jobs on multiple queues, and processing them later. It was originally developed
for the ruby language. https://github.com/defunkt/resque

cirque is a clojure-based implementation of the same protocol. It aims to be
fully interoperable with the original project.

Maintained with love by [HomeSwipe](https://homeswipe.com).

## Usage

    (ns my.test
      (:require [cirque.core :as resque]))

    (resque/configure {:host "localhost" :port 6379 :scheduler-enabled? true}) ;; optional

    ;; creating a job
    (resque/enqueue "testqueue" "clojure.core/println" "hello" "resque")

    ;; scheduling a job 5 seconds from now
    ;; will be stored but not run unless/until you set :scheduler-enabled? true
    (resque/enqueue-at (+ (System/currentTimeMillis) 5000) "testqueue" "clojure.core/println" "hello" "resque" "later")

    ;; listening for jobs & run scheduler if enabled
    (resque/start ["testqueue"])

## TODO

* cron jobs!
* add resque:stat:* keys
* add resque-status as an option/plugin

# License

Released under the MIT license. Please see LICENSE file.
