(ns leiningen.new.holy-lambda
  (:require
   [leiningen.new.templates :refer [renderer name-to-path ->files]]
   [leiningen.core.main :as main]))

(def render (renderer "holy-lambda"))

(defn holy-lambda
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}
        render* #(render % data)]
    (main/info "Generating fresh 'lein new' holy-lambda project.")
    (->files data
             ["src/{{sanitized}}/core.clj" (render* "core.clj")]
             ["Makefile" (render* "Makefile")]
             ["README.md" (render* "README.md")]
             ["project.clj" (render* "project.clj")]
             ["resources/native-agents-payloads/1-pass.json" (render* "1-pass.json")]
             ["resources/native-deps/cacerts" (render* "cacerts")]
             ["resources/native-deps/libsunec.so" (render* "libsunec.so")]
             ["resources/bootstrap" (render* "bootstrap")]
             ["resources/local-event.json" (render* "local-event.json")]
             [".joker" (render* "joker")]
             [".editorconfig" (render* "editorconfig")]
             [".gitignore" (render* "gitignore")])))
