(ns rmi-service.utils
  (:import [org.springframework.remoting.rmi RmiProxyFactoryBean]
           [com.basecity.hjd ImageBean]
           [com.basecity.hjd.service.user ProtectionInfoBean]))

(defn get-rmi-service
  "get rmi service instance"
  [service-interface service-url]
  (let [rmi (RmiProxyFactoryBean.)]
    (doto rmi
      (.setServiceInterface service-interface) 
      (.setServiceUrl service-url)
      (.setLookupStubOnStartup true)
      (.setRefreshStubOnConnectFailure true) 
      (.afterPropertiesSet))
    (.getObject rmi)))

;;provide a cached rmi service instance
(def get-service (memoize get-rmi-service))

(defn bean-without-class
  "get the bean of object without class"
  [obj]
  (dissoc (bean obj) :class))
			
(defn gen-image-bean
  "将map 数据转化成java ImageBean 类
   m 格式必须是: {:bodyIndex 0, :decoratorIndex 3, :faceIndex 0, :hairIndex 0,
                :hairIndex2 0, :male false}"
  [m]
  (doto (ImageBean.)
    (.setHairIndex (get m :hairIndex 0))
    (.setHairIndex2 (get m :hairIndex2 0))
    (.setFaceIndex (get m :faceIndex 0))
    (.setBodyIndex (get m :bodyIndex 0))
    (.setDecoratorIndex (get m :decoratorIndex 0))
    (.setMale (get m :male true))))

(defn gen-protection-info-bean
  "将map 数据转化成java ProtectionInfoBean 类"
  [p]
  (doto (ProtectionInfoBean.)
    (.setIdNumber (get p :idNumber))
    (.setRealName (get p :realName))
    (.setSecondPassword (get p :secondPassword))
    (.setPasswordQuestion (get p :passwordQuestion))
    (.setPasswordAnswer (get p :passwordAnswer))))

;;config file must be placed under the classpaths named rmi_config.clj
;;namespace rmi-config

(defn get-url
  "get the rmi url of the specify service"
  [config service]
  (or (get config service)
      (throw (RuntimeException. (str "Cannot find " service " in " config)))))

(defn get-url-of-varfn
  "get the rmi url of specify var function"
  [config var-fn]
  (let [service (:service (meta var-fn))]
    (if service 
      (get-url config service)
      (throw (RuntimeException. (str "Cannot find :service meta in " var-fn))))))

(defn has-simple-config?
  [config var-fn]
  (if-let [service (:service (meta var-fn))]
    (config service)))

