(ns exchange.schedule
  (:require [clojurewerkz.quartzite.scheduler :as qs]
            [clojurewerkz.quartzite.triggers :as qt]
            [clojurewerkz.quartzite.conversion :as qc]
            [clojurewerkz.quartzite.jobs :as j]
            [clojurewerkz.quartzite.jobs :refer [defjob]]
            [clojurewerkz.quartzite.schedule.cron :refer [schedule daily-at-hour-and-minute]]))

(defjob InterJob [ctx]
        (let [data (qc/from-job-data ctx)
              f (get data "f")]
          (f)))

(defn start-daily-schedule
  [name hour minute f]
  (let [scheduler (-> (qs/initialize) qs/start)
        job (j/build
              (j/of-type InterJob)
              (j/using-job-data {:f f})
              (j/with-identity (j/key (str name "-job"))))
        trigger (qt/build
                  (qt/with-identity (qt/key (str name "-trigger")))
                  (qt/start-now)
                  (qt/with-schedule (schedule
                                     (daily-at-hour-and-minute hour minute))))]
    (qs/schedule scheduler job trigger)
    (fn [] (qs/shutdown scheduler))))
